/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FilamentType implements Enumeration
{
    INCANDESCENT("Incandescent"),
    HALOGEN("Halogen"),
    OTHER("Other");

    private final String value;

    private FilamentType(String value) {
        this.value = value;
    }

    public static FilamentType fromString(String value) throws EnumerationException {
        if ("Incandescent".equals(value)) {
            return INCANDESCENT;
        }
        if ("Halogen".equals(value)) {
            return HALOGEN;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, FilamentType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

