/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FileInfo;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.StatusListener;
import loci.formats.UnknownFormatException;
import loci.formats.meta.MetadataStore;

public class ImageReader
implements IFormatReader {
    private static ClassList defaultClasses;
    private IFormatReader[] readers;
    private String[] suffixes;
    private String currentId;
    private int current;

    private static ClassList getDefaultReaderClasses() {
        if (defaultClasses == null) {
            try {
                defaultClasses = new ClassList("readers.txt", IFormatReader.class);
            }
            catch (IOException exc) {
                defaultClasses = new ClassList(IFormatReader.class);
                LogTools.trace(exc);
            }
        }
        return defaultClasses;
    }

    public ImageReader() {
        this(ImageReader.getDefaultReaderClasses());
    }

    public ImageReader(ClassList classList) {
        Vector<IFormatReader> v = new Vector<IFormatReader>();
        Class[] c = classList.getClasses();
        for (int i = 0; i < c.length; ++i) {
            IFormatReader reader = null;
            try {
                reader = (IFormatReader)c[i].newInstance();
            }
            catch (IllegalAccessException exc) {
            }
            catch (InstantiationException exc) {
                // empty catch block
            }
            if (reader == null) {
                LogTools.println("Error: " + c[i].getName() + " cannot be instantiated.");
                continue;
            }
            v.add(reader);
        }
        this.readers = new IFormatReader[v.size()];
        v.copyInto(this.readers);
    }

    public String getFormat(String id) throws FormatException, IOException {
        return this.getReader(id).getFormat();
    }

    public IFormatReader getReader(String id) throws FormatException, IOException {
        Location.getHandle(id);
        if (!id.equals(this.currentId)) {
            boolean success = false;
            for (int i = 0; i < this.readers.length; ++i) {
                if (!this.readers[i].isThisType(id)) continue;
                this.current = i;
                this.currentId = id;
                success = true;
                break;
            }
            if (!success) {
                throw new UnknownFormatException("Unknown file format: " + id);
            }
        }
        return this.getReader();
    }

    public IFormatReader getReader() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.readers[this.current];
    }

    public IFormatReader getReader(Class c) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].getClass().equals(c)) continue;
            return this.readers[i];
        }
        return null;
    }

    public IFormatReader[] getReaders() {
        IFormatReader[] r = new IFormatReader[this.readers.length];
        System.arraycopy(this.readers, 0, r, 0, this.readers.length);
        return r;
    }

    public boolean isThisType(String name, boolean open) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].isThisType(name, open)) continue;
            return true;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].isThisType(block)) continue;
            return true;
        }
        return false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].isThisType(stream)) continue;
            return true;
        }
        return false;
    }

    public int getImageCount() {
        return this.getReader().getImageCount();
    }

    public boolean isRGB() {
        return this.getReader().isRGB();
    }

    public int getSizeX() {
        return this.getReader().getSizeX();
    }

    public int getSizeY() {
        return this.getReader().getSizeY();
    }

    public int getSizeC() {
        return this.getReader().getSizeC();
    }

    public int getSizeZ() {
        return this.getReader().getSizeZ();
    }

    public int getSizeT() {
        return this.getReader().getSizeT();
    }

    public int getPixelType() {
        return this.getReader().getPixelType();
    }

    public int getBitsPerPixel() {
        return this.getReader().getBitsPerPixel();
    }

    public int getEffectiveSizeC() {
        return this.getReader().getEffectiveSizeC();
    }

    public int getRGBChannelCount() {
        return this.getReader().getRGBChannelCount();
    }

    public boolean isIndexed() {
        return this.getReader().isIndexed();
    }

    public boolean isFalseColor() {
        return this.getReader().isFalseColor();
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.getReader().get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.getReader().get16BitLookupTable();
    }

    public int[] getChannelDimLengths() {
        return this.getReader().getChannelDimLengths();
    }

    public String[] getChannelDimTypes() {
        return this.getReader().getChannelDimTypes();
    }

    public int getThumbSizeX() {
        return this.getReader().getThumbSizeX();
    }

    public int getThumbSizeY() {
        return this.getReader().getThumbSizeY();
    }

    public boolean isLittleEndian() {
        return this.getReader().isLittleEndian();
    }

    public String getDimensionOrder() {
        return this.getReader().getDimensionOrder();
    }

    public boolean isOrderCertain() {
        return this.getReader().isOrderCertain();
    }

    public boolean isThumbnailSeries() {
        return this.getReader().isThumbnailSeries();
    }

    public boolean isInterleaved() {
        return this.getReader().isInterleaved();
    }

    public boolean isInterleaved(int subC) {
        return this.getReader().isInterleaved(subC);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.getReader().openBytes(no);
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.getReader().openBytes(no, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.getReader().openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.getReader().openBytes(no, buf, x, y, w, h);
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.getReader().openPlane(no, x, y, w, h);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return this.getReader().openThumbBytes(no);
    }

    public int getSeriesCount() {
        return this.getReader().getSeriesCount();
    }

    public void setSeries(int no) {
        this.getReader().setSeries(no);
    }

    public int getSeries() {
        return this.getReader().getSeries();
    }

    public String[] getUsedFiles() {
        return this.getReader().getUsedFiles();
    }

    public String[] getUsedFiles(boolean noPixels) {
        return this.getReader().getUsedFiles(noPixels);
    }

    public String[] getSeriesUsedFiles() {
        return this.getReader().getSeriesUsedFiles();
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        return this.getReader().getSeriesUsedFiles(noPixels);
    }

    public FileInfo[] getAdvancedUsedFiles(boolean noPixels) {
        return this.getReader().getAdvancedUsedFiles(noPixels);
    }

    public FileInfo[] getAdvancedSeriesUsedFiles(boolean noPixels) {
        return this.getReader().getAdvancedSeriesUsedFiles(noPixels);
    }

    public int getIndex(int z, int c, int t) {
        return this.getReader().getIndex(z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return this.getReader().getZCTCoords(index);
    }

    public Object getMetadataValue(String field) {
        return this.getReader().getMetadataValue(field);
    }

    public Hashtable getGlobalMetadata() {
        return this.getReader().getGlobalMetadata();
    }

    public Hashtable getSeriesMetadata() {
        return this.getReader().getSeriesMetadata();
    }

    public Hashtable getMetadata() {
        return this.getReader().getMetadata();
    }

    public CoreMetadata[] getCoreMetadata() {
        return this.getReader().getCoreMetadata();
    }

    public void close(boolean fileOnly) throws IOException {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].close(fileOnly);
        }
        if (!fileOnly) {
            this.currentId = null;
        }
    }

    public void setGroupFiles(boolean group) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setGroupFiles(group);
        }
    }

    public boolean isGroupFiles() {
        return this.getReader().isGroupFiles();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.getReader(id).fileGroupOption(id);
    }

    public boolean isMetadataComplete() {
        return this.getReader().isMetadataComplete();
    }

    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setNormalized(normalize);
        }
    }

    public boolean isNormalized() {
        return this.readers[0].isNormalized();
    }

    public void setMetadataCollected(boolean collect) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataCollected(collect);
        }
    }

    public boolean isMetadataCollected() {
        return this.readers[0].isMetadataCollected();
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setOriginalMetadataPopulated(populate);
        }
    }

    public boolean isOriginalMetadataPopulated() {
        return this.readers[0].isOriginalMetadataPopulated();
    }

    public String getCurrentFile() {
        return this.currentId;
    }

    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataFiltered(filter);
        }
    }

    public boolean isMetadataFiltered() {
        return this.readers[0].isMetadataFiltered();
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataStore(store);
        }
    }

    public MetadataStore getMetadataStore() {
        return this.getReader().getMetadataStore();
    }

    public Object getMetadataStoreRoot() {
        return this.getReader().getMetadataStoreRoot();
    }

    public IFormatReader[] getUnderlyingReaders() {
        return this.getReaders();
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return this.getReader(id).isSingleFile(id);
    }

    public String[] getPossibleDomains(String id) throws FormatException, IOException {
        return this.getReader(id).getPossibleDomains(id);
    }

    public String[] getDomains() {
        return this.getReader().getDomains();
    }

    public boolean isThisType(String name) {
        return this.isThisType(name, false) || this.isThisType(name, true);
    }

    public String getFormat() {
        return this.getReader().getFormat();
    }

    public String[] getSuffixes() {
        if (this.suffixes == null) {
            HashSet<String> suffixSet = new HashSet<String>();
            for (int i = 0; i < this.readers.length; ++i) {
                String[] suf = this.readers[i].getSuffixes();
                for (int j = 0; j < suf.length; ++j) {
                    suffixSet.add(suf[j]);
                }
            }
            this.suffixes = new String[suffixSet.size()];
            suffixSet.toArray(this.suffixes);
            Arrays.sort(this.suffixes);
        }
        return this.suffixes;
    }

    public Class getNativeDataType() {
        return this.getReader().getNativeDataType();
    }

    public void setId(String id) throws FormatException, IOException {
        this.getReader(id).setId(id);
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void addStatusListener(StatusListener l) {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].addStatusListener(l);
        }
    }

    public void removeStatusListener(StatusListener l) {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].removeStatusListener(l);
        }
    }

    public StatusListener[] getStatusListeners() {
        return this.readers[0].getStatusListeners();
    }
}

