/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Plate;
import omero.model.Reagent;
import omero.model.Well;
import omero.model.WellAnnotationLink;
import omero.model.WellAnnotationLinkI;
import omero.model.WellReagentLink;
import omero.model.WellReagentLinkI;
import omero.model.WellSample;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WellI
extends Well
implements ModelBased {
    public static final String COLUMN = "ome.model.screen.Well_column";
    public static final String ROW = "ome.model.screen.Well_row";
    public static final String RED = "ome.model.screen.Well_red";
    public static final String GREEN = "ome.model.screen.Well_green";
    public static final String BLUE = "ome.model.screen.Well_blue";
    public static final String ALPHA = "ome.model.screen.Well_alpha";
    public static final String REAGENTLINKS = "ome.model.screen.Well_reagentLinks";
    public static final String EXTERNALDESCRIPTION = "ome.model.screen.Well_externalDescription";
    public static final String EXTERNALIDENTIFIER = "ome.model.screen.Well_externalIdentifier";
    public static final String TYPE = "ome.model.screen.Well_type";
    public static final String WELLSAMPLES = "ome.model.screen.Well_wellSamples";
    public static final String PLATE = "ome.model.screen.Well_plate";
    public static final String ANNOTATIONLINKS = "ome.model.screen.Well_annotationLinks";
    public static final String DETAILS = "ome.model.screen.Well_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.reagentLinksSeq = new ArrayList();
            this.reagentLinksLoaded = true;
        } else {
            this.reagentLinksSeq = null;
            this.reagentLinksLoaded = false;
        }
        if (load) {
            this.wellSamplesSeq = new ArrayList();
            this.wellSamplesLoaded = true;
        } else {
            this.wellSamplesSeq = null;
            this.wellSamplesLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public WellI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public WellI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public WellI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadColumn();
        this.unloadRow();
        this.unloadRed();
        this.unloadGreen();
        this.unloadBlue();
        this.unloadAlpha();
        this.unloadReagentLinks();
        this.unloadExternalDescription();
        this.unloadExternalIdentifier();
        this.unloadType();
        this.unloadWellSamples();
        this.unloadPlate();
        this.unloadAnnotationLinks();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        WellI copy = new WellI();
        copy.id = this.id;
        copy.version = this.version;
        copy.column = this.column;
        copy.row = this.row;
        copy.red = this.red;
        copy.green = this.green;
        copy.blue = this.blue;
        copy.alpha = this.alpha;
        if (!this.reagentLinksLoaded) {
            copy.reagentLinksLoaded = false;
            copy.reagentLinksSeq = null;
        } else {
            copy.reagentLinksLoaded = true;
            copy.reagentLinksSeq = new ArrayList<WellReagentLink>();
            for (IObject item : this.reagentLinksSeq) {
                copy.reagentLinksSeq.add(item == null ? null : (WellReagentLink)item.proxy());
            }
        }
        copy.externalDescription = this.externalDescription;
        copy.externalIdentifier = this.externalIdentifier;
        copy.type = this.type;
        if (!this.wellSamplesLoaded) {
            copy.wellSamplesLoaded = false;
            copy.wellSamplesSeq = null;
        } else {
            copy.wellSamplesLoaded = true;
            copy.wellSamplesSeq = new ArrayList<WellSample>();
            for (IObject item : this.wellSamplesSeq) {
                copy.wellSamplesSeq.add(item == null ? null : (WellSample)item.proxy());
            }
        }
        Plate plate = copy.plate = this.plate == null ? null : (Plate)this.plate.proxy();
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<WellAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (WellAnnotationLink)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new WellI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadColumn() {
        this.column = null;
    }

    @Override
    public RInt getColumn(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.column;
    }

    @Override
    public void setColumn(RInt column, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.column = column;
    }

    private void copyColumn(ome.model.screen.Well source, IceMapper mapper) {
        this.column = source.getColumn() == null ? null : rtypes.rint(source.getColumn());
    }

    private void fillColumn(ome.model.screen.Well target, IceMapper mapper) {
        try {
            target.setColumn((Integer)mapper.fromRType(this.getColumn()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadRow() {
        this.row = null;
    }

    @Override
    public RInt getRow(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.row;
    }

    @Override
    public void setRow(RInt row, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.row = row;
    }

    private void copyRow(ome.model.screen.Well source, IceMapper mapper) {
        this.row = source.getRow() == null ? null : rtypes.rint(source.getRow());
    }

    private void fillRow(ome.model.screen.Well target, IceMapper mapper) {
        try {
            target.setRow((Integer)mapper.fromRType(this.getRow()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadRed() {
        this.red = null;
    }

    @Override
    public RInt getRed(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.red;
    }

    @Override
    public void setRed(RInt red, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.red = red;
    }

    private void copyRed(ome.model.screen.Well source, IceMapper mapper) {
        this.red = source.getRed() == null ? null : rtypes.rint(source.getRed());
    }

    private void fillRed(ome.model.screen.Well target, IceMapper mapper) {
        try {
            target.setRed((Integer)mapper.fromRType(this.getRed()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadGreen() {
        this.green = null;
    }

    @Override
    public RInt getGreen(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.green;
    }

    @Override
    public void setGreen(RInt green, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.green = green;
    }

    private void copyGreen(ome.model.screen.Well source, IceMapper mapper) {
        this.green = source.getGreen() == null ? null : rtypes.rint(source.getGreen());
    }

    private void fillGreen(ome.model.screen.Well target, IceMapper mapper) {
        try {
            target.setGreen((Integer)mapper.fromRType(this.getGreen()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadBlue() {
        this.blue = null;
    }

    @Override
    public RInt getBlue(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.blue;
    }

    @Override
    public void setBlue(RInt blue, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.blue = blue;
    }

    private void copyBlue(ome.model.screen.Well source, IceMapper mapper) {
        this.blue = source.getBlue() == null ? null : rtypes.rint(source.getBlue());
    }

    private void fillBlue(ome.model.screen.Well target, IceMapper mapper) {
        try {
            target.setBlue((Integer)mapper.fromRType(this.getBlue()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadAlpha() {
        this.alpha = null;
    }

    @Override
    public RInt getAlpha(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.alpha;
    }

    @Override
    public void setAlpha(RInt alpha, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.alpha = alpha;
    }

    private void copyAlpha(ome.model.screen.Well source, IceMapper mapper) {
        this.alpha = source.getAlpha() == null ? null : rtypes.rint(source.getAlpha());
    }

    private void fillAlpha(ome.model.screen.Well target, IceMapper mapper) {
        try {
            target.setAlpha((Integer)mapper.fromRType(this.getAlpha()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadReagentLinks(Current current) {
        this.reagentLinksLoaded = false;
        this.reagentLinksSeq = null;
    }

    protected List getReagentLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.reagentLinksSeq;
    }

    protected void setReagentLinks(List reagentLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.reagentLinksSeq = reagentLinks == null ? new ArrayList() : new ArrayList(reagentLinks);
        this.reagentLinksLoaded = reagentLinks != null;
    }

    private void copyReagentLinks(ome.model.screen.Well source, IceMapper mapper) {
        this.setReagentLinks((List)mapper.findCollection((Collection)source.retrieve(REAGENTLINKS)), null);
        this.reagentLinksCountPerOwner = source.getReagentLinksCountPerOwner();
    }

    private void fillReagentLinks(ome.model.screen.Well target, IceMapper mapper) {
        if (this.reagentLinksLoaded) {
            target.putAt(REAGENTLINKS, (Object)mapper.reverse(this.reagentLinksSeq, Set.class));
        } else {
            target.putAt(REAGENTLINKS, null);
        }
    }

    public boolean isReagentLinksLoaded() {
        return this.reagentLinksLoaded;
    }

    @Override
    public int sizeOfReagentLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            return -1;
        }
        return this.reagentLinksSeq.size();
    }

    public List copyReagentLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        ArrayList result = new ArrayList(this.reagentLinksSeq);
        return result;
    }

    public Iterator iterateReagentLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        return this.reagentLinksSeq.iterator();
    }

    @Override
    public void addWellReagentLink(WellReagentLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        this.reagentLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllWellReagentLinkSet(List<WellReagentLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        this.reagentLinksSeq.addAll(targets);
        for (WellReagentLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeWellReagentLink(WellReagentLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        this.reagentLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllWellReagentLinkSet(List<WellReagentLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        for (WellReagentLink elt : targets) {
            elt.setParent(null);
            this.reagentLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearReagentLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        for (WellReagentLink elt : this.reagentLinksSeq) {
            elt.setParent(null);
        }
        this.reagentLinksSeq.clear();
    }

    @Override
    public void reloadReagentLinks(Well toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.reagentLinksLoaded) {
            throw new ClientError("Cannot reload active collection: reagentLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<WellReagentLink> copy = toCopy.copyReagentLinks();
        for (WellReagentLink elt : copy) {
            elt.setParent(this);
        }
        this.reagentLinksSeq = new ArrayList<WellReagentLink>(copy);
        toCopy.unloadReagentLinks();
        this.reagentLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getReagentLinksCountPerOwner(Current current) {
        return this.reagentLinksCountPerOwner;
    }

    @Override
    public WellReagentLink linkReagent(Reagent addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        WellReagentLinkI link = new WellReagentLinkI();
        link.link(this, addition);
        this.addWellReagentLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addWellReagentLinkToBoth(WellReagentLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        this.reagentLinksSeq.add(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().addWellReagentLinkToBoth(link, false);
        }
    }

    @Override
    public List<WellReagentLink> findWellReagentLink(Reagent removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        ArrayList<WellReagentLink> result = new ArrayList<WellReagentLink>();
        for (WellReagentLink link : this.reagentLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkReagent(Reagent removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        List<WellReagentLink> toRemove = this.findWellReagentLink(removal);
        Iterator<WellReagentLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeWellReagentLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeWellReagentLinkFromBoth(WellReagentLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("reagentLinksSeq");
        }
        this.reagentLinksSeq.remove(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().removeWellReagentLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Reagent> linkedReagentList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLinksLoaded) {
            this.throwNullCollectionException("ReagentLinks");
        }
        ArrayList<Reagent> linked = new ArrayList<Reagent>();
        for (WellReagentLink link : this.reagentLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadExternalDescription() {
        this.externalDescription = null;
    }

    @Override
    public RString getExternalDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.externalDescription;
    }

    @Override
    public void setExternalDescription(RString externalDescription, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.externalDescription = externalDescription;
    }

    private void copyExternalDescription(ome.model.screen.Well source, IceMapper mapper) {
        this.externalDescription = source.getExternalDescription() == null ? null : rtypes.rstring(source.getExternalDescription());
    }

    private void fillExternalDescription(ome.model.screen.Well target, IceMapper mapper) {
        try {
            target.setExternalDescription((String)mapper.fromRType(this.getExternalDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadExternalIdentifier() {
        this.externalIdentifier = null;
    }

    @Override
    public RString getExternalIdentifier(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.externalIdentifier;
    }

    @Override
    public void setExternalIdentifier(RString externalIdentifier, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.externalIdentifier = externalIdentifier;
    }

    private void copyExternalIdentifier(ome.model.screen.Well source, IceMapper mapper) {
        this.externalIdentifier = source.getExternalIdentifier() == null ? null : rtypes.rstring(source.getExternalIdentifier());
    }

    private void fillExternalIdentifier(ome.model.screen.Well target, IceMapper mapper) {
        try {
            target.setExternalIdentifier((String)mapper.fromRType(this.getExternalIdentifier()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadType() {
        this.type = null;
    }

    @Override
    public RString getType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.type;
    }

    @Override
    public void setType(RString type, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.type = type;
    }

    private void copyType(ome.model.screen.Well source, IceMapper mapper) {
        this.type = source.getType() == null ? null : rtypes.rstring(source.getType());
    }

    private void fillType(ome.model.screen.Well target, IceMapper mapper) {
        try {
            target.setType((String)mapper.fromRType(this.getType()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadWellSamples(Current current) {
        this.wellSamplesLoaded = false;
        this.wellSamplesSeq = null;
    }

    protected List getWellSamples(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.wellSamplesSeq;
    }

    protected void setWellSamples(List wellSamples, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.wellSamplesSeq = wellSamples == null ? new ArrayList() : new ArrayList(wellSamples);
        this.wellSamplesLoaded = wellSamples != null;
    }

    private void copyWellSamples(ome.model.screen.Well source, IceMapper mapper) {
        this.setWellSamples((List)mapper.findCollection((Collection)source.retrieve(WELLSAMPLES)), null);
    }

    private void fillWellSamples(ome.model.screen.Well target, IceMapper mapper) {
        if (this.wellSamplesLoaded) {
            target.putAt(WELLSAMPLES, (Object)mapper.reverse(this.wellSamplesSeq, List.class));
        } else {
            target.putAt(WELLSAMPLES, null);
        }
    }

    public boolean isWellSamplesLoaded() {
        return this.wellSamplesLoaded;
    }

    @Override
    public int sizeOfWellSamples(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            return -1;
        }
        return this.wellSamplesSeq.size();
    }

    public List copyWellSamples(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        ArrayList result = new ArrayList(this.wellSamplesSeq);
        return result;
    }

    public Iterator iterateWellSamples() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        return this.wellSamplesSeq.iterator();
    }

    @Override
    public void addWellSample(WellSample target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        this.wellSamplesSeq.add(target);
        target.setWell(this);
    }

    @Override
    public void addAllWellSampleSet(List<WellSample> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        this.wellSamplesSeq.addAll(targets);
        for (WellSample target : targets) {
            target.setWell(this);
        }
    }

    @Override
    public void removeWellSample(WellSample target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        this.wellSamplesSeq.remove(target);
        target.setWell(null);
    }

    @Override
    public void removeAllWellSampleSet(List<WellSample> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        for (WellSample elt : targets) {
            elt.setWell(null);
            this.wellSamplesSeq.remove(elt);
        }
    }

    @Override
    public void clearWellSamples(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        for (WellSample elt : this.wellSamplesSeq) {
            elt.setWell(null);
        }
        this.wellSamplesSeq.clear();
    }

    @Override
    public void reloadWellSamples(Well toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.wellSamplesLoaded) {
            throw new ClientError("Cannot reload active collection: wellSamplesSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<WellSample> copy = toCopy.copyWellSamples();
        for (WellSample elt : copy) {
            elt.setWell(this);
        }
        this.wellSamplesSeq = new ArrayList<WellSample>(copy);
        toCopy.unloadWellSamples();
        this.wellSamplesLoaded = true;
    }

    @Override
    public WellSample getWellSample(int index, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        return (WellSample)this.wellSamplesSeq.get(index);
    }

    @Override
    public void setWellSample(int index, WellSample element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        this.wellSamplesSeq.set(index, element);
    }

    @Override
    public WellSample getPrimaryWellSample(Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        return (WellSample)this.wellSamplesSeq.get(0);
    }

    @Override
    public WellSample setPrimaryWellSample(WellSample element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        int index = this.wellSamplesSeq.indexOf(element);
        WellSample old = (WellSample)this.wellSamplesSeq.get(0);
        this.wellSamplesSeq.set(index, old);
        this.wellSamplesSeq.set(0, element);
        return old;
    }

    public void unloadPlate() {
        this.plate = null;
    }

    @Override
    public Plate getPlate(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.plate;
    }

    @Override
    public void setPlate(Plate plate, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.plate = plate;
    }

    private void copyPlate(ome.model.screen.Well source, IceMapper mapper) {
        this.plate = (Plate)mapper.findTarget(source.getPlate());
    }

    private void fillPlate(ome.model.screen.Well target, IceMapper mapper) {
        target.putAt(PLATE, (Object)mapper.reverse((ModelBased)((Object)this.getPlate())));
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.screen.Well source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.screen.Well target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addWellAnnotationLink(WellAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllWellAnnotationLinkSet(List<WellAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (WellAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeWellAnnotationLink(WellAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllWellAnnotationLinkSet(List<WellAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (WellAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (WellAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Well toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<WellAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (WellAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<WellAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public WellAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        WellAnnotationLinkI link = new WellAnnotationLinkI();
        link.link(this, addition);
        this.addWellAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addWellAnnotationLinkToBoth(WellAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<WellAnnotationLink> findWellAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<WellAnnotationLink> result = new ArrayList<WellAnnotationLink>();
        for (WellAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<WellAnnotationLink> toRemove = this.findWellAnnotationLink(removal);
        Iterator<WellAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeWellAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeWellAnnotationLinkFromBoth(WellAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (WellAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.screen.Well) {
            ome.model.screen.Well source = (ome.model.screen.Well)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyColumn(source, mapper);
                this.copyRow(source, mapper);
                this.copyRed(source, mapper);
                this.copyGreen(source, mapper);
                this.copyBlue(source, mapper);
                this.copyAlpha(source, mapper);
                this.copyReagentLinks(source, mapper);
                this.copyExternalDescription(source, mapper);
                this.copyExternalIdentifier(source, mapper);
                this.copyType(source, mapper);
                this.copyWellSamples(source, mapper);
                this.copyPlate(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Well cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.screen.Well target = new ome.model.screen.Well();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillColumn(target, mapper);
            this.fillRow(target, mapper);
            this.fillRed(target, mapper);
            this.fillGreen(target, mapper);
            this.fillBlue(target, mapper);
            this.fillAlpha(target, mapper);
            this.fillReagentLinks(target, mapper);
            this.fillExternalDescription(target, mapper);
            this.fillExternalIdentifier(target, mapper);
            this.fillType(target, mapper);
            this.fillWellSamples(target, mapper);
            this.fillPlate(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<WellI> cast(List list) {
        return list;
    }
}

