/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Detector;
import omero.model.Dichroic;
import omero.model.Filter;
import omero.model.FilterSet;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.LightSource;
import omero.model.Microscope;
import omero.model.OTF;
import omero.model.Objective;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentI
extends Instrument
implements ModelBased {
    public static final String MICROSCOPE = "ome.model.acquisition.Instrument_microscope";
    public static final String DETECTOR = "ome.model.acquisition.Instrument_detector";
    public static final String OBJECTIVE = "ome.model.acquisition.Instrument_objective";
    public static final String LIGHTSOURCE = "ome.model.acquisition.Instrument_lightSource";
    public static final String FILTER = "ome.model.acquisition.Instrument_filter";
    public static final String DICHROIC = "ome.model.acquisition.Instrument_dichroic";
    public static final String FILTERSET = "ome.model.acquisition.Instrument_filterSet";
    public static final String OTF = "ome.model.acquisition.Instrument_otf";
    public static final String DETAILS = "ome.model.acquisition.Instrument_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.detectorSeq = new ArrayList();
            this.detectorLoaded = true;
        } else {
            this.detectorSeq = null;
            this.detectorLoaded = false;
        }
        if (load) {
            this.objectiveSeq = new ArrayList();
            this.objectiveLoaded = true;
        } else {
            this.objectiveSeq = null;
            this.objectiveLoaded = false;
        }
        if (load) {
            this.lightSourceSeq = new ArrayList();
            this.lightSourceLoaded = true;
        } else {
            this.lightSourceSeq = null;
            this.lightSourceLoaded = false;
        }
        if (load) {
            this.filterSeq = new ArrayList();
            this.filterLoaded = true;
        } else {
            this.filterSeq = null;
            this.filterLoaded = false;
        }
        if (load) {
            this.dichroicSeq = new ArrayList();
            this.dichroicLoaded = true;
        } else {
            this.dichroicSeq = null;
            this.dichroicLoaded = false;
        }
        if (load) {
            this.filterSetSeq = new ArrayList();
            this.filterSetLoaded = true;
        } else {
            this.filterSetSeq = null;
            this.filterSetLoaded = false;
        }
        if (load) {
            this.otfSeq = new ArrayList();
            this.otfLoaded = true;
        } else {
            this.otfSeq = null;
            this.otfLoaded = false;
        }
    }

    public InstrumentI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public InstrumentI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public InstrumentI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadMicroscope();
        this.unloadDetector();
        this.unloadObjective();
        this.unloadLightSource();
        this.unloadFilter();
        this.unloadDichroic();
        this.unloadFilterSet();
        this.unloadOtf();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        InstrumentI copy = new InstrumentI();
        copy.id = this.id;
        copy.version = this.version;
        Microscope microscope = copy.microscope = this.microscope == null ? null : (Microscope)this.microscope.proxy();
        if (!this.detectorLoaded) {
            copy.detectorLoaded = false;
            copy.detectorSeq = null;
        } else {
            copy.detectorLoaded = true;
            copy.detectorSeq = new ArrayList<Detector>();
            for (IObject item : this.detectorSeq) {
                copy.detectorSeq.add(item == null ? null : (Detector)item.proxy());
            }
        }
        if (!this.objectiveLoaded) {
            copy.objectiveLoaded = false;
            copy.objectiveSeq = null;
        } else {
            copy.objectiveLoaded = true;
            copy.objectiveSeq = new ArrayList<Objective>();
            for (IObject item : this.objectiveSeq) {
                copy.objectiveSeq.add(item == null ? null : (Objective)item.proxy());
            }
        }
        if (!this.lightSourceLoaded) {
            copy.lightSourceLoaded = false;
            copy.lightSourceSeq = null;
        } else {
            copy.lightSourceLoaded = true;
            copy.lightSourceSeq = new ArrayList<LightSource>();
            for (IObject item : this.lightSourceSeq) {
                copy.lightSourceSeq.add(item == null ? null : (LightSource)item.proxy());
            }
        }
        if (!this.filterLoaded) {
            copy.filterLoaded = false;
            copy.filterSeq = null;
        } else {
            copy.filterLoaded = true;
            copy.filterSeq = new ArrayList<Filter>();
            for (IObject item : this.filterSeq) {
                copy.filterSeq.add(item == null ? null : (Filter)item.proxy());
            }
        }
        if (!this.dichroicLoaded) {
            copy.dichroicLoaded = false;
            copy.dichroicSeq = null;
        } else {
            copy.dichroicLoaded = true;
            copy.dichroicSeq = new ArrayList<Dichroic>();
            for (IObject item : this.dichroicSeq) {
                copy.dichroicSeq.add(item == null ? null : (Dichroic)item.proxy());
            }
        }
        if (!this.filterSetLoaded) {
            copy.filterSetLoaded = false;
            copy.filterSetSeq = null;
        } else {
            copy.filterSetLoaded = true;
            copy.filterSetSeq = new ArrayList<FilterSet>();
            for (IObject item : this.filterSetSeq) {
                copy.filterSetSeq.add(item == null ? null : (FilterSet)item.proxy());
            }
        }
        if (!this.otfLoaded) {
            copy.otfLoaded = false;
            copy.otfSeq = null;
        } else {
            copy.otfLoaded = true;
            copy.otfSeq = new ArrayList<OTF>();
            for (IObject item : this.otfSeq) {
                copy.otfSeq.add(item == null ? null : (OTF)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new InstrumentI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadMicroscope() {
        this.microscope = null;
    }

    @Override
    public Microscope getMicroscope(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.microscope;
    }

    @Override
    public void setMicroscope(Microscope microscope, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.microscope = microscope;
    }

    private void copyMicroscope(ome.model.acquisition.Instrument source, IceMapper mapper) {
        this.microscope = (Microscope)mapper.findTarget(source.getMicroscope());
    }

    private void fillMicroscope(ome.model.acquisition.Instrument target, IceMapper mapper) {
        target.putAt(MICROSCOPE, (Object)mapper.reverse((ModelBased)((Object)this.getMicroscope())));
    }

    @Override
    public void unloadDetector(Current current) {
        this.detectorLoaded = false;
        this.detectorSeq = null;
    }

    protected List getDetector(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.detectorSeq;
    }

    protected void setDetector(List detector, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.detectorSeq = detector == null ? new ArrayList() : new ArrayList(detector);
        this.detectorLoaded = detector != null;
    }

    private void copyDetector(ome.model.acquisition.Instrument source, IceMapper mapper) {
        this.setDetector((List)mapper.findCollection((Collection)source.retrieve(DETECTOR)), null);
    }

    private void fillDetector(ome.model.acquisition.Instrument target, IceMapper mapper) {
        if (this.detectorLoaded) {
            target.putAt(DETECTOR, (Object)mapper.reverse(this.detectorSeq, Set.class));
        } else {
            target.putAt(DETECTOR, null);
        }
    }

    public boolean isDetectorLoaded() {
        return this.detectorLoaded;
    }

    @Override
    public int sizeOfDetector(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.detectorLoaded) {
            return -1;
        }
        return this.detectorSeq.size();
    }

    public List copyDetector(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.detectorLoaded) {
            this.throwNullCollectionException("detectorSeq");
        }
        ArrayList result = new ArrayList(this.detectorSeq);
        return result;
    }

    public Iterator iterateDetector() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.detectorLoaded) {
            this.throwNullCollectionException("detectorSeq");
        }
        return this.detectorSeq.iterator();
    }

    @Override
    public void addDetector(Detector target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.detectorLoaded) {
            this.throwNullCollectionException("detectorSeq");
        }
        this.detectorSeq.add(target);
        target.setInstrument(this);
    }

    @Override
    public void addAllDetectorSet(List<Detector> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.detectorLoaded) {
            this.throwNullCollectionException("detectorSeq");
        }
        this.detectorSeq.addAll(targets);
        for (Detector target : targets) {
            target.setInstrument(this);
        }
    }

    @Override
    public void removeDetector(Detector target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.detectorLoaded) {
            this.throwNullCollectionException("detectorSeq");
        }
        this.detectorSeq.remove(target);
        target.setInstrument(null);
    }

    @Override
    public void removeAllDetectorSet(List<Detector> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.detectorLoaded) {
            this.throwNullCollectionException("detectorSeq");
        }
        for (Detector elt : targets) {
            elt.setInstrument(null);
            this.detectorSeq.remove(elt);
        }
    }

    @Override
    public void clearDetector(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.detectorLoaded) {
            this.throwNullCollectionException("detectorSeq");
        }
        for (Detector elt : this.detectorSeq) {
            elt.setInstrument(null);
        }
        this.detectorSeq.clear();
    }

    @Override
    public void reloadDetector(Instrument toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.detectorLoaded) {
            throw new ClientError("Cannot reload active collection: detectorSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Detector> copy = toCopy.copyDetector();
        for (Detector elt : copy) {
            elt.setInstrument(this);
        }
        this.detectorSeq = new ArrayList<Detector>(copy);
        toCopy.unloadDetector();
        this.detectorLoaded = true;
    }

    @Override
    public void unloadObjective(Current current) {
        this.objectiveLoaded = false;
        this.objectiveSeq = null;
    }

    protected List getObjective(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.objectiveSeq;
    }

    protected void setObjective(List objective, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.objectiveSeq = objective == null ? new ArrayList() : new ArrayList(objective);
        this.objectiveLoaded = objective != null;
    }

    private void copyObjective(ome.model.acquisition.Instrument source, IceMapper mapper) {
        this.setObjective((List)mapper.findCollection((Collection)source.retrieve(OBJECTIVE)), null);
    }

    private void fillObjective(ome.model.acquisition.Instrument target, IceMapper mapper) {
        if (this.objectiveLoaded) {
            target.putAt(OBJECTIVE, (Object)mapper.reverse(this.objectiveSeq, Set.class));
        } else {
            target.putAt(OBJECTIVE, null);
        }
    }

    public boolean isObjectiveLoaded() {
        return this.objectiveLoaded;
    }

    @Override
    public int sizeOfObjective(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.objectiveLoaded) {
            return -1;
        }
        return this.objectiveSeq.size();
    }

    public List copyObjective(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.objectiveLoaded) {
            this.throwNullCollectionException("objectiveSeq");
        }
        ArrayList result = new ArrayList(this.objectiveSeq);
        return result;
    }

    public Iterator iterateObjective() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.objectiveLoaded) {
            this.throwNullCollectionException("objectiveSeq");
        }
        return this.objectiveSeq.iterator();
    }

    @Override
    public void addObjective(Objective target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.objectiveLoaded) {
            this.throwNullCollectionException("objectiveSeq");
        }
        this.objectiveSeq.add(target);
        target.setInstrument(this);
    }

    @Override
    public void addAllObjectiveSet(List<Objective> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.objectiveLoaded) {
            this.throwNullCollectionException("objectiveSeq");
        }
        this.objectiveSeq.addAll(targets);
        for (Objective target : targets) {
            target.setInstrument(this);
        }
    }

    @Override
    public void removeObjective(Objective target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.objectiveLoaded) {
            this.throwNullCollectionException("objectiveSeq");
        }
        this.objectiveSeq.remove(target);
        target.setInstrument(null);
    }

    @Override
    public void removeAllObjectiveSet(List<Objective> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.objectiveLoaded) {
            this.throwNullCollectionException("objectiveSeq");
        }
        for (Objective elt : targets) {
            elt.setInstrument(null);
            this.objectiveSeq.remove(elt);
        }
    }

    @Override
    public void clearObjective(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.objectiveLoaded) {
            this.throwNullCollectionException("objectiveSeq");
        }
        for (Objective elt : this.objectiveSeq) {
            elt.setInstrument(null);
        }
        this.objectiveSeq.clear();
    }

    @Override
    public void reloadObjective(Instrument toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.objectiveLoaded) {
            throw new ClientError("Cannot reload active collection: objectiveSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Objective> copy = toCopy.copyObjective();
        for (Objective elt : copy) {
            elt.setInstrument(this);
        }
        this.objectiveSeq = new ArrayList<Objective>(copy);
        toCopy.unloadObjective();
        this.objectiveLoaded = true;
    }

    @Override
    public void unloadLightSource(Current current) {
        this.lightSourceLoaded = false;
        this.lightSourceSeq = null;
    }

    protected List getLightSource(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lightSourceSeq;
    }

    protected void setLightSource(List lightSource, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lightSourceSeq = lightSource == null ? new ArrayList() : new ArrayList(lightSource);
        this.lightSourceLoaded = lightSource != null;
    }

    private void copyLightSource(ome.model.acquisition.Instrument source, IceMapper mapper) {
        this.setLightSource((List)mapper.findCollection((Collection)source.retrieve(LIGHTSOURCE)), null);
    }

    private void fillLightSource(ome.model.acquisition.Instrument target, IceMapper mapper) {
        if (this.lightSourceLoaded) {
            target.putAt(LIGHTSOURCE, (Object)mapper.reverse(this.lightSourceSeq, Set.class));
        } else {
            target.putAt(LIGHTSOURCE, null);
        }
    }

    public boolean isLightSourceLoaded() {
        return this.lightSourceLoaded;
    }

    @Override
    public int sizeOfLightSource(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceLoaded) {
            return -1;
        }
        return this.lightSourceSeq.size();
    }

    public List copyLightSource(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceLoaded) {
            this.throwNullCollectionException("lightSourceSeq");
        }
        ArrayList result = new ArrayList(this.lightSourceSeq);
        return result;
    }

    public Iterator iterateLightSource() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceLoaded) {
            this.throwNullCollectionException("lightSourceSeq");
        }
        return this.lightSourceSeq.iterator();
    }

    @Override
    public void addLightSource(LightSource target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceLoaded) {
            this.throwNullCollectionException("lightSourceSeq");
        }
        this.lightSourceSeq.add(target);
        target.setInstrument(this);
    }

    @Override
    public void addAllLightSourceSet(List<LightSource> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceLoaded) {
            this.throwNullCollectionException("lightSourceSeq");
        }
        this.lightSourceSeq.addAll(targets);
        for (LightSource target : targets) {
            target.setInstrument(this);
        }
    }

    @Override
    public void removeLightSource(LightSource target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceLoaded) {
            this.throwNullCollectionException("lightSourceSeq");
        }
        this.lightSourceSeq.remove(target);
        target.setInstrument(null);
    }

    @Override
    public void removeAllLightSourceSet(List<LightSource> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceLoaded) {
            this.throwNullCollectionException("lightSourceSeq");
        }
        for (LightSource elt : targets) {
            elt.setInstrument(null);
            this.lightSourceSeq.remove(elt);
        }
    }

    @Override
    public void clearLightSource(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceLoaded) {
            this.throwNullCollectionException("lightSourceSeq");
        }
        for (LightSource elt : this.lightSourceSeq) {
            elt.setInstrument(null);
        }
        this.lightSourceSeq.clear();
    }

    @Override
    public void reloadLightSource(Instrument toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.lightSourceLoaded) {
            throw new ClientError("Cannot reload active collection: lightSourceSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<LightSource> copy = toCopy.copyLightSource();
        for (LightSource elt : copy) {
            elt.setInstrument(this);
        }
        this.lightSourceSeq = new ArrayList<LightSource>(copy);
        toCopy.unloadLightSource();
        this.lightSourceLoaded = true;
    }

    @Override
    public void unloadFilter(Current current) {
        this.filterLoaded = false;
        this.filterSeq = null;
    }

    protected List getFilter(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.filterSeq;
    }

    protected void setFilter(List filter, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.filterSeq = filter == null ? new ArrayList() : new ArrayList(filter);
        this.filterLoaded = filter != null;
    }

    private void copyFilter(ome.model.acquisition.Instrument source, IceMapper mapper) {
        this.setFilter((List)mapper.findCollection((Collection)source.retrieve(FILTER)), null);
    }

    private void fillFilter(ome.model.acquisition.Instrument target, IceMapper mapper) {
        if (this.filterLoaded) {
            target.putAt(FILTER, (Object)mapper.reverse(this.filterSeq, Set.class));
        } else {
            target.putAt(FILTER, null);
        }
    }

    public boolean isFilterLoaded() {
        return this.filterLoaded;
    }

    @Override
    public int sizeOfFilter(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterLoaded) {
            return -1;
        }
        return this.filterSeq.size();
    }

    public List copyFilter(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterLoaded) {
            this.throwNullCollectionException("filterSeq");
        }
        ArrayList result = new ArrayList(this.filterSeq);
        return result;
    }

    public Iterator iterateFilter() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterLoaded) {
            this.throwNullCollectionException("filterSeq");
        }
        return this.filterSeq.iterator();
    }

    @Override
    public void addFilter(Filter target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterLoaded) {
            this.throwNullCollectionException("filterSeq");
        }
        this.filterSeq.add(target);
        target.setInstrument(this);
    }

    @Override
    public void addAllFilterSet(List<Filter> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterLoaded) {
            this.throwNullCollectionException("filterSeq");
        }
        this.filterSeq.addAll(targets);
        for (Filter target : targets) {
            target.setInstrument(this);
        }
    }

    @Override
    public void removeFilter(Filter target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterLoaded) {
            this.throwNullCollectionException("filterSeq");
        }
        this.filterSeq.remove(target);
        target.setInstrument(null);
    }

    @Override
    public void removeAllFilterSet(List<Filter> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterLoaded) {
            this.throwNullCollectionException("filterSeq");
        }
        for (Filter elt : targets) {
            elt.setInstrument(null);
            this.filterSeq.remove(elt);
        }
    }

    @Override
    public void clearFilter(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterLoaded) {
            this.throwNullCollectionException("filterSeq");
        }
        for (Filter elt : this.filterSeq) {
            elt.setInstrument(null);
        }
        this.filterSeq.clear();
    }

    @Override
    public void reloadFilter(Instrument toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.filterLoaded) {
            throw new ClientError("Cannot reload active collection: filterSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Filter> copy = toCopy.copyFilter();
        for (Filter elt : copy) {
            elt.setInstrument(this);
        }
        this.filterSeq = new ArrayList<Filter>(copy);
        toCopy.unloadFilter();
        this.filterLoaded = true;
    }

    @Override
    public void unloadDichroic(Current current) {
        this.dichroicLoaded = false;
        this.dichroicSeq = null;
    }

    protected List getDichroic(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.dichroicSeq;
    }

    protected void setDichroic(List dichroic, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.dichroicSeq = dichroic == null ? new ArrayList() : new ArrayList(dichroic);
        this.dichroicLoaded = dichroic != null;
    }

    private void copyDichroic(ome.model.acquisition.Instrument source, IceMapper mapper) {
        this.setDichroic((List)mapper.findCollection((Collection)source.retrieve(DICHROIC)), null);
    }

    private void fillDichroic(ome.model.acquisition.Instrument target, IceMapper mapper) {
        if (this.dichroicLoaded) {
            target.putAt(DICHROIC, (Object)mapper.reverse(this.dichroicSeq, Set.class));
        } else {
            target.putAt(DICHROIC, null);
        }
    }

    public boolean isDichroicLoaded() {
        return this.dichroicLoaded;
    }

    @Override
    public int sizeOfDichroic(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.dichroicLoaded) {
            return -1;
        }
        return this.dichroicSeq.size();
    }

    public List copyDichroic(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.dichroicLoaded) {
            this.throwNullCollectionException("dichroicSeq");
        }
        ArrayList result = new ArrayList(this.dichroicSeq);
        return result;
    }

    public Iterator iterateDichroic() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.dichroicLoaded) {
            this.throwNullCollectionException("dichroicSeq");
        }
        return this.dichroicSeq.iterator();
    }

    @Override
    public void addDichroic(Dichroic target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.dichroicLoaded) {
            this.throwNullCollectionException("dichroicSeq");
        }
        this.dichroicSeq.add(target);
        target.setInstrument(this);
    }

    @Override
    public void addAllDichroicSet(List<Dichroic> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.dichroicLoaded) {
            this.throwNullCollectionException("dichroicSeq");
        }
        this.dichroicSeq.addAll(targets);
        for (Dichroic target : targets) {
            target.setInstrument(this);
        }
    }

    @Override
    public void removeDichroic(Dichroic target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.dichroicLoaded) {
            this.throwNullCollectionException("dichroicSeq");
        }
        this.dichroicSeq.remove(target);
        target.setInstrument(null);
    }

    @Override
    public void removeAllDichroicSet(List<Dichroic> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.dichroicLoaded) {
            this.throwNullCollectionException("dichroicSeq");
        }
        for (Dichroic elt : targets) {
            elt.setInstrument(null);
            this.dichroicSeq.remove(elt);
        }
    }

    @Override
    public void clearDichroic(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.dichroicLoaded) {
            this.throwNullCollectionException("dichroicSeq");
        }
        for (Dichroic elt : this.dichroicSeq) {
            elt.setInstrument(null);
        }
        this.dichroicSeq.clear();
    }

    @Override
    public void reloadDichroic(Instrument toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.dichroicLoaded) {
            throw new ClientError("Cannot reload active collection: dichroicSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Dichroic> copy = toCopy.copyDichroic();
        for (Dichroic elt : copy) {
            elt.setInstrument(this);
        }
        this.dichroicSeq = new ArrayList<Dichroic>(copy);
        toCopy.unloadDichroic();
        this.dichroicLoaded = true;
    }

    @Override
    public void unloadFilterSet(Current current) {
        this.filterSetLoaded = false;
        this.filterSetSeq = null;
    }

    protected List getFilterSet(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.filterSetSeq;
    }

    protected void setFilterSet(List filterSet, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.filterSetSeq = filterSet == null ? new ArrayList() : new ArrayList(filterSet);
        this.filterSetLoaded = filterSet != null;
    }

    private void copyFilterSet(ome.model.acquisition.Instrument source, IceMapper mapper) {
        this.setFilterSet((List)mapper.findCollection((Collection)source.retrieve(FILTERSET)), null);
    }

    private void fillFilterSet(ome.model.acquisition.Instrument target, IceMapper mapper) {
        if (this.filterSetLoaded) {
            target.putAt(FILTERSET, (Object)mapper.reverse(this.filterSetSeq, Set.class));
        } else {
            target.putAt(FILTERSET, null);
        }
    }

    public boolean isFilterSetLoaded() {
        return this.filterSetLoaded;
    }

    @Override
    public int sizeOfFilterSet(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterSetLoaded) {
            return -1;
        }
        return this.filterSetSeq.size();
    }

    public List copyFilterSet(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterSetLoaded) {
            this.throwNullCollectionException("filterSetSeq");
        }
        ArrayList result = new ArrayList(this.filterSetSeq);
        return result;
    }

    public Iterator iterateFilterSet() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterSetLoaded) {
            this.throwNullCollectionException("filterSetSeq");
        }
        return this.filterSetSeq.iterator();
    }

    @Override
    public void addFilterSet(FilterSet target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterSetLoaded) {
            this.throwNullCollectionException("filterSetSeq");
        }
        this.filterSetSeq.add(target);
        target.setInstrument(this);
    }

    @Override
    public void addAllFilterSetSet(List<FilterSet> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterSetLoaded) {
            this.throwNullCollectionException("filterSetSeq");
        }
        this.filterSetSeq.addAll(targets);
        for (FilterSet target : targets) {
            target.setInstrument(this);
        }
    }

    @Override
    public void removeFilterSet(FilterSet target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterSetLoaded) {
            this.throwNullCollectionException("filterSetSeq");
        }
        this.filterSetSeq.remove(target);
        target.setInstrument(null);
    }

    @Override
    public void removeAllFilterSetSet(List<FilterSet> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterSetLoaded) {
            this.throwNullCollectionException("filterSetSeq");
        }
        for (FilterSet elt : targets) {
            elt.setInstrument(null);
            this.filterSetSeq.remove(elt);
        }
    }

    @Override
    public void clearFilterSet(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.filterSetLoaded) {
            this.throwNullCollectionException("filterSetSeq");
        }
        for (FilterSet elt : this.filterSetSeq) {
            elt.setInstrument(null);
        }
        this.filterSetSeq.clear();
    }

    @Override
    public void reloadFilterSet(Instrument toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.filterSetLoaded) {
            throw new ClientError("Cannot reload active collection: filterSetSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<FilterSet> copy = toCopy.copyFilterSet();
        for (FilterSet elt : copy) {
            elt.setInstrument(this);
        }
        this.filterSetSeq = new ArrayList<FilterSet>(copy);
        toCopy.unloadFilterSet();
        this.filterSetLoaded = true;
    }

    @Override
    public void unloadOtf(Current current) {
        this.otfLoaded = false;
        this.otfSeq = null;
    }

    protected List getOtf(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.otfSeq;
    }

    protected void setOtf(List otf, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.otfSeq = otf == null ? new ArrayList() : new ArrayList(otf);
        this.otfLoaded = otf != null;
    }

    private void copyOtf(ome.model.acquisition.Instrument source, IceMapper mapper) {
        this.setOtf((List)mapper.findCollection((Collection)source.retrieve(OTF)), null);
    }

    private void fillOtf(ome.model.acquisition.Instrument target, IceMapper mapper) {
        if (this.otfLoaded) {
            target.putAt(OTF, (Object)mapper.reverse(this.otfSeq, Set.class));
        } else {
            target.putAt(OTF, null);
        }
    }

    public boolean isOtfLoaded() {
        return this.otfLoaded;
    }

    @Override
    public int sizeOfOtf(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.otfLoaded) {
            return -1;
        }
        return this.otfSeq.size();
    }

    public List copyOtf(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.otfLoaded) {
            this.throwNullCollectionException("otfSeq");
        }
        ArrayList result = new ArrayList(this.otfSeq);
        return result;
    }

    public Iterator iterateOtf() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.otfLoaded) {
            this.throwNullCollectionException("otfSeq");
        }
        return this.otfSeq.iterator();
    }

    @Override
    public void addOTF(OTF target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.otfLoaded) {
            this.throwNullCollectionException("otfSeq");
        }
        this.otfSeq.add(target);
        target.setInstrument(this);
    }

    @Override
    public void addAllOTFSet(List<OTF> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.otfLoaded) {
            this.throwNullCollectionException("otfSeq");
        }
        this.otfSeq.addAll(targets);
        for (OTF target : targets) {
            target.setInstrument(this);
        }
    }

    @Override
    public void removeOTF(OTF target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.otfLoaded) {
            this.throwNullCollectionException("otfSeq");
        }
        this.otfSeq.remove(target);
        target.setInstrument(null);
    }

    @Override
    public void removeAllOTFSet(List<OTF> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.otfLoaded) {
            this.throwNullCollectionException("otfSeq");
        }
        for (OTF elt : targets) {
            elt.setInstrument(null);
            this.otfSeq.remove(elt);
        }
    }

    @Override
    public void clearOtf(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.otfLoaded) {
            this.throwNullCollectionException("otfSeq");
        }
        for (OTF elt : this.otfSeq) {
            elt.setInstrument(null);
        }
        this.otfSeq.clear();
    }

    @Override
    public void reloadOtf(Instrument toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.otfLoaded) {
            throw new ClientError("Cannot reload active collection: otfSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<OTF> copy = toCopy.copyOtf();
        for (OTF elt : copy) {
            elt.setInstrument(this);
        }
        this.otfSeq = new ArrayList<OTF>(copy);
        toCopy.unloadOtf();
        this.otfLoaded = true;
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.Instrument) {
            ome.model.acquisition.Instrument source = (ome.model.acquisition.Instrument)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyMicroscope(source, mapper);
                this.copyDetector(source, mapper);
                this.copyObjective(source, mapper);
                this.copyLightSource(source, mapper);
                this.copyFilter(source, mapper);
                this.copyDichroic(source, mapper);
                this.copyFilterSet(source, mapper);
                this.copyOtf(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Instrument cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.Instrument target = new ome.model.acquisition.Instrument();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillMicroscope(target, mapper);
            this.fillDetector(target, mapper);
            this.fillObjective(target, mapper);
            this.fillLightSource(target, mapper);
            this.fillFilter(target, mapper);
            this.fillDichroic(target, mapper);
            this.fillFilterSet(target, mapper);
            this.fillOtf(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<InstrumentI> cast(List list) {
        return list;
    }
}

