/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Filter;
import omero.model.FilterType;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.TransmittanceRange;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterI
extends Filter
implements ModelBased {
    public static final String MANUFACTURER = "ome.model.acquisition.Filter_manufacturer";
    public static final String MODEL = "ome.model.acquisition.Filter_model";
    public static final String LOTNUMBER = "ome.model.acquisition.Filter_lotNumber";
    public static final String FILTERWHEEL = "ome.model.acquisition.Filter_filterWheel";
    public static final String TYPE = "ome.model.acquisition.Filter_type";
    public static final String TRANSMITTANCERANGE = "ome.model.acquisition.Filter_transmittanceRange";
    public static final String INSTRUMENT = "ome.model.acquisition.Filter_instrument";
    public static final String DETAILS = "ome.model.acquisition.Filter_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public FilterI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public FilterI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public FilterI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadManufacturer();
        this.unloadModel();
        this.unloadLotNumber();
        this.unloadFilterWheel();
        this.unloadType();
        this.unloadTransmittanceRange();
        this.unloadInstrument();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        FilterI copy = new FilterI();
        copy.id = this.id;
        copy.version = this.version;
        copy.manufacturer = this.manufacturer;
        copy.model = this.model;
        copy.lotNumber = this.lotNumber;
        copy.filterWheel = this.filterWheel;
        copy.type = this.type == null ? null : (FilterType)this.type.proxy();
        copy.transmittanceRange = this.transmittanceRange == null ? null : (TransmittanceRange)this.transmittanceRange.proxy();
        copy.instrument = this.instrument == null ? null : (Instrument)this.instrument.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new FilterI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadManufacturer() {
        this.manufacturer = null;
    }

    @Override
    public RString getManufacturer(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(RString manufacturer, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.manufacturer = manufacturer;
    }

    private void copyManufacturer(ome.model.acquisition.Filter source, IceMapper mapper) {
        this.manufacturer = source.getManufacturer() == null ? null : rtypes.rstring(source.getManufacturer());
    }

    private void fillManufacturer(ome.model.acquisition.Filter target, IceMapper mapper) {
        try {
            target.setManufacturer((String)mapper.fromRType(this.getManufacturer()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadModel() {
        this.model = null;
    }

    @Override
    public RString getModel(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.model;
    }

    @Override
    public void setModel(RString model, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.model = model;
    }

    private void copyModel(ome.model.acquisition.Filter source, IceMapper mapper) {
        this.model = source.getModel() == null ? null : rtypes.rstring(source.getModel());
    }

    private void fillModel(ome.model.acquisition.Filter target, IceMapper mapper) {
        try {
            target.setModel((String)mapper.fromRType(this.getModel()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadLotNumber() {
        this.lotNumber = null;
    }

    @Override
    public RString getLotNumber(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lotNumber;
    }

    @Override
    public void setLotNumber(RString lotNumber, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lotNumber = lotNumber;
    }

    private void copyLotNumber(ome.model.acquisition.Filter source, IceMapper mapper) {
        this.lotNumber = source.getLotNumber() == null ? null : rtypes.rstring(source.getLotNumber());
    }

    private void fillLotNumber(ome.model.acquisition.Filter target, IceMapper mapper) {
        try {
            target.setLotNumber((String)mapper.fromRType(this.getLotNumber()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadFilterWheel() {
        this.filterWheel = null;
    }

    @Override
    public RString getFilterWheel(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.filterWheel;
    }

    @Override
    public void setFilterWheel(RString filterWheel, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.filterWheel = filterWheel;
    }

    private void copyFilterWheel(ome.model.acquisition.Filter source, IceMapper mapper) {
        this.filterWheel = source.getFilterWheel() == null ? null : rtypes.rstring(source.getFilterWheel());
    }

    private void fillFilterWheel(ome.model.acquisition.Filter target, IceMapper mapper) {
        try {
            target.setFilterWheel((String)mapper.fromRType(this.getFilterWheel()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadType() {
        this.type = null;
    }

    @Override
    public FilterType getType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.type;
    }

    @Override
    public void setType(FilterType type, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.type = type;
    }

    private void copyType(ome.model.acquisition.Filter source, IceMapper mapper) {
        this.type = (FilterType)mapper.findTarget(source.getType());
    }

    private void fillType(ome.model.acquisition.Filter target, IceMapper mapper) {
        target.putAt(TYPE, (Object)mapper.reverse((ModelBased)((Object)this.getType())));
    }

    public void unloadTransmittanceRange() {
        this.transmittanceRange = null;
    }

    @Override
    public TransmittanceRange getTransmittanceRange(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.transmittanceRange;
    }

    @Override
    public void setTransmittanceRange(TransmittanceRange transmittanceRange, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.transmittanceRange = transmittanceRange;
    }

    private void copyTransmittanceRange(ome.model.acquisition.Filter source, IceMapper mapper) {
        this.transmittanceRange = (TransmittanceRange)mapper.findTarget(source.getTransmittanceRange());
    }

    private void fillTransmittanceRange(ome.model.acquisition.Filter target, IceMapper mapper) {
        target.putAt(TRANSMITTANCERANGE, (Object)mapper.reverse((ModelBased)((Object)this.getTransmittanceRange())));
    }

    public void unloadInstrument() {
        this.instrument = null;
    }

    @Override
    public Instrument getInstrument(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.instrument = instrument;
    }

    private void copyInstrument(ome.model.acquisition.Filter source, IceMapper mapper) {
        this.instrument = (Instrument)mapper.findTarget(source.getInstrument());
    }

    private void fillInstrument(ome.model.acquisition.Filter target, IceMapper mapper) {
        target.putAt(INSTRUMENT, (Object)mapper.reverse((ModelBased)((Object)this.getInstrument())));
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.Filter) {
            ome.model.acquisition.Filter source = (ome.model.acquisition.Filter)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyManufacturer(source, mapper);
                this.copyModel(source, mapper);
                this.copyLotNumber(source, mapper);
                this.copyFilterWheel(source, mapper);
                this.copyType(source, mapper);
                this.copyTransmittanceRange(source, mapper);
                this.copyInstrument(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Filter cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.Filter target = new ome.model.acquisition.Filter();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillManufacturer(target, mapper);
            this.fillModel(target, mapper);
            this.fillLotNumber(target, mapper);
            this.fillFilterWheel(target, mapper);
            this.fillType(target, mapper);
            this.fillTransmittanceRange(target, mapper);
            this.fillInstrument(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<FilterI> cast(List list) {
        return list;
    }
}

