/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.BasicStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamWrapper
extends InputStream {
    private BasicStream _s;
    private int _markPos;

    public InputStreamWrapper(int size, BasicStream s) {
        this._s = s;
        this._markPos = 0;
    }

    public int read() throws IOException {
        try {
            return this._s.getBuffer().b.get();
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int count) throws IOException {
        try {
            this._s.getBuffer().b.get(b, offset, count);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
        return count;
    }

    public int available() {
        return this._s.getBuffer().b.remaining();
    }

    public void mark(int readlimit) {
        this._markPos = this._s.pos();
    }

    public void reset() throws IOException {
        this._s.pos(this._markPos);
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
    }
}

