/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Logger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoggerI
implements Logger {
    String _prefix = "";
    String _lineSeparator;
    DateFormat _date;
    SimpleDateFormat _time;

    public LoggerI(String prefix) {
        if (prefix.length() > 0) {
            this._prefix = prefix + ": ";
        }
        this._lineSeparator = System.getProperty("line.separator");
        this._date = DateFormat.getDateInstance(3);
        this._time = new SimpleDateFormat(" HH:mm:ss:SSS");
    }

    public void print(String message) {
        System.err.print(message + this._lineSeparator);
    }

    public void trace(String category, String message) {
        StringBuilder s = new StringBuilder(256);
        s.append("[ ");
        s.append(this._date.format(new Date()));
        s.append(this._time.format(new Date()));
        s.append(' ');
        s.append(this._prefix);
        s.append(category);
        s.append(": ");
        s.append(message);
        s.append(" ]");
        int idx = 0;
        while ((idx = s.indexOf("\n", idx)) != -1) {
            s.insert(idx + 1, "  ");
            ++idx;
        }
        s.append(this._lineSeparator);
        System.err.print(s.toString());
    }

    public void warning(String message) {
        StringBuilder s = new StringBuilder(256);
        s.append(this._date.format(new Date()));
        s.append(this._time.format(new Date()));
        s.append(' ');
        s.append(this._prefix);
        s.append("warning: ");
        s.append(Thread.currentThread().getName());
        s.append(": ");
        s.append(message);
        s.append(this._lineSeparator);
        System.err.print(s.toString());
    }

    public void error(String message) {
        StringBuilder s = new StringBuilder(256);
        s.append(this._date.format(new Date()));
        s.append(this._time.format(new Date()));
        s.append(' ');
        s.append(this._prefix);
        s.append("error: ");
        s.append(Thread.currentThread().getName());
        s.append(": ");
        s.append(message);
        s.append(this._lineSeparator);
        System.err.print(s.toString());
    }
}

