/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.util;

import Ice.Current;
import Ice.Identity;
import Ice.UserException;
import Ice.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import ome.api.ServiceInterface;
import ome.services.blitz.util.UnregisterServantMessage;
import ome.system.OmeroContext;
import ome.util.messages.InternalMessage;
import omero.ServerError;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IceMethodInvoker {
    private static Log log = LogFactory.getLog(IceMethodInvoker.class);
    private static final Map<Class<?>, Map<String, Info>> staticmap = new HashMap();
    private final Class<?> serviceClass;
    private OmeroContext ctx;

    public IceMethodInvoker(ServiceInterface srv, OmeroContext context) {
        this(srv.getClass(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends ServiceInterface> IceMethodInvoker(Class<S> k, OmeroContext context) {
        this.serviceClass = k;
        this.ctx = context;
        if (!staticmap.containsKey(this.serviceClass)) {
            Map<Class<?>, Map<String, Info>> map = staticmap;
            synchronized (map) {
                if (!staticmap.containsKey(this.serviceClass)) {
                    Method[] ms;
                    HashMap<String, Info> map2 = new HashMap<String, Info>();
                    for (Method m : ms = this.serviceClass.getMethods()) {
                        Info i = new Info();
                        i.method = m;
                        i.params = m.getParameterTypes();
                        i.retType = m.getReturnType();
                        map2.put(m.getName(), i);
                    }
                    staticmap.put(this.serviceClass, map2);
                }
            }
        }
    }

    Map<String, Info> map() {
        return staticmap.get(this.serviceClass);
    }

    public boolean isVoid(Current current) {
        Info info = this.map().get(current.operation);
        return info.retType.equals(Void.TYPE);
    }

    public Object invoke(Object obj, Current current, IceMapper mapper, Object ... args) throws UserException {
        Assert.notNull((Object)((Object)mapper), (String)"IceMapper cannot be null");
        Assert.notNull((Object)current, (String)"Ice.Current cannot be null");
        Info info = this.map().get(current.operation);
        if (info == null) {
            throw new IllegalArgumentException("Unknown method:" + current.operation);
        }
        Object[] objs = this.arguments(current, mapper, info, args);
        Object retVal = null;
        try {
            retVal = this.callOrClose(obj, current, info, objs);
        }
        catch (Throwable t) {
            throw mapper.handleException(t, this.ctx);
        }
        Class<?> retType = info.retType;
        if (retType == Object.class && retVal != null) {
            retType = retVal.getClass();
        }
        if (mapper.canMapReturnValue()) {
            return mapper.mapReturnValue(retVal);
        }
        return mapper.handleOutput(retType, retVal);
    }

    private Object[] arguments(Current current, IceMapper mapper, Info info, Object ... args) throws ServerError {
        if (mapper.canMapReturnValue()) {
            return args;
        }
        Class<?>[] params = info.params;
        if (params.length != args.length) {
            throw new IllegalArgumentException("Must provide " + params.length + " arguments for " + current.operation + " not " + args.length);
        }
        Object[] objs = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> p = params[i];
            Object arg = args[i];
            objs[i] = mapper.handleInput(p, arg);
        }
        return objs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object callOrClose(Object obj, Current current, Info info, Object[] objs) throws Throwable, IllegalAccessException, InvocationTargetException {
        Object retVal = null;
        try {
            retVal = info.method.invoke(obj, objs);
        }
        finally {
            if ("close".equals(info.method.getName())) {
                UnregisterServantMessage usm = new UnregisterServantMessage(this, Util.identityToString((Identity)current.id), current);
                this.ctx.publishMessage((InternalMessage)usm);
            }
        }
        return retVal;
    }

    public Method getMethod(String name) {
        return this.map().get((Object)name).method;
    }

    static class Info {
        Method method;
        Class<?>[] params;
        Class<?> retType;
        int[] switches;

        Info() {
        }
    }
}

