/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz;

import Glacier2.AdminPrx;
import Glacier2.AdminPrxHelper;
import Ice.Communicator;
import Ice.ObjectPrx;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Router {
    private static final String LOCALHOST = "127.0.0.1";
    private static final Log log = LogFactory.getLog((String)"OMERO.router");
    Process p = null;
    private final Map<String, String> map = new HashMap<String, String>();

    public Router() {
        this.map.put("Glacier2.InstanceName", "OMERO.Glacier2");
        this.setClientEndpoints(LOCALHOST, 4063);
        this.setSessionManager(LOCALHOST, 9999);
        this.setPermissionsVerifier(LOCALHOST, 9999);
        this.setTimeout(600);
    }

    public void allowAdministration() {
        this.map.put("Glacier2.Admin.Endpoints", "tcp -p 4064 -h 127.0.0.1");
    }

    public void setClientEndpoints(String host, int port) {
        this.map.put("Glacier2.Client.Endpoints", "tcp -p " + port + " -h " + host);
    }

    public void setServerEndpoints(String host, int port) {
        this.map.put("Glacier2.Server.Endpoints", "tcp -h " + host + " -p " + port);
    }

    public void setSessionManager(String host, int port) {
        this.map.put("Glacier2.SessionManager", "BlitzManager:tcp -h " + host + " -p " + port);
    }

    public void setPermissionsVerifier(String host, int port) {
        this.map.put("Glacier2.PermissionsVerifier", "BlitzVerifier:tcp -h " + host + " -p " + port);
    }

    public void setTimeout(int timeout) {
        this.map.put("Glacier2.SessionTimeout", "" + timeout);
    }

    public int start() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getBashPath());
        list.add("--daemon");
        for (String string : this.map.keySet()) {
            list.add("--" + string + "=" + this.map.get(string));
        }
        log.info(list);
        ProcessBuilder pb = new ProcessBuilder(list.toArray(new String[list.size()]));
        try {
            this.p = pb.start();
            this.p.waitFor();
            return this.p.exitValue();
        }
        catch (Exception e) {
            log.info((Object)"Failed to start", (Throwable)e);
            return Integer.MIN_VALUE;
        }
    }

    public boolean shutdown(Communicator ic) {
        ObjectPrx prx = ic.stringToProxy(this.map.get("Glacier2.InstanceName") + "/admin:tcp -p 4064 -h 127.0.0.1");
        try {
            AdminPrx rtr = AdminPrxHelper.checkedCast((ObjectPrx)prx);
            rtr.shutdown();
        }
        catch (Exception e) {
            log.error((Object)"Error while calling router.shutdown.", (Throwable)e);
            return false;
        }
        return true;
    }

    String getBashPath() {
        String path;
        ProcessBuilder pb = new ProcessBuilder("bash", "-l", "-c", "which glacier2router");
        try {
            int c;
            Process p = pb.start();
            StringBuilder sb = new StringBuilder();
            InputStream is = p.getInputStream();
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
            path = sb.toString().trim();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return path;
    }
}

