/*
 * Decompiled with CFR 0.152.
 */
package ome.model.core;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.ImagingEnvironment;
import ome.model.acquisition.Instrument;
import ome.model.acquisition.ObjectiveSettings;
import ome.model.acquisition.StageLabel;
import ome.model.annotations.Annotation;
import ome.model.annotations.ImageAnnotationLink;
import ome.model.containers.Dataset;
import ome.model.containers.DatasetImageLink;
import ome.model.core.Pixels;
import ome.model.experiment.Experiment;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.screen.WellSample;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="image_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="image_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="image_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="image_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="image_owner_filter_PIXELS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="image_group_filter_PIXELS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="image_event_filter_PIXELS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="image_perms_filter_PIXELS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="image_owner_filter_WELLSAMPLES", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="image_group_filter_WELLSAMPLES", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="image_event_filter_WELLSAMPLES", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="image_perms_filter_WELLSAMPLES", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="image_owner_filter_DATASETLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="image_group_filter_DATASETLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="image_event_filter_DATASETLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="image_perms_filter_DATASETLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="image_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="image_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="image_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="image_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="image_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="image_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="image_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="image_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="image", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_image", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_image"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Image
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "image_owner_filter";
    public static final String GROUP_FILTER = "image_group_filter";
    public static final String EVENT_FILTER = "image_event_filter";
    public static final String PERMS_FILTER = "image_perms_filter";
    public static final String ID = "ome.model.core.Image_id";
    protected Long id;
    public static final String VERSION = "ome.model.core.Image_version";
    protected Integer version = 0;
    protected Timestamp acquisitionDate = null;
    protected Boolean archived = null;
    protected ImagingEnvironment imagingEnvironment = null;
    protected ObjectiveSettings objectiveSettings = null;
    protected Instrument instrument = null;
    protected StageLabel stageLabel = null;
    protected Experiment experiment = null;
    protected List<Pixels> pixels = new ArrayList<Pixels>();
    public static final String OWNER_FILTER_PIXELS = "image_owner_filter_PIXELS";
    public static final String GROUP_FILTER_PIXELS = "image_group_filter_PIXELS";
    public static final String EVENT_FILTER_PIXELS = "image_event_filter_PIXELS";
    public static final String PERMS_FILTER_PIXELS = "image_perms_filter_PIXELS";
    protected Set<WellSample> wellSamples = new HashSet<WellSample>();
    public static final String OWNER_FILTER_WELLSAMPLES = "image_owner_filter_WELLSAMPLES";
    public static final String GROUP_FILTER_WELLSAMPLES = "image_group_filter_WELLSAMPLES";
    public static final String EVENT_FILTER_WELLSAMPLES = "image_event_filter_WELLSAMPLES";
    public static final String PERMS_FILTER_WELLSAMPLES = "image_perms_filter_WELLSAMPLES";
    protected Set<DatasetImageLink> datasetLinks = new HashSet<DatasetImageLink>();
    public static final String OWNER_FILTER_DATASETLINKS = "image_owner_filter_DATASETLINKS";
    public static final String GROUP_FILTER_DATASETLINKS = "image_group_filter_DATASETLINKS";
    public static final String EVENT_FILTER_DATASETLINKS = "image_event_filter_DATASETLINKS";
    public static final String PERMS_FILTER_DATASETLINKS = "image_perms_filter_DATASETLINKS";
    private Map<Long, Long> datasetLinksCountPerOwner = null;
    protected Set<ImageAnnotationLink> annotationLinks = new HashSet<ImageAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "image_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "image_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "image_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "image_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String name = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String ACQUISITIONDATE = "ome.model.core.Image_acquisitionDate";
    public static final String ARCHIVED = "ome.model.core.Image_archived";
    public static final String IMAGINGENVIRONMENT = "ome.model.core.Image_imagingEnvironment";
    public static final String OBJECTIVESETTINGS = "ome.model.core.Image_objectiveSettings";
    public static final String INSTRUMENT = "ome.model.core.Image_instrument";
    public static final String STAGELABEL = "ome.model.core.Image_stageLabel";
    public static final String EXPERIMENT = "ome.model.core.Image_experiment";
    public static final String PIXELS = "ome.model.core.Image_pixels";
    public static final String WELLSAMPLES = "ome.model.core.Image_wellSamples";
    public static final String DATASETLINKSCOUNTPEROWNER = "ome.model.core.Image_datasetLinksCountPerOwner";
    public static final String DATASETLINKS = "ome.model.core.Image_datasetLinks";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.core.Image_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.core.Image_annotationLinks";
    public static final String NAME = "ome.model.core.Image_name";
    public static final String DESCRIPTION = "ome.model.core.Image_description";
    public static final String DETAILS = "ome.model.core.Image_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Image() {
        this(null, true);
    }

    protected Image(Long id) {
        this(id, true);
    }

    public Image(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Image(Timestamp _acquisitionDate, String _name) {
        this(null, true);
        this.setAcquisitionDate(_acquisitionDate);
        this.setName(_name);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_image")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="acquisitionDate", updatable=true)
    public Timestamp getAcquisitionDate() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.acquisitionDate;
    }

    public void setAcquisitionDate(Timestamp acquisitionDate) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.acquisitionDate = acquisitionDate;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="archived", updatable=true)
    public Boolean getArchived() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.archived;
    }

    public void setArchived(Boolean archived) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.archived = archived;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ImagingEnvironment.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="imagingEnvironment", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKimage_imagingEnvironment_imagingenvironment")
    public ImagingEnvironment getImagingEnvironment() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.imagingEnvironment;
    }

    public void setImagingEnvironment(ImagingEnvironment imagingEnvironment) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.imagingEnvironment = imagingEnvironment;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ObjectiveSettings.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="objectiveSettings", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKimage_objectiveSettings_objectivesettings")
    public ObjectiveSettings getObjectiveSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.objectiveSettings;
    }

    public void setObjectiveSettings(ObjectiveSettings objectiveSettings) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.objectiveSettings = objectiveSettings;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Instrument.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="instrument", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKimage_instrument_instrument")
    public Instrument getInstrument() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.instrument = instrument;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=StageLabel.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="stageLabel", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKimage_stageLabel_stagelabel")
    public StageLabel getStageLabel() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.stageLabel;
    }

    public void setStageLabel(StageLabel stageLabel) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.stageLabel = stageLabel;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Experiment.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="experiment", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKimage_experiment_experiment")
    public Experiment getExperiment() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.experiment;
    }

    public void setExperiment(Experiment experiment) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.experiment = experiment;
    }

    @JoinColumn(name="image", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="image_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="image_owner_filter_PIXELS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="image_group_filter_PIXELS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="image_event_filter_PIXELS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="image_perms_filter_PIXELS", condition=":permsStr = permissions")})
    protected List<Pixels> getPixels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixels;
    }

    protected void setPixels(List<Pixels> pixels) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pixels = pixels;
    }

    public int sizeOfPixels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixels == null ? -1 : this.pixels.size();
    }

    public Iterator<Pixels> iteratePixels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            return new EmptyIterator<Pixels>();
        }
        return this.getPixels().iterator();
    }

    public Collection<Pixels> unmodifiablePixels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getPixels());
    }

    public <E> List<E> collectPixels(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Pixels> it = this.iteratePixels();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addPixels(Pixels target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            this.throwNullCollectionException("Pixels");
        }
        this.getPixels().add(target);
        if (target.isLoaded()) {
            target.setImage(this);
        }
    }

    public void addPixelsSet(Collection<Pixels> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            this.throwNullCollectionException("Pixels");
        }
        this.getPixels().addAll(targets);
        for (Pixels target : targets) {
            if (!target.isLoaded()) continue;
            target.setImage(this);
        }
    }

    public void removePixels(Pixels target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            this.throwNullCollectionException("Pixels");
        }
        this.getPixels().remove(target);
        if (target.isLoaded()) {
            target.setImage(null);
        }
    }

    public void removePixelsSet(Collection<Pixels> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            this.throwNullCollectionException("Pixels");
        }
        this.getPixels().removeAll(targets);
        for (Pixels target : targets) {
            if (!target.isLoaded()) continue;
            target.setImage(null);
        }
    }

    public void clearPixels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            this.throwNullCollectionException("Pixels");
        }
        this.getPixels().clear();
        Iterator<Pixels> it = this.iteratePixels();
        while (it.hasNext()) {
            Pixels target = it.next();
            target.setImage(null);
        }
    }

    public Pixels getPixels(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            this.throwNullCollectionException("Pixels");
        }
        return this.getPixels().get(index);
    }

    public void setPixels(int index, Pixels element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            this.throwNullCollectionException("Pixels");
        }
        this.getPixels().set(index, element);
    }

    @Transient
    public Pixels getPrimaryPixels() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            this.throwNullCollectionException("Pixels");
        }
        return this.getPixels().get(0);
    }

    public Pixels setPrimaryPixels(Pixels element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixels() == null) {
            this.throwNullCollectionException("Pixels");
        }
        List<Pixels> list = this.getPixels();
        int index = list.indexOf(element);
        Pixels old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    @OneToMany(mappedBy="image", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="image_owner_filter_WELLSAMPLES", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="image_group_filter_WELLSAMPLES", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="image_event_filter_WELLSAMPLES", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="image_perms_filter_WELLSAMPLES", condition=":permsStr = permissions")})
    protected Set<WellSample> getWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellSamples;
    }

    protected void setWellSamples(Set<WellSample> wellSamples) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.wellSamples = wellSamples;
    }

    public int sizeOfWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellSamples == null ? -1 : this.wellSamples.size();
    }

    public Iterator<WellSample> iterateWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            return new EmptyIterator<WellSample>();
        }
        return this.getWellSamples().iterator();
    }

    public Collection<WellSample> unmodifiableWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getWellSamples());
    }

    public <E> List<E> collectWellSamples(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<WellSample> it = this.iterateWellSamples();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addWellSample(WellSample target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().add(target);
        target.setImage(this);
    }

    public void addWellSampleSet(Collection<WellSample> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().addAll(targets);
        for (WellSample target : targets) {
            target.setImage(this);
        }
    }

    public void removeWellSample(WellSample target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().remove(target);
        target.setImage(null);
    }

    public void removeWellSampleSet(Collection<WellSample> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().removeAll(targets);
        for (WellSample target : targets) {
            target.setImage(null);
        }
    }

    public void clearWellSamples() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellSamples() == null) {
            this.throwNullCollectionException("WellSamples");
        }
        this.getWellSamples().clear();
        Iterator<WellSample> it = this.iterateWellSamples();
        while (it.hasNext()) {
            WellSample target = it.next();
            target.setImage(null);
        }
    }

    @OneToMany(mappedBy="child", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="image_owner_filter_DATASETLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="image_group_filter_DATASETLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="image_event_filter_DATASETLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="image_perms_filter_DATASETLINKS", condition=":permsStr = permissions")})
    protected Set<DatasetImageLink> getDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.datasetLinks;
    }

    protected void setDatasetLinks(Set<DatasetImageLink> datasetLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.datasetLinks = datasetLinks;
    }

    public int sizeOfDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.datasetLinks == null ? -1 : this.datasetLinks.size();
    }

    public Iterator<DatasetImageLink> iterateDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            return new EmptyIterator<DatasetImageLink>();
        }
        return this.getDatasetLinks().iterator();
    }

    public Collection<DatasetImageLink> unmodifiableDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getDatasetLinks());
    }

    public <E> List<E> collectDatasetLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<DatasetImageLink> it = this.iterateDatasetLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addDatasetImageLink(DatasetImageLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().add(target);
        target.setChild(this);
    }

    public void addDatasetImageLinkSet(Collection<DatasetImageLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().addAll(targets);
        for (DatasetImageLink target : targets) {
            target.setChild(this);
        }
    }

    public void removeDatasetImageLink(DatasetImageLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().remove(target);
        target.setChild(null);
    }

    public void removeDatasetImageLinkSet(Collection<DatasetImageLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().removeAll(targets);
        for (DatasetImageLink target : targets) {
            target.setChild(null);
        }
    }

    public DatasetImageLink linkDataset(Dataset addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        DatasetImageLink link = new DatasetImageLink();
        link.link(addition, this);
        this.addDatasetImageLink(link, true);
        return link;
    }

    public void addDatasetImageLink(DatasetImageLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().add(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().addDatasetImageLink(link, false);
        }
    }

    public Iterator<Dataset> linkedDatasetIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            return new EmptyIterator<Dataset>();
        }
        final Iterator<DatasetImageLink> it = this.getDatasetLinks().iterator();
        return new Iterator<Dataset>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Dataset next() {
                if (it == null) {
                    throw new NoSuchElementException("datasetLinks is null; no elements.");
                }
                DatasetImageLink link = (DatasetImageLink)it.next();
                return link.parent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<DatasetImageLink> findDatasetImageLink(Dataset target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<DatasetImageLink> it = this.iterateDatasetLinks();
        HashSet<DatasetImageLink> result = new HashSet<DatasetImageLink>();
        while (it.hasNext()) {
            DatasetImageLink link = it.next();
            if (link.parent() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Dataset> linkedDatasetList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Dataset> it = this.linkedDatasetIterator();
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedDataset(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Dataset> it = this.linkedDatasetIterator();
        while (it.hasNext()) {
            Dataset obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkDataset(Dataset removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<DatasetImageLink> toRemove = this.findDatasetImageLink(removal);
        Iterator<DatasetImageLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeDatasetImageLink(it.next(), true);
        }
    }

    public void removeDatasetImageLink(DatasetImageLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().remove(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().removeDatasetImageLink(link, false);
        }
    }

    public void clearDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<DatasetImageLink> list = new ArrayList<DatasetImageLink>(this.getDatasetLinks());
        for (DatasetImageLink link : list) {
            this.removeDatasetImageLink(link, true);
        }
    }

    protected void setDatasetLinksCountPerOwner(Map<Long, Long> map) {
        this.datasetLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_Image_datasetLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_Image_datasetLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getDatasetLinksCountPerOwner() {
        return this.datasetLinksCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="image_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="image_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="image_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="image_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<ImageAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<ImageAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<ImageAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<ImageAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<ImageAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ImageAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addImageAnnotationLink(ImageAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        target.setParent(this);
    }

    public void addImageAnnotationLinkSet(Collection<ImageAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (ImageAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    public void removeImageAnnotationLink(ImageAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeImageAnnotationLinkSet(Collection<ImageAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (ImageAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public ImageAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ImageAnnotationLink link = new ImageAnnotationLink();
        link.link(this, addition);
        this.addImageAnnotationLink(link, true);
        return link;
    }

    public void addImageAnnotationLink(ImageAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<ImageAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                ImageAnnotationLink link = (ImageAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ImageAnnotationLink> findImageAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ImageAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<ImageAnnotationLink> result = new HashSet<ImageAnnotationLink>();
        while (it.hasNext()) {
            ImageAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ImageAnnotationLink> toRemove = this.findImageAnnotationLink(removal);
        Iterator<ImageAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeImageAnnotationLink(it.next(), true);
        }
    }

    public void removeImageAnnotationLink(ImageAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ImageAnnotationLink> list = new ArrayList<ImageAnnotationLink>(this.getAnnotationLinks());
        for (ImageAnnotationLink link : list) {
            this.removeImageAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_Image_annotationLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_Image_annotationLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Image newInstance() {
        return new Image();
    }

    public Image proxy() {
        return new Image(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.acquisitionDate = (Timestamp)__filter.filter(ACQUISITIONDATE, this.acquisitionDate);
            this.archived = (Boolean)__filter.filter(ARCHIVED, this.archived);
            this.imagingEnvironment = (ImagingEnvironment)__filter.filter(IMAGINGENVIRONMENT, this.imagingEnvironment);
            this.objectiveSettings = (ObjectiveSettings)__filter.filter(OBJECTIVESETTINGS, this.objectiveSettings);
            this.instrument = (Instrument)__filter.filter(INSTRUMENT, this.instrument);
            this.stageLabel = (StageLabel)__filter.filter(STAGELABEL, this.stageLabel);
            this.experiment = (Experiment)__filter.filter(EXPERIMENT, this.experiment);
            this.pixels = (List)__filter.filter(PIXELS, this.pixels);
            this.wellSamples = (Set)__filter.filter(WELLSAMPLES, this.wellSamples);
            this.datasetLinksCountPerOwner = __filter.filter(DATASETLINKSCOUNTPEROWNER, this.datasetLinksCountPerOwner);
            this.datasetLinks = (Set)__filter.filter(DATASETLINKS, this.datasetLinks);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.name = (String)__filter.filter(NAME, this.name);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(ACQUISITIONDATE)) {
            return this.getAcquisitionDate();
        }
        if (field.equals(ARCHIVED)) {
            return this.getArchived();
        }
        if (field.equals(IMAGINGENVIRONMENT)) {
            return this.getImagingEnvironment();
        }
        if (field.equals(OBJECTIVESETTINGS)) {
            return this.getObjectiveSettings();
        }
        if (field.equals(INSTRUMENT)) {
            return this.getInstrument();
        }
        if (field.equals(STAGELABEL)) {
            return this.getStageLabel();
        }
        if (field.equals(EXPERIMENT)) {
            return this.getExperiment();
        }
        if (field.equals(PIXELS)) {
            return this.getPixels();
        }
        if (field.equals(WELLSAMPLES)) {
            return this.getWellSamples();
        }
        if (field.equals(DATASETLINKSCOUNTPEROWNER)) {
            return this.getDatasetLinksCountPerOwner();
        }
        if (field.equals(DATASETLINKS)) {
            return this.getDatasetLinks();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(ACQUISITIONDATE)) {
            this.setAcquisitionDate((Timestamp)value);
        } else if (field.equals(ARCHIVED)) {
            this.setArchived((Boolean)value);
        } else if (field.equals(IMAGINGENVIRONMENT)) {
            this.setImagingEnvironment((ImagingEnvironment)value);
        } else if (field.equals(OBJECTIVESETTINGS)) {
            this.setObjectiveSettings((ObjectiveSettings)value);
        } else if (field.equals(INSTRUMENT)) {
            this.setInstrument((Instrument)value);
        } else if (field.equals(STAGELABEL)) {
            this.setStageLabel((StageLabel)value);
        } else if (field.equals(EXPERIMENT)) {
            this.setExperiment((Experiment)value);
        } else if (field.equals(PIXELS)) {
            this.setPixels((List)value);
        } else if (field.equals(WELLSAMPLES)) {
            this.setWellSamples((Set)value);
        } else if (field.equals(DATASETLINKSCOUNTPEROWNER)) {
            this.setDatasetLinksCountPerOwner((Map)value);
        } else if (field.equals(DATASETLINKS)) {
            this.setDatasetLinks((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.acquisitionDate = null;
        this.archived = null;
        this.imagingEnvironment = null;
        this.objectiveSettings = null;
        this.instrument = null;
        this.stageLabel = null;
        this.experiment = null;
        this.pixels = null;
        this.wellSamples = null;
        this.datasetLinksCountPerOwner = null;
        this.datasetLinks = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.name = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(ACQUISITIONDATE);
        raw.add(ARCHIVED);
        raw.add(IMAGINGENVIRONMENT);
        raw.add(OBJECTIVESETTINGS);
        raw.add(INSTRUMENT);
        raw.add(STAGELABEL);
        raw.add(EXPERIMENT);
        raw.add(PIXELS);
        raw.add(WELLSAMPLES);
        raw.add(DATASETLINKSCOUNTPEROWNER);
        raw.add(DATASETLINKS);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKimage_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKimage_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKimage_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKimage_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKimage_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

