/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.utests;

import junit.framework.TestCase;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.OMEROWrapper;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.utests.TestEnumerationProvider;
import ome.formats.utests.TestServiceFactory;
import ome.util.LSID;
import omero.model.Image;
import omero.model.Instrument;
import omero.model.Objective;
import omero.model.ObjectiveSettings;
import omero.model.Pixels;

public class ObjectiveSettingsTest
extends TestCase {
    private OMEROWrapper wrapper;
    private OMEROMetadataStoreClient store;
    private static final int OBJECTIVE_INDEX = 0;
    private static final int INSTRUMENT_INDEX = 0;
    private static final int IMAGE_INDEX = 0;
    private static final int PIXELS_INDEX = 0;
    private static final String OBJECTIVE_MODEL = "Model";

    protected void setUp() throws Exception {
        TestServiceFactory sf = new TestServiceFactory();
        this.wrapper = new OMEROWrapper();
        this.store = new OMEROMetadataStoreClient();
        this.store.initialize(sf);
        this.store.setEnumerationProvider(new TestEnumerationProvider());
        this.store.setInstanceProvider(new BlitzInstanceProvider(this.store.getEnumerationProvider()));
        this.wrapper.setMetadataStore(this.store);
        this.store.setPixelsSizeX(1, 0, 0);
        this.store.setPixelsSizeX(1, 1, 0);
        this.store.setPixelsSizeX(1, 2, 0);
        this.store.setObjectiveModel(OBJECTIVE_MODEL, 0, 0);
        this.store.setObjectiveID("Objective:0", 0, 0);
        this.store.setInstrumentID("Instrument:0", 0);
        this.store.setImageInstrumentRef("Instrument:0", 0);
        this.store.setImageInstrumentRef("Instrument:0", 1);
        this.store.setImageInstrumentRef("Instrument:0", 2);
        this.store.setObjectiveSettingsObjective("Objective:0", 0);
        this.store.setObjectiveSettingsObjective("Objective:0", 1);
        this.store.setObjectiveSettingsObjective("Objective:0", 2);
    }

    public void testObjectiveCorrectionExists() {
        Objective o = (Objective)this.store.getSourceObject(new LSID("Objective:0"));
        ObjectiveSettingsTest.assertNotNull((Object)o.getCorrection());
    }

    public void testObjectiveCorrectionZeroLength() {
        this.store.setObjectiveCorrection("", 0, 0);
        Objective o = (Objective)this.store.getSourceObject(new LSID("Objective:0"));
        ObjectiveSettingsTest.assertEquals((String)"Unknown", (String)o.getCorrection().getValue().getValue());
    }

    public void testObjectiveCorrectionNull() {
        this.store.setObjectiveCorrection(null, 0, 0);
        Objective o = (Objective)this.store.getSourceObject(new LSID("Objective:0"));
        ObjectiveSettingsTest.assertEquals((String)"Unknown", (String)o.getCorrection().getValue().getValue());
    }

    public void testImageObjectiveExists() {
        int i = 0;
        while (i < 3) {
            LSID lsid = new LSID(Pixels.class, new int[]{i++, 0});
            ObjectiveSettingsTest.assertNotNull((Object)this.store.getSourceObject(lsid));
        }
        ObjectiveSettingsTest.assertNotNull((Object)this.store.getSourceObject(new LSID("Instrument:0")));
        ObjectiveSettingsTest.assertNotNull((Object)this.store.getSourceObject(new LSID("Objective:0")));
    }

    public void testObjectiveModelPreserved() {
        Objective objective = this.store.getObjective(0, 0);
        ObjectiveSettingsTest.assertEquals((String)OBJECTIVE_MODEL, (String)objective.getModel().getValue());
    }

    public void testContainerCount() {
        ObjectiveSettingsTest.assertEquals((int)1, (int)this.store.countCachedContainers(Objective.class, new int[0]));
        ObjectiveSettingsTest.assertEquals((int)1, (int)this.store.countCachedContainers(Instrument.class, new int[0]));
        ObjectiveSettingsTest.assertEquals((int)3, (int)this.store.countCachedContainers(Pixels.class, new int[0]));
        ObjectiveSettingsTest.assertEquals((int)5, (int)this.store.countCachedContainers(null, new int[0]));
    }

    public void testReferences() {
        int i = 0;
        while (i < 3) {
            LSID imageLsid = new LSID(Image.class, new int[]{i});
            LSID osLsid = new LSID(ObjectiveSettings.class, new int[]{0 + i});
            ObjectiveSettingsTest.assertTrue((boolean)this.store.hasReference(osLsid, new LSID("Objective:0")));
            ObjectiveSettingsTest.assertTrue((boolean)this.store.hasReference(imageLsid, new LSID("Instrument:0")));
            ++i;
        }
        ObjectiveSettingsTest.assertEquals((int)6, (int)this.store.countCachedReferences(null, null));
    }
}

