/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.utests;

import java.util.HashMap;
import java.util.LinkedHashMap;
import junit.framework.TestCase;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.utests.TestEnumerationProvider;
import ome.formats.utests.TestServiceFactory;
import ome.util.LSID;
import omero.model.Image;
import omero.model.ObjectiveSettings;

public class IObjectContainerStoreTest
extends TestCase {
    private OMEROMetadataStoreClient store;
    private static final int IMAGE_INDEX = 0;
    private static final int PIXELS_INDEX = 0;

    protected void setUp() throws Exception {
        TestServiceFactory sf = new TestServiceFactory();
        this.store = new OMEROMetadataStoreClient();
        this.store.initialize(sf);
        this.store.setEnumerationProvider(new TestEnumerationProvider());
        this.store.setInstanceProvider(new BlitzInstanceProvider(this.store.getEnumerationProvider()));
        this.store.setImageName("Foo1", 0);
        this.store.setImageName("Foo2", 1);
        this.store.setPixelsSizeX(1, 0, 0);
        this.store.setObjectiveSettingsObjective("Objective:0", 0);
    }

    public void testGetCaches() {
        IObjectContainerStoreTest.assertNotNull(this.store.getContainerCache());
        IObjectContainerStoreTest.assertNotNull(this.store.getReferenceCache());
        IObjectContainerStoreTest.assertNull(this.store.getReferenceStringCache());
    }

    public void testSetReferenceStringCache() {
        HashMap<String, String> a = new HashMap<String, String>();
        this.store.setReferenceStringCache(a);
        IObjectContainerStoreTest.assertEquals(a, this.store.getReferenceStringCache());
    }

    public void testGetSourceObject() {
        IObjectContainerStoreTest.assertNotNull((Object)this.store.getSourceObject(new LSID(Image.class, new int[]{0})));
    }

    public void testGetSourceObjects() {
        IObjectContainerStoreTest.assertEquals((int)2, (int)this.store.getSourceObjects(Image.class).size());
    }

    public void testGetIObjectContainer() {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", 2);
        this.store.getIObjectContainer(Image.class, indexes);
        IObjectContainerStoreTest.assertEquals((int)3, (int)this.store.countCachedContainers(Image.class, new int[0]));
    }

    public void testCachedContainers() {
        IObjectContainerStoreTest.assertEquals((int)2, (int)this.store.countCachedContainers(Image.class, new int[0]));
    }

    public void testHasReference() {
        IObjectContainerStoreTest.assertTrue((boolean)this.store.hasReference(new LSID(ObjectiveSettings.class, new int[]{0}), new LSID("Objective:0")));
    }
}

