/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ETable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final Color MAC_FOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR = new Color(8235754);
    private static final Color MAC_UNFOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR = new Color(0xE0E0E0);
    private static final Color MAC_UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR = new Color(0xC0C0C0);
    private static final Color MAC_FOCUSED_UNSELECTED_VERTICAL_LINE_COLOR = new Color(0xD9D9D9);
    private static final Color MAC_FOCUSED_SELECTED_VERTICAL_LINE_COLOR = new Color(3435966);
    private static final Color MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR = new Color(0xD9D9D9);
    private static final Color MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR = new Color(0xACACAC);
    public static final Color ALTERNATE_ROW_COLOR = new Color(0.92f, 0.95f, 0.99f);

    public ETable() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension());
        this.getTableHeader().setReorderingAllowed(false);
        if (ETable.isMacOs()) {
            ((JLabel)JLabel.class.cast(this.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(10);
            this.setShowHorizontalLines(true);
            this.setShowVerticalLines(true);
        }
    }

    public ETable(AbstractTableModel atm) {
        this.setModel(atm);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension());
        this.getTableHeader().setReorderingAllowed(false);
        if (ETable.isMacOs()) {
            ((JLabel)JLabel.class.cast(this.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(10);
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
    }

    public static boolean isMacOs() {
        return System.getProperty("os.name").contains("Mac");
    }

    public static boolean isGtk() {
        return UIManager.getLookAndFeel().getClass().getName().contains("GTK");
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        int height = clip.y + clip.height;
        if (rowCount * this.rowHeight < height) {
            int i = rowCount;
            while (i <= height / this.rowHeight) {
                g.setColor(this.colorForRow(i));
                g.fillRect(clip.x, i * this.rowHeight, clip.width, this.rowHeight);
                ++i;
            }
            if (ETable.isMacOs() && this.getShowVerticalLines()) {
                g.setColor(MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
                TableColumnModel columnModel = this.getColumnModel();
                int x = 0;
                int i2 = 0;
                while (i2 < columnModel.getColumnCount()) {
                    TableColumn column = columnModel.getColumn(i2);
                    g.drawLine((x += column.getWidth()) - 1, rowCount * this.rowHeight, x - 1, height);
                    ++i2;
                }
            }
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected Color colorForRow(int row) {
        return row % 2 == 0 ? this.alternateRowColor() : this.getBackground();
    }

    private Color alternateRowColor() {
        return ETable.isGtk() ? Color.WHITE : ALTERNATE_ROW_COLOR;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        boolean focused = this.hasFocus();
        boolean selected = this.isCellSelected(row, column);
        if (selected) {
            if (ETable.isMacOs() && !focused) {
                c.setBackground(MAC_UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR);
                c.setForeground(UIManager.getColor("Table.foreground"));
            } else {
                c.setBackground(UIManager.getColor("Table.selectionBackground"));
                c.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
        } else {
            c.setBackground(this.colorForRow(row));
            c.setForeground(UIManager.getColor("Table.foreground"));
        }
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            if (ETable.isGtk() && c instanceof JCheckBox) {
                jc.setOpaque(true);
            }
            if (!this.getCellSelectionEnabled() && !this.isEditing()) {
                if (ETable.isMacOs()) {
                    this.fixMacOsCellRendererBorder(jc, selected, focused);
                } else {
                    jc.setBorder(null);
                }
            }
            this.initToolTip(jc, row, column);
        }
        return c;
    }

    private void fixMacOsCellRendererBorder(JComponent renderer, boolean selected, boolean focused) {
        Border border = selected ? BorderFactory.createMatteBorder(0, 0, 1, 0, focused ? MAC_FOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR : MAC_UNFOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR) : BorderFactory.createEmptyBorder(0, 0, 1, 0);
        if (this.getShowVerticalLines()) {
            Color verticalLineColor = focused ? (selected ? MAC_FOCUSED_SELECTED_VERTICAL_LINE_COLOR : MAC_FOCUSED_UNSELECTED_VERTICAL_LINE_COLOR) : (selected ? MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR : MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
            MatteBorder verticalBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, verticalLineColor);
            border = BorderFactory.createCompoundBorder(border, verticalBorder);
        }
        renderer.setBorder(border);
    }

    private void initToolTip(JComponent c, int row, int column) {
        String toolTipText = null;
        if (c.getPreferredSize().width > this.getCellRect((int)row, (int)column, (boolean)false).width) {
            toolTipText = this.getValueAt(row, column).toString();
        }
        c.setToolTipText(toolTipText);
    }

    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        int colIndex = this.columnAtPoint(p);
        int rowIndex = this.rowAtPoint(p);
        if (rowIndex == -1) {
            return null;
        }
        String tooltip = null;
        if (colIndex == 0) {
            tooltip = this.getModel().getValueAt(rowIndex, 4).toString();
        } else if (colIndex == 1) {
            String[] pd = this.getValueAt(rowIndex, colIndex).toString().split("/");
            tooltip = "<html>Project: " + pd[0] + ", id: " + this.getModel().getValueAt(rowIndex, 6).toString() + "<br>" + "Dataset: " + pd[1] + ", id: " + this.getModel().getValueAt(rowIndex, 3).toString() + "</html>";
        } else if (colIndex == 2) {
            String status = this.getValueAt(rowIndex, colIndex).toString();
            if (status == "added") {
                tooltip = "<html>This file has yet to be imported.</html>";
            }
            if (status == "pending") {
                tooltip = "<html>This file has been queued for import.</html>";
            }
            if (status == "done") {
                tooltip = "<html>This file has successfully been imported.</html>";
            }
            if (status == "invalid format") {
                tooltip = "<html>This file is of an unknown file type.</html>";
            }
            if (status == "failed") {
                tooltip = "<html>For some reason this file could not import. <br>The debug window may provide you with more information.</html>";
            }
            if (status == "prepping") {
                tooltip = "<html>Collecting file metadata for analysis. <br>This process may take several minutes during which <br>time the application may appear to be stalled.</html>";
            }
            if (status == "analyzing") {
                tooltip = "<html>Analysing and saving your meta data. <br>This process may take some time.</html>";
            }
            if (status == "archiving") {
                tooltip = "<html>Backing up your original file. <br>This process may take some time.</html>";
            }
            if (status.contains(":")) {
                String[] splitString = this.getValueAt(rowIndex, colIndex).toString().split(":");
                String[] series = splitString[0].split("/");
                String[] plane = splitString[1].split("/");
                tooltip = "<html>This entry contains a series of images:<br>&nbsp;&nbsp;Importing Series Image: " + series[0] + " of " + series[1] + "<br>" + "&nbsp;&nbsp;Importing Image Plane: " + plane[0] + " of " + plane[1] + "</html>";
            } else if (status.contains("/")) {
                String[] plane = this.getValueAt(rowIndex, colIndex).toString().split("/");
                tooltip = "<html>Importing Image Plane: " + plane[0] + " of " + plane[1];
            }
        } else {
            tooltip = this.getValueAt(rowIndex, colIndex).toString();
        }
        return tooltip;
    }

    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        if (!ETable.isMacOs()) {
            return;
        }
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            Component renderer = new JTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, 0);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(renderer, "Center");
            scrollPane.setCorner("UPPER_RIGHT_CORNER", panel);
        }
    }
}

