/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Dataset;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Project;
import omero.model.ProjectAnnotationLink;
import omero.model.ProjectAnnotationLinkI;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectDatasetLinkI;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectI
extends Project
implements ModelBased {
    public static final String DATASETLINKS = "ome.model.containers.Project_datasetLinks";
    public static final String ANNOTATIONLINKS = "ome.model.containers.Project_annotationLinks";
    public static final String NAME = "ome.model.containers.Project_name";
    public static final String DESCRIPTION = "ome.model.containers.Project_description";
    public static final String DETAILS = "ome.model.containers.Project_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.datasetLinksSeq = new ArrayList();
            this.datasetLinksLoaded = true;
        } else {
            this.datasetLinksSeq = null;
            this.datasetLinksLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public ProjectI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ProjectI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ProjectI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadDatasetLinks();
        this.unloadAnnotationLinks();
        this.unloadName();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ProjectI copy = new ProjectI();
        copy.id = this.id;
        copy.version = this.version;
        if (!this.datasetLinksLoaded) {
            copy.datasetLinksLoaded = false;
            copy.datasetLinksSeq = null;
        } else {
            copy.datasetLinksLoaded = true;
            copy.datasetLinksSeq = new ArrayList<ProjectDatasetLink>();
            for (IObject item : this.datasetLinksSeq) {
                copy.datasetLinksSeq.add(item == null ? null : (ProjectDatasetLink)item.proxy());
            }
        }
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<ProjectAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (ProjectAnnotationLink)item.proxy());
            }
        }
        copy.name = this.name;
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ProjectI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    @Override
    public void unloadDatasetLinks(Current current) {
        this.datasetLinksLoaded = false;
        this.datasetLinksSeq = null;
    }

    protected List getDatasetLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.datasetLinksSeq;
    }

    protected void setDatasetLinks(List datasetLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.datasetLinksSeq = datasetLinks == null ? new ArrayList() : new ArrayList(datasetLinks);
        this.datasetLinksLoaded = datasetLinks != null;
    }

    private void copyDatasetLinks(ome.model.containers.Project source, IceMapper mapper) {
        this.setDatasetLinks((List)mapper.findCollection((Collection)source.retrieve(DATASETLINKS)), null);
        this.datasetLinksCountPerOwner = source.getDatasetLinksCountPerOwner();
    }

    private void fillDatasetLinks(ome.model.containers.Project target, IceMapper mapper) {
        if (this.datasetLinksLoaded) {
            target.putAt(DATASETLINKS, mapper.reverse(this.datasetLinksSeq, Set.class));
        } else {
            target.putAt(DATASETLINKS, null);
        }
    }

    public boolean isDatasetLinksLoaded() {
        return this.datasetLinksLoaded;
    }

    @Override
    public int sizeOfDatasetLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            return -1;
        }
        return this.datasetLinksSeq.size();
    }

    public List copyDatasetLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        ArrayList result = new ArrayList(this.datasetLinksSeq);
        return result;
    }

    public Iterator iterateDatasetLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        return this.datasetLinksSeq.iterator();
    }

    @Override
    public void addProjectDatasetLink(ProjectDatasetLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllProjectDatasetLinkSet(List<ProjectDatasetLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.addAll(targets);
        for (ProjectDatasetLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeProjectDatasetLink(ProjectDatasetLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.remove(target);
        target.setParent(null);
    }

    public void removeProjectDatasetLinkSet(Collection<ProjectDatasetLink> targets) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        for (ProjectDatasetLink elt : targets) {
            elt.setParent(null);
            this.datasetLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearDatasetLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        for (ProjectDatasetLink elt : this.datasetLinksSeq) {
            elt.setParent(null);
        }
        this.datasetLinksSeq.clear();
    }

    @Override
    public void reloadDatasetLinks(Project toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.datasetLinksLoaded) {
            throw new ClientError("Cannot reload active collection: datasetLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ProjectDatasetLink> copy = toCopy.copyDatasetLinks();
        for (ProjectDatasetLink elt : copy) {
            elt.setParent(this);
        }
        this.datasetLinksSeq = new ArrayList<ProjectDatasetLink>(copy);
        toCopy.unloadDatasetLinks();
        this.datasetLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getDatasetLinksCountPerOwner(Current current) {
        return this.datasetLinksCountPerOwner;
    }

    @Override
    public ProjectDatasetLink linkDataset(Dataset addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        ProjectDatasetLinkI link = new ProjectDatasetLinkI();
        link.link(this, addition);
        this.addProjectDatasetLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addProjectDatasetLinkToBoth(ProjectDatasetLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.add(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().addProjectDatasetLinkToBoth(link, false);
        }
    }

    @Override
    public List<ProjectDatasetLink> findProjectDatasetLink(Dataset removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        ArrayList<ProjectDatasetLink> result = new ArrayList<ProjectDatasetLink>();
        for (ProjectDatasetLink link : this.datasetLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkDataset(Dataset removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        List<ProjectDatasetLink> toRemove = this.findProjectDatasetLink(removal);
        Iterator<ProjectDatasetLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeProjectDatasetLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeProjectDatasetLinkFromBoth(ProjectDatasetLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.remove(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().removeProjectDatasetLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Dataset> linkedDatasetList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("DatasetLinks");
        }
        ArrayList<Dataset> linked = new ArrayList<Dataset>();
        for (ProjectDatasetLink link : this.datasetLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.containers.Project source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.containers.Project target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addProjectAnnotationLink(ProjectAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllProjectAnnotationLinkSet(List<ProjectAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (ProjectAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeProjectAnnotationLink(ProjectAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    public void removeProjectAnnotationLinkSet(Collection<ProjectAnnotationLink> targets) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ProjectAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ProjectAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Project toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ProjectAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (ProjectAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<ProjectAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public ProjectAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ProjectAnnotationLinkI link = new ProjectAnnotationLinkI();
        link.link(this, addition);
        this.addProjectAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addProjectAnnotationLinkToBoth(ProjectAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<ProjectAnnotationLink> findProjectAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<ProjectAnnotationLink> result = new ArrayList<ProjectAnnotationLink>();
        for (ProjectAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<ProjectAnnotationLink> toRemove = this.findProjectAnnotationLink(removal);
        Iterator<ProjectAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeProjectAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeProjectAnnotationLinkFromBoth(ProjectAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (ProjectAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadName() {
        this.name = null;
    }

    @Override
    public RString getName(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.name;
    }

    @Override
    public void setName(RString name, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.name = name;
    }

    private void copyName(ome.model.containers.Project source, IceMapper mapper) {
        this.name = source.getName() == null ? null : rtypes.rstring(source.getName());
    }

    private void fillName(ome.model.containers.Project target, IceMapper mapper) {
        try {
            target.setName((String)mapper.fromRType(this.getName()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.containers.Project source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.containers.Project target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.containers.Project) {
            ome.model.containers.Project source = (ome.model.containers.Project)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyDatasetLinks(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyName(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Project cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.containers.Project target = new ome.model.containers.Project();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillDatasetLinks(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillName(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<ProjectI> cast(List list) {
        return list;
    }
}

