/*
 * Decompiled with CFR 0.152.
 */
package IceUtilInternal;

import Ice.IntHolder;
import Ice.StringHolder;
import java.io.UnsupportedEncodingException;

public final class StringUtil {
    public static int findFirstOf(String str, String match) {
        return StringUtil.findFirstOf(str, match, 0);
    }

    public static int findFirstOf(String str, String match, int start) {
        int len = str.length();
        for (int i = start; i < len; ++i) {
            char ch = str.charAt(i);
            if (match.indexOf(ch) == -1) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstNotOf(String str, String match) {
        return StringUtil.findFirstNotOf(str, match, 0);
    }

    public static int findFirstNotOf(String str, String match, int start) {
        int len = str.length();
        for (int i = start; i < len; ++i) {
            char ch = str.charAt(i);
            if (match.indexOf(ch) != -1) continue;
            return i;
        }
        return -1;
    }

    private static void encodeChar(byte b, StringBuffer sb, String special) {
        switch (b) {
            case 92: {
                sb.append("\\\\");
                break;
            }
            case 39: {
                sb.append("\\'");
                break;
            }
            case 34: {
                sb.append("\\\"");
                break;
            }
            case 8: {
                sb.append("\\b");
                break;
            }
            case 12: {
                sb.append("\\f");
                break;
            }
            case 10: {
                sb.append("\\n");
                break;
            }
            case 13: {
                sb.append("\\r");
                break;
            }
            case 9: {
                sb.append("\\t");
                break;
            }
            default: {
                if (b < 32 || b > 126) {
                    sb.append('\\');
                    String octal = Integer.toOctalString(b < 0 ? b + 256 : b);
                    for (int j = octal.length(); j < 3; ++j) {
                        sb.append('0');
                    }
                    sb.append(octal);
                    break;
                }
                if (special != null && special.indexOf((char)b) != -1) {
                    sb.append('\\');
                    sb.append((char)b);
                    break;
                }
                sb.append((char)b);
            }
        }
    }

    public static String escapeString(String s, String special) {
        if (special != null) {
            for (int i = 0; i < special.length(); ++i) {
                if (special.charAt(i) >= ' ' && special.charAt(i) <= '~') continue;
                throw new IllegalArgumentException("special characters must be in ASCII range 32-126");
            }
        }
        byte[] bytes = null;
        try {
            bytes = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            assert (false);
            return null;
        }
        StringBuffer result = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            StringUtil.encodeChar(bytes[i], result, special);
        }
        return result.toString();
    }

    private static char checkChar(char c) {
        if (c < ' ' || c > '~') {
            throw new IllegalArgumentException("illegal input character");
        }
        return c;
    }

    private static char decodeChar(String s, int start, int end, IntHolder nextStart) {
        int c;
        assert (start >= 0);
        assert (start < end);
        assert (end <= s.length());
        if (s.charAt(start) != '\\') {
            c = StringUtil.checkChar(s.charAt(start++));
        } else {
            if (start + 1 == end) {
                throw new IllegalArgumentException("trailing backslash in argument");
            }
            switch (s.charAt(++start)) {
                case '\"': 
                case '\'': 
                case '\\': {
                    c = s.charAt(start++);
                    break;
                }
                case 'b': {
                    ++start;
                    c = 8;
                    break;
                }
                case 'f': {
                    ++start;
                    c = 12;
                    break;
                }
                case 'n': {
                    ++start;
                    c = 10;
                    break;
                }
                case 'r': {
                    ++start;
                    c = 13;
                    break;
                }
                case 't': {
                    ++start;
                    c = 9;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int oct = 0;
                    for (int j = 0; j < 3 && start < end; ++j) {
                        int charVal;
                        if ((charVal = s.charAt(start++) - 48) < 0 || charVal > 7) {
                            --start;
                            break;
                        }
                        oct = oct * 8 + charVal;
                    }
                    if (oct > 255) {
                        throw new IllegalArgumentException("octal value out of range");
                    }
                    c = (char)oct;
                    break;
                }
                default: {
                    c = StringUtil.checkChar(s.charAt(start++));
                }
            }
        }
        nextStart.value = start;
        return (char)c;
    }

    private static void decodeString(String s, int start, int end, StringBuffer sb) {
        IntHolder nextStart = new IntHolder();
        while (start < end) {
            sb.append(StringUtil.decodeChar(s, start, end, nextStart));
            start = nextStart.value;
        }
    }

    public static boolean unescapeString(String s, int start, int end, StringHolder result) {
        if (start < 0) {
            throw new IllegalArgumentException("start offset must be >= 0");
        }
        if (end > s.length()) {
            throw new IllegalArgumentException("end offset must <= s.length()");
        }
        if (start > end) {
            throw new IllegalArgumentException("start offset must <= end offset");
        }
        try {
            StringBuffer sb = new StringBuffer();
            StringUtil.decodeString(s, start, end, sb);
            String decodedString = sb.toString();
            byte[] arr = new byte[decodedString.length()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (byte)decodedString.charAt(i);
            }
            result.value = new String(arr, 0, arr.length, "UTF8");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static int checkQuote(String s) {
        return StringUtil.checkQuote(s, 0);
    }

    public static int checkQuote(String s, int start) {
        char quoteChar = s.charAt(start);
        if (quoteChar == '\"' || quoteChar == '\'') {
            int pos;
            ++start;
            int len = s.length();
            while (start < len && (pos = s.indexOf(quoteChar, start)) != -1) {
                if (s.charAt(pos - 1) != '\\') {
                    return pos;
                }
                start = pos + 1;
            }
            return -1;
        }
        return 0;
    }
}

