/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.FileException;
import Ice.Identity;
import Ice.ImplicitContextI;
import Ice.InitializationData;
import Ice.InitializationException;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.Logger;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.PluginManager;
import Ice.PluginManagerI;
import Ice.ProcessPrx;
import Ice.ProcessPrxHelper;
import Ice.PropertiesI;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.ServerNotFoundException;
import Ice.StringSeqHolder;
import Ice.SysLoggerI;
import Ice.Util;
import Ice._ObjectAdapterOperationsNC;
import IceInternal.ConnectionMonitor;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointFactoryManager;
import IceInternal.EndpointHostResolver;
import IceInternal.LocatorManager;
import IceInternal.ObjectAdapterFactory;
import IceInternal.ObjectFactoryManager;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.ProcessI;
import IceInternal.PropertiesAdminI;
import IceInternal.ProxyFactory;
import IceInternal.ReferenceFactory;
import IceInternal.RouterManager;
import IceInternal.SelectorThread;
import IceInternal.TcpEndpointFactory;
import IceInternal.ThreadPool;
import IceInternal.Timer;
import IceInternal.TraceLevels;
import IceInternal.UdpEndpointFactory;
import IceUtilInternal.Assert;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Instance {
    private static final int StateActive = 0;
    private static final int StateDestroyInProgress = 1;
    private static final int StateDestroyed = 2;
    private int _state = 0;
    private final InitializationData _initData;
    private final TraceLevels _traceLevels;
    private final DefaultsAndOverrides _defaultsAndOverrides;
    private final int _messageSizeMax;
    private final int _clientACM;
    private final int _serverACM;
    private final ImplicitContextI _implicitContext;
    private RouterManager _routerManager;
    private LocatorManager _locatorManager;
    private ReferenceFactory _referenceFactory;
    private ProxyFactory _proxyFactory;
    private OutgoingConnectionFactory _outgoingConnectionFactory;
    private ConnectionMonitor _connectionMonitor;
    private ObjectFactoryManager _servantFactoryManager;
    private ObjectAdapterFactory _objectAdapterFactory;
    private int _protocolSupport;
    private ThreadPool _clientThreadPool;
    private ThreadPool _serverThreadPool;
    private SelectorThread _selectorThread;
    private EndpointHostResolver _endpointHostResolver;
    private Timer _timer;
    private EndpointFactoryManager _endpointFactoryManager;
    private PluginManager _pluginManager;
    private Map<String, String> _defaultContext;
    private ObjectAdapter _adminAdapter;
    private Map<String, Object> _adminFacets = new HashMap<String, Object>();
    private Set<String> _adminFacetFilter = new HashSet<String>();
    private Identity _adminIdentity;
    private static Map<String, String> _emptyContext = new HashMap<String, String>();
    private static boolean _oneOffDone = false;

    public InitializationData initializationData() {
        return this._initData;
    }

    public TraceLevels traceLevels() {
        return this._traceLevels;
    }

    public DefaultsAndOverrides defaultsAndOverrides() {
        return this._defaultsAndOverrides;
    }

    public synchronized RouterManager routerManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._routerManager;
    }

    public synchronized LocatorManager locatorManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._locatorManager;
    }

    public synchronized ReferenceFactory referenceFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._referenceFactory;
    }

    public synchronized ProxyFactory proxyFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._proxyFactory;
    }

    public synchronized OutgoingConnectionFactory outgoingConnectionFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._outgoingConnectionFactory;
    }

    public synchronized ConnectionMonitor connectionMonitor() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._connectionMonitor;
    }

    public synchronized ObjectFactoryManager servantFactoryManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._servantFactoryManager;
    }

    public synchronized ObjectAdapterFactory objectAdapterFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._objectAdapterFactory;
    }

    public synchronized int protocolSupport() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._protocolSupport;
    }

    public synchronized ThreadPool clientThreadPool() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._clientThreadPool == null) {
            this._clientThreadPool = new ThreadPool(this, "Ice.ThreadPool.Client", 0);
        }
        return this._clientThreadPool;
    }

    public synchronized ThreadPool serverThreadPool() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._serverThreadPool == null) {
            int timeout = this._initData.properties.getPropertyAsInt("Ice.ServerIdleTime");
            this._serverThreadPool = new ThreadPool(this, "Ice.ThreadPool.Server", timeout);
        }
        return this._serverThreadPool;
    }

    public synchronized SelectorThread selectorThread() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._selectorThread == null) {
            this._selectorThread = new SelectorThread(this);
        }
        return this._selectorThread;
    }

    public synchronized EndpointHostResolver endpointHostResolver() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._endpointHostResolver == null) {
            this._endpointHostResolver = new EndpointHostResolver(this);
        }
        return this._endpointHostResolver;
    }

    public synchronized Timer timer() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._timer == null) {
            this._timer = new Timer(this);
        }
        return this._timer;
    }

    public synchronized EndpointFactoryManager endpointFactoryManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._endpointFactoryManager;
    }

    public synchronized PluginManager pluginManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._pluginManager;
    }

    public int messageSizeMax() {
        return this._messageSizeMax;
    }

    public int clientACM() {
        return this._clientACM;
    }

    public int serverACM() {
        return this._serverACM;
    }

    public synchronized void setDefaultContext(Map<String, String> ctx) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        this._defaultContext = ctx == null || ctx.isEmpty() ? _emptyContext : new HashMap<String, String>(ctx);
    }

    public synchronized Map<String, String> getDefaultContext() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return new HashMap<String, String>(this._defaultContext);
    }

    public ImplicitContextI getImplicitContext() {
        return this._implicitContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        ObjectAdapterFactory adapterFactory;
        OutgoingConnectionFactory connectionFactory;
        Instance instance = this;
        synchronized (instance) {
            if (this._state == 2) {
                throw new CommunicatorDestroyedException();
            }
            connectionFactory = this._outgoingConnectionFactory;
            adapterFactory = this._objectAdapterFactory;
        }
        connectionFactory.flushBatchRequests();
        adapterFactory.flushBatchRequests();
    }

    public Identity stringToIdentity(String s) {
        return Util.stringToIdentity(s);
    }

    public String identityToString(Identity ident) {
        return Util.identityToString(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectPrx getAdmin() {
        java.lang.Object adminOA;
        _ObjectAdapterOperationsNC adapter = null;
        String serverId = null;
        LocatorPrx defaultLocator = null;
        Instance instance = this;
        synchronized (instance) {
            if (this._state == 2) {
                throw new CommunicatorDestroyedException();
            }
            adminOA = "Ice.Admin";
            if (this._adminAdapter != null) {
                return this._adminAdapter.createProxy(this._adminIdentity);
            }
            if (this._initData.properties.getProperty("Ice.Admin.Endpoints").length() == 0) {
                return null;
            }
            serverId = this._initData.properties.getProperty("Ice.Admin.ServerId");
            String instanceName = this._initData.properties.getProperty("Ice.Admin.InstanceName");
            defaultLocator = this._referenceFactory.getDefaultLocator();
            if (defaultLocator != null && serverId.length() > 0 || instanceName.length() > 0) {
                if (this._adminIdentity == null) {
                    if (instanceName.length() == 0) {
                        instanceName = Util.generateUUID();
                    }
                    this._adminIdentity = new Identity("admin", instanceName);
                }
                this._adminAdapter = this._objectAdapterFactory.createObjectAdapter("Ice.Admin", "", null);
                HashMap<String, Object> filteredFacets = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : this._adminFacets.entrySet()) {
                    if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(entry.getKey())) {
                        this._adminAdapter.addFacet(entry.getValue(), this._adminIdentity, entry.getKey());
                        continue;
                    }
                    filteredFacets.put(entry.getKey(), entry.getValue());
                }
                this._adminFacets = filteredFacets;
                adapter = this._adminAdapter;
            }
        }
        if (adapter == null) {
            return null;
        }
        try {
            adapter.activate();
        }
        catch (LocalException ex) {
            adminOA = this;
            synchronized (adminOA) {
                this._adminAdapter = null;
                adapter.destroy();
            }
            throw ex;
        }
        if (defaultLocator != null && serverId.length() > 0) {
            StringBuffer s;
            ProcessPrx process = ProcessPrxHelper.uncheckedCast(adapter.createProxy(this._adminIdentity).ice_facet("Process"));
            try {
                defaultLocator.getRegistry().setServerProcessProxy(serverId, process);
            }
            catch (ServerNotFoundException ex) {
                if (this._traceLevels.location >= 1) {
                    s = new StringBuffer();
                    s.append("couldn't register server `" + serverId + "' with the locator registry:\n");
                    s.append("the server is not known to the locator registry");
                    this._initData.logger.trace(this._traceLevels.locationCat, s.toString());
                }
                throw new InitializationException("Locator knows nothing about server '" + serverId + "'");
            }
            catch (LocalException ex) {
                if (this._traceLevels.location >= 1) {
                    s = new StringBuffer();
                    s.append("couldn't register server `" + serverId + "' with the locator registry:\n" + ex);
                    this._initData.logger.trace(this._traceLevels.locationCat, s.toString());
                }
                throw ex;
            }
            if (this._traceLevels.location >= 1) {
                StringBuffer s2 = new StringBuffer();
                s2.append("registered server `" + serverId + "' with the locator registry");
                this._initData.logger.trace(this._traceLevels.locationCat, s2.toString());
            }
        }
        return adapter.createProxy(this._adminIdentity);
    }

    public synchronized void addAdminFacet(Object servant, String facet) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._adminAdapter == null || !this._adminFacetFilter.isEmpty() && !this._adminFacetFilter.contains(facet)) {
            if (this._adminFacets.get(facet) != null) {
                throw new AlreadyRegisteredException("facet", facet);
            }
            this._adminFacets.put(facet, servant);
        } else {
            this._adminAdapter.addFacet(servant, this._adminIdentity, facet);
        }
    }

    public synchronized Object removeAdminFacet(String facet) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        Object result = null;
        if (this._adminAdapter == null || !this._adminFacetFilter.isEmpty() && !this._adminFacetFilter.contains(facet)) {
            result = this._adminFacets.remove(facet);
            if (result == null) {
                throw new NotRegisteredException("facet", facet);
            }
        } else {
            result = this._adminAdapter.removeFacet(this._adminIdentity, facet);
        }
        return result;
    }

    public synchronized void setDefaultLocator(LocatorPrx locator) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        this._referenceFactory = this._referenceFactory.setDefaultLocator(locator);
    }

    public synchronized void setDefaultRouter(RouterPrx router) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        this._referenceFactory = this._referenceFactory.setDefaultRouter(router);
    }

    public void setLogger(Logger logger) {
        this._initData.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance(Communicator communicator, InitializationData initData) {
        this._initData = initData;
        try {
            if (this._initData.properties == null) {
                this._initData.properties = Util.createProperties();
            }
            Class<Instance> clazz = Instance.class;
            synchronized (Instance.class) {
                boolean ipv6;
                if (!_oneOffDone) {
                    String stdOut = this._initData.properties.getProperty("Ice.StdOut");
                    String stdErr = this._initData.properties.getProperty("Ice.StdErr");
                    PrintStream outStream = null;
                    if (stdOut.length() > 0) {
                        System.out.close();
                        try {
                            outStream = new PrintStream(new FileOutputStream(stdOut, true));
                        }
                        catch (FileNotFoundException ex) {
                            FileException fe = new FileException();
                            fe.path = stdOut;
                            fe.initCause(ex);
                            throw fe;
                        }
                        System.setOut(outStream);
                    }
                    if (stdErr.length() > 0) {
                        System.err.close();
                        if (stdErr.equals(stdOut)) {
                            System.setErr(outStream);
                        } else {
                            try {
                                System.setErr(new PrintStream(new FileOutputStream(stdErr, true)));
                            }
                            catch (FileNotFoundException ex) {
                                FileException fe = new FileException();
                                fe.path = stdErr;
                                fe.initCause(ex);
                                throw fe;
                            }
                        }
                    }
                    _oneOffDone = true;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (this._initData.logger == null) {
                    this._initData.logger = this._initData.properties.getPropertyAsInt("Ice.UseSyslog") > 0 ? new SysLoggerI(this._initData.properties.getProperty("Ice.ProgramName")) : Util.getProcessLogger();
                }
                this.validatePackages();
                this._traceLevels = new TraceLevels(this._initData.properties);
                this._defaultsAndOverrides = new DefaultsAndOverrides(this._initData.properties);
                int defaultMessageSizeMax = 1024;
                int num = this._initData.properties.getPropertyAsIntWithDefault("Ice.MessageSizeMax", 1024);
                this._messageSizeMax = num < 1 ? 0x100000 : (num > 0x1FFFFF ? Integer.MAX_VALUE : num * 1024);
                this._clientACM = this._initData.properties.getPropertyAsIntWithDefault("Ice.ACM.Client", 60);
                this._serverACM = this._initData.properties.getPropertyAsInt("Ice.ACM.Server");
                this._implicitContext = ImplicitContextI.create(this._initData.properties.getProperty("Ice.ImplicitContext"));
                this._routerManager = new RouterManager();
                this._locatorManager = new LocatorManager();
                this._referenceFactory = new ReferenceFactory(this, communicator);
                this._proxyFactory = new ProxyFactory(this);
                boolean ipv4 = this._initData.properties.getPropertyAsIntWithDefault("Ice.IPv4", 1) > 0;
                boolean bl = ipv6 = this._initData.properties.getPropertyAsIntWithDefault("Ice.IPv6", 0) > 0;
                if (!ipv4 && !ipv6) {
                    throw new InitializationException("Both IPV4 and IPv6 support cannot be disabled.");
                }
                this._protocolSupport = ipv4 && ipv6 ? 2 : (ipv4 ? 0 : 1);
                this._endpointFactoryManager = new EndpointFactoryManager(this);
                TcpEndpointFactory tcpEndpointFactory = new TcpEndpointFactory(this);
                this._endpointFactoryManager.add(tcpEndpointFactory);
                UdpEndpointFactory udpEndpointFactory = new UdpEndpointFactory(this);
                this._endpointFactoryManager.add(udpEndpointFactory);
                this._pluginManager = new PluginManagerI(communicator);
                this._defaultContext = _emptyContext;
                this._outgoingConnectionFactory = new OutgoingConnectionFactory(this);
                this._servantFactoryManager = new ObjectFactoryManager();
                this._objectAdapterFactory = new ObjectAdapterFactory(this, communicator);
                String[] facetFilter = this._initData.properties.getPropertyAsList("Ice.Admin.Facets");
                if (facetFilter.length > 0) {
                    this._adminFacetFilter.addAll(Arrays.asList(facetFilter));
                }
                this._adminFacets.put("Properties", new PropertiesAdminI(this._initData.properties));
                this._adminFacets.put("Process", new ProcessI(communicator));
            }
        }
        catch (LocalException ex) {
            this.destroy();
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._state == 2);
        Assert.FinalizerAssert(this._referenceFactory == null);
        Assert.FinalizerAssert(this._proxyFactory == null);
        Assert.FinalizerAssert(this._outgoingConnectionFactory == null);
        Assert.FinalizerAssert(this._connectionMonitor == null);
        Assert.FinalizerAssert(this._servantFactoryManager == null);
        Assert.FinalizerAssert(this._objectAdapterFactory == null);
        Assert.FinalizerAssert(this._clientThreadPool == null);
        Assert.FinalizerAssert(this._serverThreadPool == null);
        Assert.FinalizerAssert(this._selectorThread == null);
        Assert.FinalizerAssert(this._endpointHostResolver == null);
        Assert.FinalizerAssert(this._timer == null);
        Assert.FinalizerAssert(this._routerManager == null);
        Assert.FinalizerAssert(this._locatorManager == null);
        Assert.FinalizerAssert(this._endpointFactoryManager == null);
        Assert.FinalizerAssert(this._pluginManager == null);
        super.finalize();
    }

    public void finishSetup(StringSeqHolder args) {
        LocatorPrx loc;
        PluginManagerI pluginManagerImpl = (PluginManagerI)this._pluginManager;
        pluginManagerImpl.loadPlugins(args);
        RouterPrx router = RouterPrxHelper.uncheckedCast(this._proxyFactory.propertyToProxy("Ice.Default.Router"));
        if (router != null) {
            this._referenceFactory = this._referenceFactory.setDefaultRouter(router);
        }
        if ((loc = LocatorPrxHelper.uncheckedCast(this._proxyFactory.propertyToProxy("Ice.Default.Locator"))) != null) {
            this._referenceFactory = this._referenceFactory.setDefaultLocator(loc);
        }
        if (this._initData.properties.getPropertyAsIntWithDefault("Ice.Admin.DelayCreation", 0) <= 0) {
            this.getAdmin();
        }
        int interval = 0;
        if (this._clientACM > 0 && this._serverACM > 0) {
            interval = this._clientACM < this._serverACM ? this._clientACM : this._serverACM;
        } else if (this._clientACM > 0) {
            interval = this._clientACM;
        } else if (this._serverACM > 0) {
            interval = this._serverACM;
        }
        interval = this._initData.properties.getPropertyAsIntWithDefault("Ice.MonitorConnections", interval);
        if (interval > 0) {
            this._connectionMonitor = new ConnectionMonitor(this, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        List<String> unusedProperties;
        Instance instance = this;
        synchronized (instance) {
            if (this._state != 0) {
                return;
            }
            this._state = 1;
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.shutdown();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.destroy();
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.destroy();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.waitUntilFinished();
        }
        ThreadPool serverThreadPool = null;
        ThreadPool clientThreadPool = null;
        SelectorThread selectorThread = null;
        EndpointHostResolver endpointHostResolver = null;
        Instance instance2 = this;
        synchronized (instance2) {
            this._objectAdapterFactory = null;
            this._outgoingConnectionFactory = null;
            if (this._connectionMonitor != null) {
                this._connectionMonitor.destroy();
                this._connectionMonitor = null;
            }
            if (this._serverThreadPool != null) {
                this._serverThreadPool.destroy();
                serverThreadPool = this._serverThreadPool;
                this._serverThreadPool = null;
            }
            if (this._clientThreadPool != null) {
                this._clientThreadPool.destroy();
                clientThreadPool = this._clientThreadPool;
                this._clientThreadPool = null;
            }
            if (this._selectorThread != null) {
                this._selectorThread.destroy();
                selectorThread = this._selectorThread;
                this._selectorThread = null;
            }
            if (this._endpointHostResolver != null) {
                this._endpointHostResolver.destroy();
                endpointHostResolver = this._endpointHostResolver;
                this._endpointHostResolver = null;
            }
            if (this._timer != null) {
                this._timer._destroy();
                this._timer = null;
            }
            if (this._servantFactoryManager != null) {
                this._servantFactoryManager.destroy();
                this._servantFactoryManager = null;
            }
            if (this._referenceFactory != null) {
                this._referenceFactory.destroy();
                this._referenceFactory = null;
            }
            this._proxyFactory = null;
            if (this._routerManager != null) {
                this._routerManager.destroy();
                this._routerManager = null;
            }
            if (this._locatorManager != null) {
                this._locatorManager.destroy();
                this._locatorManager = null;
            }
            if (this._endpointFactoryManager != null) {
                this._endpointFactoryManager.destroy();
                this._endpointFactoryManager = null;
            }
            if (this._pluginManager != null) {
                this._pluginManager.destroy();
                this._pluginManager = null;
            }
            this._adminAdapter = null;
            this._adminFacets.clear();
            this._state = 2;
        }
        if (clientThreadPool != null) {
            clientThreadPool.joinWithAllThreads();
        }
        if (serverThreadPool != null) {
            serverThreadPool.joinWithAllThreads();
        }
        if (selectorThread != null) {
            selectorThread.joinWithThread();
        }
        if (endpointHostResolver != null) {
            endpointHostResolver.joinWithThread();
        }
        if (this._initData.properties.getPropertyAsInt("Ice.Warn.UnusedProperties") > 0 && (unusedProperties = ((PropertiesI)this._initData.properties).getUnusedProperties()).size() != 0) {
            String message = "The following properties were set but never read:";
            Iterator<String> p = unusedProperties.iterator();
            while (p.hasNext()) {
                message = message + "\n    " + p.next();
            }
            this._initData.logger.warning(message);
        }
    }

    private void validatePackages() {
        String prefix = "Ice.Package.";
        Map<String, String> map = this._initData.properties.getPropertiesForPrefix("Ice.Package.");
        for (Map.Entry<String, String> e : map.entrySet()) {
            String key = e.getKey();
            String pkg = e.getValue();
            if (key.length() == "Ice.Package.".length()) {
                this._initData.logger.warning("ignoring invalid property: " + key + "=" + pkg);
            }
            String module = key.substring("Ice.Package.".length());
            String className = pkg + "." + module + "._Marker";
            try {
                Class.forName(className);
            }
            catch (Exception ex) {
                this._initData.logger.warning("unable to validate package: " + key + "=" + pkg);
            }
        }
    }
}

