/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Connection;
import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.PostCompletionCallback;
import Freeze.Transaction;

class TransactionI
implements Transaction {
    private ConnectionI _connection;
    private int _txTrace;
    private com.sleepycat.db.Transaction _txn;
    private PostCompletionCallback _postCompletionCallback;
    private String _errorPrefix;
    private boolean _ownConnection = false;

    public void commit() {
        if (this._txn == null) {
            throw new DatabaseException(this._errorPrefix + "inactive transaction");
        }
        String txnId = null;
        boolean committed = false;
        boolean deadlock = false;
        try {
            this._connection.closeAllIterators();
            if (this._txTrace >= 1) {
                txnId = Long.toHexString((long)(this._txn.getId() & Integer.MAX_VALUE) + 0x80000000L);
            }
            this._txn.commit();
            committed = true;
            if (this._txTrace >= 1) {
                this._connection.communicator().getLogger().trace("Freeze.Transaction", this._errorPrefix + "committed transaction " + txnId);
            }
        }
        catch (com.sleepycat.db.DeadlockException e) {
            deadlock = true;
            if (this._txTrace >= 1) {
                this._connection.communicator().getLogger().trace("Freeze.Transaction", this._errorPrefix + "failed to commit transaction " + txnId + ": " + e.getMessage());
            }
            DeadlockException ex = new DeadlockException(this._errorPrefix + "DbTxn.commit: " + e.getMessage(), this);
            ex.initCause(e);
            throw ex;
        }
        catch (com.sleepycat.db.DatabaseException e) {
            if (this._txTrace >= 1) {
                this._connection.communicator().getLogger().trace("Freeze.Transaction", this._errorPrefix + "failed to commit transaction " + txnId + ": " + e.getMessage());
            }
            DatabaseException ex = new DatabaseException();
            ex.initCause(e);
            ex.message = this._errorPrefix + "DbTxn.commit: " + e.getMessage();
            throw ex;
        }
        finally {
            this._connection.clearTransaction();
            if (this._ownConnection) {
                this._connection.close();
            }
            this._connection = null;
            this._txn = null;
            this.postCompletion(committed, deadlock);
        }
    }

    public void rollback() {
        if (this._txn == null) {
            throw new DatabaseException(this._errorPrefix + "inactive transaction");
        }
        String txnId = null;
        boolean deadlock = false;
        try {
            this._connection.closeAllIterators();
            if (this._txTrace >= 1) {
                txnId = Long.toHexString((long)(this._txn.getId() & Integer.MAX_VALUE) + 0x80000000L);
            }
            this._txn.abort();
            if (this._txTrace >= 1) {
                this._connection.communicator().getLogger().trace("Freeze.Transaction", this._errorPrefix + "rolled back transaction " + txnId);
            }
        }
        catch (com.sleepycat.db.DeadlockException e) {
            if (this._txTrace >= 1) {
                this._connection.communicator().getLogger().trace("Freeze.Transaction", this._errorPrefix + "failed to rollback transaction " + txnId + ": " + e.getMessage());
            }
            deadlock = true;
            DeadlockException ex = new DeadlockException(this._errorPrefix + "DbTxn.abort: " + e.getMessage(), this);
            ex.initCause(e);
            throw ex;
        }
        catch (com.sleepycat.db.DatabaseException e) {
            if (this._txTrace >= 1) {
                this._connection.communicator().getLogger().trace("Freeze.Transaction", this._errorPrefix + "failed to rollback transaction " + txnId + ": " + e.getMessage());
            }
            DatabaseException ex = new DatabaseException();
            ex.initCause(e);
            ex.message = this._errorPrefix + "DbTxn.abort: " + e.getMessage();
            throw ex;
        }
        finally {
            this._connection.clearTransaction();
            if (this._ownConnection) {
                this._connection.close();
            }
            this._connection = null;
            this._txn = null;
            this.postCompletion(false, deadlock);
        }
    }

    public Connection getConnection() {
        return this._connection;
    }

    TransactionI(ConnectionI connection) {
        this._connection = connection;
        this._txTrace = connection.txTrace();
        this._errorPrefix = "DbEnv(\"" + this._connection.envName() + "\"): ";
        try {
            this._txn = this._connection.dbEnv().getEnv().beginTransaction(null, null);
            if (this._txTrace >= 1) {
                String txnId = Long.toHexString((long)(this._txn.getId() & Integer.MAX_VALUE) + 0x80000000L);
                this._connection.communicator().getLogger().trace("Freeze.Transaction", this._errorPrefix + "started transaction " + txnId);
            }
        }
        catch (com.sleepycat.db.DatabaseException e) {
            if (this._txTrace >= 1) {
                this._connection.communicator().getLogger().trace("Freeze.Transaction", this._errorPrefix + "failed to start transaction: " + e.getMessage());
            }
            DatabaseException ex = new DatabaseException();
            ex.initCause(e);
            ex.message = this._errorPrefix + "txn_begin: " + e.getMessage();
            throw ex;
        }
    }

    void setPostCompletionCallback(PostCompletionCallback cb) {
        this._postCompletionCallback = cb;
    }

    void adoptConnection() {
        this._ownConnection = true;
    }

    ConnectionI getConnectionI() {
        return this._connection;
    }

    com.sleepycat.db.Transaction dbTxn() {
        return this._txn;
    }

    private void postCompletion(boolean committed, boolean deadlock) {
        if (this._postCompletionCallback != null) {
            this._postCompletionCallback.postCompletion(committed, deadlock);
        }
    }
}

