/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Logger;
import IceInternal.Connector;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceInternal.UdpTransceiver;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;

final class UdpConnector
implements Connector,
Comparable {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private InetSocketAddress _addr;
    private String _mcastInterface;
    private int _mcastTtl;
    private byte _protocolMajor;
    private byte _protocolMinor;
    private byte _encodingMajor;
    private byte _encodingMinor;
    private String _connectionId;
    private int _hashCode;

    public Transceiver connect() {
        return new UdpTransceiver(this._instance, this._addr, this._mcastInterface, this._mcastTtl);
    }

    public SelectableChannel fd() {
        assert (false);
        return null;
    }

    public short type() {
        return 3;
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    public int hashCode() {
        return this._hashCode;
    }

    UdpConnector(Instance instance, InetSocketAddress addr, String mcastInterface, int mcastTtl, byte protocolMajor, byte protocolMinor, byte encodingMajor, byte encodingMinor, String connectionId) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._addr = addr;
        this._mcastInterface = mcastInterface;
        this._mcastTtl = mcastTtl;
        this._protocolMajor = protocolMajor;
        this._protocolMinor = protocolMinor;
        this._encodingMajor = encodingMajor;
        this._encodingMinor = encodingMinor;
        this._connectionId = connectionId;
        this._hashCode = this._addr.getAddress().getHostAddress().hashCode();
        this._hashCode = 5 * this._hashCode + this._addr.getPort();
        this._hashCode = 5 * this._hashCode + this._mcastInterface.hashCode();
        this._hashCode = 5 * this._hashCode + this._mcastTtl;
        this._hashCode = 5 * this._hashCode + this._connectionId.hashCode();
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        UdpConnector p;
        block17: {
            p = null;
            try {
                p = (UdpConnector)obj;
            }
            catch (ClassCastException ex) {
                try {
                    Connector c = (Connector)obj;
                    return this.type() < c.type() ? -1 : 1;
                }
                catch (ClassCastException ee) {
                    if ($assertionsDisabled) break block17;
                    throw new AssertionError();
                }
            }
        }
        if (this == p) {
            return 0;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return this._connectionId.compareTo(p._connectionId);
        }
        if (this._protocolMajor < p._protocolMajor) {
            return -1;
        }
        if (p._protocolMajor < this._protocolMajor) {
            return 1;
        }
        if (this._protocolMinor < p._protocolMinor) {
            return -1;
        }
        if (p._protocolMinor < this._protocolMinor) {
            return 1;
        }
        if (this._encodingMajor < p._encodingMajor) {
            return -1;
        }
        if (p._encodingMajor < this._encodingMajor) {
            return 1;
        }
        if (this._encodingMinor < p._encodingMinor) {
            return -1;
        }
        if (p._encodingMinor < this._encodingMinor) {
            return 1;
        }
        if (this._mcastTtl < p._mcastTtl) {
            return -1;
        }
        if (p._mcastTtl < this._mcastTtl) {
            return 1;
        }
        int rc = this._mcastInterface.compareTo(p._mcastInterface);
        if (rc != 0) {
            return rc;
        }
        return Network.compareAddress(this._addr, p._addr);
    }
}

