/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Random;
import omero.model.Point;
import omero.model.RectI;
import omero.model.SmartShape;
import omero.rtypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartRectI
extends RectI
implements SmartShape {
    @Override
    public void areaPoints(SmartShape.PointCallback cb) {
        Shape s = this.asAwtShape();
        Rectangle2D r = s.getBounds2D();
        SmartShape.Util.pointsByBoundingBox(s, r, cb);
    }

    @Override
    public Shape asAwtShape() {
        double[] d = this.data();
        Rectangle2D.Double rect = new Rectangle2D.Double(d[0], d[1], d[2], d[3]);
        return rect;
    }

    @Override
    public List<Point> asPoints() {
        double[] d = this.data();
        List<Point> points = SmartShape.Util.points(d[0], d[1], d[2], d[3]);
        assert (SmartShape.Util.checkNonNull(points)) : "Null points in " + this;
        return points;
    }

    @Override
    public void randomize(Random random) {
        if (this.roi != null) {
            throw new UnsupportedOperationException("Roi-based values unsupported");
        }
        this.x = rtypes.rdouble(random.nextInt(100));
        this.y = rtypes.rdouble(random.nextInt(100));
        this.width = rtypes.rdouble(random.nextInt(100));
        this.height = rtypes.rdouble(random.nextInt(100));
    }

    private double[] data() {
        double x = this.getX().getValue();
        double y = this.getY().getValue();
        double w = this.getWidth().getValue();
        double h = this.getHeight().getValue();
        return new double[]{x, y, w, h};
    }
}

