/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.InputStream;
import Ice.MarshalException;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.OutputStream;
import IceInternal.BasicStream;
import IceInternal.Ex;
import IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import omero.RInt;
import omero.RIntHolder;
import omero.RLong;
import omero.RLongHolder;
import omero.RString;
import omero.RStringHolder;
import omero.RTime;
import omero.RTimeHolder;
import omero.model.Annotation;
import omero.model.AnnotationHolder;
import omero.model.Details;
import omero.model.Event;
import omero.model.EventHolder;
import omero.model.Experimenter;
import omero.model.ExperimenterHolder;
import omero.model.IObject;
import omero.model.Node;
import omero.model.NodeHolder;
import omero.model.SessionAnnotationLink;
import omero.model.SessionAnnotationLinkHolder;
import omero.model.SessionAnnotationLinksSeqHelper;
import omero.model.SessionEventsSeqHelper;
import omero.model.SessionHolder;
import omero.model.SessionLinkedAnnotationSeqHelper;
import omero.model._SessionOperations;
import omero.model._SessionOperationsNC;
import omero.sys.CountMapHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Session
extends IObject
implements _SessionOperations,
_SessionOperationsNC {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::model::IObject", "::omero::model::Session"};
    private static final String[] __all = new String[]{"addAllEventSet", "addAllSessionAnnotationLinkSet", "addEvent", "addSessionAnnotationLink", "addSessionAnnotationLinkToBoth", "clearAnnotationLinks", "clearEvents", "copyAnnotationLinks", "copyEvents", "findSessionAnnotationLink", "getAnnotationLinksCountPerOwner", "getClosed", "getDefaultEventType", "getDefaultPermissions", "getDetails", "getId", "getMessage", "getNode", "getOwner", "getStarted", "getTimeToIdle", "getTimeToLive", "getUserAgent", "getUuid", "getVersion", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isAnnotated", "isGlobal", "isLink", "isLoaded", "isMutable", "linkAnnotation", "linkedAnnotationList", "proxy", "reloadAnnotationLinks", "reloadEvents", "removeAllEventSet", "removeAllSessionAnnotationLinkSet", "removeEvent", "removeSessionAnnotationLink", "removeSessionAnnotationLinkFromBoth", "setClosed", "setDefaultEventType", "setDefaultPermissions", "setId", "setMessage", "setNode", "setOwner", "setStarted", "setTimeToIdle", "setTimeToLive", "setUserAgent", "setUuid", "setVersion", "shallowCopy", "sizeOfAnnotationLinks", "sizeOfEvents", "unlinkAnnotation", "unload", "unloadAnnotationLinks", "unloadCollections", "unloadDetails", "unloadEvents"};
    protected RInt version;
    protected Node node;
    protected RString uuid;
    protected Experimenter owner;
    protected RLong timeToIdle;
    protected RLong timeToLive;
    protected RTime started;
    protected RTime closed;
    protected RString message;
    protected RString defaultPermissions;
    protected RString defaultEventType;
    protected RString userAgent;
    protected List<Event> eventsSeq;
    protected boolean eventsLoaded;
    protected List<SessionAnnotationLink> annotationLinksSeq;
    protected boolean annotationLinksLoaded;
    protected Map<Long, Long> annotationLinksCountPerOwner;

    public Session() {
    }

    public Session(RLong id, Details details, boolean loaded, RInt version, Node node, RString uuid, Experimenter owner, RLong timeToIdle, RLong timeToLive, RTime started, RTime closed, RString message, RString defaultPermissions, RString defaultEventType, RString userAgent, List<Event> eventsSeq, boolean eventsLoaded, List<SessionAnnotationLink> annotationLinksSeq, boolean annotationLinksLoaded, Map<Long, Long> annotationLinksCountPerOwner) {
        super(id, details, loaded);
        this.version = version;
        this.node = node;
        this.uuid = uuid;
        this.owner = owner;
        this.timeToIdle = timeToIdle;
        this.timeToLive = timeToLive;
        this.started = started;
        this.closed = closed;
        this.message = message;
        this.defaultPermissions = defaultPermissions;
        this.defaultEventType = defaultEventType;
        this.userAgent = userAgent;
        this.eventsSeq = eventsSeq;
        this.eventsLoaded = eventsLoaded;
        this.annotationLinksSeq = annotationLinksSeq;
        this.annotationLinksLoaded = annotationLinksLoaded;
        this.annotationLinksCountPerOwner = annotationLinksCountPerOwner;
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current __current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[2];
    }

    @Override
    public String ice_id(Current __current) {
        return __ids[2];
    }

    public static String ice_staticId() {
        return __ids[2];
    }

    @Override
    public final void addAllEventSet(List<Event> targets) {
        this.addAllEventSet(targets, null);
    }

    @Override
    public final void addAllSessionAnnotationLinkSet(List<SessionAnnotationLink> targets) {
        this.addAllSessionAnnotationLinkSet(targets, null);
    }

    @Override
    public final void addEvent(Event target) {
        this.addEvent(target, null);
    }

    @Override
    public final void addSessionAnnotationLink(SessionAnnotationLink target) {
        this.addSessionAnnotationLink(target, null);
    }

    @Override
    public final void addSessionAnnotationLinkToBoth(SessionAnnotationLink link, boolean bothSides) {
        this.addSessionAnnotationLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void clearAnnotationLinks() {
        this.clearAnnotationLinks(null);
    }

    @Override
    public final void clearEvents() {
        this.clearEvents(null);
    }

    @Override
    public final List<SessionAnnotationLink> copyAnnotationLinks() {
        return this.copyAnnotationLinks(null);
    }

    @Override
    public final List<Event> copyEvents() {
        return this.copyEvents(null);
    }

    @Override
    public final List<SessionAnnotationLink> findSessionAnnotationLink(Annotation removal) {
        return this.findSessionAnnotationLink(removal, null);
    }

    @Override
    public final Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.getAnnotationLinksCountPerOwner(null);
    }

    @Override
    public final RTime getClosed() {
        return this.getClosed(null);
    }

    @Override
    public final RString getDefaultEventType() {
        return this.getDefaultEventType(null);
    }

    @Override
    public final RString getDefaultPermissions() {
        return this.getDefaultPermissions(null);
    }

    @Override
    public final RString getMessage() {
        return this.getMessage(null);
    }

    @Override
    public final Node getNode() {
        return this.getNode(null);
    }

    @Override
    public final Experimenter getOwner() {
        return this.getOwner(null);
    }

    @Override
    public final RTime getStarted() {
        return this.getStarted(null);
    }

    @Override
    public final RLong getTimeToIdle() {
        return this.getTimeToIdle(null);
    }

    @Override
    public final RLong getTimeToLive() {
        return this.getTimeToLive(null);
    }

    @Override
    public final RString getUserAgent() {
        return this.getUserAgent(null);
    }

    @Override
    public final RString getUuid() {
        return this.getUuid(null);
    }

    @Override
    public final RInt getVersion() {
        return this.getVersion(null);
    }

    @Override
    public final SessionAnnotationLink linkAnnotation(Annotation addition) {
        return this.linkAnnotation(addition, null);
    }

    @Override
    public final List<Annotation> linkedAnnotationList() {
        return this.linkedAnnotationList(null);
    }

    @Override
    public final void reloadAnnotationLinks(Session toCopy) {
        this.reloadAnnotationLinks(toCopy, null);
    }

    @Override
    public final void reloadEvents(Session toCopy) {
        this.reloadEvents(toCopy, null);
    }

    @Override
    public final void removeAllEventSet(List<Event> targets) {
        this.removeAllEventSet(targets, null);
    }

    @Override
    public final void removeAllSessionAnnotationLinkSet(List<SessionAnnotationLink> targets) {
        this.removeAllSessionAnnotationLinkSet(targets, null);
    }

    @Override
    public final void removeEvent(Event theTarget) {
        this.removeEvent(theTarget, null);
    }

    @Override
    public final void removeSessionAnnotationLink(SessionAnnotationLink theTarget) {
        this.removeSessionAnnotationLink(theTarget, null);
    }

    @Override
    public final void removeSessionAnnotationLinkFromBoth(SessionAnnotationLink link, boolean bothSides) {
        this.removeSessionAnnotationLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void setClosed(RTime theClosed) {
        this.setClosed(theClosed, null);
    }

    @Override
    public final void setDefaultEventType(RString theDefaultEventType) {
        this.setDefaultEventType(theDefaultEventType, null);
    }

    @Override
    public final void setDefaultPermissions(RString theDefaultPermissions) {
        this.setDefaultPermissions(theDefaultPermissions, null);
    }

    @Override
    public final void setMessage(RString theMessage) {
        this.setMessage(theMessage, null);
    }

    @Override
    public final void setNode(Node theNode) {
        this.setNode(theNode, null);
    }

    @Override
    public final void setOwner(Experimenter theOwner) {
        this.setOwner(theOwner, null);
    }

    @Override
    public final void setStarted(RTime theStarted) {
        this.setStarted(theStarted, null);
    }

    @Override
    public final void setTimeToIdle(RLong theTimeToIdle) {
        this.setTimeToIdle(theTimeToIdle, null);
    }

    @Override
    public final void setTimeToLive(RLong theTimeToLive) {
        this.setTimeToLive(theTimeToLive, null);
    }

    @Override
    public final void setUserAgent(RString theUserAgent) {
        this.setUserAgent(theUserAgent, null);
    }

    @Override
    public final void setUuid(RString theUuid) {
        this.setUuid(theUuid, null);
    }

    @Override
    public final void setVersion(RInt theVersion) {
        this.setVersion(theVersion, null);
    }

    @Override
    public final int sizeOfAnnotationLinks() {
        return this.sizeOfAnnotationLinks(null);
    }

    @Override
    public final int sizeOfEvents() {
        return this.sizeOfEvents(null);
    }

    @Override
    public final void unlinkAnnotation(Annotation removal) {
        this.unlinkAnnotation(removal, null);
    }

    @Override
    public final void unloadAnnotationLinks() {
        this.unloadAnnotationLinks(null);
    }

    @Override
    public final void unloadEvents() {
        this.unloadEvents(null);
    }

    public static DispatchStatus ___getVersion(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RInt __ret = __obj.getVersion(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setVersion(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RIntHolder theVersion = new RIntHolder();
        __is.readObject((IceInternal.Patcher)theVersion.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setVersion(theVersion.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getNode(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        Node __ret = __obj.getNode(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setNode(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        NodeHolder theNode = new NodeHolder();
        __is.readObject((IceInternal.Patcher)theNode.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setNode(theNode.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getUuid(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RString __ret = __obj.getUuid(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setUuid(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RStringHolder theUuid = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theUuid.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setUuid(theUuid.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getOwner(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        Experimenter __ret = __obj.getOwner(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setOwner(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ExperimenterHolder theOwner = new ExperimenterHolder();
        __is.readObject((IceInternal.Patcher)theOwner.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setOwner(theOwner.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getTimeToIdle(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RLong __ret = __obj.getTimeToIdle(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setTimeToIdle(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RLongHolder theTimeToIdle = new RLongHolder();
        __is.readObject((IceInternal.Patcher)theTimeToIdle.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setTimeToIdle(theTimeToIdle.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getTimeToLive(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RLong __ret = __obj.getTimeToLive(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setTimeToLive(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RLongHolder theTimeToLive = new RLongHolder();
        __is.readObject((IceInternal.Patcher)theTimeToLive.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setTimeToLive(theTimeToLive.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getStarted(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RTime __ret = __obj.getStarted(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setStarted(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RTimeHolder theStarted = new RTimeHolder();
        __is.readObject((IceInternal.Patcher)theStarted.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setStarted(theStarted.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getClosed(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RTime __ret = __obj.getClosed(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setClosed(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RTimeHolder theClosed = new RTimeHolder();
        __is.readObject((IceInternal.Patcher)theClosed.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setClosed(theClosed.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getMessage(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RString __ret = __obj.getMessage(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setMessage(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RStringHolder theMessage = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theMessage.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setMessage(theMessage.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getDefaultPermissions(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RString __ret = __obj.getDefaultPermissions(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setDefaultPermissions(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RStringHolder theDefaultPermissions = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theDefaultPermissions.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setDefaultPermissions(theDefaultPermissions.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getDefaultEventType(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RString __ret = __obj.getDefaultEventType(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setDefaultEventType(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RStringHolder theDefaultEventType = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theDefaultEventType.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setDefaultEventType(theDefaultEventType.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getUserAgent(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RString __ret = __obj.getUserAgent(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setUserAgent(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RStringHolder theUserAgent = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theUserAgent.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setUserAgent(theUserAgent.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadEvents(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.unloadEvents(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfEvents(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        int __ret = __obj.sizeOfEvents(__current);
        __os.writeInt(__ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyEvents(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.copyEvents(__current);
        SessionEventsSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addEvent(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        EventHolder target = new EventHolder();
        __is.readObject((IceInternal.Patcher)target.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addEvent(target.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllEventSet(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<Event> targets = SessionEventsSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addAllEventSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeEvent(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        EventHolder theTarget = new EventHolder();
        __is.readObject((IceInternal.Patcher)theTarget.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeEvent(theTarget.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllEventSet(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<Event> targets = SessionEventsSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeAllEventSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearEvents(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.clearEvents(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadEvents(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        SessionHolder toCopy = new SessionHolder();
        __is.readObject((IceInternal.Patcher)toCopy.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.reloadEvents(toCopy.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadAnnotationLinks(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.unloadAnnotationLinks(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfAnnotationLinks(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        int __ret = __obj.sizeOfAnnotationLinks(__current);
        __os.writeInt(__ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyAnnotationLinks(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.copyAnnotationLinks(__current);
        SessionAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addSessionAnnotationLink(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        SessionAnnotationLinkHolder target = new SessionAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)target.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addSessionAnnotationLink(target.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllSessionAnnotationLinkSet(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<SessionAnnotationLink> targets = SessionAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addAllSessionAnnotationLinkSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeSessionAnnotationLink(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        SessionAnnotationLinkHolder theTarget = new SessionAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)theTarget.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeSessionAnnotationLink(theTarget.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllSessionAnnotationLinkSet(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<SessionAnnotationLink> targets = SessionAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeAllSessionAnnotationLinkSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearAnnotationLinks(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.clearAnnotationLinks(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadAnnotationLinks(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        SessionHolder toCopy = new SessionHolder();
        __is.readObject((IceInternal.Patcher)toCopy.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.reloadAnnotationLinks(toCopy.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getAnnotationLinksCountPerOwner(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        Map __ret = __obj.getAnnotationLinksCountPerOwner(__current);
        CountMapHelper.write(__os, __ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkAnnotation(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        AnnotationHolder addition = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)addition.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        SessionAnnotationLink __ret = __obj.linkAnnotation(addition.value, __current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addSessionAnnotationLinkToBoth(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        SessionAnnotationLinkHolder link = new SessionAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)link.getPatcher());
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addSessionAnnotationLinkToBoth(link.value, bothSides, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findSessionAnnotationLink(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)removal.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.findSessionAnnotationLink(removal.value, __current);
        SessionAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkAnnotation(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)removal.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.unlinkAnnotation(removal.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeSessionAnnotationLinkFromBoth(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        SessionAnnotationLinkHolder link = new SessionAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)link.getPatcher());
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeSessionAnnotationLinkFromBoth(link.value, bothSides, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedAnnotationList(Session __obj, Incoming __inS, Current __current) {
        Session.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.linkedAnnotationList(__current);
        SessionLinkedAnnotationSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return Session.___addAllEventSet(this, in, __current);
            }
            case 1: {
                return Session.___addAllSessionAnnotationLinkSet(this, in, __current);
            }
            case 2: {
                return Session.___addEvent(this, in, __current);
            }
            case 3: {
                return Session.___addSessionAnnotationLink(this, in, __current);
            }
            case 4: {
                return Session.___addSessionAnnotationLinkToBoth(this, in, __current);
            }
            case 5: {
                return Session.___clearAnnotationLinks(this, in, __current);
            }
            case 6: {
                return Session.___clearEvents(this, in, __current);
            }
            case 7: {
                return Session.___copyAnnotationLinks(this, in, __current);
            }
            case 8: {
                return Session.___copyEvents(this, in, __current);
            }
            case 9: {
                return Session.___findSessionAnnotationLink(this, in, __current);
            }
            case 10: {
                return Session.___getAnnotationLinksCountPerOwner(this, in, __current);
            }
            case 11: {
                return Session.___getClosed(this, in, __current);
            }
            case 12: {
                return Session.___getDefaultEventType(this, in, __current);
            }
            case 13: {
                return Session.___getDefaultPermissions(this, in, __current);
            }
            case 14: {
                return IObject.___getDetails(this, in, __current);
            }
            case 15: {
                return IObject.___getId(this, in, __current);
            }
            case 16: {
                return Session.___getMessage(this, in, __current);
            }
            case 17: {
                return Session.___getNode(this, in, __current);
            }
            case 18: {
                return Session.___getOwner(this, in, __current);
            }
            case 19: {
                return Session.___getStarted(this, in, __current);
            }
            case 20: {
                return Session.___getTimeToIdle(this, in, __current);
            }
            case 21: {
                return Session.___getTimeToLive(this, in, __current);
            }
            case 22: {
                return Session.___getUserAgent(this, in, __current);
            }
            case 23: {
                return Session.___getUuid(this, in, __current);
            }
            case 24: {
                return Session.___getVersion(this, in, __current);
            }
            case 25: {
                return Session.___ice_id((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 26: {
                return Session.___ice_ids((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 27: {
                return Session.___ice_isA((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 28: {
                return Session.___ice_ping((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 29: {
                return IObject.___isAnnotated(this, in, __current);
            }
            case 30: {
                return IObject.___isGlobal(this, in, __current);
            }
            case 31: {
                return IObject.___isLink(this, in, __current);
            }
            case 32: {
                return IObject.___isLoaded(this, in, __current);
            }
            case 33: {
                return IObject.___isMutable(this, in, __current);
            }
            case 34: {
                return Session.___linkAnnotation(this, in, __current);
            }
            case 35: {
                return Session.___linkedAnnotationList(this, in, __current);
            }
            case 36: {
                return IObject.___proxy(this, in, __current);
            }
            case 37: {
                return Session.___reloadAnnotationLinks(this, in, __current);
            }
            case 38: {
                return Session.___reloadEvents(this, in, __current);
            }
            case 39: {
                return Session.___removeAllEventSet(this, in, __current);
            }
            case 40: {
                return Session.___removeAllSessionAnnotationLinkSet(this, in, __current);
            }
            case 41: {
                return Session.___removeEvent(this, in, __current);
            }
            case 42: {
                return Session.___removeSessionAnnotationLink(this, in, __current);
            }
            case 43: {
                return Session.___removeSessionAnnotationLinkFromBoth(this, in, __current);
            }
            case 44: {
                return Session.___setClosed(this, in, __current);
            }
            case 45: {
                return Session.___setDefaultEventType(this, in, __current);
            }
            case 46: {
                return Session.___setDefaultPermissions(this, in, __current);
            }
            case 47: {
                return IObject.___setId(this, in, __current);
            }
            case 48: {
                return Session.___setMessage(this, in, __current);
            }
            case 49: {
                return Session.___setNode(this, in, __current);
            }
            case 50: {
                return Session.___setOwner(this, in, __current);
            }
            case 51: {
                return Session.___setStarted(this, in, __current);
            }
            case 52: {
                return Session.___setTimeToIdle(this, in, __current);
            }
            case 53: {
                return Session.___setTimeToLive(this, in, __current);
            }
            case 54: {
                return Session.___setUserAgent(this, in, __current);
            }
            case 55: {
                return Session.___setUuid(this, in, __current);
            }
            case 56: {
                return Session.___setVersion(this, in, __current);
            }
            case 57: {
                return IObject.___shallowCopy(this, in, __current);
            }
            case 58: {
                return Session.___sizeOfAnnotationLinks(this, in, __current);
            }
            case 59: {
                return Session.___sizeOfEvents(this, in, __current);
            }
            case 60: {
                return Session.___unlinkAnnotation(this, in, __current);
            }
            case 61: {
                return IObject.___unload(this, in, __current);
            }
            case 62: {
                return Session.___unloadAnnotationLinks(this, in, __current);
            }
            case 63: {
                return IObject.___unloadCollections(this, in, __current);
            }
            case 64: {
                return IObject.___unloadDetails(this, in, __current);
            }
            case 65: {
                return Session.___unloadEvents(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    @Override
    public void __write(BasicStream __os) {
        __os.writeTypeId(Session.ice_staticId());
        __os.startWriteSlice();
        __os.writeObject((Ice.Object)this.version);
        __os.writeObject((Ice.Object)this.node);
        __os.writeObject((Ice.Object)this.uuid);
        __os.writeObject((Ice.Object)this.owner);
        __os.writeObject((Ice.Object)this.timeToIdle);
        __os.writeObject((Ice.Object)this.timeToLive);
        __os.writeObject((Ice.Object)this.started);
        __os.writeObject((Ice.Object)this.closed);
        __os.writeObject((Ice.Object)this.message);
        __os.writeObject((Ice.Object)this.defaultPermissions);
        __os.writeObject((Ice.Object)this.defaultEventType);
        __os.writeObject((Ice.Object)this.userAgent);
        SessionEventsSeqHelper.write(__os, this.eventsSeq);
        __os.writeBool(this.eventsLoaded);
        SessionAnnotationLinksSeqHelper.write(__os, this.annotationLinksSeq);
        __os.writeBool(this.annotationLinksLoaded);
        CountMapHelper.write(__os, this.annotationLinksCountPerOwner);
        __os.endWriteSlice();
        super.__write(__os);
    }

    @Override
    public void __read(BasicStream __is, boolean __rid) {
        if (__rid) {
            __is.readTypeId();
        }
        __is.startReadSlice();
        __is.readObject((IceInternal.Patcher)new Patcher(2));
        __is.readObject((IceInternal.Patcher)new Patcher(3));
        __is.readObject((IceInternal.Patcher)new Patcher(4));
        __is.readObject((IceInternal.Patcher)new Patcher(5));
        __is.readObject((IceInternal.Patcher)new Patcher(6));
        __is.readObject((IceInternal.Patcher)new Patcher(7));
        __is.readObject((IceInternal.Patcher)new Patcher(8));
        __is.readObject((IceInternal.Patcher)new Patcher(9));
        __is.readObject((IceInternal.Patcher)new Patcher(10));
        __is.readObject((IceInternal.Patcher)new Patcher(11));
        __is.readObject((IceInternal.Patcher)new Patcher(12));
        __is.readObject((IceInternal.Patcher)new Patcher(13));
        this.eventsSeq = SessionEventsSeqHelper.read(__is);
        this.eventsLoaded = __is.readBool();
        this.annotationLinksSeq = SessionAnnotationLinksSeqHelper.read(__is);
        this.annotationLinksLoaded = __is.readBool();
        this.annotationLinksCountPerOwner = CountMapHelper.read(__is);
        __is.endReadSlice();
        super.__read(__is, true);
    }

    @Override
    public void __write(OutputStream __outS) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::model::Session was not generated with stream support";
        throw ex;
    }

    @Override
    public void __read(InputStream __inS, boolean __rid) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::model::Session was not generated with stream support";
        throw ex;
    }

    private class Patcher
    implements IceInternal.Patcher {
        private int __member;
        private String __typeId;

        Patcher(int member) {
            this.__member = member;
        }

        public void patch(Ice.Object v) {
            try {
                switch (this.__member) {
                    case 0: {
                        this.__typeId = "::omero::RLong";
                        Session.this.id = (RLong)v;
                        break;
                    }
                    case 1: {
                        this.__typeId = "::omero::model::Details";
                        Session.this.details = (Details)v;
                        break;
                    }
                    case 2: {
                        this.__typeId = "::omero::RInt";
                        Session.this.version = (RInt)v;
                        break;
                    }
                    case 3: {
                        this.__typeId = "::omero::model::Node";
                        Session.this.node = (Node)v;
                        break;
                    }
                    case 4: {
                        this.__typeId = "::omero::RString";
                        Session.this.uuid = (RString)v;
                        break;
                    }
                    case 5: {
                        this.__typeId = "::omero::model::Experimenter";
                        Session.this.owner = (Experimenter)v;
                        break;
                    }
                    case 6: {
                        this.__typeId = "::omero::RLong";
                        Session.this.timeToIdle = (RLong)v;
                        break;
                    }
                    case 7: {
                        this.__typeId = "::omero::RLong";
                        Session.this.timeToLive = (RLong)v;
                        break;
                    }
                    case 8: {
                        this.__typeId = "::omero::RTime";
                        Session.this.started = (RTime)v;
                        break;
                    }
                    case 9: {
                        this.__typeId = "::omero::RTime";
                        Session.this.closed = (RTime)v;
                        break;
                    }
                    case 10: {
                        this.__typeId = "::omero::RString";
                        Session.this.message = (RString)v;
                        break;
                    }
                    case 11: {
                        this.__typeId = "::omero::RString";
                        Session.this.defaultPermissions = (RString)v;
                        break;
                    }
                    case 12: {
                        this.__typeId = "::omero::RString";
                        Session.this.defaultEventType = (RString)v;
                        break;
                    }
                    case 13: {
                        this.__typeId = "::omero::RString";
                        Session.this.userAgent = (RString)v;
                    }
                }
            }
            catch (ClassCastException ex) {
                Ex.throwUOE((String)this.type(), (String)v.ice_id());
            }
        }

        public String type() {
            return this.__typeId;
        }
    }
}

