/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Plate;
import omero.model.Reagent;
import omero.model.Screen;
import omero.model.ScreenAcquisition;
import omero.model.ScreenAnnotationLink;
import omero.model.ScreenAnnotationLinkI;
import omero.model.ScreenPlateLink;
import omero.model.ScreenPlateLinkI;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenI
extends Screen
implements ModelBased {
    public static final String TYPE = "ome.model.screen.Screen_type";
    public static final String PROTOCOLIDENTIFIER = "ome.model.screen.Screen_protocolIdentifier";
    public static final String PROTOCOLDESCRIPTION = "ome.model.screen.Screen_protocolDescription";
    public static final String REAGENTSETIDENTIFIER = "ome.model.screen.Screen_reagentSetIdentifier";
    public static final String REAGENTSETDESCRIPTION = "ome.model.screen.Screen_reagentSetDescription";
    public static final String PLATELINKS = "ome.model.screen.Screen_plateLinks";
    public static final String REAGENT = "ome.model.screen.Screen_reagent";
    public static final String SCREENACQUISITION = "ome.model.screen.Screen_screenAcquisition";
    public static final String ANNOTATIONLINKS = "ome.model.screen.Screen_annotationLinks";
    public static final String NAME = "ome.model.screen.Screen_name";
    public static final String DESCRIPTION = "ome.model.screen.Screen_description";
    public static final String DETAILS = "ome.model.screen.Screen_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.plateLinksSeq = new ArrayList();
            this.plateLinksLoaded = true;
        } else {
            this.plateLinksSeq = null;
            this.plateLinksLoaded = false;
        }
        if (load) {
            this.reagentSeq = new ArrayList();
            this.reagentLoaded = true;
        } else {
            this.reagentSeq = null;
            this.reagentLoaded = false;
        }
        if (load) {
            this.screenAcquisitionSeq = new ArrayList();
            this.screenAcquisitionLoaded = true;
        } else {
            this.screenAcquisitionSeq = null;
            this.screenAcquisitionLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public ScreenI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ScreenI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ScreenI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadType();
        this.unloadProtocolIdentifier();
        this.unloadProtocolDescription();
        this.unloadReagentSetIdentifier();
        this.unloadReagentSetDescription();
        this.unloadPlateLinks();
        this.unloadReagent();
        this.unloadScreenAcquisition();
        this.unloadAnnotationLinks();
        this.unloadName();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ScreenI copy = new ScreenI();
        copy.id = this.id;
        copy.version = this.version;
        copy.type = this.type;
        copy.protocolIdentifier = this.protocolIdentifier;
        copy.protocolDescription = this.protocolDescription;
        copy.reagentSetIdentifier = this.reagentSetIdentifier;
        copy.reagentSetDescription = this.reagentSetDescription;
        if (!this.plateLinksLoaded) {
            copy.plateLinksLoaded = false;
            copy.plateLinksSeq = null;
        } else {
            copy.plateLinksLoaded = true;
            copy.plateLinksSeq = new ArrayList<ScreenPlateLink>();
            for (IObject item : this.plateLinksSeq) {
                copy.plateLinksSeq.add(item == null ? null : (ScreenPlateLink)item.proxy());
            }
        }
        if (!this.reagentLoaded) {
            copy.reagentLoaded = false;
            copy.reagentSeq = null;
        } else {
            copy.reagentLoaded = true;
            copy.reagentSeq = new ArrayList<Reagent>();
            for (IObject item : this.reagentSeq) {
                copy.reagentSeq.add(item == null ? null : (Reagent)item.proxy());
            }
        }
        if (!this.screenAcquisitionLoaded) {
            copy.screenAcquisitionLoaded = false;
            copy.screenAcquisitionSeq = null;
        } else {
            copy.screenAcquisitionLoaded = true;
            copy.screenAcquisitionSeq = new ArrayList<ScreenAcquisition>();
            for (IObject item : this.screenAcquisitionSeq) {
                copy.screenAcquisitionSeq.add(item == null ? null : (ScreenAcquisition)item.proxy());
            }
        }
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<ScreenAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (ScreenAnnotationLink)item.proxy());
            }
        }
        copy.name = this.name;
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ScreenI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadType() {
        this.type = null;
    }

    @Override
    public RString getType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.type;
    }

    @Override
    public void setType(RString type, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.type = type;
    }

    private void copyType(ome.model.screen.Screen source, IceMapper mapper) {
        this.type = source.getType() == null ? null : rtypes.rstring(source.getType());
    }

    private void fillType(ome.model.screen.Screen target, IceMapper mapper) {
        try {
            target.setType((String)mapper.fromRType(this.getType()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadProtocolIdentifier() {
        this.protocolIdentifier = null;
    }

    @Override
    public RString getProtocolIdentifier(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.protocolIdentifier;
    }

    @Override
    public void setProtocolIdentifier(RString protocolIdentifier, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.protocolIdentifier = protocolIdentifier;
    }

    private void copyProtocolIdentifier(ome.model.screen.Screen source, IceMapper mapper) {
        this.protocolIdentifier = source.getProtocolIdentifier() == null ? null : rtypes.rstring(source.getProtocolIdentifier());
    }

    private void fillProtocolIdentifier(ome.model.screen.Screen target, IceMapper mapper) {
        try {
            target.setProtocolIdentifier((String)mapper.fromRType(this.getProtocolIdentifier()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadProtocolDescription() {
        this.protocolDescription = null;
    }

    @Override
    public RString getProtocolDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.protocolDescription;
    }

    @Override
    public void setProtocolDescription(RString protocolDescription, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.protocolDescription = protocolDescription;
    }

    private void copyProtocolDescription(ome.model.screen.Screen source, IceMapper mapper) {
        this.protocolDescription = source.getProtocolDescription() == null ? null : rtypes.rstring(source.getProtocolDescription());
    }

    private void fillProtocolDescription(ome.model.screen.Screen target, IceMapper mapper) {
        try {
            target.setProtocolDescription((String)mapper.fromRType(this.getProtocolDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadReagentSetIdentifier() {
        this.reagentSetIdentifier = null;
    }

    @Override
    public RString getReagentSetIdentifier(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.reagentSetIdentifier;
    }

    @Override
    public void setReagentSetIdentifier(RString reagentSetIdentifier, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.reagentSetIdentifier = reagentSetIdentifier;
    }

    private void copyReagentSetIdentifier(ome.model.screen.Screen source, IceMapper mapper) {
        this.reagentSetIdentifier = source.getReagentSetIdentifier() == null ? null : rtypes.rstring(source.getReagentSetIdentifier());
    }

    private void fillReagentSetIdentifier(ome.model.screen.Screen target, IceMapper mapper) {
        try {
            target.setReagentSetIdentifier((String)mapper.fromRType(this.getReagentSetIdentifier()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadReagentSetDescription() {
        this.reagentSetDescription = null;
    }

    @Override
    public RString getReagentSetDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.reagentSetDescription;
    }

    @Override
    public void setReagentSetDescription(RString reagentSetDescription, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.reagentSetDescription = reagentSetDescription;
    }

    private void copyReagentSetDescription(ome.model.screen.Screen source, IceMapper mapper) {
        this.reagentSetDescription = source.getReagentSetDescription() == null ? null : rtypes.rstring(source.getReagentSetDescription());
    }

    private void fillReagentSetDescription(ome.model.screen.Screen target, IceMapper mapper) {
        try {
            target.setReagentSetDescription((String)mapper.fromRType(this.getReagentSetDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadPlateLinks(Current current) {
        this.plateLinksLoaded = false;
        this.plateLinksSeq = null;
    }

    protected List getPlateLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.plateLinksSeq;
    }

    protected void setPlateLinks(List plateLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.plateLinksSeq = plateLinks == null ? new ArrayList() : new ArrayList(plateLinks);
        this.plateLinksLoaded = plateLinks != null;
    }

    private void copyPlateLinks(ome.model.screen.Screen source, IceMapper mapper) {
        this.setPlateLinks((List)mapper.findCollection((Collection)source.retrieve(PLATELINKS)), null);
        this.plateLinksCountPerOwner = source.getPlateLinksCountPerOwner();
    }

    private void fillPlateLinks(ome.model.screen.Screen target, IceMapper mapper) {
        if (this.plateLinksLoaded) {
            target.putAt(PLATELINKS, (Object)mapper.reverse(this.plateLinksSeq, Set.class));
        } else {
            target.putAt(PLATELINKS, null);
        }
    }

    public boolean isPlateLinksLoaded() {
        return this.plateLinksLoaded;
    }

    @Override
    public int sizeOfPlateLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            return -1;
        }
        return this.plateLinksSeq.size();
    }

    public List copyPlateLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        ArrayList result = new ArrayList(this.plateLinksSeq);
        return result;
    }

    public Iterator iteratePlateLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        return this.plateLinksSeq.iterator();
    }

    @Override
    public void addScreenPlateLink(ScreenPlateLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        this.plateLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllScreenPlateLinkSet(List<ScreenPlateLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        this.plateLinksSeq.addAll(targets);
        for (ScreenPlateLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeScreenPlateLink(ScreenPlateLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        this.plateLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllScreenPlateLinkSet(List<ScreenPlateLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        for (ScreenPlateLink elt : targets) {
            elt.setParent(null);
            this.plateLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearPlateLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        for (ScreenPlateLink elt : this.plateLinksSeq) {
            elt.setParent(null);
        }
        this.plateLinksSeq.clear();
    }

    @Override
    public void reloadPlateLinks(Screen toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.plateLinksLoaded) {
            throw new ClientError("Cannot reload active collection: plateLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ScreenPlateLink> copy = toCopy.copyPlateLinks();
        for (ScreenPlateLink elt : copy) {
            elt.setParent(this);
        }
        this.plateLinksSeq = new ArrayList<ScreenPlateLink>(copy);
        toCopy.unloadPlateLinks();
        this.plateLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getPlateLinksCountPerOwner(Current current) {
        return this.plateLinksCountPerOwner;
    }

    @Override
    public ScreenPlateLink linkPlate(Plate addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        ScreenPlateLinkI link = new ScreenPlateLinkI();
        link.link(this, addition);
        this.addScreenPlateLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addScreenPlateLinkToBoth(ScreenPlateLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        this.plateLinksSeq.add(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().addScreenPlateLinkToBoth(link, false);
        }
    }

    @Override
    public List<ScreenPlateLink> findScreenPlateLink(Plate removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        ArrayList<ScreenPlateLink> result = new ArrayList<ScreenPlateLink>();
        for (ScreenPlateLink link : this.plateLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkPlate(Plate removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        List<ScreenPlateLink> toRemove = this.findScreenPlateLink(removal);
        Iterator<ScreenPlateLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeScreenPlateLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeScreenPlateLinkFromBoth(ScreenPlateLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("plateLinksSeq");
        }
        this.plateLinksSeq.remove(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().removeScreenPlateLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Plate> linkedPlateList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateLinksLoaded) {
            this.throwNullCollectionException("PlateLinks");
        }
        ArrayList<Plate> linked = new ArrayList<Plate>();
        for (ScreenPlateLink link : this.plateLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void unloadReagent(Current current) {
        this.reagentLoaded = false;
        this.reagentSeq = null;
    }

    protected List getReagent(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.reagentSeq;
    }

    protected void setReagent(List reagent, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.reagentSeq = reagent == null ? new ArrayList() : new ArrayList(reagent);
        this.reagentLoaded = reagent != null;
    }

    private void copyReagent(ome.model.screen.Screen source, IceMapper mapper) {
        this.setReagent((List)mapper.findCollection((Collection)source.retrieve(REAGENT)), null);
    }

    private void fillReagent(ome.model.screen.Screen target, IceMapper mapper) {
        if (this.reagentLoaded) {
            target.putAt(REAGENT, (Object)mapper.reverse(this.reagentSeq, Set.class));
        } else {
            target.putAt(REAGENT, null);
        }
    }

    public boolean isReagentLoaded() {
        return this.reagentLoaded;
    }

    @Override
    public int sizeOfReagent(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLoaded) {
            return -1;
        }
        return this.reagentSeq.size();
    }

    public List copyReagent(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLoaded) {
            this.throwNullCollectionException("reagentSeq");
        }
        ArrayList result = new ArrayList(this.reagentSeq);
        return result;
    }

    public Iterator iterateReagent() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLoaded) {
            this.throwNullCollectionException("reagentSeq");
        }
        return this.reagentSeq.iterator();
    }

    @Override
    public void addReagent(Reagent target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLoaded) {
            this.throwNullCollectionException("reagentSeq");
        }
        this.reagentSeq.add(target);
        target.setScreen(this);
    }

    @Override
    public void addAllReagentSet(List<Reagent> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLoaded) {
            this.throwNullCollectionException("reagentSeq");
        }
        this.reagentSeq.addAll(targets);
        for (Reagent target : targets) {
            target.setScreen(this);
        }
    }

    @Override
    public void removeReagent(Reagent target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLoaded) {
            this.throwNullCollectionException("reagentSeq");
        }
        this.reagentSeq.remove(target);
        target.setScreen(null);
    }

    @Override
    public void removeAllReagentSet(List<Reagent> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLoaded) {
            this.throwNullCollectionException("reagentSeq");
        }
        for (Reagent elt : targets) {
            elt.setScreen(null);
            this.reagentSeq.remove(elt);
        }
    }

    @Override
    public void clearReagent(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.reagentLoaded) {
            this.throwNullCollectionException("reagentSeq");
        }
        for (Reagent elt : this.reagentSeq) {
            elt.setScreen(null);
        }
        this.reagentSeq.clear();
    }

    @Override
    public void reloadReagent(Screen toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.reagentLoaded) {
            throw new ClientError("Cannot reload active collection: reagentSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Reagent> copy = toCopy.copyReagent();
        for (Reagent elt : copy) {
            elt.setScreen(this);
        }
        this.reagentSeq = new ArrayList<Reagent>(copy);
        toCopy.unloadReagent();
        this.reagentLoaded = true;
    }

    @Override
    public void unloadScreenAcquisition(Current current) {
        this.screenAcquisitionLoaded = false;
        this.screenAcquisitionSeq = null;
    }

    protected List getScreenAcquisition(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.screenAcquisitionSeq;
    }

    protected void setScreenAcquisition(List screenAcquisition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.screenAcquisitionSeq = screenAcquisition == null ? new ArrayList() : new ArrayList(screenAcquisition);
        this.screenAcquisitionLoaded = screenAcquisition != null;
    }

    private void copyScreenAcquisition(ome.model.screen.Screen source, IceMapper mapper) {
        this.setScreenAcquisition((List)mapper.findCollection((Collection)source.retrieve(SCREENACQUISITION)), null);
    }

    private void fillScreenAcquisition(ome.model.screen.Screen target, IceMapper mapper) {
        if (this.screenAcquisitionLoaded) {
            target.putAt(SCREENACQUISITION, (Object)mapper.reverse(this.screenAcquisitionSeq, Set.class));
        } else {
            target.putAt(SCREENACQUISITION, null);
        }
    }

    public boolean isScreenAcquisitionLoaded() {
        return this.screenAcquisitionLoaded;
    }

    @Override
    public int sizeOfScreenAcquisition(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLoaded) {
            return -1;
        }
        return this.screenAcquisitionSeq.size();
    }

    public List copyScreenAcquisition(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLoaded) {
            this.throwNullCollectionException("screenAcquisitionSeq");
        }
        ArrayList result = new ArrayList(this.screenAcquisitionSeq);
        return result;
    }

    public Iterator iterateScreenAcquisition() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLoaded) {
            this.throwNullCollectionException("screenAcquisitionSeq");
        }
        return this.screenAcquisitionSeq.iterator();
    }

    @Override
    public void addScreenAcquisition(ScreenAcquisition target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLoaded) {
            this.throwNullCollectionException("screenAcquisitionSeq");
        }
        this.screenAcquisitionSeq.add(target);
        target.setScreen(this);
    }

    @Override
    public void addAllScreenAcquisitionSet(List<ScreenAcquisition> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLoaded) {
            this.throwNullCollectionException("screenAcquisitionSeq");
        }
        this.screenAcquisitionSeq.addAll(targets);
        for (ScreenAcquisition target : targets) {
            target.setScreen(this);
        }
    }

    @Override
    public void removeScreenAcquisition(ScreenAcquisition target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLoaded) {
            this.throwNullCollectionException("screenAcquisitionSeq");
        }
        this.screenAcquisitionSeq.remove(target);
        target.setScreen(null);
    }

    @Override
    public void removeAllScreenAcquisitionSet(List<ScreenAcquisition> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLoaded) {
            this.throwNullCollectionException("screenAcquisitionSeq");
        }
        for (ScreenAcquisition elt : targets) {
            elt.setScreen(null);
            this.screenAcquisitionSeq.remove(elt);
        }
    }

    @Override
    public void clearScreenAcquisition(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenAcquisitionLoaded) {
            this.throwNullCollectionException("screenAcquisitionSeq");
        }
        for (ScreenAcquisition elt : this.screenAcquisitionSeq) {
            elt.setScreen(null);
        }
        this.screenAcquisitionSeq.clear();
    }

    @Override
    public void reloadScreenAcquisition(Screen toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.screenAcquisitionLoaded) {
            throw new ClientError("Cannot reload active collection: screenAcquisitionSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ScreenAcquisition> copy = toCopy.copyScreenAcquisition();
        for (ScreenAcquisition elt : copy) {
            elt.setScreen(this);
        }
        this.screenAcquisitionSeq = new ArrayList<ScreenAcquisition>(copy);
        toCopy.unloadScreenAcquisition();
        this.screenAcquisitionLoaded = true;
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.screen.Screen source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.screen.Screen target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addScreenAnnotationLink(ScreenAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllScreenAnnotationLinkSet(List<ScreenAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (ScreenAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeScreenAnnotationLink(ScreenAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllScreenAnnotationLinkSet(List<ScreenAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ScreenAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ScreenAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Screen toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ScreenAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (ScreenAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<ScreenAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public ScreenAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ScreenAnnotationLinkI link = new ScreenAnnotationLinkI();
        link.link(this, addition);
        this.addScreenAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addScreenAnnotationLinkToBoth(ScreenAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<ScreenAnnotationLink> findScreenAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<ScreenAnnotationLink> result = new ArrayList<ScreenAnnotationLink>();
        for (ScreenAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<ScreenAnnotationLink> toRemove = this.findScreenAnnotationLink(removal);
        Iterator<ScreenAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeScreenAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeScreenAnnotationLinkFromBoth(ScreenAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (ScreenAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadName() {
        this.name = null;
    }

    @Override
    public RString getName(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.name;
    }

    @Override
    public void setName(RString name, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.name = name;
    }

    private void copyName(ome.model.screen.Screen source, IceMapper mapper) {
        this.name = source.getName() == null ? null : rtypes.rstring(source.getName());
    }

    private void fillName(ome.model.screen.Screen target, IceMapper mapper) {
        try {
            target.setName((String)mapper.fromRType(this.getName()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.screen.Screen source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.screen.Screen target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.screen.Screen) {
            ome.model.screen.Screen source = (ome.model.screen.Screen)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyType(source, mapper);
                this.copyProtocolIdentifier(source, mapper);
                this.copyProtocolDescription(source, mapper);
                this.copyReagentSetIdentifier(source, mapper);
                this.copyReagentSetDescription(source, mapper);
                this.copyPlateLinks(source, mapper);
                this.copyReagent(source, mapper);
                this.copyScreenAcquisition(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyName(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Screen cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.screen.Screen target = new ome.model.screen.Screen();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillType(target, mapper);
            this.fillProtocolIdentifier(target, mapper);
            this.fillProtocolDescription(target, mapper);
            this.fillReagentSetIdentifier(target, mapper);
            this.fillReagentSetDescription(target, mapper);
            this.fillPlateLinks(target, mapper);
            this.fillReagent(target, mapper);
            this.fillScreenAcquisition(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillName(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<ScreenI> cast(List list) {
        return list;
    }
}

