/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.InputStream;
import Ice.MarshalException;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.OutputStream;
import IceInternal.BasicStream;
import IceInternal.Ex;
import IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import omero.RInt;
import omero.RIntHolder;
import omero.RLong;
import omero.RString;
import omero.RStringHolder;
import omero.model.Annotation;
import omero.model.AnnotationHolder;
import omero.model.DatasetAnnotationLink;
import omero.model.DatasetAnnotationLinkHolder;
import omero.model.DatasetAnnotationLinksSeqHelper;
import omero.model.DatasetHolder;
import omero.model.DatasetImageLink;
import omero.model.DatasetImageLinkHolder;
import omero.model.DatasetImageLinksSeqHelper;
import omero.model.DatasetLinkedAnnotationSeqHelper;
import omero.model.DatasetLinkedImageSeqHelper;
import omero.model.DatasetLinkedProjectSeqHelper;
import omero.model.DatasetProjectLinksSeqHelper;
import omero.model.Details;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageHolder;
import omero.model.Project;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectDatasetLinkHolder;
import omero.model.ProjectHolder;
import omero.model._DatasetOperations;
import omero.model._DatasetOperationsNC;
import omero.sys.CountMapHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dataset
extends IObject
implements _DatasetOperations,
_DatasetOperationsNC {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::model::Dataset", "::omero::model::IObject"};
    private static final String[] __all = new String[]{"addAllDatasetAnnotationLinkSet", "addAllDatasetImageLinkSet", "addAllProjectDatasetLinkSet", "addDatasetAnnotationLink", "addDatasetAnnotationLinkToBoth", "addDatasetImageLink", "addDatasetImageLinkToBoth", "addProjectDatasetLink", "addProjectDatasetLinkToBoth", "clearAnnotationLinks", "clearImageLinks", "clearProjectLinks", "copyAnnotationLinks", "copyImageLinks", "copyProjectLinks", "findDatasetAnnotationLink", "findDatasetImageLink", "findProjectDatasetLink", "getAnnotationLinksCountPerOwner", "getDescription", "getDetails", "getId", "getImageLinksCountPerOwner", "getName", "getProjectLinksCountPerOwner", "getVersion", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isAnnotated", "isGlobal", "isLink", "isLoaded", "isMutable", "linkAnnotation", "linkImage", "linkProject", "linkedAnnotationList", "linkedImageList", "linkedProjectList", "proxy", "reloadAnnotationLinks", "reloadImageLinks", "reloadProjectLinks", "removeAllDatasetAnnotationLinkSet", "removeAllDatasetImageLinkSet", "removeAllProjectDatasetLinkSet", "removeDatasetAnnotationLink", "removeDatasetAnnotationLinkFromBoth", "removeDatasetImageLink", "removeDatasetImageLinkFromBoth", "removeProjectDatasetLink", "removeProjectDatasetLinkFromBoth", "setDescription", "setId", "setName", "setVersion", "shallowCopy", "sizeOfAnnotationLinks", "sizeOfImageLinks", "sizeOfProjectLinks", "unlinkAnnotation", "unlinkImage", "unlinkProject", "unload", "unloadAnnotationLinks", "unloadCollections", "unloadDetails", "unloadImageLinks", "unloadProjectLinks"};
    protected RInt version;
    protected List<ProjectDatasetLink> projectLinksSeq;
    protected boolean projectLinksLoaded;
    protected Map<Long, Long> projectLinksCountPerOwner;
    protected List<DatasetImageLink> imageLinksSeq;
    protected boolean imageLinksLoaded;
    protected Map<Long, Long> imageLinksCountPerOwner;
    protected List<DatasetAnnotationLink> annotationLinksSeq;
    protected boolean annotationLinksLoaded;
    protected Map<Long, Long> annotationLinksCountPerOwner;
    protected RString name;
    protected RString description;

    public Dataset() {
    }

    public Dataset(RLong id, Details details, boolean loaded, RInt version, List<ProjectDatasetLink> projectLinksSeq, boolean projectLinksLoaded, Map<Long, Long> projectLinksCountPerOwner, List<DatasetImageLink> imageLinksSeq, boolean imageLinksLoaded, Map<Long, Long> imageLinksCountPerOwner, List<DatasetAnnotationLink> annotationLinksSeq, boolean annotationLinksLoaded, Map<Long, Long> annotationLinksCountPerOwner, RString name, RString description) {
        super(id, details, loaded);
        this.version = version;
        this.projectLinksSeq = projectLinksSeq;
        this.projectLinksLoaded = projectLinksLoaded;
        this.projectLinksCountPerOwner = projectLinksCountPerOwner;
        this.imageLinksSeq = imageLinksSeq;
        this.imageLinksLoaded = imageLinksLoaded;
        this.imageLinksCountPerOwner = imageLinksCountPerOwner;
        this.annotationLinksSeq = annotationLinksSeq;
        this.annotationLinksLoaded = annotationLinksLoaded;
        this.annotationLinksCountPerOwner = annotationLinksCountPerOwner;
        this.name = name;
        this.description = description;
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current __current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[1];
    }

    @Override
    public String ice_id(Current __current) {
        return __ids[1];
    }

    public static String ice_staticId() {
        return __ids[1];
    }

    @Override
    public final void addAllDatasetAnnotationLinkSet(List<DatasetAnnotationLink> targets) {
        this.addAllDatasetAnnotationLinkSet(targets, null);
    }

    @Override
    public final void addAllDatasetImageLinkSet(List<DatasetImageLink> targets) {
        this.addAllDatasetImageLinkSet(targets, null);
    }

    @Override
    public final void addAllProjectDatasetLinkSet(List<ProjectDatasetLink> targets) {
        this.addAllProjectDatasetLinkSet(targets, null);
    }

    @Override
    public final void addDatasetAnnotationLink(DatasetAnnotationLink target) {
        this.addDatasetAnnotationLink(target, null);
    }

    @Override
    public final void addDatasetAnnotationLinkToBoth(DatasetAnnotationLink link, boolean bothSides) {
        this.addDatasetAnnotationLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void addDatasetImageLink(DatasetImageLink target) {
        this.addDatasetImageLink(target, null);
    }

    @Override
    public final void addDatasetImageLinkToBoth(DatasetImageLink link, boolean bothSides) {
        this.addDatasetImageLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void addProjectDatasetLink(ProjectDatasetLink target) {
        this.addProjectDatasetLink(target, null);
    }

    @Override
    public final void addProjectDatasetLinkToBoth(ProjectDatasetLink link, boolean bothSides) {
        this.addProjectDatasetLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void clearAnnotationLinks() {
        this.clearAnnotationLinks(null);
    }

    @Override
    public final void clearImageLinks() {
        this.clearImageLinks(null);
    }

    @Override
    public final void clearProjectLinks() {
        this.clearProjectLinks(null);
    }

    @Override
    public final List<DatasetAnnotationLink> copyAnnotationLinks() {
        return this.copyAnnotationLinks(null);
    }

    @Override
    public final List<DatasetImageLink> copyImageLinks() {
        return this.copyImageLinks(null);
    }

    @Override
    public final List<ProjectDatasetLink> copyProjectLinks() {
        return this.copyProjectLinks(null);
    }

    @Override
    public final List<DatasetAnnotationLink> findDatasetAnnotationLink(Annotation removal) {
        return this.findDatasetAnnotationLink(removal, null);
    }

    @Override
    public final List<DatasetImageLink> findDatasetImageLink(Image removal) {
        return this.findDatasetImageLink(removal, null);
    }

    @Override
    public final List<ProjectDatasetLink> findProjectDatasetLink(Project removal) {
        return this.findProjectDatasetLink(removal, null);
    }

    @Override
    public final Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.getAnnotationLinksCountPerOwner(null);
    }

    @Override
    public final RString getDescription() {
        return this.getDescription(null);
    }

    @Override
    public final Map<Long, Long> getImageLinksCountPerOwner() {
        return this.getImageLinksCountPerOwner(null);
    }

    @Override
    public final RString getName() {
        return this.getName(null);
    }

    @Override
    public final Map<Long, Long> getProjectLinksCountPerOwner() {
        return this.getProjectLinksCountPerOwner(null);
    }

    @Override
    public final RInt getVersion() {
        return this.getVersion(null);
    }

    @Override
    public final DatasetAnnotationLink linkAnnotation(Annotation addition) {
        return this.linkAnnotation(addition, null);
    }

    @Override
    public final DatasetImageLink linkImage(Image addition) {
        return this.linkImage(addition, null);
    }

    @Override
    public final ProjectDatasetLink linkProject(Project addition) {
        return this.linkProject(addition, null);
    }

    @Override
    public final List<Annotation> linkedAnnotationList() {
        return this.linkedAnnotationList(null);
    }

    @Override
    public final List<Image> linkedImageList() {
        return this.linkedImageList(null);
    }

    @Override
    public final List<Project> linkedProjectList() {
        return this.linkedProjectList(null);
    }

    @Override
    public final void reloadAnnotationLinks(Dataset toCopy) {
        this.reloadAnnotationLinks(toCopy, null);
    }

    @Override
    public final void reloadImageLinks(Dataset toCopy) {
        this.reloadImageLinks(toCopy, null);
    }

    @Override
    public final void reloadProjectLinks(Dataset toCopy) {
        this.reloadProjectLinks(toCopy, null);
    }

    @Override
    public final void removeAllDatasetAnnotationLinkSet(List<DatasetAnnotationLink> targets) {
        this.removeAllDatasetAnnotationLinkSet(targets, null);
    }

    @Override
    public final void removeAllDatasetImageLinkSet(List<DatasetImageLink> targets) {
        this.removeAllDatasetImageLinkSet(targets, null);
    }

    @Override
    public final void removeAllProjectDatasetLinkSet(List<ProjectDatasetLink> targets) {
        this.removeAllProjectDatasetLinkSet(targets, null);
    }

    @Override
    public final void removeDatasetAnnotationLink(DatasetAnnotationLink theTarget) {
        this.removeDatasetAnnotationLink(theTarget, null);
    }

    @Override
    public final void removeDatasetAnnotationLinkFromBoth(DatasetAnnotationLink link, boolean bothSides) {
        this.removeDatasetAnnotationLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void removeDatasetImageLink(DatasetImageLink theTarget) {
        this.removeDatasetImageLink(theTarget, null);
    }

    @Override
    public final void removeDatasetImageLinkFromBoth(DatasetImageLink link, boolean bothSides) {
        this.removeDatasetImageLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void removeProjectDatasetLink(ProjectDatasetLink theTarget) {
        this.removeProjectDatasetLink(theTarget, null);
    }

    @Override
    public final void removeProjectDatasetLinkFromBoth(ProjectDatasetLink link, boolean bothSides) {
        this.removeProjectDatasetLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void setDescription(RString theDescription) {
        this.setDescription(theDescription, null);
    }

    @Override
    public final void setName(RString theName) {
        this.setName(theName, null);
    }

    @Override
    public final void setVersion(RInt theVersion) {
        this.setVersion(theVersion, null);
    }

    @Override
    public final int sizeOfAnnotationLinks() {
        return this.sizeOfAnnotationLinks(null);
    }

    @Override
    public final int sizeOfImageLinks() {
        return this.sizeOfImageLinks(null);
    }

    @Override
    public final int sizeOfProjectLinks() {
        return this.sizeOfProjectLinks(null);
    }

    @Override
    public final void unlinkAnnotation(Annotation removal) {
        this.unlinkAnnotation(removal, null);
    }

    @Override
    public final void unlinkImage(Image removal) {
        this.unlinkImage(removal, null);
    }

    @Override
    public final void unlinkProject(Project removal) {
        this.unlinkProject(removal, null);
    }

    @Override
    public final void unloadAnnotationLinks() {
        this.unloadAnnotationLinks(null);
    }

    @Override
    public final void unloadImageLinks() {
        this.unloadImageLinks(null);
    }

    @Override
    public final void unloadProjectLinks() {
        this.unloadProjectLinks(null);
    }

    public static DispatchStatus ___getVersion(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RInt __ret = __obj.getVersion(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setVersion(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RIntHolder theVersion = new RIntHolder();
        __is.readObject((IceInternal.Patcher)theVersion.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setVersion(theVersion.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadProjectLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.unloadProjectLinks(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfProjectLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        int __ret = __obj.sizeOfProjectLinks(__current);
        __os.writeInt(__ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyProjectLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.copyProjectLinks(__current);
        DatasetProjectLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addProjectDatasetLink(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ProjectDatasetLinkHolder target = new ProjectDatasetLinkHolder();
        __is.readObject((IceInternal.Patcher)target.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addProjectDatasetLink(target.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllProjectDatasetLinkSet(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<ProjectDatasetLink> targets = DatasetProjectLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addAllProjectDatasetLinkSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeProjectDatasetLink(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ProjectDatasetLinkHolder theTarget = new ProjectDatasetLinkHolder();
        __is.readObject((IceInternal.Patcher)theTarget.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeProjectDatasetLink(theTarget.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllProjectDatasetLinkSet(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<ProjectDatasetLink> targets = DatasetProjectLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeAllProjectDatasetLinkSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearProjectLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.clearProjectLinks(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadProjectLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetHolder toCopy = new DatasetHolder();
        __is.readObject((IceInternal.Patcher)toCopy.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.reloadProjectLinks(toCopy.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getProjectLinksCountPerOwner(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        Map __ret = __obj.getProjectLinksCountPerOwner(__current);
        CountMapHelper.write(__os, __ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkProject(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ProjectHolder addition = new ProjectHolder();
        __is.readObject((IceInternal.Patcher)addition.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        ProjectDatasetLink __ret = __obj.linkProject(addition.value, __current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addProjectDatasetLinkToBoth(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ProjectDatasetLinkHolder link = new ProjectDatasetLinkHolder();
        __is.readObject((IceInternal.Patcher)link.getPatcher());
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addProjectDatasetLinkToBoth(link.value, bothSides, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findProjectDatasetLink(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ProjectHolder removal = new ProjectHolder();
        __is.readObject((IceInternal.Patcher)removal.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.findProjectDatasetLink(removal.value, __current);
        DatasetProjectLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkProject(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ProjectHolder removal = new ProjectHolder();
        __is.readObject((IceInternal.Patcher)removal.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.unlinkProject(removal.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeProjectDatasetLinkFromBoth(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ProjectDatasetLinkHolder link = new ProjectDatasetLinkHolder();
        __is.readObject((IceInternal.Patcher)link.getPatcher());
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeProjectDatasetLinkFromBoth(link.value, bothSides, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedProjectList(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.linkedProjectList(__current);
        DatasetLinkedProjectSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadImageLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.unloadImageLinks(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfImageLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        int __ret = __obj.sizeOfImageLinks(__current);
        __os.writeInt(__ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyImageLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.copyImageLinks(__current);
        DatasetImageLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addDatasetImageLink(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetImageLinkHolder target = new DatasetImageLinkHolder();
        __is.readObject((IceInternal.Patcher)target.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addDatasetImageLink(target.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllDatasetImageLinkSet(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<DatasetImageLink> targets = DatasetImageLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addAllDatasetImageLinkSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeDatasetImageLink(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetImageLinkHolder theTarget = new DatasetImageLinkHolder();
        __is.readObject((IceInternal.Patcher)theTarget.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeDatasetImageLink(theTarget.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllDatasetImageLinkSet(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<DatasetImageLink> targets = DatasetImageLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeAllDatasetImageLinkSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearImageLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.clearImageLinks(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadImageLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetHolder toCopy = new DatasetHolder();
        __is.readObject((IceInternal.Patcher)toCopy.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.reloadImageLinks(toCopy.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getImageLinksCountPerOwner(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        Map __ret = __obj.getImageLinksCountPerOwner(__current);
        CountMapHelper.write(__os, __ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkImage(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ImageHolder addition = new ImageHolder();
        __is.readObject((IceInternal.Patcher)addition.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        DatasetImageLink __ret = __obj.linkImage(addition.value, __current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addDatasetImageLinkToBoth(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetImageLinkHolder link = new DatasetImageLinkHolder();
        __is.readObject((IceInternal.Patcher)link.getPatcher());
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addDatasetImageLinkToBoth(link.value, bothSides, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findDatasetImageLink(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ImageHolder removal = new ImageHolder();
        __is.readObject((IceInternal.Patcher)removal.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.findDatasetImageLink(removal.value, __current);
        DatasetImageLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkImage(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ImageHolder removal = new ImageHolder();
        __is.readObject((IceInternal.Patcher)removal.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.unlinkImage(removal.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeDatasetImageLinkFromBoth(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetImageLinkHolder link = new DatasetImageLinkHolder();
        __is.readObject((IceInternal.Patcher)link.getPatcher());
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeDatasetImageLinkFromBoth(link.value, bothSides, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedImageList(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.linkedImageList(__current);
        DatasetLinkedImageSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadAnnotationLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.unloadAnnotationLinks(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfAnnotationLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        int __ret = __obj.sizeOfAnnotationLinks(__current);
        __os.writeInt(__ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyAnnotationLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.copyAnnotationLinks(__current);
        DatasetAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addDatasetAnnotationLink(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetAnnotationLinkHolder target = new DatasetAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)target.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addDatasetAnnotationLink(target.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllDatasetAnnotationLinkSet(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<DatasetAnnotationLink> targets = DatasetAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addAllDatasetAnnotationLinkSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeDatasetAnnotationLink(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetAnnotationLinkHolder theTarget = new DatasetAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)theTarget.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeDatasetAnnotationLink(theTarget.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllDatasetAnnotationLinkSet(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        List<DatasetAnnotationLink> targets = DatasetAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeAllDatasetAnnotationLinkSet(targets, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearAnnotationLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.clearAnnotationLinks(__current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadAnnotationLinks(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetHolder toCopy = new DatasetHolder();
        __is.readObject((IceInternal.Patcher)toCopy.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.reloadAnnotationLinks(toCopy.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getAnnotationLinksCountPerOwner(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        Map __ret = __obj.getAnnotationLinksCountPerOwner(__current);
        CountMapHelper.write(__os, __ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkAnnotation(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        AnnotationHolder addition = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)addition.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        DatasetAnnotationLink __ret = __obj.linkAnnotation(addition.value, __current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addDatasetAnnotationLinkToBoth(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetAnnotationLinkHolder link = new DatasetAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)link.getPatcher());
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.addDatasetAnnotationLinkToBoth(link.value, bothSides, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findDatasetAnnotationLink(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)removal.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.findDatasetAnnotationLink(removal.value, __current);
        DatasetAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkAnnotation(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)removal.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.unlinkAnnotation(removal.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeDatasetAnnotationLinkFromBoth(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        DatasetAnnotationLinkHolder link = new DatasetAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)link.getPatcher());
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.removeDatasetAnnotationLinkFromBoth(link.value, bothSides, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedAnnotationList(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        List __ret = __obj.linkedAnnotationList(__current);
        DatasetLinkedAnnotationSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getName(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RString __ret = __obj.getName(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setName(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RStringHolder theName = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theName.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setName(theName.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getDescription(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RString __ret = __obj.getDescription(__current);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setDescription(Dataset __obj, Incoming __inS, Current __current) {
        Dataset.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RStringHolder theDescription = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theDescription.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setDescription(theDescription.value, __current);
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return Dataset.___addAllDatasetAnnotationLinkSet(this, in, __current);
            }
            case 1: {
                return Dataset.___addAllDatasetImageLinkSet(this, in, __current);
            }
            case 2: {
                return Dataset.___addAllProjectDatasetLinkSet(this, in, __current);
            }
            case 3: {
                return Dataset.___addDatasetAnnotationLink(this, in, __current);
            }
            case 4: {
                return Dataset.___addDatasetAnnotationLinkToBoth(this, in, __current);
            }
            case 5: {
                return Dataset.___addDatasetImageLink(this, in, __current);
            }
            case 6: {
                return Dataset.___addDatasetImageLinkToBoth(this, in, __current);
            }
            case 7: {
                return Dataset.___addProjectDatasetLink(this, in, __current);
            }
            case 8: {
                return Dataset.___addProjectDatasetLinkToBoth(this, in, __current);
            }
            case 9: {
                return Dataset.___clearAnnotationLinks(this, in, __current);
            }
            case 10: {
                return Dataset.___clearImageLinks(this, in, __current);
            }
            case 11: {
                return Dataset.___clearProjectLinks(this, in, __current);
            }
            case 12: {
                return Dataset.___copyAnnotationLinks(this, in, __current);
            }
            case 13: {
                return Dataset.___copyImageLinks(this, in, __current);
            }
            case 14: {
                return Dataset.___copyProjectLinks(this, in, __current);
            }
            case 15: {
                return Dataset.___findDatasetAnnotationLink(this, in, __current);
            }
            case 16: {
                return Dataset.___findDatasetImageLink(this, in, __current);
            }
            case 17: {
                return Dataset.___findProjectDatasetLink(this, in, __current);
            }
            case 18: {
                return Dataset.___getAnnotationLinksCountPerOwner(this, in, __current);
            }
            case 19: {
                return Dataset.___getDescription(this, in, __current);
            }
            case 20: {
                return IObject.___getDetails(this, in, __current);
            }
            case 21: {
                return IObject.___getId(this, in, __current);
            }
            case 22: {
                return Dataset.___getImageLinksCountPerOwner(this, in, __current);
            }
            case 23: {
                return Dataset.___getName(this, in, __current);
            }
            case 24: {
                return Dataset.___getProjectLinksCountPerOwner(this, in, __current);
            }
            case 25: {
                return Dataset.___getVersion(this, in, __current);
            }
            case 26: {
                return Dataset.___ice_id((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 27: {
                return Dataset.___ice_ids((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 28: {
                return Dataset.___ice_isA((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 29: {
                return Dataset.___ice_ping((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 30: {
                return IObject.___isAnnotated(this, in, __current);
            }
            case 31: {
                return IObject.___isGlobal(this, in, __current);
            }
            case 32: {
                return IObject.___isLink(this, in, __current);
            }
            case 33: {
                return IObject.___isLoaded(this, in, __current);
            }
            case 34: {
                return IObject.___isMutable(this, in, __current);
            }
            case 35: {
                return Dataset.___linkAnnotation(this, in, __current);
            }
            case 36: {
                return Dataset.___linkImage(this, in, __current);
            }
            case 37: {
                return Dataset.___linkProject(this, in, __current);
            }
            case 38: {
                return Dataset.___linkedAnnotationList(this, in, __current);
            }
            case 39: {
                return Dataset.___linkedImageList(this, in, __current);
            }
            case 40: {
                return Dataset.___linkedProjectList(this, in, __current);
            }
            case 41: {
                return IObject.___proxy(this, in, __current);
            }
            case 42: {
                return Dataset.___reloadAnnotationLinks(this, in, __current);
            }
            case 43: {
                return Dataset.___reloadImageLinks(this, in, __current);
            }
            case 44: {
                return Dataset.___reloadProjectLinks(this, in, __current);
            }
            case 45: {
                return Dataset.___removeAllDatasetAnnotationLinkSet(this, in, __current);
            }
            case 46: {
                return Dataset.___removeAllDatasetImageLinkSet(this, in, __current);
            }
            case 47: {
                return Dataset.___removeAllProjectDatasetLinkSet(this, in, __current);
            }
            case 48: {
                return Dataset.___removeDatasetAnnotationLink(this, in, __current);
            }
            case 49: {
                return Dataset.___removeDatasetAnnotationLinkFromBoth(this, in, __current);
            }
            case 50: {
                return Dataset.___removeDatasetImageLink(this, in, __current);
            }
            case 51: {
                return Dataset.___removeDatasetImageLinkFromBoth(this, in, __current);
            }
            case 52: {
                return Dataset.___removeProjectDatasetLink(this, in, __current);
            }
            case 53: {
                return Dataset.___removeProjectDatasetLinkFromBoth(this, in, __current);
            }
            case 54: {
                return Dataset.___setDescription(this, in, __current);
            }
            case 55: {
                return IObject.___setId(this, in, __current);
            }
            case 56: {
                return Dataset.___setName(this, in, __current);
            }
            case 57: {
                return Dataset.___setVersion(this, in, __current);
            }
            case 58: {
                return IObject.___shallowCopy(this, in, __current);
            }
            case 59: {
                return Dataset.___sizeOfAnnotationLinks(this, in, __current);
            }
            case 60: {
                return Dataset.___sizeOfImageLinks(this, in, __current);
            }
            case 61: {
                return Dataset.___sizeOfProjectLinks(this, in, __current);
            }
            case 62: {
                return Dataset.___unlinkAnnotation(this, in, __current);
            }
            case 63: {
                return Dataset.___unlinkImage(this, in, __current);
            }
            case 64: {
                return Dataset.___unlinkProject(this, in, __current);
            }
            case 65: {
                return IObject.___unload(this, in, __current);
            }
            case 66: {
                return Dataset.___unloadAnnotationLinks(this, in, __current);
            }
            case 67: {
                return IObject.___unloadCollections(this, in, __current);
            }
            case 68: {
                return IObject.___unloadDetails(this, in, __current);
            }
            case 69: {
                return Dataset.___unloadImageLinks(this, in, __current);
            }
            case 70: {
                return Dataset.___unloadProjectLinks(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    @Override
    public void __write(BasicStream __os) {
        __os.writeTypeId(Dataset.ice_staticId());
        __os.startWriteSlice();
        __os.writeObject((Ice.Object)this.version);
        DatasetProjectLinksSeqHelper.write(__os, this.projectLinksSeq);
        __os.writeBool(this.projectLinksLoaded);
        CountMapHelper.write(__os, this.projectLinksCountPerOwner);
        DatasetImageLinksSeqHelper.write(__os, this.imageLinksSeq);
        __os.writeBool(this.imageLinksLoaded);
        CountMapHelper.write(__os, this.imageLinksCountPerOwner);
        DatasetAnnotationLinksSeqHelper.write(__os, this.annotationLinksSeq);
        __os.writeBool(this.annotationLinksLoaded);
        CountMapHelper.write(__os, this.annotationLinksCountPerOwner);
        __os.writeObject((Ice.Object)this.name);
        __os.writeObject((Ice.Object)this.description);
        __os.endWriteSlice();
        super.__write(__os);
    }

    @Override
    public void __read(BasicStream __is, boolean __rid) {
        if (__rid) {
            __is.readTypeId();
        }
        __is.startReadSlice();
        __is.readObject((IceInternal.Patcher)new Patcher(2));
        this.projectLinksSeq = DatasetProjectLinksSeqHelper.read(__is);
        this.projectLinksLoaded = __is.readBool();
        this.projectLinksCountPerOwner = CountMapHelper.read(__is);
        this.imageLinksSeq = DatasetImageLinksSeqHelper.read(__is);
        this.imageLinksLoaded = __is.readBool();
        this.imageLinksCountPerOwner = CountMapHelper.read(__is);
        this.annotationLinksSeq = DatasetAnnotationLinksSeqHelper.read(__is);
        this.annotationLinksLoaded = __is.readBool();
        this.annotationLinksCountPerOwner = CountMapHelper.read(__is);
        __is.readObject((IceInternal.Patcher)new Patcher(3));
        __is.readObject((IceInternal.Patcher)new Patcher(4));
        __is.endReadSlice();
        super.__read(__is, true);
    }

    @Override
    public void __write(OutputStream __outS) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::model::Dataset was not generated with stream support";
        throw ex;
    }

    @Override
    public void __read(InputStream __inS, boolean __rid) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::model::Dataset was not generated with stream support";
        throw ex;
    }

    private class Patcher
    implements IceInternal.Patcher {
        private int __member;
        private String __typeId;

        Patcher(int member) {
            this.__member = member;
        }

        public void patch(Ice.Object v) {
            try {
                switch (this.__member) {
                    case 0: {
                        this.__typeId = "::omero::RLong";
                        Dataset.this.id = (RLong)v;
                        break;
                    }
                    case 1: {
                        this.__typeId = "::omero::model::Details";
                        Dataset.this.details = (Details)v;
                        break;
                    }
                    case 2: {
                        this.__typeId = "::omero::RInt";
                        Dataset.this.version = (RInt)v;
                        break;
                    }
                    case 3: {
                        this.__typeId = "::omero::RString";
                        Dataset.this.name = (RString)v;
                        break;
                    }
                    case 4: {
                        this.__typeId = "::omero::RString";
                        Dataset.this.description = (RString)v;
                    }
                }
            }
            catch (ClassCastException ex) {
                Ex.throwUOE((String)this.type(), (String)v.ice_id());
            }
        }

        public String type() {
            return this.__typeId;
        }
    }
}

