/*
 * Decompiled with CFR 0.152.
 */
package omero.grid.monitors;

import Ice.ByteSeqHelper;
import Ice.Current;
import Ice.DispatchStatus;
import Ice.InputStream;
import Ice.MarshalException;
import Ice.ObjectImpl;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.OutputStream;
import Ice.StringSeqHelper;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.Incoming;
import java.util.Arrays;
import omero.OmeroFSError;
import omero.grid.monitors.FileStats;
import omero.grid.monitors.MonitorClientPrx;
import omero.grid.monitors.MonitorClientPrxHelper;
import omero.grid.monitors.MonitorServer;
import omero.grid.monitors.MonitorState;
import omero.grid.monitors.MonitorType;
import omero.grid.monitors.PathMode;
import omero.grid.monitors.WatchEventListHelper;
import omero.grid.monitors.WatchEventType;

public abstract class _MonitorServerDisp
extends ObjectImpl
implements MonitorServer {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::grid::monitors::MonitorServer"};
    private static final String[] __all = new String[]{"createMonitor", "destroyMonitor", "fileExists", "getATime", "getBaseName", "getCTime", "getDirectory", "getMTime", "getMonitorDirectory", "getMonitorState", "getOwner", "getSHA1", "getSize", "getStats", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isDir", "isFile", "readBlock", "startMonitor", "stopMonitor"};

    protected void ice_copyStateFrom(Ice.Object __obj) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids() {
        return __ids;
    }

    public String[] ice_ids(Current __current) {
        return __ids;
    }

    public String ice_id() {
        return __ids[1];
    }

    public String ice_id(Current __current) {
        return __ids[1];
    }

    public static String ice_staticId() {
        return __ids[1];
    }

    public final String createMonitor(MonitorType mType, WatchEventType[] eTypes, PathMode pMode, String pathString, String[] whitelist, String[] blacklist, float timeout, int blockSize, boolean ignoreSysFiles, boolean ignoreDirEvents, MonitorClientPrx proxy) throws OmeroFSError {
        return this.createMonitor(mType, eTypes, pMode, pathString, whitelist, blacklist, timeout, blockSize, ignoreSysFiles, ignoreDirEvents, proxy, null);
    }

    public final void destroyMonitor(String id) throws OmeroFSError {
        this.destroyMonitor(id, null);
    }

    public final boolean fileExists(String fileId) throws OmeroFSError {
        return this.fileExists(fileId, null);
    }

    public final float getATime(String fileId) throws OmeroFSError {
        return this.getATime(fileId, null);
    }

    public final String getBaseName(String fileId) throws OmeroFSError {
        return this.getBaseName(fileId, null);
    }

    public final float getCTime(String fileId) throws OmeroFSError {
        return this.getCTime(fileId, null);
    }

    public final String[] getDirectory(String absPath, String filter) throws OmeroFSError {
        return this.getDirectory(absPath, filter, null);
    }

    public final float getMTime(String fileId) throws OmeroFSError {
        return this.getMTime(fileId, null);
    }

    public final String[] getMonitorDirectory(String id, String relPath, String filter) throws OmeroFSError {
        return this.getMonitorDirectory(id, relPath, filter, null);
    }

    public final MonitorState getMonitorState(String id) throws OmeroFSError {
        return this.getMonitorState(id, null);
    }

    public final String getOwner(String fileId) throws OmeroFSError {
        return this.getOwner(fileId, null);
    }

    public final String getSHA1(String fileId) throws OmeroFSError {
        return this.getSHA1(fileId, null);
    }

    public final long getSize(String fileId) throws OmeroFSError {
        return this.getSize(fileId, null);
    }

    public final FileStats getStats(String fileId) throws OmeroFSError {
        return this.getStats(fileId, null);
    }

    public final boolean isDir(String fileId) throws OmeroFSError {
        return this.isDir(fileId, null);
    }

    public final boolean isFile(String fileId) throws OmeroFSError {
        return this.isFile(fileId, null);
    }

    public final byte[] readBlock(String fileId, long offset, int size) throws OmeroFSError {
        return this.readBlock(fileId, offset, size, null);
    }

    public final void startMonitor(String id) throws OmeroFSError {
        this.startMonitor(id, null);
    }

    public final void stopMonitor(String id) throws OmeroFSError {
        this.stopMonitor(id, null);
    }

    public static DispatchStatus ___createMonitor(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        MonitorType mType = MonitorType.__read(__is);
        WatchEventType[] eTypes = WatchEventListHelper.read(__is);
        PathMode pMode = PathMode.__read(__is);
        String pathString = __is.readString();
        String[] whitelist = StringSeqHelper.read((BasicStream)__is);
        String[] blacklist = StringSeqHelper.read((BasicStream)__is);
        float timeout = __is.readFloat();
        int blockSize = __is.readInt();
        boolean ignoreSysFiles = __is.readBool();
        boolean ignoreDirEvents = __is.readBool();
        MonitorClientPrx proxy = MonitorClientPrxHelper.__read(__is);
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            String __ret = __obj.createMonitor(mType, eTypes, pMode, pathString, whitelist, blacklist, timeout, blockSize, ignoreSysFiles, ignoreDirEvents, proxy, __current);
            __os.writeString(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___startMonitor(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            __obj.startMonitor(id, __current);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___stopMonitor(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            __obj.stopMonitor(id, __current);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___destroyMonitor(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            __obj.destroyMonitor(id, __current);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getMonitorState(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            MonitorState __ret = __obj.getMonitorState(id, __current);
            __ret.__write(__os);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getMonitorDirectory(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String id = __is.readString();
        String relPath = __is.readString();
        String filter = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            String[] __ret = __obj.getMonitorDirectory(id, relPath, filter, __current);
            StringSeqHelper.write((BasicStream)__os, (String[])__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getDirectory(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String absPath = __is.readString();
        String filter = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            String[] __ret = __obj.getDirectory(absPath, filter, __current);
            StringSeqHelper.write((BasicStream)__os, (String[])__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___fileExists(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            boolean __ret = __obj.fileExists(fileId, __current);
            __os.writeBool(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getBaseName(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            String __ret = __obj.getBaseName(fileId, __current);
            __os.writeString(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getStats(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            FileStats __ret = __obj.getStats(fileId, __current);
            __ret.__write(__os);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getSize(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            long __ret = __obj.getSize(fileId, __current);
            __os.writeLong(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getOwner(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            String __ret = __obj.getOwner(fileId, __current);
            __os.writeString(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getCTime(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            float __ret = __obj.getCTime(fileId, __current);
            __os.writeFloat(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getMTime(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            float __ret = __obj.getMTime(fileId, __current);
            __os.writeFloat(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getATime(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            float __ret = __obj.getATime(fileId, __current);
            __os.writeFloat(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___isDir(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            boolean __ret = __obj.isDir(fileId, __current);
            __os.writeBool(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___isFile(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            boolean __ret = __obj.isFile(fileId, __current);
            __os.writeBool(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getSHA1(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            String __ret = __obj.getSHA1(fileId, __current);
            __os.writeString(__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___readBlock(MonitorServer __obj, Incoming __inS, Current __current) {
        _MonitorServerDisp.__checkMode((OperationMode)OperationMode.Idempotent, (OperationMode)__current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String fileId = __is.readString();
        long offset = __is.readLong();
        int size = __is.readInt();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            byte[] __ret = __obj.readBlock(fileId, offset, size, __current);
            ByteSeqHelper.write((BasicStream)__os, (byte[])__ret);
            return DispatchStatus.DispatchOK;
        }
        catch (OmeroFSError ex) {
            __os.writeUserException((UserException)ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return _MonitorServerDisp.___createMonitor(this, in, __current);
            }
            case 1: {
                return _MonitorServerDisp.___destroyMonitor(this, in, __current);
            }
            case 2: {
                return _MonitorServerDisp.___fileExists(this, in, __current);
            }
            case 3: {
                return _MonitorServerDisp.___getATime(this, in, __current);
            }
            case 4: {
                return _MonitorServerDisp.___getBaseName(this, in, __current);
            }
            case 5: {
                return _MonitorServerDisp.___getCTime(this, in, __current);
            }
            case 6: {
                return _MonitorServerDisp.___getDirectory(this, in, __current);
            }
            case 7: {
                return _MonitorServerDisp.___getMTime(this, in, __current);
            }
            case 8: {
                return _MonitorServerDisp.___getMonitorDirectory(this, in, __current);
            }
            case 9: {
                return _MonitorServerDisp.___getMonitorState(this, in, __current);
            }
            case 10: {
                return _MonitorServerDisp.___getOwner(this, in, __current);
            }
            case 11: {
                return _MonitorServerDisp.___getSHA1(this, in, __current);
            }
            case 12: {
                return _MonitorServerDisp.___getSize(this, in, __current);
            }
            case 13: {
                return _MonitorServerDisp.___getStats(this, in, __current);
            }
            case 14: {
                return _MonitorServerDisp.___ice_id((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 15: {
                return _MonitorServerDisp.___ice_ids((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 16: {
                return _MonitorServerDisp.___ice_isA((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 17: {
                return _MonitorServerDisp.___ice_ping((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 18: {
                return _MonitorServerDisp.___isDir(this, in, __current);
            }
            case 19: {
                return _MonitorServerDisp.___isFile(this, in, __current);
            }
            case 20: {
                return _MonitorServerDisp.___readBlock(this, in, __current);
            }
            case 21: {
                return _MonitorServerDisp.___startMonitor(this, in, __current);
            }
            case 22: {
                return _MonitorServerDisp.___stopMonitor(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    public void __write(BasicStream __os) {
        __os.writeTypeId(_MonitorServerDisp.ice_staticId());
        __os.startWriteSlice();
        __os.endWriteSlice();
        super.__write(__os);
    }

    public void __read(BasicStream __is, boolean __rid) {
        if (__rid) {
            __is.readTypeId();
        }
        __is.startReadSlice();
        __is.endReadSlice();
        super.__read(__is, true);
    }

    public void __write(OutputStream __outS) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::grid::monitors::MonitorServer was not generated with stream support";
        throw ex;
    }

    public void __read(InputStream __inS, boolean __rid) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::grid::monitors::MonitorServer was not generated with stream support";
        throw ex;
    }
}

