/*
 * Decompiled with CFR 0.152.
 */
package ome.services.roi;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.conditions.ApiUsageException;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.meta.EventLog;
import ome.model.roi.Roi;
import ome.services.messages.ShapeChangeMessage;
import ome.services.roi.PixelData;
import ome.services.roi.RoiTypes;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.tools.hibernate.SessionFactory;
import ome.util.Filterable;
import omero.RBool;
import omero.RInt;
import omero.api.RoiOptions;
import omero.api.RoiStats;
import omero.api.ShapePoints;
import omero.api.ShapeStats;
import omero.model.Ellipse;
import omero.model.IObject;
import omero.model.Line;
import omero.model.Point;
import omero.model.Rect;
import omero.model.Shape;
import omero.model.SmartEllipseI;
import omero.model.SmartLineI;
import omero.model.SmartPointI;
import omero.model.SmartRectI;
import omero.model.SmartShape;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeomTool
implements ApplicationListener {
    protected Log log = LogFactory.getLog(GeomTool.class);
    protected final AtomicBoolean hasShapes = new AtomicBoolean(true);
    protected final SimpleJdbcOperations jdbc;
    protected final SessionFactory factory;
    protected final PixelData data;
    protected final Executor ex;
    protected final String uuid;
    static final String FIND_INTERESECTING_QUERY = "select distinct r.id from Shape s, Roi r where r.image = %s and r.id  = s.roi and ";

    public GeomTool(PixelData data, SimpleJdbcOperations jdbc, SessionFactory factory) {
        this(data, jdbc, factory, null, null);
    }

    public GeomTool(PixelData data, SimpleJdbcOperations jdbc, SessionFactory factory, Executor ex, String uuid) {
        this.data = data;
        this.jdbc = jdbc;
        this.factory = factory;
        this.ex = ex;
        this.uuid = uuid;
        try {
            jdbc.queryForObject("select pg_geom from shape limit 1", String.class, new Object[0]);
        }
        catch (EmptyResultDataAccessException erdae) {
        }
        catch (Exception e) {
            jdbc.update("alter table shape add column pg_geom polygon;", new Object[0]);
            jdbc.update("create index pg_geom_idx on shape using gist (pg_geom);", new Object[0]);
            this.log.info((Object)"Configured Shape.pg_geom");
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ShapeChangeMessage) {
            if (this.ex != null) {
                this.log.info((Object)"Setting hasShapes=true");
                this.hasShapes.set(true);
                return;
            }
            ShapeChangeMessage scm = (ShapeChangeMessage)event;
            ArrayList<Long> shapeIds = new ArrayList<Long>();
            for (EventLog log : scm) {
                shapeIds.add(log.getEntityId());
            }
            this.synchronizeShapeGeometries(shapeIds);
        }
    }

    public void backgroundSynchronizeShapeGeometries() {
        if (this.ex == null || !this.hasShapes.get()) {
            return;
        }
        if (!this.hasShapes.compareAndSet(true, false)) {
            this.log.warn((Object)"hasShapes changed to false");
        }
        try {
            int count;
            while ((count = ((Integer)this.ex.execute(new Principal(this.uuid, "system", "Internal"), (Executor.Work)new Executor.SimpleWork(this, "backgroundSynchronization", new Object[0]){

                @Transactional(readOnly=false)
                public Object doWork(Session session, ServiceFactory sf) {
                    List l = GeomTool.this.getNullShapes();
                    if (l.size() > 0) {
                        GeomTool.this.log.info((Object)("Batch processing " + l.size() + " shapes"));
                        GeomTool.this.synchronizeShapeGeometries(l);
                    }
                    return l.size();
                }
            })).intValue()) > 0) {
            }
        }
        catch (Exception e) {
            this.hasShapes.set(true);
            this.log.warn((Object)"Exception during batch processing: setting hasShapes=true");
        }
    }

    public void synchronizeShapeGeometries(List<Long> shapeIds) {
        for (Long shapeId : shapeIds) {
            this.synchronizeShapeGeometry(shapeId);
        }
    }

    public void synchronizeShapeGeometry(long shapeId) {
        Session session = this.factory.getSession();
        Shape s = this.justShapeById(shapeId, session);
        String path = this.dbPath(s);
        int results = this.jdbc.update(String.format("update shape set pg_geom = %s::polygon where id = ?", path), new Object[]{shapeId});
        if (results == 0) {
            throw new RuntimeException("pg_geom missing: " + shapeId);
        }
    }

    private Shape justShapeById(long shapeId, Session session) {
        Query q = session.createQuery("select s from Shape s where s.id = :id");
        q.setParameter("id", (Object)shapeId);
        ome.model.roi.Shape shape = (ome.model.roi.Shape)q.uniqueResult();
        return (Shape)new ShapeMapper().map((Filterable)shape);
    }

    public List<Shape> random(int count) {
        if (count < 1 || count > 100000) {
            throw new RuntimeException("Count out of bounds: " + count);
        }
        Map<Class, RoiTypes.ObjectFactory> map = RoiTypes.ObjectFactories;
        ArrayList<Class> types = new ArrayList<Class>(map.keySet());
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        Random r = new Random();
        try {
            while (shapes.size() < count) {
                int which = r.nextInt(types.size());
                Class type = (Class)types.get(which);
                Method m = type.getMethod("randomize", Random.class);
                RoiTypes.ObjectFactory of = map.get(type);
                SmartShape s = (SmartShape)of.create("");
                m.invoke((Object)s, r);
                shapes.add((Shape)((Object)s));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failure on creating shape " + shapes.size(), e);
        }
        return shapes;
    }

    public Line ln(double x1, double y1, double x2, double y2) {
        SmartLineI rect = new SmartLineI();
        rect.setX1(rtypes.rdouble(x1));
        rect.setY1(rtypes.rdouble(y1));
        rect.setX2(rtypes.rdouble(x2));
        rect.setY2(rtypes.rdouble(y2));
        return rect;
    }

    public Rect rect(double x, double y, double w, double h) {
        SmartRectI rect = new SmartRectI();
        rect.setX(rtypes.rdouble(x));
        rect.setY(rtypes.rdouble(y));
        rect.setWidth(rtypes.rdouble(w));
        rect.setHeight(rtypes.rdouble(h));
        return rect;
    }

    public Point pt(double x, double y) {
        SmartPointI pt = new SmartPointI();
        pt.setCx(rtypes.rdouble(x));
        pt.setCy(rtypes.rdouble(y));
        return pt;
    }

    public Ellipse ellipse(double cx, double cy, double rx, double ry) {
        SmartEllipseI ellipse = new SmartEllipseI();
        ellipse.setCx(rtypes.rdouble(cx));
        ellipse.setCy(rtypes.rdouble(cy));
        ellipse.setRx(rtypes.rdouble(rx));
        ellipse.setRy(rtypes.rdouble(ry));
        return ellipse;
    }

    public Ellipse ellipse(double cx, double cy, double rx, double ry, int t, int z) {
        Ellipse ellipse = this.ellipse(cx, cy, rx, ry);
        ellipse.setTheT(rtypes.rint(t));
        ellipse.setTheZ(rtypes.rint(z));
        return ellipse;
    }

    public String dbPath(Shape shape) {
        if (shape == null) {
            return null;
        }
        SmartShape ss = this.assertSmart(shape);
        List<Point> points = ss.asPoints();
        StringBuilder sb = new StringBuilder();
        sb.append("'(");
        for (int i = 0; i < points.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            SmartShape.Util.appendDbPoint(sb, points.get(i));
        }
        sb.append(")'");
        return sb.toString();
    }

    public List<Long> findIntersectingRois(long imageId, Shape ... shapes) {
        return this.findIntersectingRois(imageId, (RoiOptions)null, shapes);
    }

    public List<Long> findIntersectingRois(long imageId, RoiOptions opts, Shape ... shapes) {
        if (shapes == null || shapes.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(FIND_INTERESECTING_QUERY, imageId));
        sb.append("( ");
        boolean first = true;
        for (Shape shape : shapes) {
            if (first) {
                first = false;
            } else {
                sb.append("or ");
            }
            sb.append("( ");
            RInt z = shape.getTheZ();
            RInt t = shape.getTheT();
            RBool v = shape.getVisibility();
            RBool l = shape.getLocked();
            if (z != null) {
                sb.append("s.theZ = ");
                sb.append(z.getValue());
                sb.append(" and ");
            }
            if (t != null) {
                sb.append("s.theT = ");
                sb.append(t.getValue());
                sb.append(" and ");
            }
            if (v != null) {
                sb.append("s.visibility = ");
                sb.append(v.getValue());
                sb.append(" and ");
            }
            if (l != null) {
                sb.append("s.locked = ");
                sb.append(l.getValue());
                sb.append(" and ");
            }
            if (opts != null && opts.shapes != null && opts.shapes.size() > 0) {
                sb.append("s.discriminator in ( ");
                for (int i = 0; i < opts.shapes.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append("'");
                    sb.append(this.discriminator(opts.shapes.get(i)));
                    sb.append("'");
                }
                sb.append(") and ");
            }
            sb.append("s.pg_geom && ");
            String path = this.dbPath(shape);
            sb.append(path);
            sb.append("::polygon ");
            sb.append(") ");
        }
        sb.append(") ");
        if (opts != null) {
            if (opts.userId != null) {
                sb.append(" and r.owner_id = ");
                sb.append(opts.userId.getValue());
                sb.append(" ");
            }
            if (opts.groupId != null) {
                sb.append(" and r.group_id = ");
                sb.append(opts.groupId.getValue());
                sb.append(" ");
            }
        }
        sb.append("order by r.id ");
        if (opts != null) {
            if (opts.limit != null) {
                sb.append("limit ");
                sb.append(opts.limit.getValue());
                sb.append(" ");
            }
            if (opts.offset != null) {
                sb.append("offset ");
                sb.append(opts.offset.getValue());
                sb.append(" ");
            }
        }
        List ids = this.jdbc.query(sb.toString(), (ParameterizedRowMapper)new IdRowMapper(), new Object[0]);
        return ids;
    }

    public ShapePoints getPoints(long shapeId, Session session) {
        Shape shape = this.justShapeById(shapeId, session);
        SmartShape smart = this.assertSmart(shape);
        final ArrayList xs = new ArrayList();
        final ArrayList ys = new ArrayList();
        smart.areaPoints(new SmartShape.PointCallback(){

            public void handle(int x, int y) {
                xs.add(x);
                ys.add(y);
            }
        });
        ShapePoints sp = new ShapePoints();
        sp.x = new int[xs.size()];
        sp.y = new int[ys.size()];
        for (int i = 0; i < sp.x.length; ++i) {
            sp.x[i] = (Integer)xs.get(i);
            sp.y[i] = (Integer)ys.get(i);
        }
        return sp;
    }

    public List<Long> getShapeIds(long roiId) {
        return this.jdbc.query("select id from shape where roi = ?", (ParameterizedRowMapper)new IdRowMapper(), new Object[]{roiId});
    }

    public RoiStats getStats(List<Long> shapeIds) {
        if (shapeIds == null) {
            return null;
        }
        Session session = this.factory.getSession();
        RoiStats rs = new RoiStats();
        rs.perShape = new ShapeStats[shapeIds.size()];
        for (int i = 0; i < shapeIds.size(); ++i) {
            long shapeId = shapeIds.get(i);
            ome.model.roi.Shape shape = (ome.model.roi.Shape)session.createQuery("select s from Shape s left outer join fetch s.channels selected join fetch s.roi r join fetch r.image i join fetch i.pixels p join fetch p.channels c join fetch c.logicalChannel lc where s.id = :id").setParameter("id", (Object)shapeId).uniqueResult();
            SmartShape smartShape = (SmartShape)new ShapeMapper().map((Filterable)shape);
            Roi roi = shape.getRoi();
            Image img = roi.getImage();
            Pixels pix = img.getPrimaryPixels();
            long roiId = roi.getId();
            long imgId = img.getId();
            final long pixId = pix.getId();
            int maxZ = pix.getSizeZ();
            int maxT = pix.getSizeT();
            if (rs.combined == null) {
                rs.roiId = roiId;
                rs.imageId = imgId;
                rs.pixelsId = pixId;
                int ch = pix.sizeOfChannels();
                rs.combined = this.makeStats(ch);
                rs.combined.shapeId = -1L;
                rs.combined.channelIds = new long[ch];
                for (int w = 0; w < ch; ++w) {
                    rs.combined.channelIds[w] = pix.getChannel(w).getLogicalChannel().getId();
                }
            }
            ShapeStats agg = rs.combined;
            final ShapeStats stats = this.makeStats(pix, shape);
            stats.shapeId = shape.getId();
            final int ch = stats.channelIds.length;
            final double[] sumOfSquares = new double[ch];
            Integer theZ = shape.getTheZ();
            Integer theT = shape.getTheT();
            final int startZ = theZ == null ? 0 : theZ;
            final int startT = theT == null ? 0 : theT;
            final int endZ = theZ == null ? maxZ - 1 : theZ;
            final int endT = theT == null ? maxT - 1 : theT;
            SmartShape.PointCallback cb = new SmartShape.PointCallback(){

                public void handle(int x, int y) {
                    for (int w = 0; w < ch; ++w) {
                        for (int z = startZ; z <= endZ; ++z) {
                            for (int t = startT; t <= endT; ++t) {
                                int n = w;
                                stats.pointsCount[n] = stats.pointsCount[n] + 1L;
                                double value = GeomTool.this.data.get(pixId, x, y, z, w, t);
                                stats.min[w] = Math.min(value, stats.min[w]);
                                stats.max[w] = Math.max(value, stats.max[w]);
                                int n2 = w;
                                stats.sum[n2] = stats.sum[n2] + value;
                                int n3 = w;
                                sumOfSquares[n3] = sumOfSquares[n3] + value * value;
                            }
                        }
                    }
                }
            };
            smartShape.areaPoints(cb);
            for (int w = 0; w < ch; ++w) {
                double sigmaSquare;
                stats.mean[w] = stats.sum[w] / (double)stats.pointsCount[w];
                if (stats.pointsCount[w] <= 1L || !((sigmaSquare = (sumOfSquares[w] - stats.sum[w] * stats.sum[w] / (double)stats.pointsCount[w]) / (double)(stats.pointsCount[w] - 1L)) > 0.0)) continue;
                stats.stdDev[w] = Math.sqrt(sigmaSquare);
            }
            rs.perShape[i] = stats;
        }
        return rs;
    }

    public Object discriminator(String string) {
        if (string == null || string.length() == 0) {
            throw new ApiUsageException("Empty string");
        }
        String[] s = string.split("[.:]");
        string = s[s.length - 1];
        if ((string = string.toLowerCase()).endsWith("i")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private ShapeStats makeStats(int ch) {
        ShapeStats stats = new ShapeStats();
        stats.channelIds = new long[ch];
        stats.min = new double[ch];
        stats.max = new double[ch];
        stats.sum = new double[ch];
        stats.mean = new double[ch];
        stats.stdDev = new double[ch];
        stats.pointsCount = new long[ch];
        Arrays.fill((double[])stats.min, (int)0, (int)ch, (double)Double.MAX_VALUE);
        return stats;
    }

    private ShapeStats makeStats(Pixels pix, ome.model.roi.Shape shape) {
        boolean shapeChannels = true;
        int ch = shape.sizeOfChannels();
        if (ch == 0) {
            shapeChannels = false;
            ch = pix.sizeOfChannels();
        }
        ShapeStats stats = this.makeStats(ch);
        for (int w = 0; w < ch; ++w) {
            stats.channelIds[w] = shapeChannels ? -1L : pix.getChannel(w).getLogicalChannel().getId();
        }
        return stats;
    }

    private SmartShape assertSmart(Shape shape) {
        if (!SmartShape.class.isAssignableFrom(shape.getClass())) {
            throw new RuntimeException("Internally only SmartShapes should be used! not " + shape.getClass());
        }
        SmartShape ss = (SmartShape)((Object)shape);
        return ss;
    }

    private List<Long> getNullShapes() {
        List l = this.jdbc.query("select id from shape where pg_geom is null limit 1000", (ParameterizedRowMapper)new ParameterizedRowMapper<Long>(){

            public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getLong("id");
            }
        }, new Object[0]);
        return l;
    }

    private static class ShapeMapper
    extends IceMapper {
        boolean called = false;

        private ShapeMapper() {
        }

        public Filterable filter(String fieldId, Filterable source) {
            if (!this.called) {
                this.called = true;
                return super.filter(fieldId, source);
            }
            Object o = this.findTarget(source);
            if (o instanceof IObject) {
                ome.model.IObject iobj = (ome.model.IObject)source;
                IObject robj = (IObject)o;
                robj.setId(rtypes.rlong(iobj.getId()));
                robj.unload();
            }
            return source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdRowMapper
    implements ParameterizedRowMapper<Long> {
        private IdRowMapper() {
        }

        public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getLong(1);
        }
    }
}

