/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.measurements;

import java.util.Map;
import ome.model.IObject;
import ome.services.blitz.measurements.Helper;
import omero.ApiUsageException;
import omero.ServerError;
import omero.ValidationException;
import omero.grid.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SmartColumns {
    Map<String, IObject> lsidMap;
    String[] idTypes;
    Column[] cols;
    Helper[] helpers;

    SmartColumns(Map<String, IObject> lsidMap, String[] headers, String[] idTypes, Class[] types) throws ServerError {
        int i;
        if (types == null || headers == null) {
            throw new ApiUsageException(null, null, "Required parameter is null");
        }
        if (types.length + idTypes.length != headers.length) {
            throw new ApiUsageException(null, null, String.format("types.length (%s) != headers.length (%s)", types.length, headers.length));
        }
        this.lsidMap = lsidMap;
        this.idTypes = idTypes;
        this.cols = new Column[headers.length];
        this.helpers = new Helper[headers.length];
        for (i = 0; i < idTypes.length; ++i) {
            if (!idTypes[i].contains("Roi")) {
                throw new ValidationException(null, null, "Unknown lsid type: " + idTypes[i]);
            }
            this.helpers[i] = Helper.fromLsid(idTypes[i]);
            this.cols[i] = this.helpers[i].newInstance();
            this.cols[i].name = headers[i];
        }
        for (i = 0; i < types.length; ++i) {
            int j = i + idTypes.length;
            this.helpers[j] = Helper.fromClass(types[i]);
            this.cols[j] = this.helpers[j].newInstance();
            this.cols[j].name = headers[j];
        }
    }

    public void fill(Object[][] data) {
        for (int colIdx = 0; colIdx < this.cols.length; ++colIdx) {
            Helper helper = this.helpers[colIdx];
            Column col = this.cols[colIdx];
            helper.setSize(col, data.length);
        }
        for (int rowIdx = 0; rowIdx < data.length; ++rowIdx) {
            Helper helper;
            Column col;
            int colIdx;
            Object[] row = data[rowIdx];
            for (colIdx = 0; colIdx < this.idTypes.length; ++colIdx) {
                col = this.cols[colIdx];
                helper = this.helpers[colIdx];
                String lsid = (String)data[rowIdx][colIdx];
                IObject obj = this.lsidMap.get(lsid);
                Long value = null;
                if (obj != null) {
                    value = obj.getId();
                }
                helper.setValue(col, rowIdx, value);
            }
            for (colIdx = this.idTypes.length; colIdx < this.cols.length; ++colIdx) {
                col = this.cols[colIdx];
                helper = this.helpers[colIdx];
                helper.setValue(col, rowIdx, data[rowIdx][colIdx]);
            }
        }
    }

    public Column[] asArray() {
        return this.cols;
    }
}

