/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.api.IShare;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.conditions.ValidationException;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.meta.Event;
import ome.model.meta.EventLog;
import ome.model.meta.Session;
import ome.parameters.Parameters;
import ome.security.AdminAction;
import ome.security.SecuritySystem;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.sessions.SessionManager;
import ome.services.throttling.Adapter;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.tools.hibernate.QueryBuilder;
import omero.RTime;
import omero.ServerError;
import omero.api.AMD_ITimeline_countByPeriod;
import omero.api.AMD_ITimeline_getByPeriod;
import omero.api.AMD_ITimeline_getEventLogsByPeriod;
import omero.api.AMD_ITimeline_getMostRecentAnnotationLinks;
import omero.api.AMD_ITimeline_getMostRecentObjects;
import omero.api.AMD_ITimeline_getMostRecentShareCommentLinks;
import omero.api._ITimelineOperations;
import omero.rtypes;
import omero.sys.Filter;
import omero.util.IceMapper;
import org.hibernate.Query;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineI
extends AbstractAmdServant
implements _ITimelineOperations,
ServiceFactoryAware,
BlitzOnly {
    protected ServiceFactoryI factory;
    protected SessionManager sm;
    protected SecuritySystem ss;
    static final String LOOKUP_SHARE_COMMENTS = "select l from SessionAnnotationLink l join fetch l.details.owner join fetch l.parent as share join fetch l.child as comment join fetch comment.details.owner join fetch comment.details.creationEvent where comment.details.owner.id !=:id and share.id in (:ids) order by comment.details.creationEvent.time desc";
    static final List<String> ALLTYPES = Arrays.asList("RenderingDef", "Image", "Project", "Dataset", "Annotation");
    static final Map<String, String> ORDERBY = new HashMap<String, String>();
    static final Map<String, String> BYPERIOD = new HashMap<String, String>();
    static final Map<String, String> OWNERSHIP = new HashMap<String, String>();

    public TimelineI(BlitzExecutor be) {
        super(null, be);
    }

    public void setSessionManager(SessionManager sm) {
        this.sm = sm;
    }

    public void setSecuritySystem(SecuritySystem ss) {
        this.ss = ss;
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) {
        this.factory = sf;
    }

    @Override
    public void countByPeriod_async(AMD_ITimeline_countByPeriod __cb, final List<String> types, final RTime start, final RTime end, final omero.sys.Parameters p, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.PRIMITIVE_MAP);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "countByPeriod", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                omero.sys.Parameters pWithParameters = TimelineI.this.applyDefaults(p);
                return TimelineI.this.do_periodQuery(true, types, start, end, -1L, session, pWithParameters);
            }
        }));
    }

    @Override
    public void getByPeriod_async(AMD_ITimeline_getByPeriod __cb, final List<String> types, final RTime start, final RTime end, final omero.sys.Parameters p, final boolean merge, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.PRIMITIVE_FILTERABLE_COLLECTION_MAP);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getByPeriod", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                omero.sys.Parameters pWithDefaults = TimelineI.this.applyDefaults(p);
                Map returnValue = TimelineI.this.do_periodQuery(false, types, start, end, null, session, pWithDefaults);
                if (merge) {
                    returnValue = TimelineI.this.mergeMap(returnValue, pWithDefaults, false);
                }
                return returnValue;
            }
        }));
    }

    @Override
    public void getEventLogsByPeriod_async(AMD_ITimeline_getEventLogsByPeriod __cb, final RTime start, final RTime end, final omero.sys.Parameters p, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.FILTERABLE_COLLECTION);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getEventLogsByPeriod", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                omero.sys.Parameters pWithDefaults = TimelineI.this.applyDefaults(p);
                Map events = TimelineI.this.do_periodQuery(false, Arrays.asList("EventLog"), start, end, null, session, pWithDefaults);
                List logs = (List)events.get("EventLog");
                QueryBuilder qb = new QueryBuilder(256);
                qb.select(new String[]{"i"});
                qb.from("Image", "i");
                qb.join("i.details.owner", "owner", true, true);
                qb.join("i.details.group", "group", true, true);
                qb.where();
                qb.and("i.acquisitionDate > :start ");
                qb.param("start", (Object)new Timestamp(start.getValue()));
                qb.and("i.acquisitionDate < :end ");
                qb.param("end", (Object)new Timestamp(end.getValue()));
                TimelineI.this.applyOwnerGroup(pWithDefaults, qb, "owner.id", "group.id");
                Query q = qb.query(session);
                TimelineI.this.applyParameters(pWithDefaults, q);
                List images = q.list();
                for (Image image : images) {
                    EventLog el = new EventLog();
                    el.setEntityId(image.getId());
                    el.setEntityType(image.getClass().getName());
                    el.setAction("INSERT");
                    el.setEvent(new Event());
                    el.getEvent().setTime(image.getAcquisitionDate());
                    logs.add(el);
                }
                return logs;
            }
        }));
    }

    @Override
    public void getMostRecentObjects_async(AMD_ITimeline_getMostRecentObjects __cb, final List<String> types, final omero.sys.Parameters p, final boolean merge, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.PRIMITIVE_FILTERABLE_COLLECTION_MAP);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getMostRecentObjects", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                omero.sys.Parameters pWithDefaults = TimelineI.this.applyDefaults(p);
                Map returnValue = TimelineI.this.do_periodQuery(false, types, null, null, null, session, pWithDefaults);
                if (merge) {
                    returnValue = TimelineI.this.mergeMap(returnValue, pWithDefaults, false);
                }
                return returnValue;
            }
        }));
    }

    @Override
    public void getMostRecentAnnotationLinks_async(AMD_ITimeline_getMostRecentAnnotationLinks __cb, final List<String> parentTypes, final List<String> childTypes, final List<String> namespaces, final omero.sys.Parameters p, Current __current) throws ServerError {
        final IceMapper mapper = new IceMapper(IceMapper.FILTERABLE_COLLECTION);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getMostRecentAnnotationLinks", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                omero.sys.Parameters pWithDefaults = TimelineI.this.applyDefaults(p);
                HashMap<String, List> rv = new HashMap<String, List>();
                List<String> _parentTypes = parentTypes == null || parentTypes.size() == 0 ? Arrays.asList("Project", "Dataset", "Image") : parentTypes;
                for (String _parentType : _parentTypes) {
                    QueryBuilder qb = new QueryBuilder();
                    qb.select(new String[]{"link"});
                    qb.from(_parentType + "AnnotationLink", "link");
                    qb.join("link.parent", "parent", false, false);
                    qb.join("link.child", "child", false, true);
                    qb.join("link.details.creationEvent", "creation", false, true);
                    qb.join("link.details.updateEvent", "update", false, true);
                    qb.where();
                    qb.and("TRUE = TRUE ");
                    if (childTypes != null && childTypes.size() > 0) {
                        if (childTypes.size() > 1) {
                            throw new ApiUsageException("HHH-879: You can only restrict to a single annotation type at the moment");
                        }
                        for (String _childType : childTypes) {
                            try {
                                Class<? extends IObject> kls = IceMapper.omeroClass(_childType, true);
                                qb.and("child.class = " + kls.getName());
                            }
                            catch (Exception e) {
                                throw new ValidationException("Error mapping: " + _childType);
                            }
                        }
                    }
                    if (namespaces != null && namespaces.size() > 0) {
                        qb.and(" ( ");
                        String param = qb.unique_alias("ns");
                        qb.append("child.ns like :" + param);
                        qb.param(param, namespaces.get(0));
                        for (int i = 1; i < namespaces.size(); ++i) {
                            qb.append(" OR ");
                            String param2 = qb.unique_alias("ns");
                            qb.append("child.ns like :" + param2);
                            qb.param(param2, namespaces.get(i));
                        }
                        qb.append(" ) ");
                    }
                    TimelineI.this.applyOwnerGroup(p, qb, "link.details.owner.id", "link.details.group.id");
                    qb.order("link.details.updateEvent.id", false);
                    Query q = qb.query(session);
                    TimelineI.this.applyParameters(p, q);
                    rv.put(_parentType, q.list());
                }
                return TimelineI.this.mergeList(rv, pWithDefaults, false);
            }
        }));
    }

    @Override
    public void getMostRecentShareCommentLinks_async(AMD_ITimeline_getMostRecentShareCommentLinks __cb, final omero.sys.Parameters p, Current __current) throws ServerError {
        final IceMapper mapper = new IceMapper(IceMapper.FILTERABLE_COLLECTION);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.factory.getExecutor(), this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "getMostRecentShareComments", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, final ServiceFactory sf) {
                Parameters ome_p;
                IShare sh = sf.getShareService();
                Set shares = sh.getOwnShares(false);
                Set shares2 = sh.getMemberShares(false);
                shares.addAll(shares2);
                if (shares.size() == 0) {
                    return new ArrayList();
                }
                long userId = sf.getAdminService().getEventContext().getCurrentUserId();
                HashSet<Long> ids = new HashSet<Long>();
                for (Session s : shares) {
                    ids.add(s.getId());
                }
                omero.sys.Parameters pWithDefaults = TimelineI.this.applyDefaults(p);
                try {
                    ome_p = mapper.convert(pWithDefaults);
                }
                catch (omero.ApiUsageException e) {
                    throw new InternalException("Failed to convert parameters" + e.getMessage());
                }
                ome_p.addId(Long.valueOf(userId));
                ome_p.addIds(ids);
                final ArrayList rv = new ArrayList();
                TimelineI.this.ss.runAsAdmin(new AdminAction(){

                    public void runAsAdmin() {
                        List links = sf.getQueryService().findAllByQuery(TimelineI.LOOKUP_SHARE_COMMENTS, ome_p);
                        rv.addAll(links);
                    }
                });
                return rv;
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<?, ?> do_periodQuery(boolean count, List<String> types, RTime start, RTime end, Object missingValue, org.hibernate.Session _s, omero.sys.Parameters parameters) {
        long activeStart = start != null ? start.getValue() : rtypes.rtime_min().getValue();
        long activeEnd = end != null ? end.getValue() : rtypes.rtime_max().getValue();
        List<String> activeTypes = types;
        if (types == null || types.size() == 0) {
            activeTypes = new ArrayList<String>(ALLTYPES);
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        for (String type : activeTypes) {
            String orderBy;
            String qString = BYPERIOD.get(type);
            if (qString == null) {
                returnValue.put(type, missingValue);
                continue;
            }
            QueryBuilder qb = new QueryBuilder(256);
            if (count) {
                qb.select(new String[]{"count(obj)"});
                qb.skipFrom();
                qb.append(qString.replaceAll("@FETCH@", ""));
            } else {
                qb.select(new String[]{"obj"});
                qb.skipFrom();
                qb.append(qString.replaceAll("@FETCH@", "fetch"));
            }
            qb.skipWhere();
            String owningObject = OWNERSHIP.get(type);
            if (owningObject == null) {
                if (!"EventLog".equals(type)) throw new InternalException("No ownership info for: " + type);
                if (parameters != null && parameters.theFilter != null && parameters.theFilter.ownerId != null) {
                    qb.and("e.experimenter.id = :owner_id");
                    qb.param("owner_id", (Object)parameters.theFilter.ownerId.getValue());
                }
                qb.append(")");
            } else {
                this.applyOwnerGroup(parameters, qb, owningObject + ".details.owner.id", owningObject + ".details.group.id");
            }
            if (!count && (orderBy = ORDERBY.get(type)) != null) {
                qb.append(orderBy);
            }
            qb.param("start", (Object)new Timestamp(activeStart));
            qb.param("end", (Object)new Timestamp(activeEnd));
            Query q = qb.query(_s);
            this.applyParameters(parameters, q);
            if (count) {
                returnValue.put(type, q.uniqueResult());
                continue;
            }
            returnValue.put(type, q.list());
        }
        return returnValue;
    }

    private void applyParameters(omero.sys.Parameters parameters, Query q) {
        int limit = Integer.MAX_VALUE;
        int offset = 0;
        if (parameters != null && parameters.theFilter != null) {
            Filter f = parameters.theFilter;
            if (f.offset != null) {
                offset = f.offset.getValue();
            }
            if (f.limit != null) {
                limit = f.limit.getValue();
            }
        }
        q.setFirstResult(offset);
        q.setMaxResults(limit);
    }

    private long defaultId() {
        String session = this.factory.sessionId().name;
        return this.sm.getEventContext(new Principal(session)).getCurrentUserId();
    }

    private List<Entry> mergeEntries(Map<String, List<IObject>> toMerge, omero.sys.Parameters p, boolean ascending) {
        final int swap = ascending ? 1 : -1;
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (String key : toMerge.keySet()) {
            for (IObject obj : toMerge.get(key)) {
                list.add(new Entry(key, obj));
            }
        }
        Collections.sort(list, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                long u2;
                long u1 = o1.update.getTime();
                if (u1 < (u2 = o2.update.getTime())) {
                    return 1 * swap;
                }
                if (u2 < u1) {
                    return -1 * swap;
                }
                return 0;
            }
        });
        return list;
    }

    private List<IObject> mergeList(Map<String, List<IObject>> toMerge, omero.sys.Parameters p, boolean ascending) {
        List<Entry> list = this.mergeEntries(toMerge, p, ascending);
        ArrayList<IObject> rv = new ArrayList<IObject>();
        int limit = p.theFilter.limit.getValue();
        for (int i = 0; i < Math.min(limit, list.size()); ++i) {
            Entry entry = list.get(i);
            rv.add(entry.obj);
        }
        return rv;
    }

    private Map<String, List<IObject>> mergeMap(Map<String, List<IObject>> toMerge, omero.sys.Parameters p, boolean ascending) {
        HashMap<String, List<IObject>> rv = new HashMap<String, List<IObject>>();
        for (String key : toMerge.keySet()) {
            rv.put(key, new ArrayList());
        }
        List<Entry> list = this.mergeEntries(toMerge, p, ascending);
        toMerge = null;
        int limit = p.theFilter.limit.getValue();
        for (int i = 0; i < Math.min(limit, list.size()); ++i) {
            Entry entry = list.get(i);
            List objs = (List)rv.get(entry.key);
            objs.add(entry.obj);
        }
        return rv;
    }

    private omero.sys.Parameters applyDefaults(omero.sys.Parameters p) {
        if (p == null) {
            p = new omero.sys.Parameters();
        }
        if (p.theFilter == null) {
            p.theFilter = new Filter();
        }
        if (p.theFilter.offset == null) {
            p.theFilter.offset = rtypes.rint(0);
        }
        if (p.theFilter.limit == null) {
            p.theFilter.limit = rtypes.rint(50);
        }
        if (p.theFilter.groupId == null) {
            if (p.theFilter.ownerId == null) {
                p.theFilter.ownerId = rtypes.rlong(this.defaultId());
            } else if (p.theFilter.ownerId.getValue() == -1L) {
                p.theFilter.ownerId = null;
            }
        }
        return p;
    }

    private void applyOwnerGroup(omero.sys.Parameters p, QueryBuilder qb, String ownerPath, String groupPath) {
        if (p != null && p.theFilter != null) {
            Filter f = p.theFilter;
            if (f.ownerId != null) {
                qb.and(ownerPath + " = :owner_id ");
                qb.param("owner_id", (Object)f.ownerId.getValue());
            }
            if (f.groupId != null) {
                qb.and(groupPath + " = :group_id ");
                qb.param("group_id", (Object)f.groupId.getValue());
            }
        }
    }

    static {
        String WHERE_OBJ_DETAILS = "where    (obj.details.creationEvent.time >= :start   or obj.details.updateEvent.time  >= :start) and (obj.details.creationEvent.time <= :end or obj.details.updateEvent.time <= :end ) ";
        BYPERIOD.put("Project", "from Project obj join @FETCH@ obj.details.creationEvent join @FETCH@ obj.details.owner join @FETCH@ obj.details.group " + WHERE_OBJ_DETAILS);
        OWNERSHIP.put("Project", "obj");
        ORDERBY.put("Project", "order by obj.details.updateEvent.id desc");
        BYPERIOD.put("Dataset", "from Dataset obj join @FETCH@ obj.details.creationEvent join @FETCH@ obj.details.owner join @FETCH@ obj.details.group " + WHERE_OBJ_DETAILS);
        OWNERSHIP.put("Dataset", "obj");
        ORDERBY.put("Dataset", "order by obj.details.updateEvent.id desc");
        BYPERIOD.put("RenderingDef", "from RenderingDef obj join @FETCH@ obj.details.creationEvent join @FETCH@ obj.details.owner join @FETCH@ obj.details.group left outer join @FETCH@ obj.pixels p left outer join @FETCH@ p.image i " + WHERE_OBJ_DETAILS);
        OWNERSHIP.put("RenderingDef", "i");
        ORDERBY.put("RenderingDef", "order by i.details.creationEvent.time desc");
        BYPERIOD.put("Image", "from Image obj join @FETCH@ obj.details.creationEvent join @FETCH@ obj.details.owner join @FETCH@ obj.details.group where       obj.acquisitionDate >= :start and   obj.acquisitionDate <= :end ");
        OWNERSHIP.put("Image", "obj");
        ORDERBY.put("Image", "order by obj.acquisitionDate desc");
        BYPERIOD.put("EventLog", "from EventLog obj left outer join @FETCH@ obj.event ev where     obj.entityType in (        'ome.model.containers.Dataset',         'ome.model.containers.Project')     and obj.action in ( 'INSERT', 'UPDATE')     and ev.id in (             select e.id from Event e where         e.time >= :start and e.time <= :end ");
    }

    static class Entry {
        final Timestamp update;
        final String key;
        final IObject obj;

        Entry(String key, IObject obj) {
            this.key = key;
            this.obj = obj;
            this.update = obj.getDetails().getUpdateEvent().getTime();
        }
    }
}

