/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.gateway.services.impl;

import java.awt.Color;
import ome.services.blitz.gateway.services.RenderingService;
import omero.ServerError;
import omero.api.RenderingEnginePrx;
import omero.model.Pixels;
import omero.romio.PlaneDef;

public class RenderingServiceImpl
implements RenderingService {
    private RenderingEnginePrx renderingEngine;

    public RenderingServiceImpl(RenderingEnginePrx renderingEngine) {
        this.renderingEngine = renderingEngine;
    }

    private void lookupPixels(long pixelsId) throws ServerError {
        this.renderingEngine.lookupPixels(pixelsId);
    }

    private void setPixelsId(long pixelsId) throws ServerError {
        this.renderingEngine.lookupPixels(pixelsId);
        if (!this.renderingEngine.lookupRenderingDef(pixelsId)) {
            this.renderingEngine.resetDefaults();
        }
        this.renderingEngine.lookupRenderingDef(pixelsId);
        this.renderingEngine.load();
    }

    public synchronized double getChannelWindowEnd(Long pixelsId, int w) throws ServerError {
        this.setPixelsId(pixelsId);
        return this.renderingEngine.getChannelWindowEnd(w);
    }

    public synchronized double getChannelWindowStart(Long pixelsId, int w) throws ServerError {
        this.setPixelsId(pixelsId);
        return this.renderingEngine.getChannelWindowStart(w);
    }

    public synchronized int getDefaultT(Long pixelsId) throws ServerError {
        this.setPixelsId(pixelsId);
        return this.renderingEngine.getDefaultT();
    }

    public synchronized int getDefaultZ(Long pixelsId) throws ServerError {
        this.setPixelsId(pixelsId);
        return this.renderingEngine.getDefaultZ();
    }

    public synchronized Pixels getPixels(Long pixelsId) throws ServerError {
        this.setPixelsId(pixelsId);
        return this.renderingEngine.getPixels();
    }

    public synchronized boolean isActive(Long pixelsId, int w) throws ServerError {
        this.setPixelsId(pixelsId);
        return this.renderingEngine.isActive(w);
    }

    public synchronized int[] renderAsPackedInt(Long pixelsId, int z, int t) throws ServerError {
        PlaneDef def = new PlaneDef();
        def.t = t;
        def.z = z;
        def.x = 0;
        def.y = 0;
        def.slice = 0;
        this.setPixelsId(pixelsId);
        return this.renderingEngine.renderAsPackedInt(def);
    }

    public synchronized void setActive(Long pixelsId, int w, boolean active) throws ServerError {
        this.setPixelsId(pixelsId);
        this.renderingEngine.setActive(w, active);
    }

    public synchronized void setChannelWindow(Long pixelsId, int w, double start, double end) throws ServerError {
        this.setPixelsId(pixelsId);
        this.renderingEngine.setChannelWindow(w, start, end);
    }

    public synchronized void setDefaultT(Long pixelsId, int t) throws ServerError {
        this.setPixelsId(pixelsId);
        this.renderingEngine.setDefaultT(t);
    }

    public synchronized void setDefaultZ(Long pixelsId, int z) throws ServerError {
        this.setPixelsId(pixelsId);
        this.renderingEngine.setDefaultZ(z);
    }

    public synchronized int[] getRenderedImage(long pixelsId, int z, int t) throws ServerError {
        Pixels pixels = this.getPixels(pixelsId);
        return this.renderAsPackedInt(pixelsId, z, t);
    }

    public synchronized int[][][] getRenderedImageMatrix(long pixelsId, int z, int t) throws ServerError {
        Pixels pixels = this.getPixels(pixelsId);
        int width = pixels.getSizeX().getValue();
        int height = pixels.getSizeY().getValue();
        int[][][] data = new int[width][height][3];
        int[] buff = this.renderAsPackedInt(pixelsId, z, t);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int offset = width * y + x;
                Color col = new Color(buff[offset]);
                data[x][y][0] = col.getRed();
                data[x][y][1] = col.getGreen();
                data[x][y][2] = col.getBlue();
            }
        }
        return data;
    }

    public synchronized int[] renderAsPackedIntAsRGBA(long pixelsId, int z, int t) throws ServerError {
        PlaneDef def = new PlaneDef();
        def.t = t;
        def.z = z;
        def.x = 0;
        def.y = 0;
        def.slice = 0;
        this.setPixelsId(pixelsId);
        return this.renderingEngine.renderAsPackedIntAsRGBA(def);
    }
}

