/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.gateway.services.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.services.blitz.gateway.services.DataService;
import ome.services.blitz.gateway.services.GatewayFactory;
import ome.services.blitz.gateway.services.util.ServiceUtilities;
import omero.RType;
import omero.ServerError;
import omero.api.ContainerClass;
import omero.api.IContainerPrx;
import omero.api.IQueryPrx;
import omero.api.IScriptPrx;
import omero.api.ITypesPrx;
import omero.api.IUpdatePrx;
import omero.model.Dataset;
import omero.model.DatasetImageLinkI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Pixels;
import omero.model.PixelsType;
import omero.model.Project;
import omero.sys.ParametersI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceImpl
implements DataService {
    GatewayFactory gatewayFactory;

    public DataServiceImpl(GatewayFactory gatewayFactory) {
        this.gatewayFactory = gatewayFactory;
    }

    private String convertContainer(ContainerClass nodeType) {
        return nodeType.name();
    }

    @Override
    public void attachImageToDataset(Dataset dataset, Image image) throws ServerError {
        IUpdatePrx iUpdate = this.gatewayFactory.getIUpdate();
        DatasetImageLinkI link = new DatasetImageLinkI();
        link.setParent(dataset);
        link.setChild(image);
        dataset.addDatasetImageLinkToBoth(link, true);
        iUpdate.saveObject(link);
    }

    @Override
    public void deleteObject(IObject row) throws ServerError {
        IUpdatePrx iUpdate = this.gatewayFactory.getIUpdate();
        iUpdate.deleteObject(row);
    }

    @Override
    public List<IObject> findAllByQuery(String myQuery) throws ServerError {
        IQueryPrx iQuery = this.gatewayFactory.getIQuery();
        return iQuery.findAllByQuery(myQuery, null);
    }

    @Override
    public IObject findByQuery(String myQuery) throws ServerError {
        IQueryPrx iQuery = this.gatewayFactory.getIQuery();
        return iQuery.findByQuery(myQuery, null);
    }

    @Override
    public List<Dataset> getDatasets(List<Long> ids, boolean getLeaves) throws ServerError {
        IContainerPrx iContainerService = this.gatewayFactory.getIContainer();
        ParametersI p = new ParametersI();
        if (getLeaves) {
            p.leaves();
        }
        return ServiceUtilities.collectionCast(Dataset.class, iContainerService.loadContainerHierarchy(this.convertContainer(ContainerClass.Dataset), ids, p));
    }

    @Override
    public List<Image> getImageByName(String imageName) throws ServerError {
        String datasetQuery = "select i from Image i left outer join fetch i.datasetLinks dil left outer join fetch dil.parent d where i.name like '%" + imageName + "%' order by i.name";
        List<IObject> imageList = this.findAllByQuery(datasetQuery);
        return imageList;
    }

    @Override
    public List<Image> getImageFromDatasetByName(Long datasetId, String imageName) throws ServerError {
        String datasetQuery = "select i from Image i left outer join fetch i.datasetLinks dil left outer join fetch dil.parent d where d.id=" + datasetId + " and  i.name like '%" + imageName + "%' order by i.name";
        List<IObject> imageList = this.findAllByQuery(datasetQuery);
        return imageList;
    }

    @Override
    public List<Image> getImages(ContainerClass nodeType, List<Long> nodeIds) throws ServerError {
        IContainerPrx iContainerService = this.gatewayFactory.getIContainer();
        HashMap<String, RType> map = new HashMap<String, RType>();
        return iContainerService.getImages(this.convertContainer(nodeType), nodeIds, new ParametersI(map));
    }

    @Override
    public PixelsType getPixelType(String type) throws ServerError {
        IQueryPrx iQuery = this.gatewayFactory.getIQuery();
        return (PixelsType)iQuery.findByString("PixelsType", "value", type);
    }

    @Override
    public List<PixelsType> getPixelTypes() throws ServerError {
        ITypesPrx iTypes = this.gatewayFactory.getITypes();
        List<IObject> list = iTypes.allEnumerations("PixelsType");
        return ServiceUtilities.collectionCast(PixelsType.class, list);
    }

    @Override
    public List<Pixels> getPixelsFromImage(long imageId) throws ServerError {
        IQueryPrx iQuery = this.gatewayFactory.getIQuery();
        String queryStr = new String("select p from Pixels as p left outer join fetch p.pixelsType as pt where p.image = " + imageId + " order by relatedto");
        return ServiceUtilities.collectionCast(Pixels.class, iQuery.findAllByQuery(queryStr, null));
    }

    @Override
    public List<Project> getProjects(List<Long> ids, boolean getLeaves) throws ServerError {
        IContainerPrx iContainerService = this.gatewayFactory.getIContainer();
        ParametersI p = new ParametersI();
        if (getLeaves) {
            p.leaves();
        }
        return ServiceUtilities.collectionCast(Project.class, iContainerService.loadContainerHierarchy(this.convertContainer(ContainerClass.Project), ids, p));
    }

    @Override
    public <T extends IObject> List<T> saveAndReturnArray(List<IObject> graph) throws ServerError {
        IUpdatePrx iUpdate = this.gatewayFactory.getIUpdate();
        List<IObject> rv = iUpdate.saveAndReturnArray(graph);
        return rv;
    }

    @Override
    public IObject saveAndReturnObject(IObject obj) throws ServerError {
        IUpdatePrx iUpdate = this.gatewayFactory.getIUpdate();
        return iUpdate.saveAndReturnObject(obj);
    }

    @Override
    public void saveArray(List<IObject> graph) throws ServerError {
        IUpdatePrx iUpdate = this.gatewayFactory.getIUpdate();
        iUpdate.saveArray(graph);
    }

    @Override
    public void saveObject(IObject obj) throws ServerError {
        IUpdatePrx iUpdate = this.gatewayFactory.getIUpdate();
        iUpdate.saveObject(obj);
    }

    @Override
    public Pixels updatePixels(Pixels object) throws ServerError {
        IUpdatePrx iUpdate = this.gatewayFactory.getIUpdate();
        return (Pixels)iUpdate.saveAndReturnObject(object);
    }

    @Override
    public void deleteScript(long id) throws ServerError {
        IScriptPrx iScript = this.gatewayFactory.getIScript();
        iScript.deleteScript(id);
    }

    @Override
    public Map<String, RType> getParams(long id) throws ServerError {
        IScriptPrx iScript = this.gatewayFactory.getIScript();
        return iScript.getParams(id);
    }

    @Override
    public String getScript(long id) throws ServerError {
        IScriptPrx iScript = this.gatewayFactory.getIScript();
        return iScript.getScript(id);
    }

    @Override
    public long getScriptID(String name) throws ServerError {
        IScriptPrx iScript = this.gatewayFactory.getIScript();
        return iScript.getScriptID(name);
    }

    @Override
    public Map<Long, String> getScripts() throws ServerError {
        IScriptPrx iScript = this.gatewayFactory.getIScript();
        return iScript.getScripts();
    }

    @Override
    public Map<String, RType> runScript(long id, Map<String, RType> map) throws ServerError {
        IScriptPrx iScript = this.gatewayFactory.getIScript();
        return iScript.runScript(id, map);
    }

    @Override
    public long uploadScript(String script) throws ServerError {
        IScriptPrx iScript = this.gatewayFactory.getIScript();
        return iScript.uploadScript(script);
    }
}

