/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.UnknownException;
import IceGrid.QueryPrx;
import IceGrid.QueryPrxHelper;
import IceStorm.AlreadySubscribed;
import IceStorm.BadQoS;
import IceStorm.NoSuchTopic;
import IceStorm.TopicExists;
import IceStorm.TopicManagerPrx;
import IceStorm.TopicManagerPrxHelper;
import IceStorm.TopicPrx;
import java.lang.reflect.Method;
import omero.ApiUsageException;
import omero.InternalException;
import omero.ServerError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public interface TopicManager
extends ApplicationListener {
    public void register(String var1, ObjectPrx var2) throws ServerError;

    public static final class Impl
    implements TopicManager {
        private static final Log log = LogFactory.getLog(Impl.class);
        private final Communicator communicator;

        public Impl(Communicator communicator) {
            this.communicator = communicator;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof TopicMessage) {
                TopicManagerPrx topicManager = this.managerOrNull();
                if (topicManager == null) {
                    log.warn((Object)"No topic manager");
                    return;
                }
                TopicMessage msg = (TopicMessage)event;
                try {
                    ObjectPrx obj = this.publisherOrNull(msg.topic);
                    msg.base.__copyFrom(obj);
                    Method m = null;
                    for (Method check : msg.base.getClass().getMethods()) {
                        if (!check.getName().equals(msg.method) || check.getParameterTypes().length != msg.args.length) continue;
                        if (m != null) {
                            String err = String.format("More than one method named \"%s\" with %s arguments", msg.method, msg.args);
                            log.error((Object)err);
                            continue;
                        }
                        m = check;
                    }
                    if (m == null) {
                        log.error((Object)String.format("No method named \"%s\" with %s arguments", msg.method, msg.args));
                    }
                    m.invoke((Object)msg.base, msg.args);
                }
                catch (Exception e) {
                    log.error((Object)("Error publishing to topic:" + msg.topic), (Throwable)e);
                }
            }
        }

        public void register(String topicName, ObjectPrx prx) throws ServerError {
            String id = prx.ice_id();
            id = id.replaceFirst("::", "");
            id = id.replace("::", ".");
            id = id + "PrxHelper";
            Class<?> pubClass = null;
            try {
                pubClass = Class.forName(id);
            }
            catch (ClassNotFoundException e) {
                throw new ApiUsageException(null, null, "Unknown type for proxy: " + prx.ice_id());
            }
            TopicPrx topic = this.topicOrNull(topicName);
            while (topic != null) {
                try {
                    topic.subscribeAndGetPublisher(null, prx);
                    break;
                }
                catch (UnknownException ue) {
                    log.warn((Object)"Unknown exception on subscribeAndGetPublisher");
                }
                catch (AlreadySubscribed e) {
                    throw new ApiUsageException(null, null, "Proxy already subscribed: " + prx);
                }
                catch (BadQoS e) {
                    throw new InternalException(null, null, "BadQos in TopicManager.subscribe");
                }
            }
        }

        protected TopicManagerPrx managerOrNull() {
            ObjectPrx objectPrx = this.communicator.stringToProxy("IceGrid/Query");
            ObjectPrx[] candidates = null;
            try {
                QueryPrx query = QueryPrxHelper.checkedCast((ObjectPrx)objectPrx);
                candidates = query.findAllObjectsByType("::IceStorm::TopicManager");
            }
            catch (CommunicatorDestroyedException cde) {
                return null;
            }
            catch (Exception e) {
                log.warn((Object)"Error querying for topic manager", (Throwable)e);
            }
            TopicManagerPrx tm = null;
            if (candidates == null || candidates.length == 0) {
                log.warn((Object)"Found no topic manager");
            } else if (candidates.length > 1) {
                log.warn((Object)("Found wrong number of topic managers: " + candidates.length));
            } else {
                try {
                    tm = TopicManagerPrxHelper.checkedCast((ObjectPrx)candidates[0]);
                }
                catch (Exception e) {
                    log.warn((Object)"Could not cast to TopicManager", (Throwable)e);
                }
            }
            return tm;
        }

        protected TopicPrx topicOrNull(String name) {
            TopicManagerPrx topicManager = this.managerOrNull();
            TopicPrx topic = null;
            if (topicManager != null) {
                try {
                    topic = topicManager.create(name);
                }
                catch (TopicExists ex2) {
                    try {
                        topic = topicManager.retrieve(name);
                    }
                    catch (NoSuchTopic e) {
                        throw new RuntimeException("Race condition retriving topic: " + name);
                    }
                }
            }
            return topic;
        }

        protected ObjectPrx publisherOrNull(String name) {
            TopicPrx topic = this.topicOrNull(name);
            ObjectPrx pub = null;
            if (topic != null) {
                pub = topic.getPublisher().ice_oneway();
            }
            return pub;
        }
    }

    public static final class TopicMessage
    extends ApplicationEvent {
        private final String topic;
        private final ObjectPrxHelperBase base;
        private final String method;
        private final Object[] args;

        public TopicMessage(Object source, String topic, ObjectPrxHelperBase base, String method, Object ... args) {
            super(source);
            this.topic = topic;
            this.base = base;
            this.method = method;
            this.args = args;
        }
    }
}

