/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Locale;

public class LSID {
    private Class klass;
    private int[] indexes;
    private String asString;
    private int hashCode;
    private final RuleBasedCollator stringComparator = (RuleBasedCollator)Collator.getInstance(Locale.ENGLISH);

    public LSID(Class klass, int ... indexes) {
        this.klass = klass;
        this.indexes = indexes;
        this.asString = klass.getName();
        for (int index : indexes) {
            this.asString = this.asString + ":" + index;
        }
        this.hashCode = this.asString.hashCode();
    }

    public LSID(String asString) {
        this.asString = asString;
        this.hashCode = asString.hashCode();
    }

    public LSID(String asString, boolean parse) {
        this.asString = asString;
        this.hashCode = asString.hashCode();
        if (parse) {
            this.klass = this.parseJavaClass();
            this.indexes = this.parseIndexes();
        }
    }

    public Class getJavaClass() {
        return this.klass;
    }

    public Class parseJavaClass() {
        int colonIndex = this.asString.indexOf(":");
        if (colonIndex > -1) {
            try {
                return Class.forName(this.asString.substring(0, colonIndex));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public int[] parseIndexes() {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int colonIndex = this.asString.indexOf(":");
        while (colonIndex > -1) {
            String s;
            int nextIndex = this.asString.indexOf(":", colonIndex + 1);
            if (nextIndex > -1) {
                s = this.asString.substring(colonIndex + 1, nextIndex);
                indexList.add(Integer.parseInt(s));
                colonIndex = nextIndex;
                continue;
            }
            s = this.asString.substring(colonIndex + 1);
            indexList.add(Integer.parseInt(s));
            break;
        }
        int[] toReturn = new int[indexList.size()];
        for (int i = 0; i < indexList.size(); ++i) {
            toReturn[i] = (Integer)indexList.get(i);
        }
        return toReturn;
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public String toString() {
        return this.asString;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LSID) {
            LSID comparator = (LSID)obj;
            Class comparatorClass = comparator.getJavaClass();
            if (comparatorClass == null || this.klass == null) {
                return this.stringComparator.compare(this.asString, obj.toString()) == 0;
            }
            if (comparatorClass.equals(this.klass)) {
                int[] comparatorIndexes = comparator.getIndexes();
                for (int i = 0; i < this.indexes.length; ++i) {
                    if (this.indexes[i] == comparatorIndexes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return super.equals(obj);
    }
}

