/*
 * Decompiled with CFR 0.152.
 */
package ome.model.display;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.display.CodomainMapContext;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@PrimaryKeyJoinColumn(name="codomainmapcontext_id")
@Table(name="contraststretchingcontext")
@ForeignKey(name="FKcontraststretchingcontext_codomainmapcontext_id_codomainmapcontext")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class ContrastStretchingContext
extends CodomainMapContext
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "contraststretchingcontext_owner_filter";
    public static final String GROUP_FILTER = "contraststretchingcontext_group_filter";
    public static final String EVENT_FILTER = "contraststretchingcontext_event_filter";
    public static final String PERMS_FILTER = "contraststretchingcontext_perms_filter";
    protected Integer xstart = null;
    protected Integer ystart = null;
    protected Integer xend = null;
    protected Integer yend = null;
    public static final String XSTART = "ome.model.display.ContrastStretchingContext_xstart";
    public static final String YSTART = "ome.model.display.ContrastStretchingContext_ystart";
    public static final String XEND = "ome.model.display.ContrastStretchingContext_xend";
    public static final String YEND = "ome.model.display.ContrastStretchingContext_yend";
    public static final Set<String> FIELDS;

    public ContrastStretchingContext() {
        this(null, true);
    }

    protected ContrastStretchingContext(Long id) {
        this(id, true);
    }

    public ContrastStretchingContext(Long id, boolean loaded) {
        super(id, loaded);
    }

    public ContrastStretchingContext(Integer _xstart, Integer _ystart, Integer _xend, Integer _yend) {
        this(null, true);
        this.setXstart(_xstart);
        this.setYstart(_ystart);
        this.setXend(_xend);
        this.setYend(_yend);
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="xstart", updatable=true)
    public Integer getXstart() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.xstart;
    }

    public void setXstart(Integer xstart) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.xstart = xstart;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="ystart", updatable=true)
    public Integer getYstart() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.ystart;
    }

    public void setYstart(Integer ystart) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.ystart = ystart;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="xend", updatable=true)
    public Integer getXend() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.xend;
    }

    public void setXend(Integer xend) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.xend = xend;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="yend", updatable=true)
    public Integer getYend() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.yend;
    }

    public void setYend(Integer yend) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.yend = yend;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public ContrastStretchingContext newInstance() {
        return new ContrastStretchingContext();
    }

    public ContrastStretchingContext proxy() {
        return new ContrastStretchingContext(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.xstart = (Integer)__filter.filter(XSTART, this.xstart);
            this.ystart = (Integer)__filter.filter(YSTART, this.ystart);
            this.xend = (Integer)__filter.filter(XEND, this.xend);
            this.yend = (Integer)__filter.filter(YEND, this.yend);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(XSTART)) {
            return this.getXstart();
        }
        if (field.equals(YSTART)) {
            return this.getYstart();
        }
        if (field.equals(XEND)) {
            return this.getXend();
        }
        if (field.equals(YEND)) {
            return this.getYend();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(XSTART)) {
            this.setXstart((Integer)value);
        } else if (field.equals(YSTART)) {
            this.setYstart((Integer)value);
        } else if (field.equals(XEND)) {
            this.setXend((Integer)value);
        } else if (field.equals(YEND)) {
            this.setYend((Integer)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.xstart = null;
        this.ystart = null;
        this.xend = null;
        this.yend = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(XSTART);
        raw.addAll(CodomainMapContext.FIELDS);
        raw.add(YSTART);
        raw.addAll(CodomainMapContext.FIELDS);
        raw.add(XEND);
        raw.addAll(CodomainMapContext.FIELDS);
        raw.add(YEND);
        raw.addAll(CodomainMapContext.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

