/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.CommunicatorI;
import Ice.Identity;
import Ice.IdentityParseException;
import Ice.InitializationData;
import Ice.InputStream;
import Ice.InputStreamI;
import Ice.Logger;
import Ice.LoggerI;
import Ice.ObjectPrx;
import Ice.OutputStream;
import Ice.OutputStreamI;
import Ice.Properties;
import Ice.PropertiesI;
import Ice.StringHolder;
import Ice.StringSeqHolder;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.ProtocolPluginFacade;
import IceInternal.ProtocolPluginFacadeI;
import IceUtilInternal.StringUtil;
import java.net.InetAddress;
import java.rmi.server.UID;

public final class Util {
    private static String _localAddress = null;
    private static Object _processLoggerMutex = new Object();
    private static Logger _processLogger = null;

    public static Properties createProperties() {
        return new PropertiesI();
    }

    public static Properties createProperties(StringSeqHolder args) {
        return new PropertiesI(args, null);
    }

    public static Properties createProperties(StringSeqHolder args, Properties defaults) {
        return new PropertiesI(args, defaults);
    }

    public static Properties createProperties(String[] args) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.createProperties(argsH);
    }

    public static Properties createProperties(String[] args, Properties defaults) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.createProperties(argsH, defaults);
    }

    public static Communicator initialize(StringSeqHolder args) {
        return Util.initialize(args, null);
    }

    public static Communicator initialize(String[] args) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.initialize(argsH);
    }

    public static Communicator initialize(StringSeqHolder args, InitializationData initData) {
        initData = initData == null ? new InitializationData() : (InitializationData)initData.clone();
        initData.properties = Util.createProperties(args, initData.properties);
        CommunicatorI result = new CommunicatorI(initData);
        result.finishSetup(args);
        return result;
    }

    public static Communicator initialize(String[] args, InitializationData initData) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.initialize(argsH, initData);
    }

    public static Communicator initialize(InitializationData initData) {
        initData = initData == null ? new InitializationData() : (InitializationData)initData.clone();
        CommunicatorI result = new CommunicatorI(initData);
        result.finishSetup(new StringSeqHolder(new String[0]));
        return result;
    }

    public static Communicator initialize() {
        return Util.initialize(new InitializationData());
    }

    public static Instance getInstance(Communicator communicator) {
        CommunicatorI p = (CommunicatorI)communicator;
        return p.getInstance();
    }

    public static ProtocolPluginFacade getProtocolPluginFacade(Communicator communicator) {
        return new ProtocolPluginFacadeI(communicator);
    }

    public static Identity stringToIdentity(String s) {
        Identity ident = new Identity();
        int slash = -1;
        int pos = 0;
        while ((pos = s.indexOf(47, pos)) != -1) {
            if (pos == 0 || s.charAt(pos - 1) != '\\') {
                if (slash == -1) {
                    slash = pos;
                } else {
                    IdentityParseException ex = new IdentityParseException();
                    ex.str = s;
                    throw ex;
                }
            }
            ++pos;
        }
        if (slash == -1) {
            StringHolder token = new StringHolder();
            if (!StringUtil.unescapeString(s, 0, s.length(), token)) {
                IdentityParseException ex = new IdentityParseException();
                ex.str = s;
                throw ex;
            }
            ident.category = "";
            ident.name = token.value;
        } else {
            StringHolder token = new StringHolder();
            if (!StringUtil.unescapeString(s, 0, slash, token)) {
                IdentityParseException ex = new IdentityParseException();
                ex.str = s;
                throw ex;
            }
            ident.category = token.value;
            if (slash + 1 < s.length()) {
                if (!StringUtil.unescapeString(s, slash + 1, s.length(), token)) {
                    IdentityParseException ex = new IdentityParseException();
                    ex.str = s;
                    throw ex;
                }
                ident.name = token.value;
            } else {
                ident.name = "";
            }
        }
        return ident;
    }

    public static String identityToString(Identity ident) {
        if (ident.category == null || ident.category.length() == 0) {
            return StringUtil.escapeString(ident.name, "/");
        }
        return StringUtil.escapeString(ident.category, "/") + '/' + StringUtil.escapeString(ident.name, "/");
    }

    public static synchronized String generateUUID() {
        UID uid = new UID();
        if (_localAddress == null) {
            InetAddress addr = Network.getLocalAddress(2);
            byte[] ip = addr.getAddress();
            _localAddress = "";
            for (int i = 0; i < ip.length; ++i) {
                if (i > 0) {
                    _localAddress = _localAddress + ":";
                }
                int n = ip[i] < 0 ? ip[i] + 256 : ip[i];
                _localAddress = _localAddress + Integer.toHexString(n);
            }
        }
        return _localAddress + ":" + uid;
    }

    public static int proxyIdentityCompare(ObjectPrx lhs, ObjectPrx rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return 1;
        }
        Identity lhsIdentity = lhs.ice_getIdentity();
        Identity rhsIdentity = rhs.ice_getIdentity();
        int n = lhsIdentity.name.compareTo(rhsIdentity.name);
        if (n != 0) {
            return n;
        }
        return lhsIdentity.category.compareTo(rhsIdentity.category);
    }

    public static int proxyIdentityAndFacetCompare(ObjectPrx lhs, ObjectPrx rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return 1;
        }
        Identity lhsIdentity = lhs.ice_getIdentity();
        Identity rhsIdentity = rhs.ice_getIdentity();
        int n = lhsIdentity.name.compareTo(rhsIdentity.name);
        if (n != 0) {
            return n;
        }
        n = lhsIdentity.category.compareTo(rhsIdentity.category);
        if (n != 0) {
            return n;
        }
        String lhsFacet = lhs.ice_getFacet();
        String rhsFacet = rhs.ice_getFacet();
        if (lhsFacet == null && rhsFacet == null) {
            return 0;
        }
        if (lhsFacet == null) {
            return -1;
        }
        if (rhsFacet == null) {
            return 1;
        }
        return lhsFacet.compareTo(rhsFacet);
    }

    public static InputStream createInputStream(Communicator communicator, byte[] bytes) {
        return new InputStreamI(communicator, bytes);
    }

    public static OutputStream createOutputStream(Communicator communicator) {
        return new OutputStreamI(communicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getProcessLogger() {
        Object object = _processLoggerMutex;
        synchronized (object) {
            if (_processLogger == null) {
                _processLogger = new LoggerI("");
            }
            return _processLogger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProcessLogger(Logger logger) {
        Object object = _processLoggerMutex;
        synchronized (object) {
            _processLogger = logger;
        }
    }

    public static String stringVersion() {
        return "3.3.1";
    }

    public static int intVersion() {
        return 30301;
    }
}

