/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.FileException;
import Ice.InitializationException;
import Ice.Logger;
import Ice.Properties;
import Ice.StringSeqHolder;
import Ice.SyscallException;
import Ice.Util;
import IceInternal.PropertyNames;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesI
implements Properties {
    private static final int ParseStateKey = 0;
    private static final int ParseStateValue = 1;
    private HashMap<String, PropertyValue> _properties = new HashMap();

    @Override
    public synchronized String getProperty(String key) {
        String result = null;
        PropertyValue pv = this._properties.get(key);
        if (pv == null) {
            try {
                result = System.getProperty(key, "");
            }
            catch (SecurityException ex) {
                result = "";
            }
        } else {
            pv.used = true;
            result = pv.value;
        }
        return result;
    }

    @Override
    public synchronized String getPropertyWithDefault(String key, String value) {
        String result = null;
        PropertyValue pv = this._properties.get(key);
        if (pv == null) {
            try {
                result = System.getProperty(key, value);
            }
            catch (SecurityException ex) {
                result = value;
            }
        } else {
            pv.used = true;
            result = pv.value;
        }
        return result;
    }

    @Override
    public int getPropertyAsInt(String key) {
        return this.getPropertyAsIntWithDefault(key, 0);
    }

    @Override
    public synchronized int getPropertyAsIntWithDefault(String key, int value) {
        String result = null;
        PropertyValue pv = this._properties.get(key);
        if (pv == null) {
            try {
                result = System.getProperty(key);
            }
            catch (SecurityException ex) {}
        } else {
            pv.used = true;
            result = pv.value;
        }
        if (result == null) {
            return value;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException ex) {
            Util.getProcessLogger().warning("numeric property " + key + " set to non-numeric value, defaulting to " + value);
            return value;
        }
    }

    @Override
    public String[] getPropertyAsList(String key) {
        return this.getPropertyAsListWithDefault(key, null);
    }

    @Override
    public synchronized String[] getPropertyAsListWithDefault(String key, String[] value) {
        String[] arr;
        if (value == null) {
            value = new String[]{};
        }
        String result = null;
        PropertyValue pv = this._properties.get(key);
        if (pv == null) {
            try {
                result = System.getProperty(key);
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            if (result == null) {
                return value;
            }
        } else {
            pv.used = true;
            result = pv.value;
        }
        if ((arr = this.splitString(result, ", \t\r\n")) == null) {
            Util.getProcessLogger().warning("mismatched quotes in property " + key + "'s value, returning default value");
            return value;
        }
        return arr;
    }

    @Override
    public synchronized Map<String, String> getPropertiesForPrefix(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, PropertyValue> entry : this._properties.entrySet()) {
            String key = entry.getKey();
            if (prefix.length() != 0 && !key.startsWith(prefix)) continue;
            PropertyValue pv = entry.getValue();
            pv.used = true;
            result.put(key, pv.value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, String value) {
        if (key != null) {
            key = key.trim();
        }
        Logger logger = Util.getProcessLogger();
        if (key == null || key.length() == 0) {
            throw new InitializationException("Attempt to set property with empty key");
        }
        int dotPos = key.indexOf(46);
        if (dotPos != -1) {
            String prefix = key.substring(0, dotPos);
            int i = 0;
            while (PropertyNames.validProps[i] != null) {
                String pattern = PropertyNames.validProps[i][0].pattern();
                dotPos = pattern.indexOf(46);
                assert (dotPos != -1);
                String propPrefix = pattern.substring(0, dotPos - 1);
                if (propPrefix.equals(prefix)) {
                    boolean found = false;
                    int j = 0;
                    while (PropertyNames.validProps[i][j] != null && !found) {
                        pattern = PropertyNames.validProps[i][j].pattern();
                        Pattern pComp = Pattern.compile(pattern);
                        Matcher m = pComp.matcher(key);
                        found = m.matches();
                        if (found && PropertyNames.validProps[i][j].deprecated()) {
                            logger.warning("deprecated property: " + key);
                            if (PropertyNames.validProps[i][j].deprecatedBy() != null) {
                                key = PropertyNames.validProps[i][j].deprecatedBy();
                            }
                        }
                        ++j;
                    }
                    if (!found) {
                        logger.warning("unknown property: " + key);
                    }
                }
                ++i;
            }
        }
        PropertiesI propertiesI = this;
        synchronized (propertiesI) {
            if (value != null && value.length() > 0) {
                PropertyValue pv = this._properties.get(key);
                if (pv != null) {
                    pv.value = value;
                } else {
                    pv = new PropertyValue(value, false);
                }
                this._properties.put(key, pv);
            } else {
                this._properties.remove(key);
            }
        }
    }

    @Override
    public synchronized String[] getCommandLineOptions() {
        String[] result = new String[this._properties.size()];
        Iterator<Map.Entry<String, PropertyValue>> p = this._properties.entrySet().iterator();
        int i = 0;
        while (p.hasNext()) {
            Map.Entry<String, PropertyValue> entry = p.next();
            result[i++] = "--" + entry.getKey() + "=" + entry.getValue().value;
        }
        assert (i == result.length);
        return result;
    }

    @Override
    public String[] parseCommandLineOptions(String pfx, String[] options) {
        if (pfx.length() > 0 && pfx.charAt(pfx.length() - 1) != '.') {
            pfx = pfx + '.';
        }
        pfx = "--" + pfx;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < options.length; ++i) {
            String opt = options[i];
            if (opt.startsWith(pfx)) {
                if (opt.indexOf(61) == -1) {
                    opt = opt + "=1";
                }
                this.parseLine(opt.substring(2));
                continue;
            }
            result.add(opt);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String[] parseIceCommandLineOptions(String[] options) {
        String[] args = options;
        int i = 0;
        while (PropertyNames.clPropNames[i] != null) {
            args = this.parseCommandLineOptions(PropertyNames.clPropNames[i], args);
            ++i;
        }
        return args;
    }

    @Override
    public void load(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            this.parse(br);
        }
        catch (IOException ex) {
            FileException fe = new FileException();
            fe.path = file;
            fe.initCause(ex);
            throw fe;
        }
    }

    @Override
    public synchronized Properties _clone() {
        return new PropertiesI(this);
    }

    public synchronized List<String> getUnusedProperties() {
        ArrayList<String> unused = new ArrayList<String>();
        for (Map.Entry<String, PropertyValue> entry : this._properties.entrySet()) {
            PropertyValue pv = entry.getValue();
            if (pv.used) continue;
            unused.add(entry.getKey());
        }
        return unused;
    }

    PropertiesI(PropertiesI props) {
        for (Map.Entry<String, PropertyValue> entry : props._properties.entrySet()) {
            this._properties.put(entry.getKey(), new PropertyValue(entry.getValue()));
        }
    }

    PropertiesI() {
    }

    PropertiesI(StringSeqHolder args, Properties defaults) {
        if (defaults != null) {
            this._properties = new HashMap<String, PropertyValue>(((PropertiesI)defaults)._properties);
        }
        boolean loadConfigFiles = false;
        for (int i = 0; i < args.value.length; ++i) {
            if (!args.value[i].startsWith("--Ice.Config")) continue;
            String line = args.value[i];
            if (line.indexOf(61) == -1) {
                line = line + "=1";
            }
            this.parseLine(line.substring(2));
            loadConfigFiles = true;
            String[] arr = new String[args.value.length - 1];
            System.arraycopy(args.value, 0, arr, 0, i);
            if (i < args.value.length - 1) {
                System.arraycopy(args.value, i + 1, arr, i, args.value.length - i - 1);
            }
            args.value = arr;
        }
        if (!loadConfigFiles) {
            boolean bl = loadConfigFiles = !this._properties.containsKey("Ice.Config");
        }
        if (loadConfigFiles) {
            this.loadConfig();
        }
        args.value = this.parseIceCommandLineOptions(args.value);
    }

    private void parse(BufferedReader in) {
        try {
            String line;
            while ((line = in.readLine()) != null) {
                this.parseLine(line);
            }
        }
        catch (IOException ex) {
            SyscallException se = new SyscallException();
            se.initCause(ex);
            throw se;
        }
    }

    private void parseLine(String line) {
        String key = "";
        String value = "";
        int state = 0;
        String whitespace = "";
        String escapedspace = "";
        boolean finished = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '\\': {
                            if (i < line.length() - 1) {
                                c = line.charAt(++i);
                                switch (c) {
                                    case '#': 
                                    case '=': 
                                    case '\\': {
                                        key = key + whitespace;
                                        whitespace = "";
                                        key = key + c;
                                        break block0;
                                    }
                                    case ' ': {
                                        if (key.length() == 0) break block0;
                                        whitespace = whitespace + c;
                                        break block0;
                                    }
                                }
                                key = key + whitespace;
                                whitespace = "";
                                key = key + '\\';
                                key = key + c;
                                break block0;
                            }
                            key = key + whitespace;
                            key = key + c;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (key.length() == 0) break block0;
                            whitespace = whitespace + c;
                            break block0;
                        }
                        case '=': {
                            whitespace = "";
                            state = 1;
                            break block0;
                        }
                        case '#': {
                            finished = true;
                            break block0;
                        }
                    }
                    key = key + whitespace;
                    whitespace = "";
                    key = key + c;
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            if (i < line.length() - 1) {
                                c = line.charAt(++i);
                                switch (c) {
                                    case '#': 
                                    case '=': 
                                    case '\\': {
                                        value = value + (value.length() == 0 ? escapedspace : whitespace);
                                        whitespace = "";
                                        escapedspace = "";
                                        value = value + c;
                                        break block0;
                                    }
                                    case ' ': {
                                        whitespace = whitespace + c;
                                        escapedspace = escapedspace + c;
                                        break block0;
                                    }
                                }
                                value = value + (value.length() == 0 ? escapedspace : whitespace);
                                whitespace = "";
                                escapedspace = "";
                                value = value + '\\';
                                value = value + c;
                                break block0;
                            }
                            value = value + (value.length() == 0 ? escapedspace : whitespace);
                            value = value + c;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (value.length() == 0) break block0;
                            whitespace = whitespace + c;
                            break block0;
                        }
                        case '#': {
                            value = value + escapedspace;
                            finished = true;
                            break block0;
                        }
                    }
                    value = value + (value.length() == 0 ? escapedspace : whitespace);
                    whitespace = "";
                    escapedspace = "";
                    value = value + c;
                }
            }
            if (finished) break;
        }
        value = value + escapedspace;
        if (state == 0 && key.length() != 0 || state == 1 && key.length() == 0) {
            Util.getProcessLogger().warning("invalid config file entry: \"" + line + "\"");
            return;
        }
        if (key.length() == 0) {
            return;
        }
        this.setProperty(key, value);
    }

    private void loadConfig() {
        String value = this.getProperty("Ice.Config");
        if (value.length() == 0 || value.equals("1")) {
            try {
                value = System.getenv("ICE_CONFIG");
                if (value == null) {
                    value = "";
                }
            }
            catch (SecurityException ex) {
                value = "";
            }
        }
        if (value.length() > 0) {
            String[] files = value.split(",");
            for (int i = 0; i < files.length; ++i) {
                this.load(files[i]);
            }
        }
        this._properties.put("Ice.Config", new PropertyValue(value, true));
    }

    private String[] splitString(String str, String delim) {
        ArrayList<String> l = new ArrayList<String>();
        char[] arr = new char[str.length()];
        int pos = 0;
        while (pos < str.length()) {
            int n = 0;
            char quoteChar = '\u0000';
            if (str.charAt(pos) == '\"' || str.charAt(pos) == '\'') {
                quoteChar = str.charAt(pos);
                ++pos;
            }
            while (pos < str.length()) {
                if (quoteChar != '\u0000' && str.charAt(pos) == '\\' && pos + 1 < str.length() && str.charAt(pos + 1) == quoteChar) {
                    ++pos;
                } else {
                    if (quoteChar != '\u0000' && str.charAt(pos) == quoteChar) {
                        ++pos;
                        quoteChar = '\u0000';
                        break;
                    }
                    if (delim.indexOf(str.charAt(pos)) != -1 && quoteChar == '\u0000') {
                        ++pos;
                        break;
                    }
                }
                if (pos >= str.length()) continue;
                arr[n++] = str.charAt(pos++);
            }
            if (quoteChar != '\u0000') {
                return null;
            }
            if (n <= 0) continue;
            l.add(new String(arr, 0, n));
        }
        return l.toArray(new String[0]);
    }

    class PropertyValue {
        public String value;
        public boolean used;

        public PropertyValue(PropertyValue v) {
            this.value = v.value;
            this.used = v.used;
        }

        public PropertyValue(String v, boolean u) {
            this.value = v;
            this.used = u;
        }
    }
}

