/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.BackgroundSaveEvictor;
import Freeze.BackgroundSaveEvictorI;
import Freeze.Connection;
import Freeze.ConnectionI;
import Freeze.FatalErrorCallback;
import Freeze.Index;
import Freeze.ServantInitializer;
import Freeze.Transaction;
import Freeze.TransactionI;
import Freeze.TransactionalEvictor;
import Freeze.TransactionalEvictorI;
import Ice.Communicator;
import Ice.ObjectAdapter;
import com.sleepycat.db.Environment;
import java.util.Map;

public class Util {
    private static String _catalogName = "__catalog";
    private static String _catalogIndexListName = "__catalogIndexList";
    private static FatalErrorCallback _fatalErrorCallback = null;

    public static BackgroundSaveEvictor createBackgroundSaveEvictor(ObjectAdapter adapter, String envName, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        return new BackgroundSaveEvictorI(adapter, envName, filename, initializer, indices, createDb);
    }

    public static BackgroundSaveEvictor createBackgroundSaveEvictor(ObjectAdapter adapter, String envName, Environment dbEnv, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        return new BackgroundSaveEvictorI(adapter, envName, dbEnv, filename, initializer, indices, createDb);
    }

    public static TransactionalEvictor createTransactionalEvictor(ObjectAdapter adapter, String envName, String filename, Map facetTypes, ServantInitializer initializer, Index[] indices, boolean createDb) {
        return new TransactionalEvictorI(adapter, envName, filename, facetTypes, initializer, indices, createDb);
    }

    public static TransactionalEvictor createTransactionalEvictor(ObjectAdapter adapter, String envName, Environment dbEnv, String filename, Map facetTypes, ServantInitializer initializer, Index[] indices, boolean createDb) {
        return new TransactionalEvictorI(adapter, envName, dbEnv, filename, facetTypes, initializer, indices, createDb);
    }

    public static Connection createConnection(Communicator communicator, String envName) {
        return new ConnectionI(communicator, envName, null);
    }

    public static Connection createConnection(Communicator communicator, String envName, Environment dbEnv) {
        return new ConnectionI(communicator, envName, dbEnv);
    }

    public static String catalogName() {
        return _catalogName;
    }

    public static String catalogIndexListName() {
        return _catalogIndexListName;
    }

    public static com.sleepycat.db.Transaction getTxn(Transaction tx) {
        try {
            return ((TransactionI)tx).dbTxn();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static synchronized FatalErrorCallback registerFatalErrorCallback(FatalErrorCallback cb) {
        FatalErrorCallback result = _fatalErrorCallback;
        _fatalErrorCallback = cb;
        return result;
    }

    static synchronized void handleFatalError(BackgroundSaveEvictor evictor, Communicator communicator, RuntimeException ex) {
        if (_fatalErrorCallback != null) {
            _fatalErrorCallback.handleError(evictor, communicator, ex);
        } else {
            communicator.getLogger().error("*** Halting JVM ***");
            Runtime.getRuntime().halt(1);
        }
    }
}

