/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import omero.RString;
import omero.model.UriAnnotation;
import omero.model.UriAnnotationI;
import omero.rtypes;
import pojos.AnnotationData;

public class URLAnnotationData
extends AnnotationData {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String[] URLS = new String[2];

    private void validateURL(String value) {
        if (value == null) {
            throw new IllegalArgumentException("URL not valid.");
        }
    }

    public URLAnnotationData(String url) {
        super(UriAnnotationI.class);
        this.setURL(url);
    }

    public URLAnnotationData(UriAnnotation annotation) {
        super(annotation);
    }

    public void setURL(String url) {
        this.validateURL(url);
        ((UriAnnotation)this.asAnnotation()).setTextValue(rtypes.rstring(url));
    }

    public String getURL() {
        return this.getContentAsString();
    }

    public Object getContent() {
        RString s = ((UriAnnotation)this.asAnnotation()).getTextValue();
        return s == null ? null : s.getValue();
    }

    public String getContentAsString() {
        return (String)this.getContent();
    }

    public void setContent(Object content) {
        if (content == null) {
            throw new IllegalArgumentException("URL not valid.");
        }
        if (!(content instanceof String)) {
            throw new IllegalArgumentException("URL not valid.");
        }
        this.setURL((String)content);
    }

    static {
        URLAnnotationData.URLS[0] = HTTP;
        URLAnnotationData.URLS[1] = HTTPS;
    }
}

