/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.awt.Color;
import java.awt.Font;
import omero.RInt;
import omero.RString;
import omero.model.Shape;
import pojos.DataObject;

public class ShapeSettingsData
extends DataObject {
    public static final String LINE_CAP_BUTT = "Butt";
    public static final String LINE_CAP_ROUND = "Round";
    public static final String LINE_CAP_SQUARE = "Square";
    public static final Color DEFAULT_FILL_COLOUR = new Color(0, 0, 0, 64);
    public static final Color DEFAULT_FILL_COLOUR_ALPHA = new Color(0, 0, 0, 32);
    public static final Color DEFAULT_STROKE_COLOUR = new Color(196, 196, 196, 196);
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final int DEFAULT_FONT_STYLE = 0;
    public static final String DEFAULT_FONT_FAMILY = "Courier";
    public static final double DEFAULT_STROKE_WIDTH = 1.0;

    private Color stringToColor(String value) {
        if (value == null) {
            return null;
        }
        return Color.decode(value);
    }

    ShapeSettingsData(Shape shape) {
        this.setValue(shape);
    }

    public String getFillRule() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getFillRule();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public Color getFillColor() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getFillColor();
        if (value == null) {
            return DEFAULT_FILL_COLOUR;
        }
        Color c = this.stringToColor(value.getValue());
        if (c == null) {
            return DEFAULT_FILL_COLOUR;
        }
        return c;
    }

    public Color getStrokeColor() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getStrokeColor();
        if (value == null) {
            return DEFAULT_STROKE_COLOUR;
        }
        Color c = this.stringToColor(value.getValue());
        if (c == null) {
            return DEFAULT_STROKE_COLOUR;
        }
        return c;
    }

    public double getStrokeWidth() {
        Shape shape = (Shape)this.asIObject();
        RInt value = shape.getStrokeWidth();
        if (value == null) {
            return 1.0;
        }
        return value.getValue();
    }

    public double[] getStrokeDashArray() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getStrokeDashArray();
        if (value == null) {
            return null;
        }
        String v = value.getValue();
        String[] values = v.split("\\s*,\\s*");
        double[] dashes = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            dashes[i] = new Double(values[i]);
        }
        return dashes;
    }

    public int getLineCap() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getStrokeLineCap();
        if (value == null) {
            return 0;
        }
        String v = value.getValue();
        if (LINE_CAP_BUTT.equals(v)) {
            return 0;
        }
        if (LINE_CAP_ROUND.equals(v)) {
            return 1;
        }
        if (LINE_CAP_SQUARE.equals(v)) {
            return 2;
        }
        return 0;
    }

    public String getFontFamily() {
        return DEFAULT_FONT_FAMILY;
    }

    public int getFontSize() {
        return 12;
    }

    public int getFontStyle() {
        return 0;
    }

    public String getMarkerStart() {
        return "";
    }

    public String getMarkerEnd() {
        return "";
    }

    public String getText() {
        return "";
    }

    public Font getFont() {
        return new Font(this.getFontFamily(), this.getFontStyle(), this.getFontSize());
    }

    public boolean isFontItalic() {
        return this.getFontStyle() == 2;
    }

    public boolean isFontBold() {
        return this.getFontStyle() == 1;
    }
}

