/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.model.IAnnotated;
import ome.model.IMutable;
import omero.RDouble;
import omero.RFloat;
import omero.RInt;
import omero.model.Annotation;
import omero.model.BooleanAnnotation;
import omero.model.Channel;
import omero.model.CommentAnnotation;
import omero.model.Dataset;
import omero.model.Details;
import omero.model.Event;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.FileAnnotation;
import omero.model.IObject;
import omero.model.Image;
import omero.model.LongAnnotation;
import omero.model.Pixels;
import omero.model.Plate;
import omero.model.Project;
import omero.model.Screen;
import omero.model.TagAnnotation;
import omero.model.UriAnnotation;
import omero.model.Well;
import omero.model.WellSample;
import omero.rtypes;
import pojos.BooleanAnnotationData;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.LongAnnotationData;
import pojos.PermissionData;
import pojos.PixelsData;
import pojos.ProjectData;
import pojos.RatingAnnotationData;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;
import pojos.URLAnnotationData;

public abstract class DataObject {
    private IObject value = null;
    private ExperimenterData owner = null;
    private PermissionData permissions = null;
    private boolean dirty = false;

    public static Set asPojos(Collection iObjects) {
        HashSet<DataObject> result = new HashSet<DataObject>();
        for (IObject obj : iObjects) {
            result.add(DataObject.asPojo(obj));
        }
        return result;
    }

    public static Map asPojos(Map iObjects) {
        HashMap result = new HashMap();
        for (Object key : iObjects.keySet()) {
            Object value = iObjects.get(key);
            Object convertedKey = null;
            Object convertedValue = null;
            if (key instanceof IObject) {
                convertedKey = DataObject.asPojo((IObject)key);
            } else if (key instanceof Collection) {
                convertedKey = DataObject.asPojos((Collection)key);
            } else if (key instanceof Map) {
                convertedKey = DataObject.asPojos((Map)key);
            }
            if (value instanceof IObject) {
                convertedValue = DataObject.asPojo((IObject)iObjects.get(key));
            } else if (value instanceof Collection) {
                convertedValue = DataObject.asPojos((Collection)iObjects.get(key));
            } else if (value instanceof Map) {
                convertedValue = DataObject.asPojos((Map)iObjects.get(key));
            }
            result.put(null == convertedKey ? key : convertedKey, null == convertedValue ? value : convertedValue);
        }
        return result;
    }

    public static DataObject asPojo(IObject obj) {
        DataObject converted = null;
        if (obj instanceof Project) {
            converted = new ProjectData((Project)obj);
        } else if (obj instanceof Dataset) {
            converted = new DatasetData((Dataset)obj);
        } else if (obj instanceof UriAnnotation) {
            converted = new URLAnnotationData((UriAnnotation)obj);
        } else if (obj instanceof TagAnnotation) {
            converted = new TagAnnotationData((TagAnnotation)obj);
        } else if (obj instanceof CommentAnnotation) {
            converted = new TextualAnnotationData((CommentAnnotation)obj);
        } else if (obj instanceof LongAnnotation) {
            LongAnnotation ann = (LongAnnotation)obj;
            converted = "openmicroscopy.org/omero/insight/rating".equals(ann.getNs().getValue()) ? new RatingAnnotationData(ann) : new LongAnnotationData(ann);
        } else if (obj instanceof BooleanAnnotation) {
            converted = new BooleanAnnotationData((BooleanAnnotation)obj);
        } else if (obj instanceof FileAnnotation) {
            converted = new FileAnnotationData((FileAnnotation)obj);
        } else if (obj instanceof Image) {
            converted = new ImageData((Image)obj);
        } else if (obj instanceof Pixels) {
            converted = new PixelsData((Pixels)obj);
        } else if (obj instanceof Experimenter) {
            converted = new ExperimenterData((Experimenter)obj);
        } else if (obj instanceof ExperimenterGroup) {
            converted = new GroupData((ExperimenterGroup)obj);
        } else if (obj != null) {
            throw new IllegalArgumentException("Unknown type: " + obj.getClass().getName());
        }
        return converted;
    }

    protected void setValue(IObject value) {
        if (value == null) {
            throw new IllegalArgumentException("IObject delegate for DataObject cannot be null.");
        }
        this.value = value;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public long getId() {
        return this.value.getId() == null ? -1L : (this.value.getId() == null ? -1L : this.value.getId().getValue());
    }

    public void setId(long id) {
        this.setDirty(true);
        this.value.setId(rtypes.rlong(id));
    }

    protected int getVersion() {
        if (this.value instanceof IMutable) {
            IMutable m = (IMutable)((Object)this.value);
            return m.getVersion() == null ? 0 : m.getVersion();
        }
        return 0;
    }

    protected void setVersion(int version) {
        if (this.value instanceof IMutable) {
            IMutable m = (IMutable)((Object)this.value);
            this.setDirty(true);
            m.setVersion(new Integer(version));
        }
    }

    public boolean isLoaded() {
        return this.value.isLoaded();
    }

    public ExperimenterData getOwner() {
        if (this.owner == null) {
            this.owner = new ExperimenterData(this.asIObject().getDetails().getOwner());
        }
        return this.owner;
    }

    public PermissionData getPermissions() {
        if (this.permissions == null) {
            this.permissions = new PermissionData(this.getDetails().getPermissions());
        }
        return this.permissions;
    }

    public String toString() {
        return this.getClass().getName() + " (id=" + this.getId() + ")";
    }

    protected int nullSafe(Integer i) {
        return i == null ? 0 : i;
    }

    protected int nullSafe(RInt i) {
        return i == null ? 0 : i.getValue();
    }

    protected long nullSafe(Long l) {
        return l == null ? 0L : l;
    }

    protected double nullSafe(Double d) {
        return d == null ? 0.0 : d;
    }

    protected float nullSafe(Float f) {
        return f == null ? 0.0f : f.floatValue();
    }

    protected float nullSafe(RFloat f) {
        return f == null ? 0.0f : f.getValue();
    }

    protected double nullSafe(RDouble d) {
        return d == null ? 0.0 : d.getValue();
    }

    protected Timestamp timeOfEvent(Event event) {
        if (event == null || !event.isLoaded() || event.getTime() == null) {
            throw new IllegalStateException("Event does not contain timestamp.");
        }
        return new Timestamp(event.getTime().getValue());
    }

    protected boolean nullDetails() {
        return this.asIObject().getDetails() == null;
    }

    protected Details getDetails() {
        return this.asIObject().getDetails();
    }

    public Timestamp getCreated() {
        if (this.nullDetails()) {
            return null;
        }
        return this.timeOfEvent(this.getDetails().getCreationEvent());
    }

    public Timestamp getUpdated() {
        if (this.nullDetails()) {
            return null;
        }
        return this.timeOfEvent(this.getDetails().getUpdateEvent());
    }

    public IObject asIObject() {
        return this.value;
    }

    public IAnnotated asIAnnotated() {
        return (IAnnotated)((Object)this.asIObject());
    }

    public Experimenter asExperimenter() {
        return (Experimenter)this.asIObject();
    }

    public ExperimenterGroup asGroup() {
        return (ExperimenterGroup)this.asIObject();
    }

    public Annotation asAnnotation() {
        return (Annotation)this.asIObject();
    }

    public Image asImage() {
        return (Image)this.asIObject();
    }

    public Dataset asDataset() {
        return (Dataset)this.asIObject();
    }

    public Project asProject() {
        return (Project)this.asIObject();
    }

    public Pixels asPixels() {
        return (Pixels)this.asIObject();
    }

    public Screen asScreen() {
        return (Screen)this.asIObject();
    }

    public Plate asPlate() {
        return (Plate)this.asIObject();
    }

    public Well asWell() {
        return (Well)this.asIObject();
    }

    public WellSample asWellSample() {
        return (WellSample)this.asIObject();
    }

    public Channel asChannel() {
        return (Channel)this.asIObject();
    }
}

