/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Object;
import Ice.ObjectPrxHelperBase;
import IceUtilInternal.OutputBase;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueWriter {
    public static void write(java.lang.Object obj, OutputBase out) {
        ValueWriter.writeValue(null, obj, null, out);
    }

    private static void writeValue(String name, java.lang.Object value, Map<java.lang.Object, java.lang.Object> objectTable, OutputBase out) {
        if (value == null) {
            ValueWriter.writeName(name, out);
            out.print("(null)");
        } else {
            Class<?> c = value.getClass();
            if (c.equals(Byte.class) || c.equals(Short.class) || c.equals(Integer.class) || c.equals(Long.class) || c.equals(Double.class) || c.equals(Float.class) || c.equals(Boolean.class)) {
                ValueWriter.writeName(name, out);
                out.print(value.toString());
            } else if (c.equals(String.class)) {
                int pos;
                ValueWriter.writeName(name, out);
                out.print("\"");
                out.useCurrentPosAsIndent();
                String str = value.toString();
                int start = 0;
                while (start < str.length() && (pos = str.indexOf(10, start)) != -1) {
                    out.print(str.substring(start, pos));
                    out.nl();
                    start = pos + 1;
                }
                if (start < str.length()) {
                    out.print(str.substring(start));
                }
                out.print("\"");
                out.restoreIndent();
            } else if (c.isArray()) {
                int n = Array.getLength(value);
                for (int i = 0; i < n; ++i) {
                    String elem = name != null ? name : "";
                    elem = elem + "[" + i + "]";
                    ValueWriter.writeValue(elem, Array.get(value, i), objectTable, out);
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    String elem = name != null ? name + "." : "";
                    ValueWriter.writeValue(elem + "key", entry.getKey(), objectTable, out);
                    ValueWriter.writeValue(elem + "value", entry.getValue(), objectTable, out);
                }
            } else if (value instanceof ObjectPrxHelperBase) {
                ValueWriter.writeName(name, out);
                ObjectPrxHelperBase proxy = (ObjectPrxHelperBase)value;
                out.print(proxy.__reference().toString());
            } else if (value instanceof Object) {
                if (objectTable != null && objectTable.containsKey(value)) {
                    ValueWriter.writeName(name, out);
                    out.print("(recursive)");
                } else {
                    if (objectTable == null) {
                        objectTable = new IdentityHashMap<java.lang.Object, java.lang.Object>();
                    }
                    objectTable.put(value, null);
                    ValueWriter.writeFields(name, value, c, objectTable, out);
                }
            } else {
                try {
                    Method valueMethod;
                    Field __values;
                    Field __value = c.getDeclaredField("__value");
                    if (__value.getType().equals(Integer.TYPE) && Modifier.isPrivate(__value.getModifiers()) && !Modifier.isStatic(__value.getModifiers()) && (__values = c.getDeclaredField("__values")).getType().isArray() && __values.getType().getComponentType().equals(c) && Modifier.isPrivate(__values.getModifiers()) && Modifier.isStatic(__values.getModifiers()) && (valueMethod = c.getDeclaredMethod("value", new Class[0])).getReturnType().equals(Integer.TYPE) && Modifier.isPublic(valueMethod.getModifiers()) && !Modifier.isStatic(valueMethod.getModifiers())) {
                        java.lang.Object val = valueMethod.invoke(value, new java.lang.Object[0]);
                        assert (val instanceof Integer);
                        Field[] fields = c.getDeclaredFields();
                        for (int i = 0; i < fields.length; ++i) {
                            if (!Modifier.isPublic(fields[i].getModifiers()) || !fields[i].getType().equals(Integer.TYPE) || !fields[i].getName().startsWith("_") || !fields[i].get(null).equals(val)) continue;
                            ValueWriter.writeName(name, out);
                            out.print(fields[i].getName().substring(1));
                            return;
                        }
                    }
                }
                catch (NoSuchFieldException ex) {
                }
                catch (NoSuchMethodException ex) {
                }
                catch (IllegalAccessException eX) {
                }
                catch (InvocationTargetException ex) {
                    // empty catch block
                }
                ValueWriter.writeFields(name, value, c, objectTable, out);
            }
        }
    }

    private static void writeFields(String name, java.lang.Object obj, Class<?> c, Map<java.lang.Object, java.lang.Object> objectTable, OutputBase out) {
        if (!c.equals(java.lang.Object.class)) {
            ValueWriter.writeFields(name, obj, c.getSuperclass(), objectTable, out);
            Field[] fields = null;
            try {
                fields = c.getDeclaredFields();
            }
            catch (SecurityException ex) {
                try {
                    fields = c.getFields();
                }
                catch (SecurityException e) {
                    return;
                }
            }
            assert (fields != null);
            for (int i = 0; i < fields.length; ++i) {
                int mods = fields[i].getModifiers();
                if (!Modifier.isPublic(mods) || Modifier.isStatic(mods)) continue;
                String fieldName = name != null ? name + '.' + fields[i].getName() : fields[i].getName();
                try {
                    java.lang.Object value = fields[i].get(obj);
                    ValueWriter.writeValue(fieldName, value, objectTable, out);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    assert (false);
                    continue;
                }
            }
        }
    }

    private static void writeName(String name, OutputBase out) {
        if (name != null) {
            out.nl();
            out.print(name + " = ");
        }
    }
}

