/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.LocalException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.OutgoingMessageCallback;
import IceInternal.RequestHandler;

public final class BatchOutgoing
implements OutgoingMessageCallback {
    private RequestHandler _handler;
    private ConnectionI _connection;
    private BasicStream _os;
    private boolean _sent;
    private LocalException _exception;

    public BatchOutgoing(ConnectionI connection, Instance instance) {
        this._connection = connection;
        this._sent = false;
        this._os = new BasicStream(instance);
    }

    public BatchOutgoing(RequestHandler handler) {
        this._handler = handler;
        this._sent = false;
        this._os = new BasicStream(handler.getReference().getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        assert (this._handler != null || this._connection != null);
        if (this._handler != null && !this._handler.flushBatchRequests(this) || this._connection != null && !this._connection.flushBatchRequests(this)) {
            BatchOutgoing batchOutgoing = this;
            synchronized (batchOutgoing) {
                while (this._exception == null && !this._sent) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this._exception != null) {
                    throw this._exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sent(boolean async) {
        if (async) {
            BatchOutgoing batchOutgoing = this;
            synchronized (batchOutgoing) {
                this._sent = true;
                this.notify();
            }
        } else {
            this._sent = true;
        }
    }

    public synchronized void finished(LocalException ex) {
        this._exception = ex;
        this.notify();
    }

    public BasicStream os() {
        return this._os;
    }
}

