/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.Map;
import Freeze.MapDb;
import Freeze.NotFoundException;
import Freeze.Transaction;
import Freeze.TransactionI;
import Freeze.TransactionalEvictorContext;
import Freeze.Util;
import Ice.Communicator;
import Ice.Properties;
import com.sleepycat.db.CheckpointConfig;
import com.sleepycat.db.Environment;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.LockDetectMode;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

class SharedDbEnv
implements ErrorHandler,
Runnable {
    private MapKey _key;
    private Environment _dbEnv;
    private boolean _ownDbEnv;
    private MapDb _catalog;
    private MapDb _catalogIndexList;
    private int _refCount = 0;
    private boolean _done = false;
    private int _trace = 0;
    private long _checkpointPeriod = 0L;
    private int _kbyte = 0;
    private Thread _thread;
    private Map _ctxMap = new HashMap();
    private Map<String, MapDb> _sharedDbMap = new HashMap<String, MapDb>();
    private static Map _map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedDbEnv get(Communicator communicator, String envName, Environment dbEnv) {
        SharedDbEnv result;
        MapKey key = new MapKey(envName, communicator);
        Map map = _map;
        synchronized (map) {
            result = (SharedDbEnv)_map.get(key);
            if (result == null) {
                result = new SharedDbEnv(key, dbEnv);
                SharedDbEnv previousValue = _map.put(key, result);
                assert (previousValue == null);
            } else {
                ++result._refCount;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MapDb getSharedMapDb(String dbName, String key, String value, Comparator comparator, Map.Index[] indices, Map indexComparators, boolean createDb) {
        if (dbName.equals(this._catalog.dbName())) {
            this._catalog.checkTypes(key, value);
            return this._catalog;
        }
        if (dbName.equals(this._catalogIndexList.dbName())) {
            this._catalogIndexList.checkTypes(key, value);
            return this._catalogIndexList;
        }
        Map<String, MapDb> map = this._sharedDbMap;
        synchronized (map) {
            MapDb db = this._sharedDbMap.get(dbName);
            if (db == null) {
                ConnectionI insertConnection = (ConnectionI)Util.createConnection(this._key.communicator, this._key.envName);
                try {
                    db = new MapDb(insertConnection, dbName, key, value, comparator, indices, indexComparators, createDb);
                    Object var12_11 = null;
                    insertConnection.close();
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    insertConnection.close();
                    throw throwable;
                }
                MapDb previousValue = this._sharedDbMap.put(dbName, db);
                assert (previousValue == null);
            } else {
                db.checkTypes(key, value);
                db.connectIndices(indices);
            }
            return db;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSharedMapDb(String dbName) {
        Map<String, MapDb> map = this._sharedDbMap;
        synchronized (map) {
            MapDb db = this._sharedDbMap.remove(dbName);
            if (db != null) {
                db.close();
            }
        }
    }

    public String getEnvName() {
        return this._key.envName;
    }

    public Communicator getCommunicator() {
        return this._key.communicator;
    }

    public Environment getEnv() {
        return this._dbEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = _map;
        synchronized (map) {
            if (--this._refCount == 0) {
                Object value = _map.remove(this._key);
                assert (value == this);
                this.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            SharedDbEnv sharedDbEnv = this;
            synchronized (sharedDbEnv) {
                while (!this._done) {
                    try {
                        this.wait(this._checkpointPeriod);
                        break;
                    }
                    catch (InterruptedException ex) {
                    }
                }
                if (this._done) {
                    return;
                }
            }
            if (this._trace >= 2) {
                this._key.communicator.getLogger().trace("Freeze.DbEnv", "checkpointing environment \"" + this._key.envName + "\"");
            }
            try {
                CheckpointConfig config = new CheckpointConfig();
                config.setKBytes(this._kbyte);
                this._dbEnv.checkpoint(config);
                continue;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                this._key.communicator.getLogger().warning("checkpoint on DbEnv \"" + this._key.envName + "\" raised DbException: " + dx.getMessage());
                continue;
            }
            break;
        }
    }

    public void error(Environment env, String errorPrefix, String message) {
        this._key.communicator.getLogger().error("Freeze database error in DbEnv \"" + this._key.envName + "\": " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized TransactionalEvictorContext createCurrent() {
        Thread k = Thread.currentThread();
        TransactionalEvictorContext ctx = (TransactionalEvictorContext)this._ctxMap.get(k);
        assert (ctx == null);
        ctx = new TransactionalEvictorContext(this);
        Map map = _map;
        synchronized (map) {
            ++this._refCount;
        }
        this._ctxMap.put(k, ctx);
        return ctx;
    }

    synchronized TransactionalEvictorContext getCurrent() {
        Thread k = Thread.currentThread();
        return (TransactionalEvictorContext)this._ctxMap.get(k);
    }

    synchronized void setCurrentTransaction(Transaction tx) {
        TransactionI txi = (TransactionI)tx;
        if (txi != null) {
            if (txi.getConnectionI() == null || txi.getConnectionI().dbEnv() == null) {
                throw new DatabaseException(SharedDbEnv.errorPrefix(this._key.envName) + "invalid transaction");
            }
            if (txi.getConnectionI().dbEnv() != this) {
                throw new DatabaseException(SharedDbEnv.errorPrefix(this._key.envName) + "the given transaction is bound to environment '" + txi.getConnectionI().dbEnv()._key.envName + "'");
            }
        }
        Thread k = Thread.currentThread();
        if (txi != null) {
            TransactionalEvictorContext ctx = (TransactionalEvictorContext)this._ctxMap.get(k);
            if (ctx == null || !tx.equals(ctx.transaction())) {
                ctx = new TransactionalEvictorContext(txi, this.getCommunicator());
                this._ctxMap.put(k, ctx);
            }
        } else {
            this._ctxMap.put(k, null);
        }
    }

    private SharedDbEnv(MapKey key, Environment dbEnv) {
        this._key = key;
        this._dbEnv = dbEnv;
        this._ownDbEnv = dbEnv == null;
        Properties properties = key.communicator.getProperties();
        this._trace = properties.getPropertyAsInt("Freeze.Trace.DbEnv");
        try {
            if (this._ownDbEnv) {
                EnvironmentConfig config = new EnvironmentConfig();
                config.setErrorHandler((ErrorHandler)this);
                config.setInitializeLocking(true);
                config.setInitializeLogging(true);
                config.setInitializeCache(true);
                config.setAllowCreate(true);
                config.setTransactional(true);
                config.setLockDetectMode(LockDetectMode.YOUNGEST);
                String propertyPrefix = "Freeze.DbEnv." + this._key.envName;
                if (properties.getPropertyAsInt(propertyPrefix + ".DbRecoverFatal") != 0) {
                    config.setRunFatalRecovery(true);
                } else {
                    config.setRunRecovery(true);
                }
                if (properties.getPropertyAsIntWithDefault(propertyPrefix + ".DbPrivate", 1) != 0) {
                    config.setPrivate(true);
                }
                if (properties.getPropertyAsIntWithDefault(propertyPrefix + ".OldLogsAutoDelete", 1) != 0) {
                    config.setLogAutoRemove(true);
                }
                if (this._trace >= 1) {
                    this._key.communicator.getLogger().trace("Freeze.DbEnv", "opening database environment \"" + this._key.envName + "\"");
                }
                try {
                    String dbHome = properties.getPropertyWithDefault(propertyPrefix + ".DbHome", this._key.envName);
                    File home = new File(dbHome);
                    this._dbEnv = new Environment(home, config);
                }
                catch (FileNotFoundException dx) {
                    NotFoundException ex = new NotFoundException();
                    ex.initCause(dx);
                    ex.message = SharedDbEnv.errorPrefix(this._key.envName) + "open: " + dx.getMessage();
                    throw ex;
                }
                this._checkpointPeriod = properties.getPropertyAsIntWithDefault(propertyPrefix + ".CheckpointPeriod", 120) * 1000;
                this._kbyte = properties.getPropertyAsIntWithDefault(propertyPrefix + ".PeriodicCheckpointMinSize", 0);
                String programName = properties.getProperty("Ice.ProgramName");
                String threadName = programName.length() > 0 ? programName + "-" : "";
                threadName = threadName + "FreezeCheckpointThread(" + this._key.envName + ")";
                if (this._checkpointPeriod > 0L) {
                    this._thread = new Thread((Runnable)this, threadName);
                    this._thread.start();
                }
            }
            this._catalog = new MapDb(this._key.communicator, this._key.envName, Util.catalogName(), "string", "::Freeze::CatalogData", this._dbEnv);
            this._catalogIndexList = new MapDb(this._key.communicator, this._key.envName, Util.catalogIndexListName(), "string", "::Ice::StringSeq", this._dbEnv);
        }
        catch (com.sleepycat.db.DatabaseException dx) {
            this.cleanup();
            DatabaseException ex = new DatabaseException();
            ex.initCause(dx);
            ex.message = SharedDbEnv.errorPrefix(this._key.envName) + "creation: " + dx.getMessage();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.cleanup();
            throw ex;
        }
        this._refCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        SharedDbEnv sharedDbEnv = this;
        synchronized (sharedDbEnv) {
            this._done = true;
            this.notify();
        }
        while (true) {
            if (this._thread == null) {
                continue;
            }
            try {
                this._thread.join();
                this._thread = null;
            }
            catch (InterruptedException ex) {
                continue;
            }
            break;
        }
        if (this._catalog != null) {
            try {
                this._catalog.close();
                Object var4_6 = null;
                this._catalog = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this._catalog = null;
                throw throwable;
            }
        }
        if (this._catalogIndexList != null) {
            try {
                this._catalogIndexList.close();
                Object var6_9 = null;
                this._catalogIndexList = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this._catalogIndexList = null;
                throw throwable;
            }
        }
        for (MapDb db : this._sharedDbMap.values()) {
            db.close();
        }
        if (this._trace >= 1) {
            this._key.communicator.getLogger().trace("Freeze.DbEnv", "closing database environment \"" + this._key.envName + "\"");
        }
        if (this._ownDbEnv && this._dbEnv != null) {
            try {
                try {
                    this._dbEnv.close();
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = SharedDbEnv.errorPrefix(this._key.envName) + "close: " + dx.getMessage();
                    throw ex;
                }
                Object var8_12 = null;
                this._dbEnv = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                this._dbEnv = null;
                throw throwable;
            }
        }
    }

    private static String errorPrefix(String envName) {
        return "DbEnv(\"" + envName + "\"): ";
    }

    private static class MapKey {
        final String envName;
        final Communicator communicator;

        MapKey(String envName, Communicator communicator) {
            this.envName = envName;
            this.communicator = communicator;
        }

        public boolean equals(Object o) {
            try {
                MapKey k = (MapKey)o;
                return this.communicator == k.communicator && this.envName.equals(k.envName);
            }
            catch (ClassCastException ex) {
                this.communicator.getLogger().trace("Freeze.DbEnv", "equals cast failed");
                return false;
            }
        }

        public int hashCode() {
            return this.envName.hashCode() ^ this.communicator.hashCode();
        }
    }
}

