/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import loci.common.Location;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.TiffWriter;
import loci.formats.tiff.TiffSaver;

public class OMETiffWriter
extends TiffWriter {
    private static final String WARNING_COMMENT = "<!-- Warning: this comment is an OME-XML metadata block, which contains crucial dimensional parameters and other important metadata. Please edit cautiously (if at all), and back up the original data before doing so. For more information, see the OME-TIFF web site: http://loci.wisc.edu/ome/ome-tiff.html. -->";
    private static HashMap<String, String> uuids = new HashMap();
    private ArrayList<Integer> seriesMap;
    private boolean wroteLast;

    public OMETiffWriter() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff"});
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        if (this.currentId != null) {
            if (!this.wroteLast) {
                throw new IOException("Sorry, closing OME-TIFF files early is not yet supported.");
            }
            MetadataRetrieve retrieve = this.getMetadataRetrieve();
            IMetadata omeMeta = MetadataTools.getOMEMetadata(retrieve);
            String filename = new Location(this.currentId).getName();
            String uuid = OMETiffWriter.getUUID(filename);
            omeMeta.setUUID(uuid);
            for (int series = 0; series < omeMeta.getImageCount(); ++series) {
                int num;
                String dimensionOrder = omeMeta.getPixelsDimensionOrder(series, 0);
                int sizeZ = omeMeta.getPixelsSizeZ(series, 0);
                int sizeC = omeMeta.getPixelsSizeC(series, 0);
                int sizeT = omeMeta.getPixelsSizeT(series, 0);
                int imageCount = 0;
                int ifdCount = this.seriesMap.size();
                for (int q = 0; q < ifdCount; ++q) {
                    if (this.seriesMap.get(q) != series) continue;
                    ++imageCount;
                }
                if (imageCount == 0) {
                    omeMeta.setTiffDataNumPlanes(new Integer(0), series, 0, 0);
                    continue;
                }
                if (imageCount < sizeZ * sizeC * sizeT) {
                    sizeC = imageCount / (sizeZ * sizeT);
                }
                Integer samplesPerPixel = new Integer(sizeZ * sizeC * sizeT / imageCount);
                for (int c = 0; c < omeMeta.getLogicalChannelCount(series); ++c) {
                    omeMeta.setLogicalChannelSamplesPerPixel(samplesPerPixel, series, c);
                }
                int ifd = 0;
                for (int plane = 0; plane < imageCount; plane += num) {
                    int end;
                    while (this.seriesMap.get(ifd) != series) {
                        ++ifd;
                    }
                    for (end = ifd; end < ifdCount && this.seriesMap.get(end) == series; ++end) {
                    }
                    num = end - ifd;
                    int[] zct = FormatTools.getZCTCoords(dimensionOrder, sizeZ, sizeC, sizeT, imageCount, plane);
                    omeMeta.setTiffDataFileName(filename, series, 0, plane);
                    omeMeta.setTiffDataUUID(uuid, series, 0, plane);
                    if (zct[0] > 0) {
                        omeMeta.setTiffDataFirstZ(new Integer(zct[0]), series, 0, plane);
                    }
                    if (zct[1] > 0) {
                        omeMeta.setTiffDataFirstC(new Integer(zct[1]), series, 0, plane);
                    }
                    if (zct[2] > 0) {
                        omeMeta.setTiffDataFirstT(new Integer(zct[2]), series, 0, plane);
                    }
                    if (ifd > 0) {
                        omeMeta.setTiffDataIFD(new Integer(ifd), series, 0, plane);
                    }
                    if (num != ifdCount) {
                        omeMeta.setTiffDataNumPlanes(new Integer(num), series, 0, plane);
                    }
                    ifd = end;
                }
            }
            String xml = MetadataTools.getOMEXML(omeMeta);
            String prefix = xml.substring(0, xml.indexOf(">") + 1);
            String suffix = xml.substring(xml.indexOf(">") + 1);
            xml = prefix + WARNING_COMMENT + suffix;
            try {
                TiffSaver.overwriteComment(this.currentId, xml);
            }
            catch (FormatException exc) {
                IOException io = new IOException("Unable to append OME-XML comment");
                io.initCause(exc);
                throw io;
            }
        }
        super.close();
        this.seriesMap = null;
        this.wroteLast = false;
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (this.seriesMap == null) {
            this.seriesMap = new ArrayList();
        }
        this.seriesMap.add(new Integer(series));
        if (last) {
            this.wroteLast = true;
        }
        super.saveBytes(buf, series, lastInSeries, last);
    }

    public void setId(String id) throws FormatException, IOException {
        if (id.equals(this.currentId)) {
            return;
        }
        Location file = new Location(id);
        if (file.exists() && file.length() > 0L) {
            throw new FormatException("Sorry, appending to existing OME-TIFF files is not yet supported.");
        }
        super.setId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUUID(String filename) {
        String uuid;
        HashMap<String, String> hashMap = uuids;
        synchronized (hashMap) {
            uuid = uuids.get(filename);
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                uuids.put(filename, uuid);
            }
        }
        return uuid;
    }
}

