/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;

public class EPSWriter
extends FormatWriter {
    protected RandomAccessOutputStream out;

    public EPSWriter() {
        super("Encapsulated PostScript", new String[]{"eps", "epsi"});
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        int nChannels;
        if (buf == null) {
            throw new FormatException("Byte array is null");
        }
        this.out = new RandomAccessOutputStream(this.currentId);
        MetadataRetrieve meta = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(meta, series);
        int width = meta.getPixelsSizeX(series, 0);
        int height = meta.getPixelsSizeY(series, 0);
        int type = FormatTools.pixelTypeFromString(meta.getPixelsPixelType(series, 0));
        Integer channels = meta.getLogicalChannelSamplesPerPixel(series, 0);
        if (channels == null) {
            this.warn("SamplesPerPixel #0 is null.  It is assumed to be 1.");
        }
        int n = nChannels = channels == null ? 1 : channels;
        if (!DataTools.containsValue(this.getPixelTypes(), type)) {
            throw new FormatException("Unsupported image type '" + FormatTools.getPixelTypeString(type) + "'.");
        }
        this.out.writeBytes("%!PS-Adobe-2.0 EPSF-1.2\n");
        this.out.writeBytes("%%Title: " + this.currentId + "\n");
        this.out.writeBytes("%%Creator: LOCI Bio-Formats\n");
        this.out.writeBytes("%%Pages: 1\n");
        this.out.writeBytes("%%BoundingBox: 0 0 " + width + " " + height + "\n");
        this.out.writeBytes("%%EndComments\n\n");
        this.out.writeBytes("/ld {load def} bind def\n");
        this.out.writeBytes("/s /stroke ld /f /fill ld /m /moveto ld /l /lineto ld /c /curveto ld /rgb {255 div 3 1 roll 255 div 3 1 roll 255 div 3 1 roll setrgbcolor} def\n");
        this.out.writeBytes("0 0 translate\n");
        this.out.writeBytes((float)width + " " + (float)height + " scale\n");
        this.out.writeBytes("/picstr 40 string def\n");
        if (nChannels == 1) {
            this.out.writeBytes(width + " " + height + " 8 [" + width + " 0 0 " + -1 * height + " 0 " + height + "] {currentfile picstr " + "readhexstring pop} image\n");
        } else {
            this.out.writeBytes(width + " " + height + " 8 [" + width + " 0 0 " + -1 * height + " 0 " + height + "] {currentfile picstr " + "readhexstring pop} false 3 colorimage\n");
        }
        int planeSize = width * height;
        int charCount = 0;
        for (int i = 0; i < buf.length; ++i) {
            int index = this.interleaved || nChannels == 1 ? i : i % nChannels * planeSize + i / nChannels;
            String s = Integer.toHexString(buf[index]);
            s = s.length() > 1 ? s.substring(s.length() - 2) : "0" + s;
            this.out.writeBytes(s);
            if (++charCount != 40) continue;
            this.out.writeBytes("\n");
            charCount = 0;
        }
        this.out.writeBytes("showpage\n");
        this.out.close();
    }

    public int[] getPixelTypes() {
        return new int[]{1};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
    }
}

