/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ScanrReader
extends FormatReader {
    private static final String XML_FILE = "experiment_descriptor.xml";
    private static final String EXPERIMENT_FILE = "experiment_descriptor.dat";
    private static final String ACQUISITION_FILE = "AcquisitionLog.dat";
    private Vector<String> metadataFiles = new Vector();
    private int wellRows;
    private int wellColumns;
    private int fieldRows;
    private int fieldColumns;
    private Vector<String> channelNames = new Vector();
    private String plateName;
    private String[] tiffs;
    private MinimalTiffReader reader;

    public ScanrReader() {
        super("Olympus ScanR", new String[]{"dat", "xml", "tif"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.suffixSufficient = false;
    }

    public boolean isThisType(String name, boolean open) {
        String localName = new Location(name).getName();
        if (localName.equals(XML_FILE) || localName.equals(EXPERIMENT_FILE) || localName.equals(ACQUISITION_FILE)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser p = new TiffParser(stream);
        IFD ifd = p.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        Object s = ifd.getIFDValue(305);
        if (s == null) {
            return false;
        }
        String software = s instanceof String[] ? ((String[])s)[0] : s.toString();
        return software.equals("National Instruments IMAQ");
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        for (String file : this.metadataFiles) {
            if (file == null) continue;
            files.add(file);
        }
        if (!noPixels && this.tiffs != null) {
            int offset = this.getSeries() * this.getImageCount();
            for (int i = 0; i < this.getImageCount(); ++i) {
                if (this.tiffs[offset + i] == null) continue;
                files.add(this.tiffs[offset + i]);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            this.tiffs = null;
            this.plateName = null;
            this.channelNames.clear();
            this.fieldColumns = 0;
            this.fieldRows = 0;
            this.wellColumns = 0;
            this.wellRows = 0;
            this.metadataFiles.clear();
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int index = this.getSeries() * this.getImageCount() + no;
        if (this.tiffs[index] != null) {
            this.reader.setId(this.tiffs[index]);
            this.reader.openBytes(0, buf, x, y, w, h);
            this.reader.close();
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] list;
        this.debug("ScanrReader.initFile(" + id + ")");
        super.initFile(id);
        if (!ScanrReader.checkSuffix(id, "xml")) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            if (ScanrReader.checkSuffix(id, "tif")) {
                parent = parent.getParentFile();
            }
            for (String file : list = parent.list()) {
                if (!file.equals(XML_FILE)) continue;
                id = new Location(parent, file).getAbsolutePath();
                super.initFile(id);
                break;
            }
            if (!ScanrReader.checkSuffix(id, "xml")) {
                throw new FormatException("Could not find experiment_descriptor.xml in " + parent.getAbsolutePath());
            }
        }
        Location dir = new Location(id).getAbsoluteFile().getParentFile();
        for (String file : list = dir.list(true)) {
            Location f = new Location(dir, file);
            if (f.isDirectory()) continue;
            this.metadataFiles.add(f.getAbsolutePath());
        }
        String xml = DataTools.readFile(id);
        XMLTools.parseXML(xml, (DefaultHandler)new ScanrHandler());
        int nChannels = this.getSizeC() == 0 ? 1 : this.getSizeC();
        int nSlices = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
        int nTimepoints = this.getSizeT() == 0 ? 1 : this.getSizeT();
        int nSeries = this.wellRows * this.wellColumns * this.fieldRows * this.fieldColumns;
        this.tiffs = new String[nChannels * nSlices * nTimepoints * nSeries];
        dir = new Location(dir, "data");
        list = dir.list(true);
        int next = 0;
        for (int i = 0; i < nSeries; ++i) {
            int well = i / (this.fieldRows * this.fieldColumns);
            String wellPos = String.valueOf(well + 1);
            while (wellPos.length() < 5) {
                wellPos = "0" + wellPos;
            }
            wellPos = "W" + wellPos;
            for (int z = 0; z < nSlices; ++z) {
                String zPos = String.valueOf(z);
                while (zPos.length() < 5) {
                    zPos = "0" + zPos;
                }
                zPos = "Z" + zPos;
                for (int t = 0; t < nTimepoints; ++t) {
                    String tPos = String.valueOf(t);
                    while (tPos.length() < 5) {
                        tPos = "0" + tPos;
                    }
                    tPos = "T" + tPos;
                    for (int c = 0; c < nChannels; ++c) {
                        for (String file : list) {
                            if (file.indexOf(wellPos) == -1 || file.indexOf(zPos) == -1 || file.indexOf(tPos) == -1 || file.indexOf(this.channelNames.get(c)) == -1) continue;
                            this.tiffs[next++] = new Location(dir, file).getAbsolutePath();
                        }
                    }
                }
            }
        }
        this.reader = new MinimalTiffReader();
        this.reader.setId(this.tiffs[0]);
        int sizeX = this.reader.getSizeX();
        int sizeY = this.reader.getSizeY();
        int pixelType = this.reader.getPixelType();
        boolean rgb = this.reader.isRGB();
        boolean interleaved = this.reader.isInterleaved();
        boolean indexed = this.reader.isIndexed();
        boolean littleEndian = this.reader.isLittleEndian();
        this.reader.close();
        this.core = new CoreMetadata[nSeries];
        for (int i = 0; i < nSeries; ++i) {
            this.core[i] = new CoreMetadata();
            this.core[i].sizeC = nChannels;
            this.core[i].sizeZ = nSlices;
            this.core[i].sizeT = nTimepoints;
            this.core[i].sizeX = sizeX;
            this.core[i].sizeY = sizeY;
            this.core[i].pixelType = pixelType;
            this.core[i].rgb = rgb;
            this.core[i].interleaved = interleaved;
            this.core[i].indexed = indexed;
            this.core[i].littleEndian = littleEndian;
            this.core[i].dimensionOrder = "XYCTZ";
            this.core[i].imageCount = nSlices * nTimepoints * nChannels;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            for (int c = 0; c < this.getSizeC(); ++c) {
                store.setLogicalChannelName(this.channelNames.get(c), i, c);
            }
        }
        store.setPlateRowNamingConvention("A", 0);
        store.setPlateColumnNamingConvention("1", 0);
        store.setPlateName(this.plateName, 0);
        int nFields = this.fieldRows * this.fieldColumns;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            MetadataTools.setDefaultCreationDate(store, id, i);
            int field = i % nFields;
            int well = i / nFields;
            int wellRow = well / this.wellColumns;
            int wellCol = well % this.wellColumns;
            store.setWellColumn(new Integer(wellCol), 0, well);
            store.setWellRow(new Integer(wellRow), 0, well);
            store.setWellSampleIndex(new Integer(i), 0, well, field);
            String name = "Well " + String.valueOf((char)(65 + wellRow)) + (wellCol + 1) + ", Field " + (field + 1);
            store.setImageName(name, i);
        }
    }

    class ScanrHandler
    extends DefaultHandler {
        private String key;
        private String value;
        private String qName;

        ScanrHandler() {
        }

        public void characters(char[] ch, int start, int length) {
            String v = new String(ch, start, length);
            if (v.trim().length() == 0) {
                return;
            }
            if (this.qName.equals("Name")) {
                this.key = v;
            } else if (this.qName.equals("Val")) {
                this.value = v;
                ScanrReader.this.addGlobalMeta(this.key, this.value);
                if (this.key.equals("custom column")) {
                    ScanrReader.this.wellColumns = Integer.parseInt(this.value) / ScanrReader.this.fieldColumns;
                } else if (this.key.equals("custom row")) {
                    ScanrReader.this.wellRows = Integer.parseInt(this.value) / ScanrReader.this.fieldRows;
                } else if (this.key.equals("columns/well")) {
                    ScanrReader.this.fieldColumns = Integer.parseInt(this.value);
                } else if (this.key.equals("rows/well")) {
                    ScanrReader.this.fieldRows = Integer.parseInt(this.value);
                } else if (this.key.equals("# slices")) {
                    ((ScanrReader)ScanrReader.this).core[0].sizeZ = Integer.parseInt(this.value);
                } else if (this.key.equals("timeloop real")) {
                    ((ScanrReader)ScanrReader.this).core[0].sizeT = Integer.parseInt(this.value);
                } else if (this.key.equals("name")) {
                    ScanrReader.this.channelNames.add(this.value);
                } else if (this.key.equals("plate name")) {
                    ScanrReader.this.plateName = this.value;
                }
            } else if (this.qName.equals("Dimsize") && this.key.equals("multiple_channel_typedef")) {
                ((ScanrReader)ScanrReader.this).core[0].sizeC = Integer.parseInt(v);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.qName = qName;
        }
    }
}

