/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Reagent;
import omero.model.ReagentAnnotationLink;
import omero.model.ReagentAnnotationLinkI;
import omero.model.Screen;
import omero.model.Well;
import omero.model.WellReagentLink;
import omero.model.WellReagentLinkI;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReagentI
extends Reagent
implements ModelBased {
    public static final String REAGENTIDENTIFIER = "ome.model.screen.Reagent_reagentIdentifier";
    public static final String SCREEN = "ome.model.screen.Reagent_screen";
    public static final String WELLLINKS = "ome.model.screen.Reagent_wellLinks";
    public static final String ANNOTATIONLINKS = "ome.model.screen.Reagent_annotationLinks";
    public static final String NAME = "ome.model.screen.Reagent_name";
    public static final String DESCRIPTION = "ome.model.screen.Reagent_description";
    public static final String DETAILS = "ome.model.screen.Reagent_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.wellLinksSeq = new ArrayList();
            this.wellLinksLoaded = true;
        } else {
            this.wellLinksSeq = null;
            this.wellLinksLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public ReagentI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ReagentI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ReagentI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadReagentIdentifier();
        this.unloadScreen();
        this.unloadWellLinks();
        this.unloadAnnotationLinks();
        this.unloadName();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ReagentI copy = new ReagentI();
        copy.id = this.id;
        copy.version = this.version;
        copy.reagentIdentifier = this.reagentIdentifier;
        Screen screen = copy.screen = this.screen == null ? null : (Screen)this.screen.proxy();
        if (!this.wellLinksLoaded) {
            copy.wellLinksLoaded = false;
            copy.wellLinksSeq = null;
        } else {
            copy.wellLinksLoaded = true;
            copy.wellLinksSeq = new ArrayList<WellReagentLink>();
            for (IObject item : this.wellLinksSeq) {
                copy.wellLinksSeq.add(item == null ? null : (WellReagentLink)item.proxy());
            }
        }
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<ReagentAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (ReagentAnnotationLink)item.proxy());
            }
        }
        copy.name = this.name;
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ReagentI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadReagentIdentifier() {
        this.reagentIdentifier = null;
    }

    @Override
    public RString getReagentIdentifier(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.reagentIdentifier;
    }

    @Override
    public void setReagentIdentifier(RString reagentIdentifier, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.reagentIdentifier = reagentIdentifier;
    }

    private void copyReagentIdentifier(ome.model.screen.Reagent source, IceMapper mapper) {
        this.reagentIdentifier = source.getReagentIdentifier() == null ? null : rtypes.rstring(source.getReagentIdentifier());
    }

    private void fillReagentIdentifier(ome.model.screen.Reagent target, IceMapper mapper) {
        try {
            target.setReagentIdentifier((String)mapper.fromRType(this.getReagentIdentifier()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadScreen() {
        this.screen = null;
    }

    @Override
    public Screen getScreen(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.screen;
    }

    @Override
    public void setScreen(Screen screen, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.screen = screen;
    }

    private void copyScreen(ome.model.screen.Reagent source, IceMapper mapper) {
        this.screen = (Screen)mapper.findTarget(source.getScreen());
    }

    private void fillScreen(ome.model.screen.Reagent target, IceMapper mapper) {
        target.putAt(SCREEN, (Object)mapper.reverse((ModelBased)this.getScreen()));
    }

    @Override
    public void unloadWellLinks(Current current) {
        this.wellLinksLoaded = false;
        this.wellLinksSeq = null;
    }

    protected List getWellLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.wellLinksSeq;
    }

    protected void setWellLinks(List wellLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.wellLinksSeq = wellLinks == null ? new ArrayList() : new ArrayList(wellLinks);
        this.wellLinksLoaded = wellLinks != null;
    }

    private void copyWellLinks(ome.model.screen.Reagent source, IceMapper mapper) {
        this.setWellLinks((List)mapper.findCollection((Collection)source.retrieve(WELLLINKS)), null);
        this.wellLinksCountPerOwner = source.getWellLinksCountPerOwner();
    }

    private void fillWellLinks(ome.model.screen.Reagent target, IceMapper mapper) {
        if (this.wellLinksLoaded) {
            target.putAt(WELLLINKS, (Object)mapper.reverse(this.wellLinksSeq, Set.class));
        } else {
            target.putAt(WELLLINKS, null);
        }
    }

    public boolean isWellLinksLoaded() {
        return this.wellLinksLoaded;
    }

    @Override
    public int sizeOfWellLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            return -1;
        }
        return this.wellLinksSeq.size();
    }

    public List copyWellLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        ArrayList result = new ArrayList(this.wellLinksSeq);
        return result;
    }

    public Iterator iterateWellLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        return this.wellLinksSeq.iterator();
    }

    @Override
    public void addWellReagentLink(WellReagentLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        this.wellLinksSeq.add(target);
        target.setChild(this);
    }

    @Override
    public void addAllWellReagentLinkSet(List<WellReagentLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        this.wellLinksSeq.addAll(targets);
        for (WellReagentLink target : targets) {
            target.setChild(this);
        }
    }

    @Override
    public void removeWellReagentLink(WellReagentLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        this.wellLinksSeq.remove(target);
        target.setChild(null);
    }

    @Override
    public void removeAllWellReagentLinkSet(List<WellReagentLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        for (WellReagentLink elt : targets) {
            elt.setChild(null);
            this.wellLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearWellLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        for (WellReagentLink elt : this.wellLinksSeq) {
            elt.setChild(null);
        }
        this.wellLinksSeq.clear();
    }

    @Override
    public void reloadWellLinks(Reagent toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.wellLinksLoaded) {
            throw new ClientError("Cannot reload active collection: wellLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<WellReagentLink> copy = toCopy.copyWellLinks();
        for (WellReagentLink elt : copy) {
            elt.setChild(this);
        }
        this.wellLinksSeq = new ArrayList<WellReagentLink>(copy);
        toCopy.unloadWellLinks();
        this.wellLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getWellLinksCountPerOwner(Current current) {
        return this.wellLinksCountPerOwner;
    }

    @Override
    public WellReagentLink linkWell(Well addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        WellReagentLinkI link = new WellReagentLinkI();
        link.link(addition, this);
        this.addWellReagentLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addWellReagentLinkToBoth(WellReagentLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        this.wellLinksSeq.add(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().addWellReagentLinkToBoth(link, false);
        }
    }

    @Override
    public List<WellReagentLink> findWellReagentLink(Well removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        ArrayList<WellReagentLink> result = new ArrayList<WellReagentLink>();
        for (WellReagentLink link : this.wellLinksSeq) {
            if (link.getParent() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkWell(Well removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        List<WellReagentLink> toRemove = this.findWellReagentLink(removal);
        Iterator<WellReagentLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeWellReagentLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeWellReagentLinkFromBoth(WellReagentLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("wellLinksSeq");
        }
        this.wellLinksSeq.remove(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().removeWellReagentLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Well> linkedWellList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellLinksLoaded) {
            this.throwNullCollectionException("WellLinks");
        }
        ArrayList<Well> linked = new ArrayList<Well>();
        for (WellReagentLink link : this.wellLinksSeq) {
            linked.add(link.getParent());
        }
        return linked;
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.screen.Reagent source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.screen.Reagent target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addReagentAnnotationLink(ReagentAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllReagentAnnotationLinkSet(List<ReagentAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (ReagentAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeReagentAnnotationLink(ReagentAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllReagentAnnotationLinkSet(List<ReagentAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ReagentAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ReagentAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Reagent toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ReagentAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (ReagentAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<ReagentAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public ReagentAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ReagentAnnotationLinkI link = new ReagentAnnotationLinkI();
        link.link(this, addition);
        this.addReagentAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addReagentAnnotationLinkToBoth(ReagentAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<ReagentAnnotationLink> findReagentAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<ReagentAnnotationLink> result = new ArrayList<ReagentAnnotationLink>();
        for (ReagentAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<ReagentAnnotationLink> toRemove = this.findReagentAnnotationLink(removal);
        Iterator<ReagentAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeReagentAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeReagentAnnotationLinkFromBoth(ReagentAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (ReagentAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadName() {
        this.name = null;
    }

    @Override
    public RString getName(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.name;
    }

    @Override
    public void setName(RString name, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.name = name;
    }

    private void copyName(ome.model.screen.Reagent source, IceMapper mapper) {
        this.name = source.getName() == null ? null : rtypes.rstring(source.getName());
    }

    private void fillName(ome.model.screen.Reagent target, IceMapper mapper) {
        try {
            target.setName((String)mapper.fromRType(this.getName()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.screen.Reagent source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.screen.Reagent target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.screen.Reagent) {
            ome.model.screen.Reagent source = (ome.model.screen.Reagent)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyReagentIdentifier(source, mapper);
                this.copyScreen(source, mapper);
                this.copyWellLinks(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyName(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Reagent cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.screen.Reagent target = new ome.model.screen.Reagent();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillReagentIdentifier(target, mapper);
            this.fillScreen(target, mapper);
            this.fillWellLinks(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillName(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<ReagentI> cast(List list) {
        return list;
    }
}

