/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.util;

import Ice.Identity;
import Ice.Object;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ome.conditions.InternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServantHolder {
    private final ConcurrentHashMap<String, Object> servants = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Lock> locks = new ConcurrentHashMap();

    public void acquireLock(String key) {
        Lock lock = new ReentrantLock();
        Lock oldLock = this.locks.putIfAbsent(key, lock);
        if (oldLock != null) {
            lock = oldLock;
        }
        lock.lock();
    }

    public void releaseLock(String key) {
        Lock lock = this.locks.get(key);
        if (lock == null) {
            throw new InternalException("No lock found: " + key);
        }
        lock.unlock();
    }

    public Object get(String key) {
        return this.servants.get(key);
    }

    public Object get(Identity id) {
        return this.get(id.name);
    }

    public void put(String key, Object servant) {
        this.servants.put(key, servant);
    }

    public Object remove(String key) {
        return this.servants.remove(key);
    }

    public Object remove(Identity id) {
        return this.remove(id.name);
    }

    public List<String> getServantList() {
        return new ArrayList<String>(this.servants.keySet());
    }
}

