/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Communicator;
import Ice.Current;
import Ice.Identity;
import Ice.InitializationData;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.Util;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.UUID;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.PublicRepositoryI;
import omero.RTime;
import omero.ServerError;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.ServiceFactoryPrx;
import omero.api.ThumbnailStorePrx;
import omero.grid.RepositoryPrx;
import omero.grid.RepositoryPrxHelper;
import omero.grid._InternalRepositoryDisp;
import omero.model.FormatI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternalRepositoryI
extends _InternalRepositoryDisp {
    private static final Log log = LogFactory.getLog(InternalRepositoryI.class);
    private final InitializationData id;
    private final Communicator ic;
    private final ObjectAdapter oa;
    private final Registry reg;
    private final OriginalFile description;
    private final RepositoryPrx proxy;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final FileLock lock;
    private final String dbUuid;
    private final String repoUuid;
    private final String repoDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalRepositoryI(String repoDir) throws Exception {
        this.repoDir = repoDir;
        log.info((Object)("Initializing repository in" + repoDir));
        this.id = new InitializationData();
        this.id.properties = Util.createProperties();
        String ICE_CONFIG = System.getProperty("ICE_CONFIG");
        if (ICE_CONFIG != null) {
            this.id.properties.load(ICE_CONFIG);
        }
        this.ic = Util.initialize((InitializationData)this.id);
        this.reg = new Registry.Impl(this.ic);
        this.oa = this.ic.createObjectAdapter("RepositoryAdapter");
        String serverId = this.ic.getProperties().getProperty("Ice.Admin.ServerId");
        Identity id = Util.stringToIdentity((String)serverId);
        ObjectPrx obj = this.oa.add((Ice.Object)this, id);
        ServiceFactoryPrx sf = this.reg.getInternalServiceFactory("root", null, 5, 12, UUID.randomUUID().toString());
        try {
            this.dbUuid = sf.getConfigService().getDatabaseUuid();
            File uuidDir = this.getUuidDir();
            if (!uuidDir.exists()) {
                uuidDir.mkdirs();
                log.info((Object)("Creating " + uuidDir));
            }
            File repoLock = new File(uuidDir, "omero.grid.repository");
            this.raf = new RandomAccessFile(repoLock, "rw");
            this.channel = this.raf.getChannel();
            this.lock = this.channel.lock();
            String line = this.raf.readLine();
            if (line == null || line.trim().equals("")) {
                this.repoUuid = UUID.randomUUID().toString();
                this.raf.writeChars(this.repoUuid);
                FormatI fmt = new FormatI();
                fmt.setValue(rtypes.rstring("Repository"));
                OriginalFileI r = new OriginalFileI();
                r.setFormat(fmt);
                r.setSha1(rtypes.rstring(this.repoUuid));
                r.setName(rtypes.rstring(repoDir));
                r.setPath(rtypes.rstring("/"));
                RTime tick = rtypes.rtime(System.currentTimeMillis());
                r.setCtime(tick);
                r.setAtime(tick);
                r.setMtime(tick);
                r.setSize(rtypes.rlong(0L));
                this.description = (OriginalFile)sf.getUpdateService().saveAndReturnObject(r);
                log.info((Object)("Registered new repository: " + this.repoUuid));
            } else {
                this.repoUuid = line.trim();
                this.description = (OriginalFile)sf.getQueryService().findByString("Repository", "uuid", this.repoUuid);
                log.info((Object)("Opened repository: " + this.repoUuid));
            }
        }
        finally {
            sf.destroy();
        }
        PublicRepositoryI pr = new PublicRepositoryI(-1L, null, null);
        this.proxy = RepositoryPrxHelper.uncheckedCast(this.oa.addWithUUID((Ice.Object)pr));
        this.oa.activate();
        Registry.Impl reg = new Registry.Impl(this.ic);
        if (reg.getGridQuery().findObjectById(id) == null) {
            reg.addObject(obj);
        }
    }

    public void close() {
    }

    public Communicator getCommunicator() {
        return this.ic;
    }

    public ObjectAdapter getObjectAdapter() {
        return this.oa;
    }

    public OriginalFile getDescription(Current __current) {
        return this.description;
    }

    public RepositoryPrx getProxy(Current __current) {
        return this.proxy;
    }

    public RawFileStorePrx createRawFileStore(OriginalFile file, Current __current) {
        return null;
    }

    public RawPixelsStorePrx createRawPixelsStore(OriginalFile file, Current __current) {
        return null;
    }

    public RenderingEnginePrx createRenderingEngine(OriginalFile file, Current __current) {
        return null;
    }

    public ThumbnailStorePrx createThumbnailStore(OriginalFile file, Current __current) {
        return null;
    }

    public String getFilePath(OriginalFile file, Current __current) throws ServerError {
        return null;
    }

    private File getUuidDir() {
        File mountDir = new File(this.repoDir);
        File omeroDir = new File(mountDir, ".omero");
        File specDir = new File(omeroDir, "repository");
        File uuidDir = new File(specDir, this.dbUuid);
        return uuidDir;
    }
}

