/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import loci.formats.meta.MetadataRetrieve;
import ome.conditions.ApiUsageException;
import ome.model.core.Image;
import ome.services.db.DatabaseIdentity;
import ome.tools.hibernate.ProxyCleanupFilter;
import ome.tools.hibernate.QueryBuilder;
import ome.util.Filterable;
import omero.ClientError;
import omero.model.Arc;
import omero.model.Dataset;
import omero.model.Details;
import omero.model.Ellipse;
import omero.model.Event;
import omero.model.Experiment;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.ExternalInfo;
import omero.model.ExternalInfoI;
import omero.model.Filament;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.Laser;
import omero.model.Line;
import omero.model.Plate;
import omero.model.Point;
import omero.model.Polygon;
import omero.model.Polyline;
import omero.model.Project;
import omero.model.Rect;
import omero.model.Screen;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;

public class OmeroMetadata
implements MetadataRetrieve {
    private static final Log log = LogFactory.getLog(OmeroMetadata.class);
    private final List<omero.model.Image> imageList = new ArrayList<omero.model.Image>();
    private final List<Dataset> datasetList = new ArrayList<Dataset>();
    private final List<Project> projectList = new ArrayList<Project>();
    private final List<Instrument> instrumentList = new ArrayList<Instrument>();
    private final List<Experiment> experimentList = new ArrayList<Experiment>();
    private final List<Experimenter> experimenterList = new ArrayList<Experimenter>();
    private final List<ExperimenterGroup> experimenterGroupList = new ArrayList<ExperimenterGroup>();
    private final List<Screen> screenList = new ArrayList<Screen>();
    private final List<Plate> plateList = new ArrayList<Plate>();
    private final DatabaseIdentity db;

    public OmeroMetadata(DatabaseIdentity db) {
        this.db = db;
    }

    public void addImage(omero.model.Image image) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Adding image for retrieval:", image));
        }
        this.imageList.add(image);
    }

    public omero.model.Image getImage(int i) {
        return this.imageList.get(i);
    }

    public int sizeImages() {
        return this.imageList.size();
    }

    public String handleLsid(IObject obj) {
        if (obj == null) {
            return null;
        }
        Details d = obj.getDetails();
        ExternalInfo ei = d.getExternalInfo();
        Event ue = d.getUpdateEvent();
        if (ei != null && ei.getLsid() != null) {
            return ei.getLsid().getValue();
        }
        if (obj.getId() != null) {
            Long v;
            Class<?> k = obj.getClass();
            long id = obj.getId().getValue();
            Long l = v = ue == null ? null : Long.valueOf(ue.getId().getValue());
            if (v == null) {
                return this.db.lsid(k, id);
            }
            return this.db.lsid(k, id, v.longValue());
        }
        if (ei == null) {
            ei = new ExternalInfoI();
            d.setExternalInfo(ei);
        }
        String uuid = UUID.randomUUID().toString();
        String lsid = obj.getClass().getSimpleName() + ":" + uuid;
        ei.setLsid(rtypes.rstring(lsid));
        log.warn((Object)("Assigned temporary LSID: " + lsid));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Returning LSID for object %s: %s", obj, lsid));
        }
        return ei.getLsid().getValue();
    }

    public void initialize(Session session) {
        HashMap<omero.model.Image, Image> lookups = new HashMap<omero.model.Image, Image>();
        HashMap<omero.model.Image, omero.model.Image> replacements = new HashMap<omero.model.Image, omero.model.Image>();
        for (omero.model.Image image : this.imageList) {
            if (image.isLoaded()) continue;
            long id = image.getId().getValue();
            QueryBuilder qb = new QueryBuilder();
            qb.select(new String[]{"i"});
            qb.from("Image", "i");
            qb.join("i.details.owner", "i_o", false, true);
            qb.join("i.details.group", "i_g", false, true);
            qb.join("i.pixels", "p", false, true);
            qb.join("p.details.owner", "p_o", false, true);
            qb.join("p.details.group", "p_g", false, true);
            qb.join("p.pixelsType", "pt", false, true);
            qb.join("p.dimensionOrder", "do", false, true);
            qb.join("p.channels", "c", false, true);
            qb.join("c.logicalChannel", "l", false, true);
            qb.where();
            qb.and("i.id = " + id);
            Image _i = (Image)qb.query(session).uniqueResult();
            if (_i == null) {
                throw new ApiUsageException("Cannot load image: " + id);
            }
            lookups.put(image, _i);
            if (_i.getInstrument() == null) continue;
            qb = new QueryBuilder();
            qb.select(new String[]{"i"});
            qb.from("Image", "i");
            qb.join("i.instrument", "n", true, true);
            qb.join("n.objective", "o", true, true);
            qb.join("o.correction", "o_cor", true, true);
            qb.join("o.immersion", "o_imm", true, true);
            qb.join("n.details.owner", "n_o", true, true);
            qb.join("n.details.group", "n_g", true, true);
            qb.where();
            qb.and("i.id = " + id);
            qb.query(session);
        }
        session.clear();
        IceMapper mapper = new IceMapper();
        for (omero.model.Image image : lookups.keySet()) {
            omero.model.Image replacement = (omero.model.Image)mapper.map(new ProxyCleanupFilter().filter("", (Filterable)lookups.get(image)));
            replacements.put(image, replacement);
        }
        ArrayList<omero.model.Image> newImages = new ArrayList<omero.model.Image>();
        for (int i = 0; i < this.imageList.size(); ++i) {
            omero.model.Image image = this.imageList.get(i);
            omero.model.Image replacement = (omero.model.Image)replacements.get(image);
            if (replacement != null) {
                newImages.add(replacement);
                continue;
            }
            newImages.add(image);
        }
        this.imageList.clear();
        this.imageList.addAll(newImages);
    }

    private Float dbl2flt(double value) {
        return Float.valueOf(Double.valueOf(value).floatValue());
    }

    private Integer dbl2int(double value) {
        return Double.valueOf(value).intValue();
    }

    private String millis2time(long millis) {
        return new Timestamp(millis).toString();
    }

    private String dbl2str(double value) {
        return Double.toString(value);
    }

    private String int2str(int value) {
        return Integer.toString(value);
    }

    private String flt2str(float value) {
        return Float.toString(value);
    }

    private Boolean dbl2booleanXXX(double value) {
        throw new UnsupportedOperationException("THIS SHOULD BE FIXED");
    }

    public String getUUID() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatasetCount() {
        int count = Integer.MIN_VALUE;
        try {
            count = this.datasetList.size();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDatasetCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScreenRefCount(int idxPlate) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.plateList.get(idxPlate).sizeOfScreenLinks();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getScreenRefCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProjectRefCount(int idxDataset) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.datasetList.get(idxDataset).sizeOfProjectLinks();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getProjectRefCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProjectCount() {
        int count = Integer.MIN_VALUE;
        try {
            count = this.projectList.size();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getProjectCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGroupCount() {
        int count = Integer.MIN_VALUE;
        try {
            count = this.experimenterGroupList.size();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getGroupCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPixelsCount(int idxImage) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.imageList.get(idxImage).sizeOfPixels();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getPixelsCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGroupRefCount(int idxExperimenter) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.experimenterList.get(idxExperimenter).sizeOfGroupExperimenterMap();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getGroupRefCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlateRefCount(int idxScreen) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.screenList.get(idxScreen).sizeOfPlateLinks();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getPlateRefCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWellSampleCount(int idxPlate, int idxWell) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.plateList.get(idxPlate).copyWells().get(idxWell).sizeOfWellSamples();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getWellSampleCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRegionCount(int idxImage) {
        int count = Integer.MIN_VALUE;
        try {
            count = -2;
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getRegionCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWellSampleRefCount(int idxScreen, int idxScreenAcquisition) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.screenList.get(idxScreen).copyScreenAcquisition().get(idxScreenAcquisition).sizeOfWellSampleLinks();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getWellSampleRefCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlateCount() {
        int count = Integer.MIN_VALUE;
        try {
            count = this.plateList.size();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getPlateCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogicalChannelCount(int idxImage) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.imageList.get(idxImage).getPrimaryPixels().sizeOfChannels();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getLogicalChannelCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDichroicCount(int idxInstrument) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.instrumentList.get(idxInstrument).sizeOfDichroic();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDichroicCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReagentCount(int idxScreen) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.screenList.get(idxScreen).sizeOfReagent();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getReagentCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getROIRefCount(int idxImage, int idxMicrobeamManipulation) {
        int count = Integer.MIN_VALUE;
        try {
            count = -2;
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getROIRefCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInstrumentCount() {
        int count = Integer.MIN_VALUE;
        try {
            count = this.instrumentList.size();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getInstrumentCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExperimenterCount() {
        int count = Integer.MIN_VALUE;
        try {
            count = this.experimenterList.size();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getExperimenterCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDetectorCount(int idxInstrument) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.instrumentList.get(idxInstrument).sizeOfDetector();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDetectorCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLightSourceCount(int idxInstrument) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.instrumentList.get(idxInstrument).sizeOfLightSource();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getLightSourceCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExperimentCount() {
        int count = Integer.MIN_VALUE;
        try {
            count = this.experimentList.size();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getExperimentCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScreenAcquisitionCount(int idxScreen) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.screenList.get(idxScreen).sizeOfScreenAcquisition();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getScreenAcquisitionCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelComponentCount(int idxImage, int idxLogicalChannel) {
        int count = Integer.MIN_VALUE;
        try {
            count = -2;
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getChannelComponentCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScreenCount() {
        int count = Integer.MIN_VALUE;
        try {
            count = this.screenList.size();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getScreenCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObjectiveCount(int idxInstrument) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.instrumentList.get(idxInstrument).sizeOfObjective();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getObjectiveCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatasetRefCount(int idxImage) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.imageList.get(idxImage).sizeOfDatasetLinks();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDatasetRefCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMicrobeamManipulationRefCount(int idxExperiment) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.experimentList.get(idxExperiment).sizeOfMicrobeamManipulation();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getMicrobeamManipulationRefCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLightSourceRefCount(int idxImage, int idxMicrobeamManipulation) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.imageList.get(idxImage).getExperiment().copyMicrobeamManipulation().get(idxMicrobeamManipulation).sizeOfLightSourceSettings();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getLightSourceRefCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilterCount(int idxInstrument) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.instrumentList.get(idxInstrument).sizeOfFilter();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getFilterCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMicrobeamManipulationCount(int idxImage) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.imageList.get(idxImage).getExperiment().sizeOfMicrobeamManipulation();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getMicrobeamManipulationCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getImageCount() {
        int count = Integer.MIN_VALUE;
        try {
            count = this.imageList.size();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getImageCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getROICount(int idxImage) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.imageList.get(idxImage).sizeOfRois();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getROICount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShapeCount(int idxImage, int idxROI) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.imageList.get(idxImage).copyRois().get(idxROI).sizeOfShapes();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getShapeCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTiffDataCount(int idxImage, int idxPixels) {
        int count = Integer.MIN_VALUE;
        try {
            count = -2;
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getTiffDataCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilterSetCount(int idxInstrument) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.instrumentList.get(idxInstrument).sizeOfFilterSet();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getFilterSetCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWellCount(int idxPlate) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.plateList.get(idxPlate).sizeOfWells();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getWellCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlaneCount(int idxImage, int idxPixels) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.imageList.get(idxImage).copyPixels().get(idxPixels).sizeOfPlaneInfo();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getPlaneCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOTFCount(int idxInstrument) {
        int count = Integer.MIN_VALUE;
        try {
            count = this.instrumentList.get(idxInstrument).sizeOfOtf();
        }
        catch (NullPointerException npe) {
            count = -1;
        }
        catch (ClientError ce) {
            count = -2;
        }
        catch (IndexOutOfBoundsException iob) {
            count = -3;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getOTFCount()==" + count));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaskPixelsExtendedPixelType(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskPixelsExtendedPixelType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMaskPixelsSizeX(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskPixelsSizeX()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMaskPixelsSizeY(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskPixelsSizeY()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getMaskPixelsBigEndian(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskPixelsBigEndian()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMaskPixelsBinData(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskPixelsBinData()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaskPixelsID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskPixelsID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getDatasetLocked(int idxDataset) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDatasetLocked()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatasetDescription(int idxDataset) {
        Object e = null;
        String rv = null;
        try {
            rv = this.datasetList.get(idxDataset).getDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDatasetDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatasetExperimenterRef(int idxDataset) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.datasetList.get(idxDataset).getDetails().getOwner());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDatasetExperimenterRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatasetGroupRef(int idxDataset) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.datasetList.get(idxDataset).getDetails().getGroup());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDatasetGroupRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatasetID(int idxDataset) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.datasetList.get(idxDataset));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDatasetID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatasetName(int idxDataset) {
        Object e = null;
        String rv = null;
        try {
            rv = this.datasetList.get(idxDataset).getName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDatasetName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPumpLightSource(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPumpLightSource()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenRefID(int idxPlate, int idxScreenRef) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.plateList.get(idxPlate).copyScreenLinks().get(idxScreenRef));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenRefID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectRefID(int idxDataset, int idxProjectRef) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.datasetList.get(idxDataset).copyProjectLinks().get(idxProjectRef));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getProjectRefID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectExperimenterRef(int idxProject) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.projectList.get(idxProject).getDetails().getOwner());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getProjectExperimenterRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectID(int idxProject) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.projectList.get(idxProject));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getProjectID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectGroupRef(int idxProject) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.projectList.get(idxProject).getDetails().getGroup());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getProjectGroupRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectName(int idxProject) {
        Object e = null;
        String rv = null;
        try {
            rv = this.projectList.get(idxProject).getName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getProjectName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectDescription(int idxProject) {
        Object e = null;
        String rv = null;
        try {
            rv = this.projectList.get(idxProject).getDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getProjectDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupName(int idxGroup) {
        Object e = null;
        String rv = null;
        try {
            rv = this.experimenterGroupList.get(idxGroup).getName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getGroupName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getPixelsSizeT(int idxImage, int idxPixels) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.imageList.get(idxImage).copyPixels().get(idxPixels).getSizeT().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPixelsSizeT()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPixelsDimensionOrder(int idxImage, int idxPixels) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyPixels().get(idxPixels).getDimensionOrder().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPixelsDimensionOrder()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPixelsPixelType(int idxImage, int idxPixels) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyPixels().get(idxPixels).getPixelsType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPixelsPixelType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getPixelsSizeX(int idxImage, int idxPixels) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.imageList.get(idxImage).copyPixels().get(idxPixels).getSizeX().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPixelsSizeX()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getPixelsSizeY(int idxImage, int idxPixels) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.imageList.get(idxImage).copyPixels().get(idxPixels).getSizeY().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPixelsSizeY()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getPixelsSizeZ(int idxImage, int idxPixels) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.imageList.get(idxImage).copyPixels().get(idxPixels).getSizeZ().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPixelsSizeZ()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getPixelsBigEndian(int idxImage, int idxPixels) {
        Object e = null;
        Boolean rv = null;
        try {
            rv = true;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPixelsBigEndian()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getPixelsSizeC(int idxImage, int idxPixels) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.imageList.get(idxImage).copyPixels().get(idxPixels).getSizeC().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPixelsSizeC()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPixelsID(int idxImage, int idxPixels) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).copyPixels().get(idxPixels));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPixelsID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getPlateRefSample(int idxScreen, int idxPlateRef) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateRefSample()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlateRefWell(int idxScreen, int idxPlateRef) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateRefWell()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlateRefID(int idxScreen, int idxPlateRef) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.screenList.get(idxScreen).copyPlateLinks().get(idxPlateRef));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateRefID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getWellSampleIndex(int idxPlate, int idxWell, int idxWellSample) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellSampleIndex()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public String getWellSampleImageRef(int idxPlate, int idxWell, int idxWellSample) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Integer getWellSampleTimepoint(int idxPlate, int idxWell, int idxWellSample) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Float getWellSamplePosX(int idxPlate, int idxWell, int idxWellSample) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Float getWellSamplePosY(int idxPlate, int idxWell, int idxWellSample) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWellSampleID(int idxPlate, int idxWell, int idxWellSample) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.plateList.get(idxPlate).copyWells().get(idxWell).copyWellSamples().get(idxWellSample));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellSampleID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPolylinePoints(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Polyline)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape)).getPoints().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPolylinePoints()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPolylineID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid((Polyline)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPolylineID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPolylineTransform(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Polyline)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape)).getTransform().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPolylineTransform()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRegionTag(int idxImage, int idxRegion) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getRegionTag()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRegionName(int idxImage, int idxRegion) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getRegionName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRegionID(int idxImage, int idxRegion) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getRegionID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public Float getStagePositionPositionZ(int idxImage, int idxPixels, int idxPlane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Float getStagePositionPositionX(int idxImage, int idxPixels, int idxPlane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Float getStagePositionPositionY(int idxImage, int idxPixels, int idxPlane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWellSampleRefID(int idxScreen, int idxScreenAcquisition, int idxWellSampleRef) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.screenList.get(idxScreen).copyScreenAcquisition().get(idxScreenAcquisition).copyWellSampleLinks().get(idxWellSampleRef));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellSampleRefID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlateStatus(int idxPlate) {
        Object e = null;
        String rv = null;
        try {
            rv = this.plateList.get(idxPlate).getStatus().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateStatus()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlateRowNamingConvention(int idxPlate) {
        Object e = null;
        String rv = null;
        try {
            rv = this.plateList.get(idxPlate).getRowNamingConvention().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateRowNamingConvention()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlateDescription(int idxPlate) {
        Object e = null;
        String rv = null;
        try {
            rv = this.plateList.get(idxPlate).getDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlateExternalIdentifier(int idxPlate) {
        Object e = null;
        String rv = null;
        try {
            rv = this.plateList.get(idxPlate).getExternalIdentifier().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateExternalIdentifier()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlateColumnNamingConvention(int idxPlate) {
        Object e = null;
        String rv = null;
        try {
            rv = this.plateList.get(idxPlate).getColumnNamingConvention().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateColumnNamingConvention()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getPlateWellOriginY(int idxPlate) {
        Object e = null;
        Double rv = null;
        try {
            rv = this.plateList.get(idxPlate).getWellOriginY().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateWellOriginY()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getPlateWellOriginX(int idxPlate) {
        Object e = null;
        Double rv = null;
        try {
            rv = this.plateList.get(idxPlate).getWellOriginX().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateWellOriginX()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlateID(int idxPlate) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.plateList.get(idxPlate));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlateName(int idxPlate) {
        Object e = null;
        String rv = null;
        try {
            rv = this.plateList.get(idxPlate).getName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlateName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelLightSource(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getLightSourceSettings().getLightSource());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelLightSource()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelSecondaryEmissionFilter(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getSecondaryEmissionFilter());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelSecondaryEmissionFilter()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getLogicalChannelPockelCellSetting(int idxImage, int idxLogicalChannel) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getPockelCellSetting().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelPockelCellSetting()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getLogicalChannelPinholeSize(int idxImage, int idxLogicalChannel) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getPinHoleSize().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelPinholeSize()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelSecondaryExcitationFilter(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getSecondaryExcitationFilter());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelSecondaryExcitationFilter()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelPhotometricInterpretation(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getPhotometricInterpretation().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelPhotometricInterpretation()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelMode(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getMode().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelMode()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelContrastMethod(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getContrastMethod().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelContrastMethod()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelIlluminationType(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getIllumination().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelIlluminationType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelOTF(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getOtf());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelOTF()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelID(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelFluor(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getFluor().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelFluor()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getLogicalChannelEmWave(int idxImage, int idxLogicalChannel) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getEmissionWave().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelEmWave()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getLogicalChannelNdFilter(int idxImage, int idxLogicalChannel) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getNdFilter().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelNdFilter()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelName(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelDetector(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getDetectorSettings().getDetector());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelDetector()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getLogicalChannelSamplesPerPixel(int idxImage, int idxLogicalChannel) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getSamplesPerPixel().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelSamplesPerPixel()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getLogicalChannelExWave(int idxImage, int idxLogicalChannel) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getExcitationWave().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelExWave()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogicalChannelFilterSet(int idxImage, int idxLogicalChannel) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getPrimaryPixels().copyChannels().get(idxLogicalChannel).getLogicalChannel().getFilterSet());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLogicalChannelFilterSet()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDichroicModel(int idxInstrument, int idxDichroic) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyDichroic().get(idxDichroic).getModel().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDichroicModel()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDichroicLotNumber(int idxInstrument, int idxDichroic) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyDichroic().get(idxDichroic).getLotNumber().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDichroicLotNumber()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDichroicManufacturer(int idxInstrument, int idxDichroic) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyDichroic().get(idxDichroic).getManufacturer().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDichroicManufacturer()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReagentReagentIdentifier(int idxScreen, int idxReagent) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).copyReagent().get(idxReagent).getReagentIdentifier().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getReagentReagentIdentifier()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReagentDescription(int idxScreen, int idxReagent) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).copyReagent().get(idxReagent).getDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getReagentDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReagentID(int idxScreen, int idxReagent) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.screenList.get(idxScreen).copyReagent().get(idxReagent));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getReagentID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReagentName(int idxScreen, int idxReagent) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).copyReagent().get(idxReagent).getName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getReagentName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getROIRefID(int idxImage, int idxMicrobeamManipulation, int idxROIRef) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIRefID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInstrumentID(int idxInstrument) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getInstrumentID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimenterEmail(int idxExperimenter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.experimenterList.get(idxExperimenter).getEmail().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimenterEmail()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimenterOMEName(int idxExperimenter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.experimenterList.get(idxExperimenter).getOmeName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimenterOMEName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimenterFirstName(int idxExperimenter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.experimenterList.get(idxExperimenter).getFirstName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimenterFirstName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimenterLastName(int idxExperimenter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.experimenterList.get(idxExperimenter).getLastName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimenterLastName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimenterInstitution(int idxExperimenter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.experimenterList.get(idxExperimenter).getInstitution().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimenterInstitution()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimenterID(int idxExperimenter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.experimenterList.get(idxExperimenter));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimenterID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getDetectorGain(int idxInstrument, int idxDetector) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector).getGain().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorGain()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetectorSerialNumber(int idxInstrument, int idxDetector) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector).getSerialNumber().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorSerialNumber()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getDetectorZoom(int idxInstrument, int idxDetector) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector).getZoom().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorZoom()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getDetectorAmplificationGain(int idxInstrument, int idxDetector) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector).getAmplificationGain().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorAmplificationGain()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getDetectorVoltage(int idxInstrument, int idxDetector) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector).getVoltage().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorVoltage()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getDetectorOffset(int idxInstrument, int idxDetector) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector).getOffsetValue().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorOffset()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetectorModel(int idxInstrument, int idxDetector) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector).getModel().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorModel()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetectorType(int idxInstrument, int idxDetector) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector).getType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetectorID(int idxInstrument, int idxDetector) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetectorManufacturer(int idxInstrument, int idxDetector) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyDetector().get(idxDetector).getManufacturer().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDetectorManufacturer()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLightSourceModel(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource).getModel().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLightSourceModel()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLightSourceSerialNumber(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource).getSerialNumber().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLightSourceSerialNumber()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLightSourceID(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLightSourceID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getLightSourcePower(int idxInstrument, int idxLightSource) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource).getPower().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLightSourcePower()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLightSourceManufacturer(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource).getManufacturer().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLightSourceManufacturer()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArcType(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Arc)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getArcType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRectTransform(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Rect)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape)).getTransform().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getRectTransform()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public String getRectHeight(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getRectWidth(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getRectY(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getRectX(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRectID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid((Rect)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getRectID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimentExperimenterRef(int idxExperiment) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.experimentList.get(idxExperiment).getDetails().getOwner());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimentExperimenterRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimentType(int idxExperiment) {
        Object e = null;
        String rv = null;
        try {
            rv = this.experimentList.get(idxExperiment).getType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimentType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimentDescription(int idxExperiment) {
        Object e = null;
        String rv = null;
        try {
            rv = this.experimentList.get(idxExperiment).getDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimentDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExperimentID(int idxExperiment) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.experimentList.get(idxExperiment));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getExperimentID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenAcquisitionEndTime(int idxScreen, int idxScreenAcquisition) {
        Object e = null;
        String rv = null;
        try {
            rv = this.millis2time(this.screenList.get(idxScreen).copyScreenAcquisition().get(idxScreenAcquisition).getEndTime().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenAcquisitionEndTime()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenAcquisitionID(int idxScreen, int idxScreenAcquisition) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.screenList.get(idxScreen).copyScreenAcquisition().get(idxScreenAcquisition));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenAcquisitionID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenAcquisitionStartTime(int idxScreen, int idxScreenAcquisition) {
        Object e = null;
        String rv = null;
        try {
            rv = this.millis2time(this.screenList.get(idxScreen).copyScreenAcquisition().get(idxScreenAcquisition).getStartTime().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenAcquisitionStartTime()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public Float getPlaneTimingExposureTime(int idxImage, int idxPixels, int idxPlane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Float getPlaneTimingDeltaT(int idxImage, int idxPixels, int idxPlane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getImagingEnvironmentCO2Percent(int idxImage) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.imageList.get(idxImage).getImagingEnvironment().getCo2percent().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImagingEnvironmentCO2Percent()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getImagingEnvironmentTemperature(int idxImage) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.imageList.get(idxImage).getImagingEnvironment().getTemperature().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImagingEnvironmentTemperature()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getImagingEnvironmentAirPressure(int idxImage) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.imageList.get(idxImage).getImagingEnvironment().getAirPressure().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImagingEnvironmentAirPressure()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getImagingEnvironmentHumidity(int idxImage) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.imageList.get(idxImage).getImagingEnvironment().getHumidity().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImagingEnvironmentHumidity()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilamentType(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Filament)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilamentType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicroscopeModel(int idxInstrument) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).getMicroscope().getModel().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMicroscopeModel()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicroscopeSerialNumber(int idxInstrument) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).getMicroscope().getSerialNumber().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMicroscopeSerialNumber()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicroscopeType(int idxInstrument) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).getMicroscope().getType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMicroscopeType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicroscopeID(int idxInstrument) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument).getMicroscope());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMicroscopeID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicroscopeManufacturer(int idxInstrument) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).getMicroscope().getManufacturer().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMicroscopeManufacturer()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getChannelComponentIndex(int idxImage, int idxLogicalChannel, int idxChannelComponent) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getChannelComponentIndex()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChannelComponentColorDomain(int idxImage, int idxLogicalChannel, int idxChannelComponent) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getChannelComponentColorDomain()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChannelComponentPixels(int idxImage, int idxLogicalChannel, int idxChannelComponent) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getChannelComponentPixels()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getLaserPockelCell(int idxInstrument, int idxLightSource) {
        Object e = null;
        Boolean rv = null;
        try {
            rv = ((Laser)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getPockelCell().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLaserPockelCell()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getLaserTuneable(int idxInstrument, int idxLightSource) {
        Object e = null;
        Boolean rv = null;
        try {
            rv = ((Laser)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getTuneable().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLaserTuneable()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLaserLaserMedium(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Laser)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getLaserMedium().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLaserLaserMedium()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLaserPulse(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Laser)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getPulse().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLaserPulse()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getLaserWavelength(int idxInstrument, int idxLightSource) {
        Object e = null;
        Integer rv = null;
        try {
            rv = ((Laser)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getWavelength().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLaserWavelength()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getLaserFrequencyMultiplication(int idxInstrument, int idxLightSource) {
        Object e = null;
        Integer rv = null;
        try {
            rv = ((Laser)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getFrequencyMultiplication().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLaserFrequencyMultiplication()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLaserType(int idxInstrument, int idxLightSource) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Laser)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLaserType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getLaserRepetitionRate(int idxInstrument, int idxLightSource) {
        Object e = null;
        Boolean rv = null;
        try {
            rv = this.dbl2booleanXXX(((Laser)this.instrumentList.get(idxInstrument).copyLightSource().get(idxLightSource)).getRepetitionRate().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLaserRepetitionRate()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenDescription(int idxScreen) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).getDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenReagentSetDescription(int idxScreen) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).getReagentSetDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenReagentSetDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenProtocolIdentifier(int idxScreen) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).getProtocolIdentifier().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenProtocolIdentifier()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenProtocolDescription(int idxScreen) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).getProtocolDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenProtocolDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenExtern(int idxScreen) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenExtern()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenName(int idxScreen) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).getName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenType(int idxScreen) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).getType().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenID(int idxScreen) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.screenList.get(idxScreen));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenReagentSetIdentifier(int idxScreen) {
        Object e = null;
        String rv = null;
        try {
            rv = this.screenList.get(idxScreen).getReagentSetIdentifier().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getScreenReagentSetIdentifier()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getThumbnailMIMEtype(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getThumbnailMIMEtype()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getThumbnailHref(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getThumbnailHref()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getThumbnailID(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getThumbnailID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getObjectiveIris(int idxInstrument, int idxObjective) {
        Object e = null;
        Boolean rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getIris().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveIris()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getObjectiveWorkingDistance(int idxInstrument, int idxObjective) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getWorkingDistance().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveWorkingDistance()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectiveImmersion(int idxInstrument, int idxObjective) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getImmersion().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveImmersion()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectiveCorrection(int idxInstrument, int idxObjective) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getCorrection().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveCorrection()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectiveSerialNumber(int idxInstrument, int idxObjective) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getSerialNumber().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveSerialNumber()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getObjectiveLensNA(int idxInstrument, int idxObjective) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getLensNA().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveLensNA()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getObjectiveNominalMagnification(int idxInstrument, int idxObjective) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getNominalMagnification().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveNominalMagnification()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectiveModel(int idxInstrument, int idxObjective) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getModel().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveModel()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getObjectiveCalibratedMagnification(int idxInstrument, int idxObjective) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getCalibratedMagnification().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveCalibratedMagnification()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectiveID(int idxInstrument, int idxObjective) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectiveManufacturer(int idxInstrument, int idxObjective) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyObjective().get(idxObjective).getManufacturer().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getObjectiveManufacturer()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCircleR(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getCircleR()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCircleCy(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getCircleCy()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCircleCx(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getCircleCx()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCircleID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getCircleID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCircleTransform(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getCircleTransform()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatasetRefID(int idxImage, int idxDatasetRef) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).copyDatasetLinks().get(idxDatasetRef));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDatasetRefID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicrobeamManipulationRefID(int idxExperiment, int idxMicrobeamManipulationRef) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.experimentList.get(idxExperiment).copyMicrobeamManipulation().get(idxMicrobeamManipulationRef));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMicrobeamManipulationRefID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public String getLightSourceRefLightSource(int idxImage, int idxMicrobeamManipulation, int idxLightSourceRef) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Integer getLightSourceRefWavelength(int idxImage, int idxMicrobeamManipulation, int idxLightSourceRef) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Float getLightSourceRefAttenuation(int idxImage, int idxMicrobeamManipulation, int idxLightSourceRef) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPointR(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPointR()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public String getPointCy(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getPointCx(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPointID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid((Point)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPointID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPointTransform(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Point)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape)).getTransform().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPointTransform()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterFilterWheel(int idxInstrument, int idxFilter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getFilterWheel().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterFilterWheel()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterModel(int idxInstrument, int idxFilter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getModel().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterModel()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterLotNumber(int idxInstrument, int idxFilter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getLotNumber().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterLotNumber()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterType(int idxInstrument, int idxFilter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterManufacturer(int idxInstrument, int idxFilter) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getManufacturer().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterManufacturer()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicrobeamManipulationExperimenterRef(int idxImage, int idxMicrobeamManipulation) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getExperiment().copyMicrobeamManipulation().get(idxMicrobeamManipulation).getDetails().getOwner());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMicrobeamManipulationExperimenterRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicrobeamManipulationType(int idxImage, int idxMicrobeamManipulation) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getExperiment().copyMicrobeamManipulation().get(idxMicrobeamManipulation).getType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMicrobeamManipulationType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMicrobeamManipulationID(int idxImage, int idxMicrobeamManipulation) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getExperiment().copyMicrobeamManipulation().get(idxMicrobeamManipulation));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMicrobeamManipulationID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public String getEllipseRx(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getEllipseRy(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEllipseTransform(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Ellipse)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape)).getTransform().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getEllipseTransform()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public String getEllipseCy(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getEllipseCx(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEllipseID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid((Ellipse)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getEllipseID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGreyChannelChannelNumber(int idxImage) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getGreyChannelChannelNumber()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getGreyChannelBlackLevel(int idxImage) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getGreyChannelBlackLevel()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getGreyChannelWhiteLevel(int idxImage) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getGreyChannelWhiteLevel()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getGreyChannelGamma(int idxImage) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getGreyChannelGamma()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getGreyChannelisOn(int idxImage) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getGreyChannelisOn()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTransmittanceRangeCutIn(int idxInstrument, int idxFilter) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getTransmittanceRange().getCutIn().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTransmittanceRangeCutIn()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTransmittanceRangeTransmittance(int idxInstrument, int idxFilter) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.dbl2int(this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getTransmittanceRange().getTransmittance().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTransmittanceRangeTransmittance()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTransmittanceRangeCutOut(int idxInstrument, int idxFilter) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getTransmittanceRange().getCutOut().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTransmittanceRangeCutOut()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTransmittanceRangeCutInTolerance(int idxInstrument, int idxFilter) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getTransmittanceRange().getCutInTolerance().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTransmittanceRangeCutInTolerance()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTransmittanceRangeCutOutTolerance(int idxInstrument, int idxFilter) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilter().get(idxFilter).getTransmittanceRange().getCutOutTolerance().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTransmittanceRangeCutOutTolerance()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageExperimentRef(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getExperiment());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageExperimentRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageDescription(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageExperimenterRef(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getDetails().getOwner());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageExperimenterRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageGroupRef(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getDetails().getGroup());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageGroupRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageInstrumentRef(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getInstrument());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageInstrumentRef()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageDefaultPixels(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getPrimaryPixels());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageDefaultPixels()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageAcquiredPixels(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageAcquiredPixels()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageObjective(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).getObjectiveSettings().getObjective());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageObjective()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageCreationDate(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.millis2time(this.imageList.get(idxImage).getAcquisitionDate().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageCreationDate()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageID(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageName(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getImageName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getROIT0(int idxImage, int idxROI) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIT0()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getROIT1(int idxImage, int idxROI) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIT1()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getROIY1(int idxImage, int idxROI) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIY1()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getROIY0(int idxImage, int idxROI) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIY0()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getROIX0(int idxImage, int idxROI) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIX0()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getROIX1(int idxImage, int idxROI) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIX1()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getROIZ0(int idxImage, int idxROI) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIZ0()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getROIZ1(int idxImage, int idxROI) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIZ1()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getROIID(int idxImage, int idxROI) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).copyRois().get(idxROI));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getROIID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeTextAnchor(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeTextAnchor()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeVectorEffect(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape).getVectorEffect().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeVectorEffect()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeFontStyle(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeFontStyle()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeStrokeLineJoin(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape).getStrokeLineJoin().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeStrokeLineJoin()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeBaselineShift(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeBaselineShift()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public Boolean getShapeVisibility(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Integer getShapeTheT(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeFontStretch(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeFontStretch()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeStrokeLineCap(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape).getStrokeLineCap().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeStrokeLineCap()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeStrokeDashArray(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape).getStrokeDashArray().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeStrokeDashArray()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeDirection(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeDirection()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getShapeGlyphOrientationVertical(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeGlyphOrientationVertical()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeFontVariant(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeFontVariant()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public Float getShapeStrokeOpacity(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeFontFamily(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeFontFamily()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeFillRule(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape).getFillRule().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeFillRule()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeStrokeAttribute(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeStrokeAttribute()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public Boolean getShapeLocked(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeTextDecoration(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeTextDecoration()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeG(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape).getG().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeG()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeWritingMode(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeWritingMode()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getShapeFontSize(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeFontSize()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeFillColor(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape).getFillColor().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeFillColor()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public Integer getShapeStrokeWidth(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeTextStroke(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeTextStroke()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public Integer getShapeStrokeMiterLimit(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeText(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeText()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeTextFill(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeTextFill()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeFontWeight(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeFontWeight()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public String getShapeFillOpacity(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShapeStrokeColor(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape).getStrokeColor().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getShapeStrokeColor()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public Integer getShapeTheZ(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContactExperimenter(int idxGroup) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getContactExperimenter()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPolygonPoints(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Polygon)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape)).getPoints().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPolygonPoints()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPolygonID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid((Polygon)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPolygonID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPolygonTransform(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Polygon)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape)).getTransform().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPolygonTransform()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaskTransform(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskTransform()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaskHeight(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskHeight()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaskWidth(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskWidth()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaskY(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskY()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaskX(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskX()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaskID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getMaskID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getStageLabelY(int idxImage) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.imageList.get(idxImage).getStageLabel().getPositionY().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getStageLabelY()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getStageLabelX(int idxImage) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.imageList.get(idxImage).getStageLabel().getPositionX().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getStageLabelX()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getStageLabelZ(int idxImage) {
        Object e = null;
        Float rv = null;
        try {
            rv = this.dbl2flt(this.imageList.get(idxImage).getStageLabel().getPositionZ().getValue());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getStageLabelZ()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStageLabelName(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = this.imageList.get(idxImage).getStageLabel().getName().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getStageLabelName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTiffDataUUID(int idxImage, int idxPixels, int idxTiffData) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTiffDataUUID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTiffDataNumPlanes(int idxImage, int idxPixels, int idxTiffData) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTiffDataNumPlanes()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTiffDataFirstC(int idxImage, int idxPixels, int idxTiffData) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTiffDataFirstC()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTiffDataFileName(int idxImage, int idxPixels, int idxTiffData) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTiffDataFileName()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTiffDataIFD(int idxImage, int idxPixels, int idxTiffData) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTiffDataIFD()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTiffDataFirstZ(int idxImage, int idxPixels, int idxTiffData) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTiffDataFirstZ()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTiffDataFirstT(int idxImage, int idxPixels, int idxTiffData) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getTiffDataFirstT()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayOptionsID(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDisplayOptionsID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayOptionsDisplay(int idxImage) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDisplayOptionsDisplay()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getDisplayOptionsZoom(int idxImage) {
        Object e = null;
        Object rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getDisplayOptionsZoom()==");
                sb.append((Object)rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterSetDichroic(int idxInstrument, int idxFilterSet) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument).copyFilterSet().get(idxFilterSet).getDichroic());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterSetDichroic()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterSetExFilter(int idxInstrument, int idxFilterSet) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument).copyFilterSet().get(idxFilterSet).getExFilter());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterSetExFilter()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterSetLotNumber(int idxInstrument, int idxFilterSet) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilterSet().get(idxFilterSet).getLotNumber().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterSetLotNumber()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterSetEmFilter(int idxInstrument, int idxFilterSet) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument).copyFilterSet().get(idxFilterSet).getEmFilter());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterSetEmFilter()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterSetModel(int idxInstrument, int idxFilterSet) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilterSet().get(idxFilterSet).getModel().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterSetModel()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterSetManufacturer(int idxInstrument, int idxFilterSet) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyFilterSet().get(idxFilterSet).getManufacturer().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getFilterSetManufacturer()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWellExternalIdentifier(int idxPlate, int idxWell) {
        Object e = null;
        String rv = null;
        try {
            rv = this.plateList.get(idxPlate).copyWells().get(idxWell).getExternalIdentifier().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellExternalIdentifier()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getWellColumn(int idxPlate, int idxWell) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.plateList.get(idxPlate).copyWells().get(idxWell).getColumn().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellColumn()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWellExternalDescription(int idxPlate, int idxWell) {
        Object e = null;
        String rv = null;
        try {
            rv = this.plateList.get(idxPlate).copyWells().get(idxWell).getExternalDescription().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellExternalDescription()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWellReagent(int idxPlate, int idxWell) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellReagent()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWellType(int idxPlate, int idxWell) {
        Object e = null;
        String rv = null;
        try {
            rv = this.plateList.get(idxPlate).copyWells().get(idxWell).getType().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWellID(int idxPlate, int idxWell) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.plateList.get(idxPlate).copyWells().get(idxWell));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getWellRow(int idxPlate, int idxWell) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.plateList.get(idxPlate).copyWells().get(idxWell).getRow().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getWellRow()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlaneID(int idxImage, int idxPixels, int idxPlane) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.imageList.get(idxImage).copyPixels().get(idxPixels).copyPlaneInfo().get(idxPlane));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlaneID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public Integer getPlaneTheT(int idxImage, int idxPixels, int idxPlane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Integer getPlaneTheC(int idxImage, int idxPixels, int idxPlane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Integer getPlaneTheZ(int idxImage, int idxPixels, int idxPlane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlaneHashSHA1(int idxImage, int idxPixels, int idxPlane) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getPlaneHashSHA1()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public String getLineX1(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLineTransform(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = ((Line)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape)).getTransform().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLineTransform()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * Exception decompiling
     */
    public String getLineY1(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getLineX2(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getLineY2(int idxImage, int idxROI, int idxShape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLineID(int idxImage, int idxROI, int idxShape) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid((Line)this.imageList.get(idxImage).copyRois().get(idxROI).copyShapes().get(idxShape));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getLineID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOTFPixelType(int idxInstrument, int idxOTF) {
        Object e = null;
        String rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyOtf().get(idxOTF).getPixelsType().getValue().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getOTFPixelType()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getOTFSizeX(int idxInstrument, int idxOTF) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyOtf().get(idxOTF).getSizeX().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getOTFSizeX()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getOTFSizeY(int idxInstrument, int idxOTF) {
        Object e = null;
        Integer rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyOtf().get(idxOTF).getSizeY().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getOTFSizeY()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getOTFOpticalAxisAveraged(int idxInstrument, int idxOTF) {
        Object e = null;
        Boolean rv = null;
        try {
            rv = this.instrumentList.get(idxInstrument).copyOtf().get(idxOTF).getOpticalAxisAveraged().getValue();
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getOTFOpticalAxisAveraged()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOTFObjective(int idxInstrument, int idxOTF) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument).copyOtf().get(idxOTF).getObjective());
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getOTFObjective()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOTFBinaryFile(int idxInstrument, int idxOTF) {
        Object e = null;
        String rv = null;
        try {
            rv = null;
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getOTFBinaryFile()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOTFID(int idxInstrument, int idxOTF) {
        Object e = null;
        String rv = null;
        try {
            rv = this.handleLsid(this.instrumentList.get(idxInstrument).copyOtf().get(idxOTF));
        }
        catch (NullPointerException npe) {
            e = npe;
            rv = null;
        }
        catch (ClientError ce) {
            e = ce;
            rv = null;
        }
        catch (IndexOutOfBoundsException iob) {
            e = iob;
            rv = null;
        }
        finally {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("getOTFID()==");
                sb.append(rv);
                if (e != null) {
                    sb.append("(");
                    sb.append(e.getClass().getSimpleName());
                    sb.append(")");
                }
                log.debug((Object)sb.toString());
            }
        }
        return rv;
    }

    public String getDetectorSettingsBinning(int imageIndex, int logicalChannelIndex) {
        return null;
    }

    public String getDetectorSettingsDetector(int imageIndex, int logicalChannelIndex) {
        return null;
    }

    public Float getDetectorSettingsGain(int imageIndex, int logicalChannelIndex) {
        return null;
    }

    public Float getDetectorSettingsOffset(int imageIndex, int logicalChannelIndex) {
        return null;
    }

    public Float getDetectorSettingsReadOutRate(int imageIndex, int logicalChannelIndex) {
        return null;
    }

    public Float getDetectorSettingsVoltage(int imageIndex, int logicalChannelIndex) {
        return null;
    }

    public Float getDimensionsPhysicalSizeX(int imageIndex, int pixelsIndex) {
        return null;
    }

    public Float getDimensionsPhysicalSizeY(int imageIndex, int pixelsIndex) {
        return null;
    }

    public Float getDimensionsPhysicalSizeZ(int imageIndex, int pixelsIndex) {
        return null;
    }

    public Float getDimensionsTimeIncrement(int imageIndex, int pixelsIndex) {
        return null;
    }

    public Integer getDimensionsWaveIncrement(int imageIndex, int pixelsIndex) {
        return null;
    }

    public Integer getDimensionsWaveStart(int imageIndex, int pixelsIndex) {
        return null;
    }

    public Integer getDisplayOptionsProjectionZStart(int imageIndex) {
        return null;
    }

    public Integer getDisplayOptionsProjectionZStop(int imageIndex) {
        return null;
    }

    public Integer getDisplayOptionsTimeTStart(int imageIndex) {
        return null;
    }

    public Integer getDisplayOptionsTimeTStop(int imageIndex) {
        return null;
    }

    public String getEmFilterLotNumber(int instrumentIndex, int filterIndex) {
        return null;
    }

    public String getEmFilterManufacturer(int instrumentIndex, int filterIndex) {
        return null;
    }

    public String getEmFilterModel(int instrumentIndex, int filterIndex) {
        return null;
    }

    public String getEmFilterType(int instrumentIndex, int filterIndex) {
        return null;
    }

    public String getExFilterLotNumber(int instrumentIndex, int filterIndex) {
        return null;
    }

    public String getExFilterManufacturer(int instrumentIndex, int filterIndex) {
        return null;
    }

    public String getExFilterModel(int instrumentIndex, int filterIndex) {
        return null;
    }

    public String getExFilterType(int instrumentIndex, int filterIndex) {
        return null;
    }

    public int getExperimenterMembershipCount(int experimenterIndex) {
        return 0;
    }

    public String getExperimenterMembershipGroup(int experimenterIndex, int groupRefIndex) {
        return null;
    }

    public String getGreyChannelMapColorMap(int imageIndex) {
        return null;
    }

    public Float getLightSourceSettingsAttenuation(int imageIndex, int logicalChannelIndex) {
        return null;
    }

    public String getLightSourceSettingsLightSource(int imageIndex, int logicalChannelIndex) {
        return null;
    }

    public Integer getLightSourceSettingsWavelength(int imageIndex, int logicalChannelIndex) {
        return null;
    }

    public Float getObjectiveSettingsCorrectionCollar(int imageIndex) {
        return null;
    }

    public String getObjectiveSettingsMedium(int imageIndex) {
        return null;
    }

    public String getObjectiveSettingsObjective(int imageIndex) {
        return null;
    }

    public Float getObjectiveSettingsRefractiveIndex(int imageIndex) {
        return null;
    }

    public String getPathD(int imageIndex, int roiIndex, int shapeIndex) {
        return null;
    }

    public String getPathID(int imageIndex, int roiIndex, int shapeIndex) {
        return null;
    }

    public String getDichroicID(int arg0, int arg1) {
        return null;
    }

    public String getFilterID(int arg0, int arg1) {
        return null;
    }

    public String getFilterSetID(int arg0, int arg1) {
        return null;
    }

    public int getRoiLinkCount(int arg0, int arg1) {
        return 0;
    }

    public String getRoiLinkDirection(int arg0, int arg1, int arg2) {
        return null;
    }

    public String getRoiLinkName(int arg0, int arg1, int arg2) {
        return null;
    }

    public String getRoiLinkRef(int arg0, int arg1, int arg2) {
        return null;
    }

    public String getGroupID(int arg0) {
        return null;
    }
}

