/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.xml.transform.TransformerException;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import ome.api.RawPixelsStore;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.OmeroMetadata;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.blitz.util.UnregisterServantMessage;
import ome.services.db.DatabaseIdentity;
import ome.services.formats.OmeroReader;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import ome.xml.DOMUtil;
import ome.xml.OMEXMLNode;
import omero.ServerError;
import omero.api.AMD_Exporter_addImage;
import omero.api.AMD_Exporter_generateTiff;
import omero.api.AMD_Exporter_generateXml;
import omero.api.AMD_Exporter_read;
import omero.api.AMD_StatefulServiceInterface_activate;
import omero.api.AMD_StatefulServiceInterface_close;
import omero.api.AMD_StatefulServiceInterface_getCurrentEventContext;
import omero.api.AMD_StatefulServiceInterface_passivate;
import omero.api._ExporterOperations;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.Pixels;
import omero.util.IceMapper;
import omero.util.TempFileManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.context.ApplicationEvent;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

public class ExporterI
extends AbstractAmdServant
implements _ExporterOperations,
ServiceFactoryAware,
BlitzOnly {
    private static final Log log = LogFactory.getLog(ExporterI.class);
    private static final int MAX_SIZE = 0x100000;
    private ServiceFactoryI factory;
    private volatile OmeroMetadata retrieve;
    private volatile File file;
    private final DatabaseIdentity databaseIdentity;

    public ExporterI(BlitzExecutor be, DatabaseIdentity databaseIdentity) {
        super(null, be);
        this.databaseIdentity = databaseIdentity;
        this.retrieve = new OmeroMetadata(databaseIdentity);
    }

    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        this.factory = sf;
    }

    public void addImage_async(AMD_Exporter_addImage __cb, long id, Current __current) throws ServerError {
        State state = State.check(this);
        ServerError se = this.assertConfig(state);
        if (se != null) {
            __cb.ice_exception((Exception)((Object)se));
        }
        this.retrieve.addImage(new ImageI(id, false));
        __cb.ice_response();
    }

    public void generateXml_async(AMD_Exporter_generateXml __cb, Current __current) throws ServerError {
        State state = State.check(this);
        ServerError se = this.assertConfig(state);
        if (se != null) {
            __cb.ice_exception((Exception)((Object)se));
        }
        this.do_xml(__cb);
    }

    public void generateTiff_async(AMD_Exporter_generateTiff __cb, Current __current) throws ServerError {
        State state = State.check(this);
        ServerError se = this.assertConfig(state);
        if (se != null) {
            __cb.ice_exception((Exception)((Object)se));
        }
        this.do_tiff(__cb);
    }

    public void read_async(AMD_Exporter_read __cb, long pos, int size, Current __current) throws ServerError {
        State state = State.check(this);
        switch (state) {
            case config: {
                omero.ApiUsageException aue = new omero.ApiUsageException(null, null, "Call a generate method first");
                __cb.ice_exception((Exception)((Object)aue));
                return;
            }
            case output: {
                try {
                    __cb.ice_response(this.read(pos, size));
                }
                catch (Exception e) {
                    if (e instanceof ServerError) {
                        __cb.ice_exception(e);
                    }
                    omero.InternalException ie = new omero.InternalException(null, null, "Error during read");
                    IceMapper.fillServerError(ie, e);
                    __cb.ice_exception((Exception)((Object)ie));
                }
                return;
            }
        }
        throw new InternalException("Unknown state: " + (Object)((Object)state));
    }

    private ServerError assertConfig(State state) {
        switch (state) {
            case config: {
                return null;
            }
            case output: {
                return new omero.ApiUsageException(null, null, "Cannot configure during output");
            }
        }
        return new omero.InternalException(null, null, "Unknown state: " + (Object)((Object)state));
    }

    private void startConfig() {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    private void do_xml(final AMD_Exporter_generateXml __cb) {
        try {
            this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "generateXml", new Object[0]){

                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    Object root;
                    ExporterI.this.retrieve.initialize(session);
                    IMetadata xmlMetadata = ExporterI.convertXml(ExporterI.this.retrieve);
                    if (xmlMetadata != null && (root = xmlMetadata.getRoot()) instanceof OMEXMLNode) {
                        OMEXMLNode node = (OMEXMLNode)root;
                        try {
                            ExporterI.this.file = TempFileManager.create_path("__omero_export__", ".ome.xml");
                            ExporterI.this.file.deleteOnExit();
                            FileOutputStream fos = new FileOutputStream(ExporterI.this.file);
                            DOMUtil.writeXML((OutputStream)fos, (Document)node.getDOMElement().getOwnerDocument());
                            fos.close();
                            ExporterI.this.retrieve = null;
                            __cb.ice_response(ExporterI.this.file.length());
                            return null;
                        }
                        catch (IOException ioe) {
                            log.error((Object)ioe);
                        }
                        catch (TransformerException e) {
                            log.error((Object)e);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            omero.InternalException ie = new omero.InternalException();
            IceMapper.fillServerError(ie, e);
            __cb.ice_exception((Exception)((Object)ie));
        }
    }

    private void do_tiff(final AMD_Exporter_generateTiff __cb) {
        try {
            this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "generateTiff", new Object[0]){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    ExporterI.this.retrieve.initialize(session);
                    int num = ExporterI.this.retrieve.sizeImages();
                    if (num != 1) {
                        omero.ApiUsageException a = new omero.ApiUsageException(null, null, "Only one image supported for TIFF, not " + num);
                        __cb.ice_exception((Exception)((Object)a));
                        return null;
                    }
                    RawPixelsStore raw = null;
                    OmeroReader reader = null;
                    ImageWriter writer = null;
                    try {
                        Image image = ExporterI.this.retrieve.getImage(0);
                        Pixels pix = image.getPixels(0);
                        ExporterI.this.file = TempFileManager.create_path("__omero_export__", ".ome.tiff");
                        raw = sf.createRawPixelsStore();
                        raw.setPixelsId(pix.getId().getValue(), true);
                        reader = new OmeroReader(raw, pix);
                        reader.setId("OMERO");
                        writer = new ImageWriter();
                        writer.setMetadataRetrieve((MetadataRetrieve)ExporterI.this.retrieve);
                        writer.setId(ExporterI.this.file.getAbsolutePath());
                        int planeCount = reader.planes;
                        int planeSize = raw.getPlaneSize();
                        byte[] plane = new byte[planeSize];
                        for (int i = 0; i < planeCount; ++i) {
                            reader.openBytes(i, plane);
                            writer.saveBytes(plane, i == planeCount - 1);
                        }
                        ExporterI.this.retrieve = null;
                        __cb.ice_response(ExporterI.this.file.length());
                        this.cleanup(raw, reader, writer);
                    }
                    catch (Exception e) {
                        try {
                            omero.InternalException ie = new omero.InternalException(null, null, "Error during TIFF generation");
                            IceMapper.fillServerError(ie, e);
                            __cb.ice_exception((Exception)((Object)ie));
                            this.cleanup(raw, reader, writer);
                        }
                        catch (Throwable throwable) {
                            this.cleanup(raw, reader, writer);
                            throw throwable;
                        }
                    }
                    return null;
                }

                private void cleanup(RawPixelsStore raw, OmeroReader reader, ImageWriter writer) {
                    try {
                        if (raw != null) {
                            raw.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Error closing pix", (Throwable)e);
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Error closing reader", (Throwable)e);
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Error closing writer", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            omero.InternalException ie = new omero.InternalException();
            IceMapper.fillServerError(ie, e);
            __cb.ice_exception((Exception)((Object)ie));
        }
    }

    private byte[] read(long pos, int size) throws ServerError {
        if (size > 0x100000) {
            throw new ApiUsageException("Max read size is: 1048576");
        }
        byte[] buf = new byte[size];
        RandomAccessFile ra = null;
        try {
            ra = new RandomAccessFile(this.file, "r");
            long l = ra.length();
            if (pos + (long)size > l) {
                size = (int)(l - pos);
            }
            ra.seek(pos);
            int read = ra.read(buf);
            if (read < 0) {
                buf = new byte[]{};
            } else if (read < size) {
                byte[] newBuf = new byte[read];
                System.arraycopy(buf, 0, newBuf, 0, read);
                buf = newBuf;
            }
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        finally {
            if (ra != null) {
                try {
                    ra.close();
                }
                catch (IOException e) {
                    log.warn((Object)"IOException on file close");
                }
            }
        }
        return buf;
    }

    public static IMetadata convertXml(MetadataRetrieve retrieve) {
        try {
            IMetadata xmlMeta = MetadataTools.createOMEXMLMetadata();
            xmlMeta.createRoot();
            MetadataTools.convertMetadata((MetadataRetrieve)retrieve, (MetadataStore)xmlMeta);
            return xmlMeta;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public static String generateXml(MetadataRetrieve retrieve) {
        IMetadata xmlMeta = ExporterI.convertXml(retrieve);
        return MetadataTools.getOMEXML((MetadataRetrieve)xmlMeta);
    }

    public void activate_async(AMD_StatefulServiceInterface_activate __cb, Current __current) {
    }

    public void passivate_async(AMD_StatefulServiceInterface_passivate __cb, Current __current) {
    }

    public void close_async(AMD_StatefulServiceInterface_close __cb, Current __current) {
        try {
            this.retrieve = null;
            if (this.file != null) {
                this.file.delete();
                this.file = null;
            }
            UnregisterServantMessage msg = new UnregisterServantMessage(this, this.factory.principal.getName(), __current);
            this.factory.context.publishEvent((ApplicationEvent)msg);
            __cb.ice_response();
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    public void getCurrentEventContext_async(AMD_StatefulServiceInterface_getCurrentEventContext __cb, Current __current) throws ServerError {
        this.callInvokerOnRawArgs(__cb, __current, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        config,
        output;


        static State check(ExporterI self) {
            if (self.file != null && self.retrieve != null) {
                throw new InternalException("Doing 2 things at once");
            }
            if (self.retrieve == null) {
                return output;
            }
            return config;
        }
    }
}

