/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ome.api.ServiceInterface;
import ome.conditions.InternalException;
import ome.logic.HardWiredInterceptor;
import ome.services.blitz.fire.AopContextInitializer;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.IceMethodInvoker;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import omero.util.IceMapper;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAmdServant
implements ApplicationContextAware {
    protected final BlitzExecutor be;
    protected ServiceInterface service;
    protected IceMethodInvoker invoker;

    public AbstractAmdServant(ServiceInterface service, BlitzExecutor be) {
        this.be = be;
        this.service = service;
    }

    public final void setApplicationContext(ApplicationContext ctx) throws BeansException {
        OmeroContext oc = (OmeroContext)ctx;
        if (this.service != null) {
            this.invoker = new IceMethodInvoker(this.service, oc);
        }
        try {
            this.onSetOmeroContext(oc);
        }
        catch (Exception e) {
            throw new FatalBeanException("Error on setOmeroContext", (Throwable)e);
        }
    }

    public void onSetOmeroContext(OmeroContext context) throws Exception {
    }

    public final void applyHardWiredInterceptors(List<HardWiredInterceptor> cptors, AopContextInitializer initializer) {
        if (this.service != null) {
            ProxyFactory wiredService = new ProxyFactory();
            wiredService.setInterfaces((Class[])this.service.getClass().getInterfaces());
            wiredService.setTarget((Object)this.service);
            ArrayList<HardWiredInterceptor> reversed = new ArrayList<HardWiredInterceptor>(cptors);
            Collections.reverse(reversed);
            for (HardWiredInterceptor hwi : reversed) {
                wiredService.addAdvice(0, (Advice)hwi);
            }
            wiredService.addAdvice(0, (Advice)initializer);
            this.service = (ServiceInterface)wiredService.getProxy();
        }
    }

    public final void callInvokerOnRawArgs(Object __cb, Current __current, Object ... args) {
        if (this.service == null) {
            throw new InternalException("Null service; cannot use callInvoker()");
        }
        this.be.callInvokerOnRawArgs(this.service, this.invoker, __cb, __current, args);
    }

    public final void callInvokerOnMappedArgs(IceMapper mapper, Object __cb, Current __current, Object ... args) {
        if (this.service == null) {
            throw new InternalException("Null service; cannot use callInvoker()");
        }
        this.be.callInvokerWithMappedArgs(this.service, this.invoker, mapper, __cb, __current, args);
    }

    public final void runnableCall(Current __current, Runnable r) {
        this.be.runnableCall(__current, r);
    }

    public final void executorWorkCall(Executor.Work work) {
        throw new UnsupportedOperationException();
    }
}

