/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Glacier2.SessionManagerPrx;
import Glacier2.SessionManagerPrxHelper;
import Glacier2.SessionPrx;
import Ice.Communicator;
import Ice.Identity;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectPrx;
import Ice.Util;
import IceGrid.AdminPrx;
import IceGrid.AdminSessionPrx;
import IceGrid.ObjectExistsException;
import IceGrid.ObjectNotRegisteredException;
import IceGrid.PermissionDeniedException;
import IceGrid.QueryPrx;
import IceGrid.QueryPrxHelper;
import IceGrid.RegistryPrx;
import IceGrid.RegistryPrxHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import ome.services.blitz.repo.InternalRepositoryI;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceFactoryPrxHelper;
import omero.grid.ClusterNodePrx;
import omero.grid.ClusterNodePrxHelper;
import omero.grid.InternalRepositoryPrx;
import omero.grid.InternalRepositoryPrxHelper;
import omero.grid.ProcessorPrx;
import omero.grid.ProcessorPrxHelper;
import omero.grid.TablesPrx;
import omero.grid.TablesPrxHelper;
import omero.grid._ClusterNodeDisp;
import omero.grid._ProcessorDisp;
import omero.grid._TablesDisp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface Registry {
    public ServiceFactoryPrx getInternalServiceFactory(String var1, String var2, int var3, int var4, String var5) throws Exception;

    public QueryPrx getGridQuery();

    public AdminSessionPrx getAdminSession() throws PermissionDeniedException;

    public void addObject(ObjectPrx var1) throws Exception;

    public void removeObject(Identity var1) throws Exception;

    public boolean removeObjectSafely(Identity var1);

    public ClusterNodePrx[] lookupClusterNodes();

    public ProcessorPrx[] lookupProcessors();

    public InternalRepositoryPrx[] lookupRepositories();

    public TablesPrx[] lookupTables();

    public static class Impl
    implements Registry {
        private static final Log log = LogFactory.getLog(Registry.class);
        private final Communicator ic;

        public Impl(Communicator ic) {
            this.ic = ic;
        }

        public ServiceFactoryPrx getInternalServiceFactory(String user, String group, int retries, int interval, String client_uuid) throws Exception {
            int tryCount = 0;
            Throwable excpt = null;
            ObjectPrx prx = this.ic.stringToProxy("IceGrid/Query");
            QueryPrx query = QueryPrxHelper.checkedCast((ObjectPrx)prx);
            if (client_uuid == null || client_uuid == "") {
                client_uuid = UUID.randomUUID().toString();
            }
            while (tryCount < retries) {
                try {
                    HashMap<String, String> ctx = new HashMap<String, String>();
                    ctx.put("omero.client.uuid", client_uuid);
                    prx = query.findAllObjectsByType("::Glacier2::SessionManager")[0];
                    SessionManagerPrx blitz = SessionManagerPrxHelper.checkedCast((ObjectPrx)prx);
                    SessionPrx sf = blitz.create(user, null, ctx);
                    return ServiceFactoryPrxHelper.checkedCast((ObjectPrx)sf);
                }
                catch (ObjectAdapterDeactivatedException oade) {
                    excpt = oade;
                }
                catch (Exception e) {
                    log.info((Object)("Failed to get session on attempt " + tryCount));
                    ++tryCount;
                    excpt = e;
                }
                ++tryCount;
                try {
                    Thread.sleep(interval * 1000);
                }
                catch (InterruptedException ie) {}
            }
            log.warn((Object)"Failed to get internal service factory", excpt);
            throw excpt;
        }

        public QueryPrx getGridQuery() {
            try {
                ObjectPrx objectPrx = this.ic.stringToProxy("IceGrid/Query");
                QueryPrx query = QueryPrxHelper.checkedCast((ObjectPrx)objectPrx);
                return query;
            }
            catch (Exception e) {
                log.warn((Object)("Could not find IceGrid/Query: " + e));
                return null;
            }
        }

        public AdminSessionPrx getAdminSession() throws PermissionDeniedException {
            ObjectPrx objectPrx = this.ic.stringToProxy("IceGrid/Registry");
            RegistryPrx reg = RegistryPrxHelper.checkedCast((ObjectPrx)objectPrx);
            AdminSessionPrx session = reg.createAdminSession("null", "");
            return session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObject(ObjectPrx obj) throws Exception {
            AdminSessionPrx session = this.getAdminSession();
            AdminPrx admin = session.getAdmin();
            String str = this.ic.identityToString(obj.ice_getIdentity());
            try {
                admin.addObject(obj);
                log.info((Object)("Added " + str + " to registry"));
            }
            catch (ObjectExistsException e) {
                admin.updateObject(obj);
                log.info((Object)("Updated " + str + " in registry"));
            }
            finally {
                session.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeObject(Identity id) throws Exception {
            AdminSessionPrx session = this.getAdminSession();
            try {
                session.getAdmin().removeObject(id);
                log.info((Object)("Removed " + this.ic.identityToString(id) + " from registry"));
            }
            finally {
                session.destroy();
            }
        }

        public boolean removeObjectSafely(Identity id) {
            try {
                this.removeObject(id);
                return true;
            }
            catch (ObjectNotRegisteredException onre) {
                log.debug((Object)(Util.identityToString((Identity)id) + " not registered"));
            }
            catch (Exception e) {
                log.error((Object)("Failed to remove registry object " + Util.identityToString((Identity)id)), (Throwable)e);
            }
            return false;
        }

        public ClusterNodePrx[] lookupClusterNodes() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType(_ClusterNodeDisp.ice_staticId());
                Object[] nodes = new ClusterNodePrx[candidates.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = ClusterNodePrxHelper.uncheckedCast(candidates[i]);
                }
                log.info((Object)("Found " + nodes.length + " cluster node(s) : " + Arrays.toString(nodes)));
                return nodes;
            }
            catch (Exception e) {
                log.warn((Object)("Could not query cluster nodes " + e));
                return null;
            }
        }

        public ProcessorPrx[] lookupProcessors() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType(_ProcessorDisp.ice_staticId());
                Object[] procs = new ProcessorPrx[candidates.length];
                for (int i = 0; i < procs.length; ++i) {
                    procs[i] = ProcessorPrxHelper.uncheckedCast(candidates[i]);
                }
                log.info((Object)("Found " + procs.length + " processor(s) : " + Arrays.toString(procs)));
                return procs;
            }
            catch (Exception e) {
                log.warn((Object)("Could not query processors " + e));
                return null;
            }
        }

        public TablesPrx[] lookupTables() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType(_TablesDisp.ice_staticId());
                Object[] tables = new TablesPrx[candidates.length];
                for (int i = 0; i < tables.length; ++i) {
                    tables[i] = TablesPrxHelper.uncheckedCast(candidates[i]);
                }
                log.info((Object)("Found " + tables.length + " table services(s) : " + Arrays.toString(tables)));
                return tables;
            }
            catch (Exception e) {
                log.warn((Object)("Could not query tables " + e));
                return null;
            }
        }

        public InternalRepositoryPrx[] lookupRepositories() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType(InternalRepositoryI.ice_staticId());
                Object[] repos = new InternalRepositoryPrx[candidates.length];
                for (int i = 0; i < repos.length; ++i) {
                    repos[i] = InternalRepositoryPrxHelper.uncheckedCast(candidates[i]);
                }
                log.info((Object)("Found " + repos.length + " repo(s) : " + Arrays.toString(repos)));
                return repos;
            }
            catch (Exception e) {
                log.warn((Object)("Could not query repositories " + e));
                return null;
            }
        }
    }
}

